//
// ConvertDataToHex() and ConvertHexToData() functions
// 

#include <windows.h>

static LPSTR hexString = "0123456789ABCDEF";
#define HexToInt(ch) \
                (BYTE)(((ch) > '9') ? ((ch) - 55) : ((ch) - '0'))

// Converts the data in source to a null-terminated hex
// string in dest. The parameter size should contain 
// the size of source.
void ConvertDataToHex(const LPSTR source,LPSTR dest,int size)
  {
  int j = 0;

  for (int i = 0;i < size;i++)
    {
    BYTE ch = source[i];

    dest[j++] = hexString[(ch >> 4) & 0x0F];
    dest[j++] = hexString[ch & 0x0F];
    }
  dest[j] = '\0';
  }

// Converts the null-terminated hex string in source to
// data stored in dest.
void ConvertHexToData(const LPSTR source,LPSTR dest)
  {
  BYTE data;
  int len = lstrlen(source),
      j = 0;

  for (int i = 0;i < len;i+=2)
    {
    data = HexToInt(source[i]);
    dest[j++] = (BYTE)((data << 4) | HexToInt(source[i+1]));
    }
  }
