unit TraceUnit;

interface

uses  Forms, Classes, SysUtils, OleAuto, Windows, Messages;

procedure Trace(s: string; p: array of const);
procedure Trace0(s: string);

implementation

{$IFDEF TRACESERVER}
uses TraceMsg;

var
   Tracer         : Variant;
   MsgWnd         : HWND;
   SharedMutex    : THandle;
   SharedFileMap  : THandle;
   SharedEvent    : THandle;
   OtherProcess   : THandle;
   OtherProcessID : integer;
   MyMutex        : THandle;
   MyFileMap      : THandle;
   MyEvent        : THandle;
   FilePtr        : pointer;
   Ring           : TSharedRing;
   rc             : boolean;
{$ENDIF}

var
   TraceLoaded    : boolean;
   TraceIsDone    : boolean;
   TraceFile      : TFileStream;

procedure Trace0(s: string);
const
   CR = #13#10;
var
   tmp : string;
begin
   if TraceIsDone then exit;
   
   if TraceLoaded then begin
      {$IFDEF TRACESERVER}
      s := Copy(s, 1, sizeof(TRingStr)-1);
      while not Ring.Push(s) do Sleep(100);
      SetEvent(MyEvent);
      {$ENDIF}
   end else begin
      tmp := s + CR;
      TraceFile.Write(tmp[1], Length(tmp));
   end;
end;

procedure Trace(s: string; p: array of const);
begin
   Trace0(Format(s, p));
end;


initialization
   TraceIsDone := False;
   TraceLoaded := False;

try
   {$IFDEF TRACESERVER}
   Tracer := CreateOleObject('TraceServ.Output');
   MsgWnd := Tracer.GetTraceHandle;
   SetFocus(Application.Handle);

   SharedMutex     := Tracer.GetMutexHandle;
   SharedFileMap   := Tracer.GetFileMapHandle;
   SharedEvent     := Tracer.GetEventHandle;
   OtherProcessID  := Tracer.GetProcessID;
   OtherProcess    := OpenProcess(STANDARD_RIGHTS_REQUIRED, False, OtherProcessID);

   rc := DuplicateHandle(OtherProcess, SharedEvent, GetCurrentProcess, @MyEvent, EVENT_ALL_ACCESS, False, 0);
   if rc=FALSE then raise Exception.Create('Could not duplicate Event');
   rc := DuplicateHandle(OtherProcess, SharedMutex, GetCurrentProcess, @MyMutex, MUTEX_ALL_ACCESS, False, 0);
   if rc=FALSE then raise Exception.Create('Could not duplicate Mutex');
   rc := DuplicateHandle(OtherProcess, SharedFileMap, GetCurrentProcess, @MyFileMap, FILE_MAP_ALL_ACCESS, False, 0);
   if rc=FALSE then raise Exception.Create('Could not duplicate FileMap');

   FilePtr := MapViewOfFile(MyFileMap, FILE_MAP_WRITE, 0, 0, 0);
   Ring    := TSharedRing.Create(MyMutex, FilePtr);
   TraceLoaded := True;
   {$ENDIF}
except
   on Exception do begin end;
end;
   if not TraceLoaded then
      TraceFile := TFileStream.Create('TraceFile.txt', fmCreate or fmShareDenyWrite);

finalization
   {$IFDEF TRACESERVER}
   if Ring<>nil then Ring.Free;
   CloseHandle(MyMutex);
   CloseHandle(MyFileMap);
   CloseHandle(MyEvent);
   {$ENDIF}
   if TraceFile<>nil then TraceFile.Free;
end.

