unit TableEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, HTMLTable, StdCtrls, HTMLFormSection, ExtCtrls, HTMLHeader,
  HTMLForm, DBTables;

type
  TTableEditForm = class(THTMLForm)
    HTMLHeader1: THTMLHeader;
    ButtonSection: THTMLFormSection;
    AddBut: TButton;
    HTMLTable1: THTMLTable;
    ReturnBut: TButton;
    Label3: TLabel;
    StatLabel: TLabel;
    DelAllBut: TButton;
    ImportBut: TButton;
    HTMLHeader2: THTMLHeader;
    FirstBut: TButton;
    Back10But: TButton;
    For10But: TButton;
    LastBut: TButton;
    BackBut: TButton;
    ForwardBut: TButton;
    EditSection: THTMLFormSection;
    EditBut: TButton;
    DelBut: TButton;
    ClearBut: TButton;
    procedure ReturnButClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure AddButClick(Sender: TObject);
    procedure DelButClick(Sender: TObject);
    procedure ClearButClick(Sender: TObject);
    procedure ForwardButClick(Sender: TObject);
    procedure BackButClick(Sender: TObject);
    procedure For10ButClick(Sender: TObject);
    procedure Back10ButClick(Sender: TObject);
    procedure FirstButClick(Sender: TObject);
    procedure LastButClick(Sender: TObject);
    procedure DelAllButClick(Sender: TObject);
    procedure EditButClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FTable     : TTable;
    procedure  SetTable(t: TTable);
    function   FindEdit(i: integer): TEdit;
    procedure  SetStat(s: string);
  public
    procedure  LocalWrap(Call: TNotifyEvent);
    procedure  AddRecord(Sender: TObject);
    procedure  EditRecord(Sender: TObject);
    procedure  DeleteRecord(Sender: TObject);
    procedure  EmptyTable(Sender: TObject);
    property   Table: TTable read FTable write SetTable;
    property   Stat: string write SetStat;
  end;


implementation

uses PoolGlobals, TraceUnit, Admin;

{$R *.DFM}

procedure TTableEditForm.SetStat(s: string);
begin
   StatLabel.Caption := s;
end;

procedure TTableEditForm.SetTable(t: TTable);
const
   BORDER = 16;
   HGT    = 48;
var
   i, pos  : integer;
   NonLF   : integer;
   fc      : integer;
   NewLab  : TLabel;
   NewEdit : TEdit;
   fn      : string;
begin
   FTable := t;
   Globals(Self).TableEdit := t;
   if Table=nil then exit;

   HTMLHeader2.Caption := 'Current Table = ' + Table.TableName;

   // Create the Edit components for this Table

   // First Clear out the old controls
   for i := EditSection.ControlCount-1 downto 0 do begin
      EditSection.Controls[i].Free;
   end;

   fc := Table.FieldCount;
   pos := 0;

   NonLF := 0;
   for i := 0 to fc-1 do
      if Table.Fields[i].Lookup = False then Inc(NonLF);

   for i := 0 to fc-1 do begin
      if Table.Fields[i].Lookup then continue;

      NewLab            := TLabel.Create(self);
      NewLab.Parent     := EditSection;
      fn := Table.Fields[i].FieldName;
      if Table.Fields[i].Required then fn := fn + ' (Req''d)';
      NewLab.Caption    := fn;
      NewLab.Name       := Format('SecLab%d', [i]);
      if pos < NonLF div 2 then begin
         NewLab.Left    := 20;
         NewLab.Top     := 1 + HGT * pos;
      end else begin
         NewLab.Left    := 300;
         NewLab.Top     := 1 + HGT * (pos - NonLF div 2);
      end;
      TRACE('Adding Field %s at %d, %d', [fn, NewLab.Left, NewLab.Top]);

      NewEdit           := TEdit.Create(self);
      NewEdit.Parent    := EditSection;
      NewEdit.Text      := '';
      NewEdit.Left      := NewLab.Left;
      NewEdit.Top       := NewLab.Top + 16;
      NewEdit.Tag       := i + 1;
      NewEdit.Name      := Format('SecEdit%d', [i]);

      pos := pos + 1;
   end;
   EditSection.Height := ((NonLF+1) div 2) * HGT + BORDER;
end;

procedure TTableEditForm.ReturnButClick(Sender: TObject);
begin
   ShowFormType(TAdminForm);
end;

function TTableEditForm.FindEdit(i: integer): TEdit;
var
   j : integer;
begin
   Result := nil;
   for j := 0 to EditSection.ControlCount-1 do
      if (EditSection.Controls[j] is TEdit) then
         if TEdit(EditSection.Controls[j]).Tag = i then
            Result := EditSection.Controls[j] as TEdit;
end;

procedure TTableEditForm.FormShow(Sender: TObject);
var
   i, j : integer;
   e    : TEdit;
begin
   if Table=nil then exit;
   HTMLTable1.Fill_N(Table, 10);

   if Globals(self).DoFillEdits = True then begin
      // Fill in the Data for the current record
      for i := 0 to Table.FieldCount-1 do begin
         e := FindEdit(i + 1);
         e.Text := Table.Fields[i].AsString;
      end;
   end;
   Globals(self).DoFillEdits := True;
end;

procedure TTableEditForm.LocalWrap(Call: TNotifyEvent);
begin
   try
      Call(nil);
   except
      on E: Exception do begin
         Stat := E.Message;
         if Table.State <> dsBrowse then Table.Cancel;
         OnShow(nil);
      end;
   end;
end;

procedure TTableEditForm.AddRecord(Sender: TObject);
var
   i : integer;
   e : TEdit;
begin
   Table.Append;
   for i := 0 to Table.FieldCount-1 do begin
      e := FindEdit(i + 1);
      // I check for blank strings to leave in NULLs (for required field checking)
      if e.Text<>'' then Table.Fields[i].AsString := e.Text;
   end;
   Table.Post;
   Stat := 'Added Record';
   OnShow(nil);
end;

procedure TTableEditForm.EditRecord(Sender: TObject);
var
   i : integer;
   e : TEdit;
begin
   Table.Edit;
   for i := 0 to Table.FieldCount-1 do begin
      e := FindEdit(i + 1);
      if e = nil then continue;
      // I check for blank strings to leave in NULLs (for required field checking)
      if e.Text<>'' then
         Table.Fields[i].AsString := e.Text
      else
         Table.Fields[i].Clear;
   end;
   Table.Post;
   Stat := 'Edited Record';
   OnShow(nil);
end;

procedure TTableEditForm.DeleteRecord(Sender: TObject);
begin
   Table.Delete;
   Stat := 'Deleted Record';
   OnShow(nil);
end;

procedure TTableEditForm.AddButClick(Sender: TObject);
begin
   LocalWrap(AddRecord);
end;

procedure TTableEditForm.DelButClick(Sender: TObject);
begin
   LocalWrap(DeleteRecord);
end;

procedure TTableEditForm.ClearButClick(Sender: TObject);
var
   i : integer;
   e : TEdit;
begin
   for i := 0 to Table.FieldCount-1 do begin
      e := FindEdit(i + 1);
      e.Text := '';
   end;
   Stat := 'Cleared Edits - Ready to Add';
   Globals(self).DoFillEdits := False;
   OnShow(nil);
end;

procedure TTableEditForm.ForwardButClick(Sender: TObject);
begin
   if Table.MoveBy(1) = 0 then
      Stat := 'Already at the End'
   else
      Stat := 'Moved Forward (1)';
   OnShow(nil);
end;

procedure TTableEditForm.BackButClick(Sender: TObject);
begin
   if Table.MoveBy(-1) = 0 then
      Stat := 'Already at the Beginning'
   else
      Stat := 'Moved Backward (1)';
   OnShow(nil);
end;

procedure TTableEditForm.For10ButClick(Sender: TObject);
begin
   if Table.MoveBy(10) = 0 then
      Stat := 'Already at the End'
   else
      Stat := 'Moved Forward (10)';
   OnShow(nil);
end;

procedure TTableEditForm.Back10ButClick(Sender: TObject);
begin
   if Table.MoveBy(-10) = 0 then
      Stat := 'Already at the Beginning'
   else
      Stat := 'Moved Backward (10)';
   OnShow(nil);
end;

procedure TTableEditForm.FirstButClick(Sender: TObject);
begin
   Table.First;
   Stat := 'Moved to First';
   OnShow(nil);
end;

procedure TTableEditForm.LastButClick(Sender: TObject);
begin
   Table.Last;
   Stat := 'Moved to Last';
   OnShow(nil);
end;

procedure TTableEditForm.DelAllButClick(Sender: TObject);
begin
   Inc(Globals(Self).DeleteCount);
   if Globals(Self).DeleteCount = 1 then begin
      Stat := 'Delete *ALL* Records? (press again to confirm)';
   end;
   if Globals(Self).DeleteCount = 2 then begin
      Globals(Self).DeleteCount := 0;
      LocalWrap(EmptyTable);
   end;
end;

procedure TTableEditForm.EmptyTable(Sender: TObject);
begin
   Table.Active := False;
   Table.EmptyTable;
   Table.Active := True;
   Stat := 'Deleted All Table Records';
   OnShow(nil);
end;


procedure TTableEditForm.EditButClick(Sender: TObject);
begin
   LocalWrap(EditRecord);
end;

procedure TTableEditForm.FormCreate(Sender: TObject);
begin
   Table := Globals(self).TableEdit;
end;

end.
