unit PoolGlobals;

interface

uses HTMLForm, CachedObject, Main, DataMod, Admin, TableEdit, DBTables;

type
   TPoolGlobals = class(TCachedObject)
   public
      // MainForm
      UserName       : string;
      UserPass       : string;
      NumAttempts    : integer;
      LogonTime      : TDateTime;
      LastLogon      : TDateTime;
      IsGuest        : boolean;
      IsAdmin        : boolean;

      // TableEditForm
      TableEdit      : TTable;
      DeleteCount    : integer;
      DoFillEdits    : boolean;

      // Globals
      PoolData       : TPoolData;
      constructor Create;
      destructor  Destroy; override;
   end;

   function Globals(f: THTMLForm) : TPoolGlobals;
   function CreateGlobals : TCachedObject;

implementation

constructor TPoolGlobals.Create;
begin
   inherited;
   PoolData    := TPoolData.Create(nil);
   DoFillEdits := True;
end;

destructor TPoolGlobals.Destroy;
begin
   PoolData.Free;
   inherited;
end;


function Globals(f: THTMLForm): TPoolGlobals;
begin
   Result := f.BaseGlobals as TPoolGlobals;
end;

function CreateGlobals: TCachedObject;
begin
   Result := TPoolGlobals.Create;
end;


end.
