unit DataMod;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, DB;

type
   TEachTable = procedure(Table: TTable) of object;

  TPoolData = class(TDataModule)
    Session1: TSession;
    UserTable: TTable;
    UserTableUserID: TAutoIncField;
    UserTableUserName: TStringField;
    UserTableUserPass: TStringField;
    UserTableLastLogon: TDateTimeField;
    UserTableNumLogons: TIntegerField;
    GlobalsTable: TTable;
    GlobalsTableCurWeek: TIntegerField;
    TeamsTable: TTable;
    TeamsTableTeamName: TStringField;
    GamesTable: TTable;
    GamesTableWeek: TIntegerField;
    GamesTableGameNum: TIntegerField;
    GamesTableHomeTeamID: TIntegerField;
    GamesTableAwayTeamID: TIntegerField;
    GamesTableSpread: TFloatField;
    GamesTablePlayed: TBooleanField;
    GamesTableScore1: TIntegerField;
    GamesTableScore2: TIntegerField;
    WeeksTable: TTable;
    WeeksTableWeek: TIntegerField;
    WeeksTableTotGames: TIntegerField;
    PicksTable: TTable;
    PicksTablePlayerID: TIntegerField;
    PicksTableWeek: TIntegerField;
    PicksTableGameID: TIntegerField;
    PicksTablePick: TIntegerField;
    PlayerWeeksTable: TTable;
    PlayerWeeksTableWeekID: TIntegerField;
    PlayerWeeksTablePlayerID: TIntegerField;
    PlayerWeeksTablePaid: TBooleanField;
    PlayerWeeksTablePaidAmount: TFloatField;
    PlayerWeeksTableComment: TStringField;
    GamesTableHomeTeamName: TStringField;
    GamesTableAwayTeamName: TStringField;
    PicksTablePlayerName: TStringField;
    PlayerWeeksTablePlayerName: TStringField;
    WeeksTableLockOutTime: TDateTimeField;
    PlayerWeeksTablePlayedWeek: TBooleanField;
    TeamsTableTeamID: TAutoIncField;
    procedure PoolDataCreate(Sender: TObject);
  private
    { Private declarations }
  public
    TempDir    : string;
    procedure  CopyUsers(Items: TStrings);
    procedure  OpenTables;
    procedure  CreateTables;
    procedure  DeleteTables;
    procedure  ForEachTable(EachTable: TEachTable);
    procedure  OpenOneTable(Table: TTable);
    procedure  DeleteOneTable(Table: TTable);
    procedure  InitTable(Table: TTable);
    procedure  CloseTable(Table: TTable);
    procedure  ClearIndexDefs(Table: TTable);
    function   GetMaxID(Table: TTable; FieldName: string): integer;
  end;

var
  PoolData: TPoolData;

implementation

{$R *.DFM}

var
   SesNum   : integer;

procedure TPoolData.ForEachTable(EachTable: TEachTable);
var
   i : integer;
   c : TComponent;
begin
   for i := 0 to ComponentCount-1 do begin
      c := Components[i];
      if (c is TTable) then
         EachTable(TTable(c));
   end;
end;

procedure TPoolData.PoolDataCreate(Sender: TObject);
var
   sn       : string;
   i        : integer;
   c        : TComponent;
begin
   Inc(SesNum);
   sn := Format('PoolData%d', [SesNum]);

   // We need a unique Session so that we are thread-safe
   Session1.SessionName := sn;
   Session1.Active := True;

   // Set all Tables to the correct Session Name
   for i := 0 to ComponentCount-1 do begin
      c := Components[i];
      if (c is TTable) then
         TTable(c).SessionName := sn;
   end;

   try
      OpenTables;
   except
      on EDataBaseError do begin
         // This is a little dangerous to Recreate the tables on ANY exception
         // I assume the exception is "Table does not exist"
         CreateTables;
      end;
   end;
end;

procedure TPoolData.CopyUsers(Items: TStrings);
var
   i : integer;
begin
   Items.Clear;

   UserTable.First;
   for i := 0 to UserTable.RecordCount-1 do begin
      Items.Add(UserTable.FieldByName('UserName').AsString);
      UserTable.Next;
   end;
end;

procedure TPoolData.OpenOneTable(Table: TTable);
begin
   Table.Active := True;
end;

procedure TPoolData.InitTable(Table: TTable);
begin
   Table.SessionName  := Session1.SessionName;
   Table.DatabaseName := TempDir;
end;

procedure TPoolData.OpenTables;
var
   TempBuf  : array[0..512] of char;
begin
   GetEnvironmentVariable('TEMP', TempBuf, sizeof(TempBuf));
   TempDir := TempBuf;
   if Copy(TempDir, Length(TempDir), 1)<>'\' then
      TempDir := TempDir + '\';

   ForEachTable(InitTable);
   ForEachTable(OpenOneTable);
end;

procedure TPoolData.CloseTable(Table: TTable);
begin
   Table.Active := False;
end;

procedure TPoolData.ClearIndexDefs(Table: TTable);
begin
   Table.IndexDefs.Clear;
end;

procedure TPoolData.CreateTables;
begin
   ForEachTable(CloseTable);
   ForEachTable(ClearIndexDefs);

   with UserTable do begin
      IndexDefs.Add('UserID',   'UserID',   [ixPrimary]);
      IndexDefs.Add('UserName', 'UserName', []);
      CreateTable;
   end;

   with GlobalsTable do begin
      CreateTable;
   end;

   with TeamsTable do begin
      IndexDefs.Add('TeamID', 'TeamID', [ixPrimary]);
      CreateTable;
   end;

   with GamesTable do begin
      IndexDefs.Add('GamesIdx', 'WeekID;GameID', [ixPrimary]);
      CreateTable;
   end;

   with WeeksTable do begin
      IndexDefs.Add('WeekID', 'WeekID', [ixPrimary]);
      CreateTable;
   end;

   with PicksTable do begin
      IndexDefs.Add('PicksIdx', 'WeekID;PlayerID;GameID', [ixPrimary]);
      CreateTable;
   end;

   with PlayerWeeksTable do begin
      IndexDefs.Add('PyrWeekIdx', 'WeekID;PlayerID', [ixPrimary]);
      CreateTable;
   end;

   OpenTables;
end;

function TPoolData.GetMaxID(Table: TTable; FieldName: string): integer;
begin
   Table.IndexFieldNames := FieldName;
   Table.Last;
   Result := Table.FieldByName(FieldName).AsInteger;
end;


procedure TPoolData.DeleteOneTable(Table: TTable);
begin
   Table.DeleteTable;
end;

procedure TPoolData.DeleteTables;
begin
   ForEachTable(CloseTable);
   ForEachTable(DeleteOneTable);
end;


end.
