' vxBase Sample Application
' Aircraft Brokerage System
' ------------------------

' Declare file select areas as Global
' so they can be accessed from any form
' -------------------------------------
Global AirPicsDbf As Integer
Global AirtypesDbf As Integer
Global AirTypesNtx As Integer
Global AircustDbf As Integer
Global Aircust1Ntx As Integer
Global Aircust2Ntx As Integer
Global Aircust3Ntx As Integer
Global AirstateDbf As Integer
Global Airstat1Ntx As Integer
Global Airstat2Ntx As Integer
Global AirbuyerDbf As Integer
Global Airbuy1Ntx As Integer
Global Airbuy2Ntx As Integer
Global AircraftDbf As Integer
Global Aircraf1Ntx As Integer
Global Aircraf2Ntx As Integer

' vars for each browse return so other forms can interrogate
' ----------------------------------------------------------
Global TypeReturn As Long
Global CustReturn As Long
Global BuyerReturn As Long
Global AircraftReturn As Long
Global StateReturn As Long

' vars to hold internal linkage keys
' ----------------------------------
Global CustKey As String
Global TypeKey As String
Global BuyerRec As Long

' Form active vars so we can test if any active
' when we close the system down in vxform1
' ----------------------------------------------
Global Form2Active As Integer
Global Form3Active As Integer
Global Form4Active As Integer
Global Form5Active As Integer
Global Form6Active As Integer
Global Form7Active As Integer

' Define some WINAPI stuff to limit text length and change cursors
' ----------------------------------------------------------------
Declare Function GetFocus% Lib "user" ()
Declare Function SetFocusApi Lib "user" Alias "SetFocus" (ByVal Hwnd As Integer) As Integer
Declare Function SendMessage& Lib "user" (ByVal Hwnd%, ByVal wMsg%, ByVal wParam%, ByVal lParam&)
Global Const WM_USER = &H400
Global Const EM_LIMITTEXT = WM_USER + 21
Global Const WM_CLOSE = &H10

Declare Function LoadCursor Lib "user" (ByVal hInstance As Integer, ByVal CursorName As Long) As Integer
Declare Function SetCursor Lib "user" (ByVal hCursor As Integer) As Integer
Global Const IDC_WAIT = 32514&
Global Const IDC_ARROW = 32512&

' winapi stuff to limit to a single app or to get browse handle
' -------------------------------------------------------------
Declare Function FindWindow Lib "user" (ByVal ClassName As Any, ByVal Caption As Any) As Integer

' ----------------------------------------------
' vxBase.txt contains the necessary declarations
' to run vxBase from Visual Basic
' ----------------------------------------------
' vxBase Global Constants
' -----------------------
Global Const BROWSE_CLOSED = -1
Global Const BROWSE_EDIT = -2
Global Const BROWSE_ADD = -3
Global Const BROWSE_DELETE = -4
Global Const BROWSE_ERROR = -5
Global Const BROWSE_USER = -6

' vxBase Color References for user tables
' ---------------------------------------
Global Const VX_RED = &HFF
Global Const VX_BLUE = &HFF0000
Global Const VX_GRAY = &HC0C0C0

' vxBase Control style modes
' --------------------------
Global Const VX_RAISE = 0
Global Const VX_RECESS = 1
Global Const VX_CREASE = 2
Global Const VX_FLAT = 3

' vxBase Table Field Types
' ------------------------
Global Const VX_FIELD = 0
Global Const VX_EXPR = 1

' browse case types
' -----------------
Global Const VX_UPPER = 0
Global Const VX_LOWER = 1

' vxCtlFormat defs
' ----------------
Global Const VX_CHAR = 1
Global Const VX_ALPHA = 2
Global Const VX_NUM = 3
Global Const VX_DATE = 4
Global Const VX_PASSWORD = 5

' vxBase String Return Types
' --------------------------
Global Const VX_VBSTRING = 0
Global Const VX_ASCIIZ = 1

' vxBase Menu item identifiers
' ----------------------------
Global Const VX_SEPBAR = 2
Global Const VX_MENUHEAD = 1
Global Const VX_RETURN = 0

' Country specific identifiers
' ----------------------------
Global Const VX_ENGLISH = 0
Global Const VX_AMERICAN = 0
Global Const VX_ANSI = 1
Global Const VX_BRITISH = 2
Global Const VX_FRENCH = 3
Global Const VX_GERMAN = 4
Global Const VX_ITALIAN = 5
Global Const VX_DUTCH = 6
Global Const VX_SPANISH = 7

' directions for locate
' ---------------------
Global Const VX_FORWARD = 0
Global Const VX_BACKWARD = 1

' font weights for vxBrowseSetup
' ------------------------------
Global Const VX_DONTCARE = 0
Global Const VX_THIN = 100
Global Const VX_EXTRALIGHT = 200
Global Const VX_LIGHT = 300
Global Const VX_NORMAL = 400
Global Const VX_MEDIUM = 500
Global Const VX_SEMIBOLD = 600
Global Const VX_BOLD = 700
Global Const VX_EXTRABOLD = 800
Global Const VX_HEAVY = 900

' vxCtlBrowseMsg Message values
' -----------------------------
Global Const VXB_REFRESH = 0
Global Const VXB_FILTERDLG = 1
Global Const VXB_FILTERPRG = 2
Global Const VXB_GETCURRENTREC = 3
Global Const VXB_GETTOPREC = 4
Global Const VXB_STATS = 5
Global Const VXB_CASE = 6
Global Const VXB_SEARCHDLG = 7
Global Const VXB_SEARCHPRG = 8
Global Const VXB_SEARCHAGAIN = 9
Global Const VXB_SEEK = 10
Global Const VXB_CLOSE = 11


' vxBase CALLed Sub Procedures
' ----------------------------
Declare Sub vxBrowse Lib "vxbase.dll" (ByVal Hwnd%, ByVal DbfArea%, ByVal NtxArea%, ByVal EditMode%, ByVal AllowFilter%, ByVal EditMenu%, ByVal StartRec&, ByVal Caption$, RetVal&)
Declare Sub vxBrowseCase Lib "vxbase.dll" (ByVal DefCase As Integer)
Declare Sub vxBrowsePos Lib "vxbase.dll" (ByVal StartX As Integer, ByVal StartY As Integer, ByVal xWidth As Integer, ByVal yHeight As Integer)
Declare Sub vxBrowseSetup Lib "vxbase.dll" (ByVal Menus%, ByVal PrintMenu%, ByVal QCol%, ByVal V3D%, ByVal FontName$, ByVal FontSize%, ByVal Weight%, ByVal Italic%, ByVal Hdr%, ByVal MinMax%, ByVal Thresh%)
Declare Sub vxCtlGrayReset Lib "vxbase.dll" ()
Declare Sub vxCtlGraySet Lib "vxbase.dll" ()
Declare Sub vxCtlLength Lib "vxbase.dll" (ByVal FieldName As String)
Declare Sub vxCtlPenWidth Lib "vxbase.dll" (ByVal PenWidth As Integer)
Declare Sub vxCtlStyle Lib "vxbase.dll" (CtlName As Any, ByVal Mode As Integer)
Declare Sub vxDouble Lib "vxbase.dll" (ByVal FieldName As String, DblAmount As Double)
Declare Sub vxExactOff Lib "vxbase.dll" ()
Declare Sub vxExactOn Lib "vxbase.dll" ()
Declare Sub vxFilter Lib "vxbase.dll" (ByVal FilterString As String)
Declare Sub vxFilterReset Lib "vxbase.dll" ()
Declare Sub vxFormFrame Lib "vxbase.dll" (ByVal Hwnd As Integer)
Declare Sub vxInit Lib "vxbase.dll" ()
Declare Sub vxJoin Lib "vxbase.dll" (ByVal DbfArea As Integer, ByVal NtxArea As Integer, ByVal JoinExpr As String, ByVal KeyType As Integer, ByVal JoinTitle As String)
Declare Sub vxJoinNoAuto Lib "vxbase.dll" ()
Declare Sub vxJoinReset Lib "vxbase.dll" ()
Declare Sub vxMemoEdit Lib "vxbase.dll" (ByVal Hwnd As Integer, ByVal FieldName As String)
Declare Sub vxMenuDeclare Lib "vxbase.dll" (ByVal NumItems As Integer)
Declare Sub vxMenuItem Lib "vxbase.dll" (ByVal MenuIndex As Integer, ByVal MenuLev As Integer, ByVal MenuString As String, ByVal MenuType As Integer)
Declare Sub vxReplDate Lib "vxbase.dll" (ByVal FieldName As String, ByVal DateString As String)
Declare Sub vxReplDateString Lib "vxbase.dll" (ByVal FieldName As String, ByVal DateString As String)
Declare Sub vxReplDouble Lib "vxbase.dll" (ByVal FieldName As String, DblAmount As Double)
Declare Sub vxReplInteger Lib "vxbase.dll" (ByVal FieldName As String, IntAmount As Integer)
Declare Sub vxReplLogical Lib "vxbase.dll" (ByVal FieldName As String, ByVal BoolVal As Integer)
Declare Sub vxReplLong Lib "vxbase.dll" (ByVal FieldName As String, LongInt As Long)
Declare Sub vxReplRecord Lib "vxbase.dll" (RecStruc As Any)
Declare Sub vxReplString Lib "vxbase.dll" (ByVal FieldName As String, ByVal FieldString As String)
Declare Sub vxSetDate Lib "vxbase.dll" (ByVal DateType As Integer)
Declare Sub vxSetErrorCaption Lib "vxbase.dll" (ByVal CaptionString As String)
Declare Sub vxSetErrorMethod Lib "vxbase.dll" (ByVal VbOrVx As Integer)
Declare Sub vxSetLanguage Lib "vxbase.dll" (ByVal LangType As Integer)
Declare Sub vxSetLocks Lib "vxbase.dll" (ByVal OnOrOff As Integer)
Declare Sub vxSetMeters Lib "vxbase.dll" (ByVal OnOrOff As Integer)
Declare Sub vxSetString Lib "vxbase.dll" (ByVal StrType As Integer)
Declare Sub vxSetupPrinter Lib "vxbase.dll" (ByVal Hwnd As Integer)
Declare Sub vxSum Lib "vxbase.dll" (ByVal FieldName As String, DblAmount As Double)
Declare Sub vxTableDeclare Lib "vxbase.dll" (ByVal ColorRef&, BofExpr As Any, EofExpr As Any, ByVal Scope%, ByVal Quick%, ByVal Columns%)
Declare Sub vxTableField Lib "vxbase.dll" (ByVal ColIndex As Integer, ByVal ColHead As String, ByVal ColExpr As String, ByVal ColType As Integer)
Declare Sub vxTableFieldExt Lib "vxbase.dll" (ByVal ColIndex As Integer, ByVal ColHead As String, ByVal ColExpr As String, ByVal ColType As Integer, ByVal ColWidth As Integer, ByVal DbfArea As Integer)
Declare Sub vxTableReset Lib "vxbase.dll" ()
Declare Sub vxWindowDereg Lib "vxbase.dll" (ByVal Hwnd As Integer)


' vxBase Functions
' ----------------
Declare Function vxAppendBlank Lib "vxbase.dll" () As Integer
Declare Function vxAppendFrom Lib "vxbase.dll" (ByVal FromFile As String) As Integer
Declare Function vxAreaDbf Lib "vxbase.dll" (ByVal DbfName As String) As Integer
Declare Function vxAreaNtx Lib "vxbase.dll" (ByVal NtxName As String) As Integer
Declare Function vxBof Lib "vxbase.dll" () As Integer
Declare Function vxBottom Lib "vxbase.dll" () As Integer
Declare Function vxChar Lib "vxbase.dll" (ByVal FieldName As String) As String
Declare Function vxClose Lib "vxbase.dll" () As Integer
Declare Function vxCloseAll Lib "vxbase.dll" () As Integer
Declare Function vxCloseNtx Lib "vxbase.dll" (ByVal NtxArea As Integer) As Integer
Declare Function vxCopy Lib "vxbase.dll" (ByVal NewDbfName As String) As Integer
Declare Function vxCopyStruc Lib "vxbase.dll" (ByVal NewDbfName As String) As Integer
Declare Function vxCreateNtx Lib "vxbase.dll" (ByVal NewNtxName As String, ByVal NtxExpr As String) As Integer
Declare Function vxCtlHwnd Lib "vxbase.dll" (ControlName As Any) As Integer
Declare Function vxCtlBrowse Lib "vxbase.dll" (ByVal ControlHwnd%, ByVal DbfArea%, ByVal NtxArea%, ByVal EditMode%, ByVal StartRec&, ByVal MemoHwnd%, ByVal MemoField$) As Integer
Declare Function vxCtlBrowseMsg Lib "vxbase.dll" (ByVal Hwnd As Integer, ByVal Msg As Integer, Param As Any) As Long
Declare Function vxCtlFormat Lib "vxbase.dll" (ByVal TextLen As Integer, ByVal Picture As Integer, ByVal Decimals As Integer) As Integer
Declare Function vxDateFormat Lib "vxbase.dll" (ByVal DateField As String) As String
Declare Function vxDateString Lib "vxbase.dll" (ByVal DateField As String, ByVal DateType As Integer) As String
Declare Function vxDbfDate Lib "vxbase.dll" () As String
Declare Function vxDbfName Lib "vxbase.dll" () As String
Declare Function vxDeallocate Lib "vxbase.dll" () As Integer
Declare Function vxDecimals Lib "vxbase.dll" (ByVal FieldName As String) As Integer
Declare Function vxDeleted Lib "vxbase.dll" () As Integer
Declare Function vxDeleteRange Lib "vxbase.dll" (ByVal StartRec As Long, ByVal EndRec As Long) As Integer
Declare Function vxDeleteRec Lib "vxbase.dll" () As Integer
Declare Function vxDescend Lib "vxbase.dll" (ByVal KeyString As String) As String
Declare Function vxEmpty Lib "vxbase.dll" (ByVal FieldName As String) As Integer
Declare Function vxEof Lib "vxbase.dll" () As Integer
Declare Function vxEval Lib "vxbase.dll" (ByVal XBaseExpr As String) As Integer
Declare Function vxEvalDouble Lib "vxbase.dll" (ByVal XBaseExpr As String, DblAmount As Double) As Integer
Declare Function vxEvalLogical Lib "vxbase.dll" (ByVal XBaseExpr As String, ByVal TrueFalse As String) As Integer
Declare Function vxEvalString Lib "vxbase.dll" (ByVal XBaseExpr As String, ByVal StringVal As String) As Integer
Declare Function vxField Lib "vxbase.dll" (ByVal FieldName As String) As String
Declare Function vxFieldCount Lib "vxbase.dll" () As Integer
Declare Function vxFieldName Lib "vxbase.dll" (ByVal FieldNumber As Integer) As String
Declare Function vxFieldSize Lib "vxbase.dll" (ByVal FieldName As String) As Integer
Declare Function vxFieldTrim Lib "vxbase.dll" (ByVal FieldName As String) As String
Declare Function vxFieldType Lib "vxbase.dll" (ByVal FieldName As String) As String
Declare Function vxFile Lib "vxbase.dll" (ByVal FileName As String) As Integer
Declare Function vxFound Lib "vxbase.dll" () As Integer
Declare Function vxGetVersion Lib "vxbase.dll" () As String
Declare Function vxGo Lib "vxbase.dll" (ByVal RecNum As Long) As Integer
Declare Function vxInteger Lib "vxbase.dll" (ByVal FieldName As String) As Integer
Declare Function vxIsMemo Lib "vxbase.dll" (ByVal MemoFieldName As String) As Integer
Declare Function vxIsPicture Lib "vxbase.dll" (ByVal MemoFieldName As String) As Integer
Declare Function vxIsRecLocked Lib "vxbase.dll" () As Integer
Declare Function vxLocate Lib "vxbase.dll" (ByVal XBaseExpr As String, ByVal Direction As Integer) As Long
Declare Function vxLocateAgain Lib "vxbase.dll" (ByVal Direction As Integer) As Long
Declare Function vxLockDbf Lib "vxbase.dll" () As Integer
Declare Function vxLocked Lib "vxbase.dll" () As Integer
Declare Function vxLockRecord Lib "vxbase.dll" () As Integer
Declare Function vxLong Lib "vxbase.dll" (ByVal FieldName As String) As Long
Declare Function vxMemoRead Lib "vxbase.dll" (ByVal FieldName As String, ByVal LineWidth As Integer) As String
Declare Function vxNtxCurrent Lib "vxbase.dll" () As Integer
Declare Function vxNtxDeselect Lib "vxbase.dll" () As Integer
Declare Function vxNtxExpr Lib "vxbase.dll" (ByVal NtxArea As Integer) As String
Declare Function vxNtxName Lib "vxbase.dll" (ByVal NtxArea As Integer) As String
Declare Function vxNtxRecNo Lib "vxbase.dll" () As Long
Declare Function vxNumRecs Lib "vxbase.dll" () As Long
Declare Function vxPack Lib "vxbase.dll" (ByVal Hwnd As Integer) As Integer
Declare Function vxPictureImport Lib "vxbase.dll" (ByVal FileName As String, ByVal FieldName As String) As Integer
Declare Function vxPictureRead Lib "vxbase.dll" (ByVal Hwnd As Integer, ByVal FieldName As String) As Integer
Declare Function vxPrinterDefault Lib "vxbase.dll" () As String
Declare Function vxPrinterEnum Lib "vxbase.dll" (ByVal PIndex As Integer) As String
Declare Function vxPrinterSelect Lib "vxbase.dll" (ByVal PrinterName As String) As Integer
Declare Function vxRecall Lib "vxbase.dll" () As Integer
Declare Function vxRecNo Lib "vxbase.dll" () As Long
Declare Function vxRecord Lib "vxbase.dll" (RecStruc As Any) As Integer
Declare Function vxRecSize Lib "vxbase.dll" () As Integer
Declare Function vxReindex Lib "vxbase.dll" () As Integer
Declare Function vxReplMemo Lib "vxbase.dll" (ByVal FieldName As String, ByVal MemoString As String) As Integer
Declare Function vxSeek Lib "vxbase.dll" (ByVal SearchKey As String) As Integer
Declare Function vxSeekFast Lib "vxbase.dll" (ByVal SearchKey As String) As Integer
Declare Function vxSeekSoft Lib "vxbase.dll" (ByVal SearchKey As String) As Integer
Declare Function vxSelectDbf Lib "vxbase.dll" (ByVal DbfArea As Integer) As Integer
Declare Function vxSelectNtx Lib "vxbase.dll" (ByVal NtxArea As Integer) As Integer
Declare Function vxSetAlias Lib "vxbase.dll" (ByVal AliasName As String, ByVal DbfArea As Integer) As Integer
Declare Function vxSetHandles Lib "vxbase.dll" (ByVal NumHandles As Integer) As Integer
Declare Function vxSetRelation Lib "vxbase.dll" (ByVal ToDbfArea As Integer, ByVal KeyConstructor As String) As Integer
Declare Function vxSkip Lib "vxbase.dll" (ByVal NumRecords As Long) As Integer
Declare Function vxTestNtx Lib "vxbase.dll" (ByVal NtxArea As Integer) As Integer
Declare Function vxTop Lib "vxbase.dll" () As Integer
Declare Function vxTrue Lib "vxbase.dll" (ByVal FieldName As String) As Integer
Declare Function vxUnlock Lib "vxbase.dll" () As Integer
Declare Function vxUseDbf Lib "vxbase.dll" (ByVal DbfName As String) As Integer
Declare Function vxUseDbfRO Lib "vxbase.dll" (ByVal DbfName As String) As Integer
Declare Function vxUseNtx Lib "vxbase.dll" (ByVal NtxName As String) As Integer
Declare Function vxWrite Lib "vxbase.dll" () As Integer
Declare Function vxWriteHdr Lib "vxbase.dll" () As Integer
Declare Function vxZap Lib "vxbase.dll" () As Integer


' ---------------------------------------
' File structure data type. Add more
' elements or delete unnecessary elements
' as required by the largest dbf creation
' in your application
' ---------------------------------------

Type FileStruc
   Fld01 As String * 16
   Fld02 As String * 16
   Fld03 As String * 16
   Fld04 As String * 16
   Fld05 As String * 16
   Fld06 As String * 16
   Fld07 As String * 16
   Fld08 As String * 16
   Fld09 As String * 16
   Fld10 As String * 16
   Fld11 As String * 16
   Fld12 As String * 16
   Fld13 As String * 16
   Fld14 As String * 16
   Fld15 As String * 16
   Fld16 As String * 16
   Fld17 As String * 16
   Fld18 As String * 16
   Fld19 As String * 16
   Fld20 As String * 16
   Fld21 As String * 16
   Fld22 As String * 16
   Fld23 As String * 16
   Fld24 As String * 16
   Fld25 As String * 16
   Fld26 As String * 16
   Fld27 As String * 16
   Fld28 As String * 16
   Fld29 As String * 16
   Fld30 As String * 16
   Fld31 As String * 16
   Fld32 As String * 16
End Type

' declare functions that use FileStruc type
' -----------------------------------------
Declare Function vxCreateDbf Lib "vxbase.dll" (ByVal NewDbfName As String, ByVal NumFields As Integer, FStructure As FileStruc) As Integer

' ----------------------------------------
' define types file record structure for
' use in vxform8 and the vxRecord  and
' vxReplRecord functions
' ----------------------------------------
Type CatRec
   cDelFlag As String * 1
   Category As String * 3
   CatName As String * 35
End Type
' note that every xbase record structure MUST begin
' with a single character deletion flag
' -------------------------------------------------

Type vxErrorStruc
   ErrorNum As Integer
   ErrorMsg As String * 80
   DbfArea As Integer
   NtxArea As Integer
   DbfName As String * 80
   NtxName As String * 80
   BadParm As String * 80
End Type

Declare Function vxErrorTest Lib "vxbase.dll" (ErrorStructure As vxErrorStruc) As Integer

Global vxError As vxErrorStruc

'============================================================================'
'                                                                            '
' Visual Basic global constant file.  This file can be loaded into the       '
' global module.                                                             '
'                                                                            '
' Some constants are commented out because they have duplicates (for         '
' example, NONE appears in several places).                                  '
'                                                                            '
'============================================================================'

'========='
'         '
' General '
'         '
'========='

'====================='
'                     '
' Function parameters '
'                     '
'====================='

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

'================='
'                 '
' Property values '
'                 '
'================='

' Alignment (label)
Global Const LEFT_JUSTIFY = 0          ' 0 - Left Justify
Global Const RIGHT_JUSTIFY = 1         ' 1 - Right Justify
Global Const CENTER = 2                ' 2 - Center

' BackColor, ForeColor, FillColor (standard RGB colors: form, controls)
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF

' BackColor, ForeColor, FillColor (system colors: form, controls)
Global Const SCROLL_BARS = &H80000000           ' Scroll-bars gray area.
Global Const DESKTOP = &H80000001               ' Desktop.
Global Const ACTIVE_TITLE_BAR = &H80000002      ' Active window caption.
Global Const INACTIVE_TITLE_BAR = &H80000003    ' Inactive window caption.
Global Const MENU_BAR = &H80000004              ' Menu background.
Global Const WINDOW_BACKGROUND = &H80000005     ' Window background.
Global Const WINDOW_FRAME = &H80000006          ' Window frame.
Global Const MENU_TEXT = &H80000007             ' Text in menus.
Global Const WINDOW_TEXT = &H80000008           ' Text in windows.
Global Const TITLE_BAR_TEXT = &H80000009        ' Text in caption, size box, scroll-bar arrow box..
Global Const ACTIVE_BORDER = &H8000000A         ' Active window border.
Global Const INACTIVE_BORDER = &H8000000B       ' Inactive window border.
Global Const APPLICATION_WORKSPACE = &H8000000C ' Background color of multiple document interface (MDI) applications.
Global Const HIGHLIGHT = &H8000000D             ' Items selected item in a control.
Global Const HIGHLIGHT_TEXT = &H8000000E        ' Text of item selected in a control.
Global Const BUTTON_FACE = &H8000000F           ' Face shading on command buttons.
Global Const BUTTON_SHADOW = &H80000010         ' Edge shading on command buttons.
Global Const GRAY_TEXT = &H80000011             ' Grayed (disabled) text.  This color is set to 0 if the current display driver does not support a solid gray color.
Global Const BUTTON_TEXT = &H80000012           ' Text on push buttons.

' BorderStyle (form, label, picture box, text box)
Global Const NONE = 0                  ' 0 - None
Global Const FIXED_SINGLE = 1          ' 1 - Fixed Single
Global Const SIZABLE = 2               ' 2 - Sizable (Forms only)
Global Const FIXED_DOUBLE = 3          ' 3 - Fixed Double (Forms only)

' DragMode (controls)
Global Const MANUAL = 0                ' 0 - Manual
Global Const AUTOMATIC = 1             ' 1 - Automatic

' DrawMode (form, picture box, Printer)
Global Const BLACKNESS = 1             ' 1 - Blackness
Global Const NOT_MERGE_PEN = 2         ' 2 - Not Merge Pen
Global Const MASK_NOT_PEN = 3          ' 3 - Mask Not Pen
Global Const NOT_COPY_PEN = 4          ' 4 - Not Copy Pen
Global Const MASK_PEN_NOT = 5          ' 5 - Mask Pen Not
Global Const INVERT = 6                ' 6 - Invert
Global Const XOR_PEN = 7               ' 7 - Xor Pen
Global Const NOT_MASK_PEN = 8          ' 8 - Not Mask Pen
Global Const MASK_PEN = 9              ' 9 - Mask Pen
Global Const NOT_XOR_PEN = 10          ' 10 - Not Xor Pen
Global Const NOP = 11                  ' 11 - Nop
Global Const MERGE_NOT_PEN = 12        ' 12 - Merge Not Pen
Global Const COPY_PEN = 13             ' 13 - Copy Pen
Global Const MERGE_PEN_NOT = 14        ' 14 - Merge Pen Not
Global Const MERGE_PEN = 15            ' 15 - Merge Pen
Global Const WHITENESS = 16            ' 16 - Whiteness

' DrawStyle (form, picture box, Printer)
Global Const SOLID = 0                 ' 0 - Solid
Global Const DASH = 1                  ' 1 - Dash
Global Const DOT = 2                   ' 2 - Dot
Global Const DASH_DOT = 3              ' 3 - Dash-Dot
Global Const DASH_DOT_DOT = 4          ' 4 - Dash-Dot-Dot
Global Const INVISIBLE = 5             ' 5 - Invisible
Global Const INSIDE_SOLID = 6          ' 6 - Inside Solid

' FillStyle (form, picture box, Printer)
' Global Const SOLID = 0               ' 0 - Solid
Global Const TRANSPARENT = 1           ' 1 - Transparent
Global Const HORIZONTAL_LINE = 2       ' 2 - Horizontal Line
Global Const VERTICAL_LINE = 3         ' 3 - Vertical Line
Global Const UPWARD_DIAGONAL = 4       ' 4 - Upward Diagonal
Global Const DOWNWARD_DIAGONAL = 5     ' 5 - Downward Diagonal
Global Const CROSS = 6                 ' 6 - Cross
Global Const DIAGONAL_CROSS = 7        ' 7 - Diagonal Cross

' LinkMode (controls)
' Global Const NONE = 0                ' 0 - None
Global Const HOT = 1                   ' 1 - Hot
Global Const COLD = 2                  ' 2 - Cold

' LinkMode (form)
' Global Const NONE = 0                ' 0 - None
Global Const SERVER = 1                ' 1 - Server

' MousePointer (form, controls)
Global Const DEFAULT = 0               ' 0 - Default
Global Const ARROW = 1                 ' 1 - Arrow
Global Const CROSSHAIR = 2             ' 2 - Cross
Global Const IBEAM = 3                 ' 3 - I-Beam
Global Const ICON_POINTER = 4          ' 4 - Icon
Global Const SIZE_POINTER = 5          ' 5 - Size
Global Const SIZE_NE_SW = 6            ' 6 - Size NE SW
Global Const SIZE_N_S = 7              ' 7 - Size N S
Global Const SIZE_NW_SE = 8            ' 8 - Size NW SE
Global Const SIZE_W_E = 9              ' 9 - Size W E
Global Const UP_ARROW = 10             ' 10 - Up Arrow
Global Const HOURGLASS = 11            ' 11 - Hourglass
Global Const NO_DROP = 12              ' 12 - No drop

' ScaleMode (form, picture box, Printer)
Global Const USER = 0                  ' 0 - User
Global Const TWIPS = 1                 ' 1 - Twip
Global Const POINTS = 2                ' 2 - Point
Global Const PIXELS = 3                ' 3 - Pixel
Global Const CHARACTERS = 4            ' 4 - Character
Global Const INCHES = 5                ' 5 - Inch
Global Const MILLIMETERS = 6           ' 6 - Millimeter
Global Const CENTIMETERS = 7           ' 7 - Centimeter

' ScrollBar (text box)
' Global Const NONE = 0                ' 0 - None
Global Const HORIZONTAL = 1            ' 1 - Horizontal
Global Const VERTICAL = 2              ' 2 - Vertical
Global Const BOTH = 3                  ' 3 - Both

' Value (check box)
Global Const UNCHECKED = 0             ' 0 - Unchecked
Global Const CHECKED = 1               ' 1 - Checked
Global Const GRAYED = 2                ' 2 - Grayed

' WindowState (form)
Global Const NORMAL = 0                ' 0 - Normal
Global Const MINIMIZED = 1             ' 1 - Minimized
Global Const MAXIMIZED = 2             ' 2 - Maximized

