/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <math.h>

#include "vstdefs.h"
#include "constant.h"
#include "vsttype.h"
#include "vstextrn.h"


void
SquintAngle(sp, trueAnomaly, curRaan, curArgPerigee, radius)
select_t *sp;
double trueAnomaly, curRaan, curArgPerigee, radius;
{
    mode_t *mp;
    track_t *tp;
    site_t *sitep;
    double phi, cosPhi, sinPhi, xOrb, yOrb, zOrb, xObs, yObs, zObs, scalar;
    double sinArgPerigee, cosArgPerigee, sinInclination, cosInclination;
    double satSqX, satSqY, satSqZ;
    double xObsOrb, yObsOrb, zObsOrb;
    extern double absol(double, double, double);
    
    tp = sp->sl_tp;
    
    if (!(tp->satp->s_flags & SF_ATTITUDE))
        return;
        
    sitep = tp->sitep;
    mp = tp->satp->s_modep;
    
    sinArgPerigee = sin(curArgPerigee);
    cosArgPerigee = cos(curArgPerigee);
    sinInclination = sin(tp->inclination);
    cosInclination = cos(tp->inclination);
        
    xOrb    =  radius * cos(trueAnomaly);   /* position in orbital plane */
    yOrb    =  radius * sin(trueAnomaly);
    zOrb    =  ZERO;

    phi     = reduce(tp->lastime - curRaan - HALFPI, ZERO, TWOPI);
    cosPhi  = cos(phi);
    sinPhi  = sin(phi);

    xObs    = sitep->c_vecX;
    yObs    = sitep->c_vecY;
    zObs    = sitep->c_vecZ;

    xObsOrb = (-sinArgPerigee * cosInclination*cosPhi + 
                cosArgPerigee * sinPhi) * xObs + 
                ( sinArgPerigee * cosInclination*sinPhi + 
                cosArgPerigee * cosPhi) * yObs -
                sinArgPerigee * sinInclination * zObs;

    yObsOrb = (-cosArgPerigee * cosInclination*cosPhi - 
                sinArgPerigee * sinPhi) * xObs + 
                ( cosArgPerigee * cosInclination*sinPhi - 
                sinArgPerigee * cosPhi) * yObs - 
                cosArgPerigee * sinInclination * zObs;

    zObsOrb =  -sinInclination * cosPhi * xObs +sinInclination * sinPhi * yObs +
                cosInclination * zObs;

    satSqX = -xOrb - xObsOrb;
    satSqY = -yOrb - yObsOrb;
    satSqZ = -zOrb - zObsOrb;
        
    scalar = mp->attVecX*satSqX + mp->attVecY*satSqY + mp->attVecZ*satSqZ;

    sp->sl_rp->r_squint = (float) (acos (- scalar /
            absol(satSqX, satSqY, satSqZ)) * CRD );
}
