#ifndef _VSTEXTRN_H
#define _VSTEXTRN_H
/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <stdio.h>
#include <string.h>

extern void nullfunc(char *, ...);
extern void (*diag)(char *, ...);

#ifdef _DEBUG_
extern void DebugFunc(char *,...);
extern void _vst_assert_(BOOL, char *, char *,  int);
#endif

extern BOOL CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);
extern BOOL CALLBACK UserMsgProc(HWND, UINT, WPARAM, LPARAM);
extern BOOL CALLBACK YesNoProc(HWND, UINT, WPARAM, LPARAM);
extern BOOL CALLBACK GetSetProc(HWND, UINT, WPARAM, LPARAM);
extern BOOL CALLBACK ShowSiteProc(HWND, UINT, WPARAM, LPARAM);
extern BOOL CALLBACK ShowSatProc(HWND, UINT, WPARAM, LPARAM);
extern BOOL CALLBACK RTDisplayProc(HWND, UINT, WPARAM, LPARAM);

extern POINT *DialogPos(HWND, HWND);
extern int  InitApplication(HANDLE);
extern int  InitInstance(HANDLE, HANDLE, int);
extern int  yesno(char *);
extern int  GetEditText(HWND, int, char *, int);
extern void usermsg(char *);
extern void PaintWindow(void);
extern void InitGraphics(void);
extern void SetScale(void);
extern void MakePen(HDC, int);
extern void MakeBrush(HDC, int);
extern void DestroyObjects(void);
extern void setwsize(HWND, BOOL);
extern void ColorSet(WPARAM, int, int);
extern void RedrawScreen(RECT *);
extern void duration_predict(select_t *);
extern void continuous_display_init(select_t *);
extern void continuous_display_finish(select_t *);
extern void fatal(char *);
extern void xsprintf(va_list,...);
extern void DrawTextStr(HDC, int, int, int, int, int, HFONT, char *, SIZE *);
extern void WaitCursor(void);
extern void NormCursor(void);
extern void setbutton(HWND, int, BOOL);
extern void SetColors();
extern int  rtd_start(HWND, HANDLE, select_t *);
extern void _display_lock(void), _display_unlock(void);
extern BOOL rtd_finish(select_t *);
extern void rtd_update(select_t *);
extern void rtd_init(void);
extern void rtd_delete(void);
extern BOOL rtd_anythread(void);
extern BOOL rtd_allrunning(void);
extern BOOL rtd_allstopped(void);
extern void rtd_allstop(void);
extern void rtd_allresume(void);
extern void rtd_savewindowstate(void);
extern void rtd_restorewindowstate(void);
extern void readactiveDB(void);
extern void saveactivelist(void);
extern char *getline(char *, int, FILE *);
extern void getMode(satellite_t *, int, char *);
extern BOOL setCurrSite(site_t *);
extern void printMode(FILE *, satellite_t *, int);
extern void upperCase(char *);
extern void lowerCase(char *);
extern void shortString(char *, char *);
extern void clipString(char *, int);
extern void stripTrailingSpace(char *);
extern char *stripLeadingSpace(char *);
extern char *saveString(char *);
extern void *safeAlloc(int);
extern void safeFree(void *);
extern int  cistrcmp(char *, char *);
extern void showSatellite(HWND, satellite_t *);
extern void listSatellites(HWND);
extern BOOL UnInstall(int);
extern double getElement(char *, int, int);
extern satellite_t *findSatbyName(char *);
extern satellite_t *findSatbyID(int);
extern int satCompare(const void *, const void *);
extern double reduce(double, double, double);
extern void siderealtime(track_t *, double);
extern void satposSPG4(select_t *, double, double *, double *,
    double *, double *, double *, double *, double *);
extern void params_init(satellite_t *, track_t *);
extern void predict_init(int, select_t *, double);
extern int  predict(int, select_t *, double);
extern select_t *findSelectionbyID(int);
extern select_t *findSelectionbyName(satellite_t *, site_t *);
extern void flagStr(unsigned int, char *);
extern select_t *addSelection(satellite_t *, site_t *, double, double, double,
        double, int, unsigned int);
extern BOOL modifySelectionbyName(HWND, select_t *, satellite_t *, site_t *,
        double, double,  double, double, int, unsigned int);
extern void listSelections(HWND);
extern int deleteSelection(select_t *);

extern BOOL init_main(void);
extern void rst(select_t *);

extern BOOL GetUserInput(char *, char *, char *, int);
extern BOOL GetKeyValue(char *, char *, int *);
extern select_t *checksat(int, int);

extern void getGroundTrack(double ,double ,double *,char *,char *);
extern void showSite(HWND, site_t *);
extern void listSites(HWND);
extern site_t *findSitebyName(char *);
extern site_t *findSitebyID(int);

extern BOOL ServerCreate(  exserver_t *, void *);
extern void ServerDestroy(void);
extern void FmtProc(int, int, exserver_t *, select_t *, char *);

extern double utctime(void);
extern long   day_number(int, int ,int);
extern void   daytodate(long ,int *, int *, int *, int *);
extern void   printDate(FILE *, double, site_t *, int);
extern void   printTime(FILE *, double, site_t *, unsigned int);
extern void   dateStr(double, site_t *, unsigned int, int, char *);
extern void   dateOnlyStr(double, site_t *, unsigned int, int, char *);
extern void   timeStr(double, site_t *, unsigned int, int, char *);
extern void   durStr(double, char *);
extern void   printMET(FILE *, double);
extern char  *monthname(int);
extern double internalTime(int, int, int, int, int, int);
extern void   timetodhms(double , int *, int *, int *, int *);
extern void   calendar(int, int, int *, int *);
extern double dateStrtoTime(char *);
extern void   *safeAlloc(int);
extern char   *saveString(char *);
extern int    cistrcmp(char *, char *);
extern site_t *findSitebyName(char *);
extern satellite_t *findSatbyName(char *);

extern void  *findRotbyModel(char *);
extern void  *findRotbyID(int);
extern void  *findRadbyModel(char *);
extern void  *findRadbyID(int);

extern COLORREF DefColors[];
extern HANDLE hInst;                        /* Instance handle                */
extern HANDLE gtr_thread_handle;            /* thread handle of ground track  */
extern HWND Gwnd,rsthwnd;                   /* global copy of the window handles */
extern HANDLE rotph, radph;                 /* Pipe handles for radio and rotator*/
extern HBITMAP hCompatBitmap;               /* handle of copy of screen bitmap*/
extern HBITMAP htBitmap;                    /* handle of bitmap where the cursor piece and dice are*/
extern HDC hCompatDC,htDC;                  /* correspoding DC's for above    */
extern HDC hAppDC, hIconDC;                 /* The window DC, rtd icon DC     */
extern HPEN hDrawPen[];                     /* All the colored pen handles    */
extern HBRUSH hDrawBrush[];                 /* All the colored brush handles  */
extern COLORREF BgColor, FgColor;           /* System Defaults for FG & BG    */
extern COLORREF Colors[];                   /* colors we can use...           */
extern HCURSOR hcurSave;                    /* previous cursor                */
extern HCURSOR hWait;                       /* Hourglass cursor handle        */
extern HFONT hArial,hHelv;                  /* Fonts                          */
extern HICON hVersa;                        /* Main Versatrk icon             */
extern double ScaleX, ScaleY;               /* screen scale factors for drawing*/
extern int npal, ncolor;                    /* # of available colors          */
extern int PenColor;                        /* current pen color              */
extern int BrushColor;                      /* current default brush          */
extern int TextColor;                       /* current text pen color         */
extern int CWhite,CBlack,DefBg,DefFg;       /* index into Colors[]            */
extern int ytop, ybottom;                   /* extra space for text and menu  */
extern int maxx_device, maxy_device;        /* Device resolution              */
extern int maxx_htdc, maxy_htdc;
extern RECT tRect;                          /* text area at bottom of window  */
extern int duration_running, duration_stop, running;
extern int modelflag;
extern int NSats, NSites;
extern mapdata_t mapdata;
extern CRITICAL_SECTION display_mutex;
extern CRITICAL_SECTION sat_mutex;

extern double minElevation;
extern double duration;
extern double stepTime;
extern double startTime;
extern double stopTime;
extern double timeZone;

extern char   dllname[NAMELEN];
extern char   *dllinvalidmsg;
extern char   *dllloadmsg;
extern char   timeZoneName[9];
extern char   timeZoneHrs[11];
extern char   datadir[96];
extern char   SiteName[64];
extern char   VersionStr[40];
extern char   mapname[16];
extern char   tmpbuf[BUFLEN];
extern char   textbuf[BUFLEN];
extern char   string[BUFLEN];
extern char   satfilename[NAMELEN];
extern char   sitefilename[NAMELEN];
extern char   activefilename[NAMELEN];
extern char   modesfilename[NAMELEN];
extern char   gtrfilename[NAMELEN];
extern char   mapfilename[NAMELEN];
extern char   rotatorfilename[NAMELEN];
extern char   radiofilename[NAMELEN];
extern char   rotpipe[NAMELEN];
extern char   radpipe[NAMELEN];
extern char   dllname[NAMELEN];
extern FILE   *gtrFile;
extern unsigned char EpochString[18];
extern exserver_t  serverInfo[SRV_NUM];

extern site_t      **siteInfo;
extern satellite_t **satInfo;
extern select_t     *selInfo;
extern select_t     *currentSel;
extern radinfo_t    *radInfo;
extern rotinfo_t    *rotInfo;

#endif /* _VSTEXTRN_H */
