/* %W% %E% %U% */

#include <windows.h>
#include "vstdefs.h"
#include "vsttype.h"
#include "libxtrns.h"
#include "vstdib.h"

#define PALETTESZ(p) ((((BITMAPINFOHEADER *)p)->biSize != \
				      sizeof(BITMAPCOREHEADER)) ? \
					  getclr((BITMAPINFOHEADER *)p) * sizeof(RGBQUAD) : 0)

HBITMAP
ReadDIB(version, fname, ybottom, width, height, mdp)
int version;
char *fname;
int ybottom;
int *width, *height;
mapdata_t *mdp;
{
    OFSTRUCT of;
    BITMAPINFOHEADER bi, *bip;
    HANDLE h, dibh;
    int fd;

    if (version < VSTVERSION)
        return NULL;

#ifdef MAPSTUB
	mdp->m_version = VSTVERSION;
	mdp->m_maxx = 360.0;
	mdp->m_minx = 0.0;
	mdp->m_maxy = 89.0;
	mdp->m_miny = -89.0;
	mdp->m_rfu0 = 0;

	hdc = GetDC(NULL);
	hbitmap = CreateCompatibleBitmap(hdc, *width = GetSystemMetrics(SM_) -50,
			*height = GetSystemMetrics(SM_)-50);
	SelectObject(hdc, hbitmap);
	FillRect(hdc, 0, 0, *width, *height, BDrawBrush[4]);
	ReleaseDC(NULL, hdc);
	*height -= ybottom;
	return hdc;
#endif /* STUB */

    if ((fd = (int) OpenFile(fname, &of, (UINT)OF_READ)) == -1)
        return NULL;

    if ((dibh = getDIBInfo(fd, width, height)) == NULL)
        return NULL;
        
    bi = *(BITMAPINFOHEADER *) GlobalLock (dibh);        
    if (bi.biSize != sizeof (BITMAPCOREHEADER)) {
        if (bi.biSizeImage == 0L)
            bi.biSizeImage = ALIGNBYTE(bi.biBitCount * bi.biWidth)
                                    * bi.biHeight;
        if (bi.biClrUsed == 0L)
            bi.biClrUsed = getclr(&bi);
    }
    GlobalUnlock (dibh);

    if ((h = GlobalReAlloc(dibh, bi.biSize + PALETTESZ(&bi)
            + bi.biSizeImage,  GHND)) == NULL) {
        GlobalFree(dibh);
        _lclose((HFILE)fd);
        return NULL;
    }
    else {
        dibh = h;
        bip = (void  *)GlobalLock(dibh);
        Readx(fd, (char *)bip + bip->biSize + PALETTESZ(bip), bi.biSizeImage);
        GlobalUnlock(dibh);
    }
    mdp->m_minx = mdp->m_maxx = mdp->m_miny = mdp->m_maxy = 0.0;
    Readx(fd, (char *) mdp, sizeof(*mdp));
    _lclose((HFILE)fd);
    
    return DIB2Bitmap(dibh, ybottom);
}


static HANDLE
getDIBInfo(int fd, int *w, int *h)
{
    long      offset;
    int       i, size, num_colors;
    HANDLE    hBi = NULL;
    BITMAPINFOHEADER   bi;
    BITMAPCOREHEADER   bc;
    BITMAPINFOHEADER  *bip;
    BITMAPFILEHEADER   bf;
    RGBQUAD  rgbq, *rgbqp;
    
    if (fd == -1)
        return NULL;

    offset = rdBitmapHdr(fd, &bf);

    if (bf.bfType != BMPMAGIC) {
        bf.bfOffBits = 0L;               
        _llseek((HFILE)fd, offset, SEEK_SET);
    }
    if (Readx((HFILE)fd, (char *)&bi, (UINT)sizeof(bi)) != sizeof(bi))
        return FALSE;

    num_colors = getclr(&bi);
#ifdef _DEBUG_
    diag("numcolors = %d\n", num_colors);
#endif /* _DEBUG_ */

    switch (size = (int)bi.biSize) {
        case sizeof (BITMAPINFOHEADER):
#ifdef _DEBUG_
        diag("file has BITMAPINFOHEADER\n");
#endif /* _DEBUG_ */
            break;

        case sizeof (BITMAPCOREHEADER):
#ifdef _DEBUG_
            diag("file has BITMAPCOREHEADER\n");
#endif /* _DEBUG_ */
            bc = *(BITMAPCOREHEADER*)&bi;
            bi.biSizeImage          = 0;
            bi.biXPelsPerMeter      = 0;
            bi.biYPelsPerMeter      = 0;
            bi.biSize               = sizeof(BITMAPINFOHEADER);
            bi.biWidth              = bc.bcWidth;
            bi.biHeight             = bc.bcHeight;
            bi.biPlanes             = bc.bcPlanes;
            bi.biBitCount           = bc.bcBitCount;
            bi.biCompression        = BI_RGB;
            bi.biClrUsed            = num_colors;
            bi.biClrImportant       = num_colors;

            _llseek((HFILE)fd, (long)sizeof(BITMAPCOREHEADER) - sizeof (BITMAPINFOHEADER), (UINT)SEEK_CUR);
            break;

        default:
            /* Not a DIB! */
            return NULL;
    }
    
    if (h)  *h = bi.biHeight;
    if (w)  *w = bi.biWidth;
    
    /*  set default values if zero */
    if (bi.biSizeImage == 0) {
#ifdef _DEBUG_
        diag("biSizeImage is zero\n");
#endif /* _DEBUG_ */
        bi.biSizeImage = ALIGNBYTE((long)bi.biWidth * bi.biBitCount)
                         * (bi.biHeight);
    }
    if (bi.biClrUsed == 0) {
#ifdef _DEBUG_
        diag("biClrUsed is zero\n");
#endif /* _DEBUG_ */
        bi.biClrUsed = getclr(&bi);
#ifdef _DEBUG_
        diag("biClrUsed now %d\n", bi.biClrUsed);
#endif /* _DEBUG_ */
    }
    /* get memory for BITMAPINFO structure and colortab */

    hBi = GlobalAlloc (GHND, (long) bi.biSize + num_colors * sizeof(RGBQUAD));
    if (!hBi)
        return NULL;
        
    bip = (void  *)GlobalLock (hBi);
    *bip = bi;

    rgbqp = (RGBQUAD  *)((char *)bip + bi.biSize);
    
    if (num_colors) {

        if (size == sizeof(BITMAPCOREHEADER)) {
            
			Readx(fd, (char *)rgbqp, num_colors * sizeof(RGBTRIPLE));

            for (i = 0; i < num_colors; i++) {
                rgbq.rgbReserved = (BYTE)0;
                rgbq.rgbRed = ((RGBTRIPLE  *)rgbqp)[i].rgbtRed;
                rgbq.rgbBlue = ((RGBTRIPLE  *)rgbqp)[i].rgbtBlue;
                rgbq.rgbGreen = ((RGBTRIPLE  *)rgbqp)[i].rgbtGreen;
                rgbqp[i] = rgbq;
            }
        }
        else
            Readx(fd, (char *) rgbqp, num_colors * sizeof(RGBQUAD));
    }

    if (bf.bfOffBits) /* back off to start of bitmap data */
        _llseek(fd, (long)offset + (long)bf.bfOffBits, (UINT)SEEK_SET);

    GlobalUnlock(hBi);
    return hBi;
}


static long
getclr(void  * pv)
{
    int cbits;

    if (((BITMAPINFOHEADER *) pv)->biSize != sizeof(BITMAPCOREHEADER)) {
#ifdef _DEBUG_
        diag("header not BITMAPCOREHEADER\n");
#endif /* _DEBUG_ */

        if (((BITMAPINFOHEADER *) pv)->biClrUsed != 0) {
#ifdef _DEBUG_
            diag("number of colors used = %d\n", ((BITMAPINFOHEADER *) pv)->biClrUsed);
#endif /* _DEBUG_ */
            return (WORD) ((BITMAPINFOHEADER *) pv)->biClrUsed;
        }
        cbits = ((BITMAPINFOHEADER *) pv)->biBitCount;
#ifdef _DEBUG_
        diag("ClrUsed is zero, color = %d bits\n", cbits);
#endif /* _DEBUG_ */
    }
    else {
        cbits = ((BITMAPCOREHEADER *)pv)->bcBitCount;
#ifdef _DEBUG_
        diag("Oldstyle bitmap, color = %d bits\n", cbits);
#endif /* _DEBUG_ */
    }
    if (cbits == 1)
        return 2;
    if (cbits == 4)
        return 16;
    if (cbits == 8)
        return 256;
    return 0;
}

/*
 * allows initialization data to be offset in Y
 */
 
static HBITMAP
DIB2Bitmap(HANDLE dibp, int ybottom)
{
    BITMAPINFOHEADER   *bip;
    BITMAPINFOHEADER    bi;
    HDC                 hdc;
    HBITMAP             hbm;

    if ((bip = (void  *)GlobalLock(dibp)) == NULL)
        return NULL;

    memcpy((void *)&bi, (void *)bip, sizeof(bi));
    bi.biHeight += ybottom;
    bi.biSizeImage = ALIGNBYTE(bi.biWidth * bi.biBitCount) * bi.biHeight;

    hdc = GetDC(NULL);
    hbm = CreateDIBitmap(hdc, (BITMAPINFOHEADER *)&bi , (long)CBM_INIT ,
        (char *)bip + bip->biSize + PALETTESZ(bip),
        (BITMAPINFO *)bip , DIB_RGB_COLORS);

    ReleaseDC(NULL,hdc);
    GlobalUnlock(dibp);
    GlobalFree(dibp);
    
    return hbm;
}

static long
Readx(fd, pv, toread)
int fd;
void *pv;
long toread;
{
    long  chunk, nread = 0;
    char  *bufp = pv;

    while (toread > 0) {
        chunk = MIN(toread, CHUNKSIZE);
        if ((long)_lread((HFILE) fd, (char *) bufp, (int)chunk) != chunk)
                return nread;
        nread += chunk;
        toread -= chunk;
        bufp += chunk;
    }
    return nread;
}

static long
rdBitmapHdr(fd, pbp)
int fd;
BITMAPFILEHEADER *pbp;
{
    long offset;

    offset = _llseek((HFILE) fd, 0L, SEEK_CUR);
    _lread((HFILE)fd, (char *) &pbp->bfType, sizeof(short));
    /* size is in the next *3* longs */
    _lread((HFILE)fd, (char *) &pbp->bfSize, sizeof(long) * 3);
    return offset;
}

