#ifndef _VSTDEFS_H
#define _VSTDEFS_H
/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#pragma check_stack(off)

#define VSTVERSION      12            /* Ver major * 10 + ver minor */
#define VERDATE         "101094"      /* Ver Date */

#define BUFLEN          200
#define NAMELEN			32			  /* length of file 'names' + 1 */
#define NOVISCIR                      /* DOES NOT WORK YET - DONT DEFINE */
#undef  WARNBEEP

#define PENWIDTH        1
#define MAXX_WORLD      360           /* from -180 deg W to +180 deg E */
#define MAXY_WORLD      180           /* from North Pole to South Pole */
#define CWHITE          CWhite
#define CBLACK          CBlack
#define DEFFG           DefFg
#define DEFBG           DefBg
#define NPAL            16

#define IDT_TIMERBASE   12001
#define IDT_ANSWER      (IDT_TIMERBASE+0)
#define IDT_CURRTIME    (IDT_TIMERBASE+1)
/*
 * NOTE: DO NOT ALLOCATE TIMER IDs after IDT_INVBASE,
 * Instead, take one in range [IDT_CURRTIME+1 .. IDT_CURTIME+IDX_NRESERVED]
 */
#define IDX_NRESERVED   90
#define IDT_RTDBASE     (IDT_CURRTIME+IDX_NRESERVED+1)

#define ANSWER_TIME     900000
#define RTD_SLEEPTIME   600

#define VST_WM                      (WM_USER+8)
#define RTD_UPDATE                  (VST_WM +  1)
#define EXTM_THEXIT                 (VST_WM +  2)
#define RTD_WINEXIT                 (VST_WM +  3)
#define RTD_THDEXIT                 (VST_WM +  4)
#define RTD_STOPPED                 (VST_WM +  5)
#define RTD_ALL_THREADS_STOPPED     (VST_WM +  6)
#define RTD_ALL_THREADS_FINISHED    (VST_WM +  7)
#define RTD_WRUNNING                (VST_WM +  8)
#define RTD_TRUNNING                (VST_WM +  9)
#define RTD_DRAWSAT                 (VST_WM + 10)
#define RTD_LONGBEEPDOWN            (VST_WM + 11)
#define RTD_LONGBEEPUP              (VST_WM + 12)
#define GTR_QUIT                    (VST_WM + 13)
#define RST_UPDATE                  (VST_WM + 14)
#define RTD_TOGGLE_ICON             (VST_WM + 15)
#define RTD_WARNBEEP                (VST_WM + 16)
#define RTD_STATE                   (VST_WM + 17)
#define CNTRL_SERVEXIT              (VST_WM + 18)
#define VST_NOP                     (VST_WM + 19)
#define RTD_DORESUME                (VST_WM + 20)

/* Server states and server thread format proc flags */
#define SRV_RADIO       0   /* index into serverInfo */
#define SRV_ROTATOR     1   /* index into serverInfo */
#define SRV_NUM         2   /* max number of servers */

#define ST_SRV_NONE     0   /* server not invoked */
#define ST_SRV_RUNNING  1   /* server invoked and apparently running */

#define FMT_INIT        0 
#define FMT_FMT         1
#define FMT_STOP        2
#define FMT_ERROR       3

/* Delayed Operations */
#define PEND_NONE               0
#define PEND_DRAWMAP            1
#define PEND_EXITPROGRAM        2
#define PEND_DURATION_PREDICT   3

#undef  ABS
#define ABS(x)      (((x) < 0) ? (-(x)) : (x) )
#undef  MIN
#define MIN(x,y)    (((x) < (y)) ? (x) : (y))
#undef  MAX
#define MAX(x,y)    (((x) > (y)) ? (x) : (y))

/*
 * values for flags member of select_t
 */
 
#define SE_RTD_BOA            1           /* blink icon on approach */
#define SE_RTD_BEEP           2           /* beep on approach */
#define SE_RTD_POA            4           /* pop icon on approach */
#define SE_RTD_BMP            8           /* blink sat position on map */
#define SE_RTD_UTC         0x10           /* display time in utc */
#define SE_RTD_SLT         0x20           /* display time in site local time */
#define SE_RTD_LOC         0x40           /* display time in local time */
#define SE_RTD_MILE        0x80           /* display distances in miles */
#define SE_RTD_KM         0x100           /* display distances in Km's */
#define SE_RTD_DIC        0x200           /* state of dialog box */
#define SE_RTD_ICONIC     0x400           /* display dialogbox in this state */
#define SE_GTR_UTC        0x800           /* Ground Track time is UTC */
#define SE_GTR_SLT       0x1000           /* Ground Track time is Site Local */
#define SE_GTR_LOC       0x2000           /* Ground Track time is current local */
#define SE_RTD_SIM       0x4000           /* simulated time intervals */
#define SE_THSTOP        0x8000           /* command to stop the thread */
#define SE_THSTOPPED    0x10000           /* acknowledge by thread */
#define SE_WNDISICON    0x20000           /* current state of rtd dlg box */
#define SE_STATE        0x40000           /* state changing */
#define SE_RTD_HIC      0x80000           /* hide while iconic */
#define SE_RFU_RFU0	   0x100000			  /* Reserved */
#define SE_RFU_RFU1	   0x200000			  /* Reserved */
#define SE_RTD_USERA   0x400000			  /* user-a */
#define SE_RTD_USERB   0x800000		      /* user-b */

/*
 * values for flags member of satellite_t
 */
#define SF_DISP         0x1         /* satellite is already being displayed */
#define SF_GEOSTAT      0x2         /* satellite is in geostationary orbit */
#define SF_GEOSYNC      0x4         /* satellite is in geosynchronous orbit */
#define SF_ATTITUDE     0x8         /* Blat/Blon is specified for satellite */

#undef ASSERT
#ifdef  _DEBUG_
#define ASSERT(e)   (void)_vst_assert_(!((BOOL)(exp)), #e, __FILE__, __LINE__)
#else /* _DEBUG_ */
#define ASSERT(e)
#endif /* _DEBUG_ */

#define display_lock()       EnterCriticalSection(&display_mutex);
#define display_unlock()     LeaveCriticalSection(&display_mutex);
#define rtd_lock(sp)         EnterCriticalSection(&sp->rtd_mutex)
#define rtd_unlock(sp)       LeaveCriticalSection(&sp->rtd_mutex)
#define sat_lock()           EnterCriticalSection(&sat_mutex)
#define sat_unlock()         LeaveCriticalSection(&sat_mutex)

/*
 * Default selection attributes
 */
#define	DURATION_DEFAULT		"1.0"		/* 1 day */
#define STEPTIME_DEFAULT		"20"		/* 20 degrees of arc */
#define MINELEVATION_DEFAULT	"0.0"		/* degrees above local horizon */
#define UPDATE_DEFAULT			"30"		/* seconds */

#endif /* _VSTDEFS_H */
