/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "vstdefs.h"
#include "constant.h"
#include "vsttype.h"
#include "libxtrns.h"

BOOL
readSatmodeDB(int version, HWND hwnd, satellite_t **slp, char *dirp, char *filename, char *buf)
{
    char modeLine[120], *cp;
    FILE *fp;
    HANDLE hg;
    mode_t *mp, mode;
    satellite_t *sp;
    int n,r, skipflag;
    double attLat, attLong, sinLat, cosLat, sinLong, cosLong;

    sprintf(modeLine,"%s\\%s", (dirp && *dirp) ? dirp : ".", filename);

    if ((fp = fopen(modeLine,"r")) == NULL) {
        sprintf(buf, "Cannot open \"%s\".", modeLine);
        usermsg(hwnd, buf);
        return FALSE;
    }
    mp = &mode;
    r = 0;
    skipflag = 0;

    while (fp && !feof(fp)) {
        
        mp->beacon       = BEACON * 1.0e6;
        mp->attVecX      = ZERO;
        mp->attVecY      = ZERO;
        mp->attVecZ      = ZERO;
        mp->perigeePhase = ZERO;
        mp->maxPhase     = MAXPHASE;
        mp->alias[0]     = 0;
        mp->nmodes       = 0;

        if (getline(modeLine, 100, fp) == NULL)
                break;

        if (modeLine[0] == '#')
            continue;

        if (skipflag && !(modeLine[0] == 0 || modeLine[0] == '$'))
            continue;
            
        if (modeLine[0] == '$' || modeLine[0] == 0) {
            skipflag = 0;
            continue;
        }
        
        cp = strtok(modeLine,":= \t");
        if (cp && strncmp(cp,"Satellite",9) == 0) {
            cp = strtok(NULL, ":");
            if (cp) {
                cp = stripLeadingSpace(cp);
                if (cp) {
                    stripTrailingSpace(cp);
                    sp = findSatbyName(slp, cp);
                    if (!sp) {
                        skipflag = 1;
                        continue;
                    }
                }
            }
        }
        else
            continue;
        
        cp = strtok(NULL, ":= \t");
        if (cp) {
            stripTrailingSpace(cp);
            if (strncmp(cp, "Alias", 5) == 0) {
                cp = strtok(NULL, ":");
                if (cp) {
                    cp = stripLeadingSpace(cp);
                    if (cp) {
                        stripTrailingSpace(cp);
                        strncpy(mp->alias, cp, sizeof(mp->alias) -1);
                        cp = strtok(NULL, ":= \t");
                        if (cp)
                            cp = stripLeadingSpace(cp);
                    }
                }
            }
            if (cp && strncmp(cp, "Beacon", 6) == 0) {
                cp = strtok(NULL, ":= \t");
                if (cp)
                    mp->beacon = atof(cp) * 1.0e6;
            }
        }
        r = 0;
        do {
            n = 0;
            if (getline(modeLine, 100, fp) == NULL)
                break;
            if (modeLine[0] == '#' || modeLine[0] == 0)
                continue;
            if (modeLine[0] == '$')
                break;

            cp = strtok(modeLine, ":");
            if (cp) {
                if (strncmp(cp, "Perigee Phase", 13) == 0) {
                    cp = strtok(NULL, " \t");
                    if (cp) {
                        mp->perigeePhase = atof(cp);
                        n = 1;
                    }
                }
                if (strncmp(cp, "Blon/Blat", 9) == 0) {
                    cp = strtok(NULL, " \t");
                    if (cp) {
                        attLong = atof(cp);
                        cp = strtok(NULL, " \t");
                        if (cp) {
                            attLat = atof(cp);
                            n = 1;
                            attLat   *= CDR;
                            attLong  *= CDR;

                            cosLat   = cos(attLat);
                            sinLat   = sin(attLat);
                            cosLong  = cos(attLong);
                            sinLong  = sin(attLong);

                            mp->attVecX = cosLong * cosLat;
                            mp->attVecY = sinLong * cosLat;
                            mp->attVecZ = sinLat;
                            if (sp)
                                sp->s_flags |= SF_ATTITUDE;
                        }
                    }
                }
                if (strncmp(cp, "Max Phase", 9) == 0) {
                    cp = strtok(NULL, " \t");
                    if (cp) {
                        mp->maxPhase = atof(cp);
                        n = 1;
                    }
                }
                mp->mds[r].modeStr[0] = 0;   
                if (strncmp(cp, "Mode", 4) == 0) {
                    cp = strtok(NULL, " \t");
                    if (cp) {
                        mp->mds[r].minPhase = (int) (atof(cp) + 0.5);
                        cp = strtok(NULL, " \t'");
                        if (cp) {
                            mp->mds[r].maxPhase = (int) (atof(cp) + 0.5);
                            cp = strtok(NULL, "'");
                            if (cp) {
                                strncpy(mp->mds[r].modeStr, cp, 2);
                                n = 1;
                                if (r < (MAXMODES -1))
                                    r++;
                            }
                        }
                    }
                }
            }
        } while (n);
        mp->nmodes = r;
        hg = GlobalAlloc(GPTR, sizeof(mode_t));
        if (hg == NULL) {
            if (fp)
                fclose(fp);
            sprintf(buf,"Out of memory");
            return FALSE;
        }
        if (sp) {
            sp->s_modep = (mode_t *) GlobalLock(hg);
            *sp->s_modep = *mp;
            GlobalUnlock(hg);
        }
    }
    if (fp)
        fclose(fp);
    return TRUE;
}

static rotinfo_t *rotp;
static radinfo_t *radp;

static rotinfo_t *
findRotbyModel(char *name)
{
    register rotinfo_t *rp;

    for (rp = rotp; rp; rp = rp->rot_next)
        if (cistrcmp(rp->rot_name, name) == 0)
            return rp;
            
    return NULL;
}

static radinfo_t *
findRadiobyModel(char *name)
{
    register radinfo_t *rp;

    for (rp = radp; rp; rp = rp->rad_next)
        if (cistrcmp(rp->rad_name, name) == 0)
            return rp;
            
    return NULL;
}

BOOL
readRotDB(int version, HWND hwnd, rotinfo_t **rpp, char *dirp, char *filename, char *buf)
{
    char line[120], *cp;
    char name[80], driver[80];
    FILE *fp;
    rotinfo_t *rp;
    HANDLE hg;
    int index;

    hg = NULL;
    index = 0;
    rp = *rpp = NULL;
    
    sprintf(line,"%s\\%s", (dirp && *dirp) ? dirp : ".", filename);

    if ((fp = fopen(line,"r")) == NULL) {
        sprintf(buf, "Cannot open \"%s\".", line);
        return FALSE;
    }

    while (fp && !feof(fp)) {
        if (getline(line, sizeof line - 1, fp) == NULL)
            break;

        if ((line[0] == '#') || (strlen(line) == 0))
            continue;

        cp = strtok(line, ":= \t");
        if (!cp)
            continue;

        stripTrailingSpace(cp);
        if (!*cp)
            continue;

        if (cistrcmp(cp, "model"))
            continue;

        cp = strtok(NULL, ":= \t");
        if (!cp)
            continue;

        stripTrailingSpace(cp);
        if (!*cp)
            continue;

        if (findRotbyModel(cp)) {
            sprintf(buf,"Duplicate entry for %s in '%s'", cp, filename);
            usermsg(hwnd, buf);
            continue;
        }
        strncpy(name, cp, sizeof(name)-1);

        cp = strtok(NULL, ":= \t");
        if (!cp)
            continue;
        stripTrailingSpace(cp);

        if (!*cp)
            continue;

        if (cistrcmp(cp,"drv"))
            if (cistrcmp(cp,"driver"))
                continue;

        cp = strtok(NULL, ":= \t");
        if (!cp)
            continue;

        stripTrailingSpace(cp);
        if (!*cp)
            continue;
        strncpy(driver, cp, sizeof(driver) -1);
        
        hg = GlobalAlloc(GPTR, sizeof(*rp));
        if (hg == NULL) {
            if (fp)
                fclose(fp);
            strcpy(buf,"out of memory reading rotator data file");
            return FALSE;
        }
        if (rp) {
            rp->rot_next = (rotinfo_t *) GlobalLock(hg);
            rp = rp->rot_next;
        }
        else
            rp = rotp = (rotinfo_t *) GlobalLock(hg);

        rp->rot_next = NULL;
        rp->rot_index = index++;
        strncpy(rp->rot_name, name, sizeof(rp->rot_name));
        strncpy(rp->rot_driver, driver, sizeof(rp->rot_driver));

        GlobalUnlock(hg);
    }
    if (fp)
        fclose(fp);

    *rpp = rotp;
    
    return TRUE;
}


BOOL
readRadDB(int version, HWND hwnd, radinfo_t **rpp, char *dirp, char *filename, char *buf)
{
    char line[120], *cp;
    char name[32], driver[64];
    FILE *fp;
    radinfo_t *rp;
    HANDLE hg;
    int index;

    hg = NULL;
    rp = *rpp = NULL;
    index = 0;
    
    sprintf(line,"%s\\%s", (dirp && *dirp) ? dirp : ".", filename);

    if ((fp = fopen(line,"r")) == NULL) {
        sprintf(buf, "Cannot open \"%s\".", line);
        return FALSE;
    }

    while (fp && !feof(fp)) {
        if (getline(line, sizeof line - 1, fp) == NULL)
            break;

        if ((line[0] == '#') || (strlen(line) == 0))
            continue;

        cp = strtok(line, ":= \t");
        if (!cp)
            continue;

        stripTrailingSpace(cp);
        if (!*cp)
            continue;

        if (cistrcmp(cp, "Model"))
            continue;

        cp = strtok(NULL, ":= \t");
        if (!cp)
            continue;

        stripTrailingSpace(cp);
        if (!*cp)
            continue;

        if (findRadiobyModel(cp)) {
            sprintf(buf,"Duplicate entry for %s in '%s'", cp, filename);
            usermsg(hwnd, buf);
            continue;
        }
        strncpy(name, cp, sizeof(name)-1);
        cp = strtok(NULL, ":= \t");
        if (!cp)
            continue;
        stripTrailingSpace(cp);
        if (!*cp)
            continue;
        if (cistrcmp(cp,"driver"))
            if (cistrcmp(cp,"drv"))
                continue;
        cp = strtok(NULL, ":= \t");
        if (!cp)
            continue;
        stripTrailingSpace(cp);
        if (!*cp)
            continue;
        strncpy(driver, cp, sizeof(driver) -1);

        hg = GlobalAlloc(GPTR, sizeof(*rp));
        if (hg == NULL) {
            if (fp)
                fclose(fp);
            sprintf(buf,"Out of memory");
            return FALSE;
        }
        if (rp) {
            rp->rad_next = (radinfo_t *) GlobalLock(hg);
            rp = rp->rad_next;
        }
        else
            radp = rp = (radinfo_t *) GlobalLock(hg);
            
        rp->rad_next = NULL;
        rp->rad_index = index++;
        strncpy(rp->rad_name, name, sizeof(rp->rad_name));
        strncpy(rp->rad_driver, driver, sizeof(rp->rad_driver));

        GlobalUnlock(hg);
    }
    if (fp)
        fclose(fp);
        
    *rpp = radp;
    
    return TRUE;
}

