/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "vstdefs.h"
#include "vsttype.h"
#include "libxtrns.h"

static int nsats;
static satellite_t *Snip, **satinfop;

static double
getElement(gstring,gstart,gstop)
int  gstart, gstop;
char gstring[80];
{
    int  k, glength;
    char gstr[74];

    glength = gstop - gstart + 1;

    for (k = 0; k <= glength; k++)
        gstr[k] = gstring[gstart+k-1];

    gstr[glength] = '\0';

    return atof(gstr);
}

/*
 * Read in the orbital elements.
 */
 
satellite_t **
readSatDB(int version, char *datadir, char *satfile, char *tbuf)
{
	FILE *fp;
	HANDLE hg;
	satellite_t *si, *dup, *last, **satinfop;
	double exp;
    int    i, j, error, index, linenum, checkSum, checkValue;
    char   line0buf[81], line1buf[81], line2buf[81], str[81], strng[10];
    char   *line0, *line1, *line2;
    static char string[200];

    extern int satcmp(const void *, const void *);
    extern satellite_t *findSatbyCatnum(int);

    sprintf(tbuf, "%s\\%s", datadir, satfile);
	if ((fp = fopen(tbuf, "r")) == NULL) {
	    sprintf(string,"Cannot open \"%s\"", tbuf);
	    strncpy(tbuf, string, 80);
        return NULL;
    }
    index = 0;
    linenum = 0;
    Snip = NULL;        
	while ((line0 = getline(line0buf, sizeof(line0buf), fp)) != NULL) {
	    linenum++;
        if (line0[0] == 0 || line0[0] == '#') /* skip comment lines */
            continue;
		do {
		    linenum++;
            if ((line1 = getline(line1buf, sizeof(line1buf), fp)) == NULL) {
	            sprintf(tbuf,"Premature eof on satellite file %s line %d (element set line 1)\n",
                        satfile, linenum);
		        return NULL;
		    }
		} while (!line1[0] || line1[0] == '\n' || line1[0] == '#');
		
		do {
		    linenum++;
		    if ((line2=getline(line2buf, sizeof(line2buf), fp)) == NULL) {
		        sprintf(tbuf, "Premature eof on satellite file %s line %d (element set line 2)\n",
                        satfile, linenum);
                return NULL;
		    }
		} while (!line2[0] || line2[0] == '\n' || line2[0] == '#');

        error = 0;
        for (j = 2; j <= 3; j++) {       /* j = error code */
            if (j == 2)
                strcpy(str, line1);
            else
                strcpy(str, line2);

            checkSum = 0;

            for (i = 0; i < 68; i++) {
                strng[0]   = str[i];
                strng[1]   = '\0';
                checkValue = atoi(strng);

                if (!strcmp(strng,"-"))
                    checkValue = 1;      /* assign check sum value to '-' */

                 checkSum += checkValue;
            }

            strng[0] = str[68];
            strng[1] = '\0';

            if (atoi(strng) != (checkSum % 10))  {
                sprintf(tbuf, "%s: around line %d: %s elset line %d checksum is %d, should be %d",
                    satfile, linenum, line0, j-1, checkSum%10, atoi(strng));
                error = j;
            }
        }
        if (error)
            continue;

        i = (long) getElement(line1, 3,   8);    /* Catalogue No. */
        j = (long) getElement(line1, 65, 68);    /* Eleset No. */
        dup = findSatbyCatnum(i);
        hg = NULL;

        if (dup) {
            if (cistrcmp(line0, dup->s_name)) {
                sprintf(tbuf, "Object # %d has different names %s and %s",
                        i, dup->s_name, line0);
                usermsg(NULL, tbuf);
            }
            if ((long) j <= (long) dup->s_elementset)
                continue;
                si = dup;
        }
        else {
       	    if (!Snip) {
                if (!(hg = GlobalAlloc(GPTR, sizeof(satellite_t)))) {
                    sprintf(tbuf,"%s: out of memory at line %d", satfile, linenum);
                    usermsg(NULL, tbuf);
                    break;
                }
                Snip = (satellite_t *) GlobalLock(hg);
                si = Snip;
            }
		    else {
		        si = last;
                if (!(hg = GlobalAlloc(GPTR,sizeof(satellite_t)))) {
                    sprintf(tbuf,"%s: out of memory at line %d", satfile, linenum);
                    usermsg(NULL, tbuf);
                    break;
                }
                si->s_next = (satellite_t *) GlobalLock(hg);
    			si = si->s_next;
      	    }
        	if (si == NULL) {
        	    sprintf(tbuf, "%s: out of memory at line %d", satfile, linenum);
                usermsg(NULL, tbuf);
                break;
        	}
            nsats++;
            si->s_lbid  = index++;
        	si->s_next  = NULL;
	        si->s_modep = NULL;
	        si->s_flags = 0;
        	strncpy(si->s_name, line0, sizeof(si->s_name)-1);
        	last = si;
        }

        si->s_satnum        = (long) i;
        si->s_epochyear     = getElement(line1, 19, 20);
        si->s_epochtime     = getElement(line1, 21, 32);
        si->s_decayrate     = getElement(line1, 34, 43);
        si->s_ephemeristype = getElement(line1, 63, 63);
        exp                 = getElement(line1, 51, 52);
        si->s_dratedot      = getElement(line1, 45, 50) * pow(10.0, -5.0 + exp);
        exp                 = getElement(line1, 60, 61);
        si->s_bstarcoeff    = getElement(line1, 54, 59) * pow(10.0, -5.0 + exp);
        si->s_elementset    = (long) j;
        si->s_inclination   = getElement(line2,  9, 16);
        si->s_raan          = getElement(line2, 18, 25);
        si->s_eccentricity  = getElement(line2, 27, 33) * 1.0e-7;
        si->s_argperigee    = getElement(line2, 35, 42);
        si->s_meananomaly   = getElement(line2, 44, 51);
        si->s_meanmotion    = getElement(line2, 53, 63);
        si->s_orbitnum      = (long) getElement(line2, 64, 68);
        si->s_epochtime    += day_number((int)si->s_epochyear, 1, 0);
        UTCdateStr(si->s_epochtime, si->s_epochstr);
        if (hg)
            GlobalUnlock(hg);
    }
    fclose(fp);

    if (!(hg = GlobalAlloc(GPTR, (index+1) * sizeof(satellite_t *)))) {
        sprintf(tbuf, "%s: out of memory", satfile);
        usermsg(NULL, tbuf);
        return NULL;
    }
	satinfop = (satellite_t **) GlobalLock(hg);
	
	/* Eliminate duplicate names and build indirect vector */
	
	for (index = 0, si = Snip; si ; si = si->s_next) {
        for (last = si->s_next; last; last = last->s_next) {
	        if (cistrcmp(si->s_name, last->s_name) == 0)
	            goto next;
	    }
		satinfop[index++] = si;
       next: ;
    }
    satinfop[index] = (satellite_t *) 0;
    qsort(satinfop, (unsigned) index, sizeof(satellite_t *), satcmp);
	GlobalUnlock(hg);

	return satinfop;
}

satellite_t *
findSatbyName(sinfp, buf)
satellite_t **sinfp;
char *buf;
{
    register satellite_t **sip;

    if (!sinfp)
        return NULL;

	for (sip = sinfp; *sip; sip++)
		if (cistrcmp((*sip)->s_name, buf) == 0)
			return *sip;

	return (satellite_t *) 0;
}

static
satellite_t *
findSatbyCatnum(num)
int num;
{
    register satellite_t *sip;

    for (sip = Snip; sip; sip = sip->s_next)
        if (sip->s_satnum == num)
            return sip;

    return (satellite_t *) 0;
}

static
satellite_t *
findSatbyID(id)
register int id;
{
    if (!satinfop || id >= nsats || id < 0)
        return NULL;

    return satinfop[id];
}

static int
satcmp(a, b)
const void *a, *b;
{
	return cistrcmp((*(satellite_t **)a)->s_name, (*(satellite_t **)b)->s_name);
}
