/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */

/*
 * Utility to fix the raw maps.
 * This program is part of VersaTrack package.
 * Copyright (c) 1994 Siamack Navabpour. All Rights Reserved.
 */

#include <windows.h>
#include <stdio.h>
#include <math.h>

#include "vstdefs.h"
#include "vsttype.h"
#include "vstextrn.h"
#include "vstdib.h"

#undef  MIN
#define MIN(x,y)    (((x) < (y) ) ? (x) : (y))
#define BLEN        (16*1024)
#define NMAPS       6

char buf[BLEN];
mapdata_t md[NMAPS];
OFSTRUCT sof,dof;

static char *mapname1[NMAPS] = {
    "world86.dib", "usa86.dib", "world64.dib", "usa64.dib",
    "world14.dib", "usa14.dib",
};

static char *mapdesig[NMAPS] = {
"world86", "usa86", "world64", "usa64", "world14", "usa14",
};

static void fatal(char *s) { printf("%s\n", s); exit(1); }

int
main(ac,av)
char *av[];
{
    HANDLE sfp;
    HANDLE dfp;
    int r, which;
    char outname[100];
    
    if (ac < 2)
        fatal("must specify maptype: world86, usa86, world64 or usa64");

    for (which = -1, r=0; r < NMAPS; r++) {
        if (strcmp(av[1], mapdesig[r]) == 0) {
           which = r;
           break;
        }
    }
    if (which < 0)
        fatal("invalid map designator");

    sfp = (HANDLE) OpenFile((void *)mapname1[which], &sof, (UINT) OF_READ);
    if (sfp == INVALID_HANDLE_VALUE)
        fatal("cannot open input .raw file for reading");

    sprintf(outname, "%s.map", mapdesig[which]);
    dfp = (HANDLE) OpenFile((void *)outname, &dof, (UINT)(OF_CREATE|OF_WRITE));

    if (dfp == INVALID_HANDLE_VALUE)
        fatal("cannot create/open .dib file for writing");

    printf("creating %s from %s", outname, mapname1[which]);
    do {
        r =_lread((int)sfp, (LPSTR)buf, BLEN);
        if (r > 0) {
            if (_lwrite((int)dfp, (LPSTR)buf, r) != r)
            fatal("write error");
        }
        printf(".");
    } while (r > 0);

    CloseHandle(sfp);

    md[0].m_version = VSTVERSION;
    md[1].m_version = VSTVERSION;
    md[2].m_version = VSTVERSION;
    md[3].m_version = VSTVERSION;

    /* USA86 */
    md[1].m_RFU0 = 0;
    md[1].m_minx = -126.137259;
    md[1].m_miny = -49.952297; /* min & max inverted in sign and position */
    md[1].m_maxx = -65.555641;
    md[1].m_maxy = -24.561303;

    /* USA64 */

    md[3].m_RFU0 = 0;
    md[3].m_minx = - 126.523950;
    md[3].m_miny = -  50.038336;  /* min & max inverted in sign and position */
    md[3].m_maxx = -  65.168950;
    md[3].m_maxy = -  24.475264;

    /* World86 */
    md[0].m_RFU0 = 0;
    md[0].m_minx = -189.653172;
    md[0].m_miny =  -88.593801;
    md[0].m_maxx =  199.683172;
    md[0].m_maxy =   88.641801;

    /* World64 */
    md[2].m_RFU0 = 0;
    md[2].m_minx = -192.564195;
    md[2].m_miny = - 89.194373;
    md[2].m_maxx = 201.394195;
    md[2].m_maxy = 89.242373;


    if (_lwrite((int)dfp, (LPSTR) &md[which], sizeof(md)) != sizeof(md))
        fatal("write error");

    CloseHandle(dfp);
    printf(" done.\n");
    exit(0);
}
