/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <stdlib.h>
#include <time.h>

#include "vstdefs.h"
#include "vsttype.h"
#include "vstextrn.h"

static reginfo_t  AppReginfo = {
    "VersaTrack",       /* message */
    "VersaTrack\\",     /* Basekey (if followed by subkey, must have \\ at end) */
    VersionStr,         /* Subkey 1 (if not the last one, must have \\ at end) */
    "",                 /* Subkey 2 (ditto) */
    "",                 /* Subkey 3 (ditto) */
    NULL,
};

static registry_t AppRegs [] = {
	"Please enter the full directory path name where VersaTrack can \
find its maps, satellite, site, mode and active data files:",
	datadir,
	datadir,
	sizeof(datadir),
	0,
	"Data Directory",
	REG_SZ,

	"Enter the name of the satellite 2-line element sets file:",
	"tle.dat",
	satfilename,
	sizeof(satfilename),
	0,
	"TLE File",
	REG_SZ,

	"Enter the name of the file containing the site information:",
    "sites.dat",
	sitefilename,
	sizeof(sitefilename),
	0,
    "Sites File",
    REG_SZ,

	"Enter the name of the modes files:",
	"modes.dat",
    modesfilename,
    sizeof(modesfilename),
    0,
    "Modes File",
    REG_SZ,

    "Enter the name of the rotator-control definition file:",
    "rotator.dat",
    rotatorfilename,
    sizeof(rotatorfilename),
    0,
    "Rotator List",
    REG_SZ,

    "Enter the name of the radio-control definition file:",
    "radio.dat",
    radiofilename,
	sizeof(radiofilename),
	0,
    "Radio List",
    REG_SZ,

	"Enter the name of the file containing the active list:",
    "active.dat",
    activefilename,
	sizeof(activefilename),
    0,
    "Active File",
    REG_SZ,

    "Enter the name of default map to be drawn upon VersaTrack startup:",
    "world",
    mapname,
    sizeof(mapname),
    0,
    "Default Map",
    REG_SZ,

	"Enter the name of your location. For example \"Denver, Colorado\". \
After the installation make sure sites file contains an entry for it.",
	"Austin, Texas",
	SiteName,
	sizeof(SiteName),
	0,
	"Default GSName",
	REG_SZ,

    "Enter the 3-letter name of your time zone",
    "CST",
    timeZoneName,
    sizeof(timeZoneName),
	0,
	"TZName",
    REG_SZ,

	"Enter the present offset in hours (and decimal fractions) between \
your time zone and UTC. A negative value indicates \"west\" of UTC:",
    "-6.0",
    timeZoneHrs,
    sizeof(timeZoneHrs),
    0,
    "TZDiff",
    REG_SZ,
    	
#if 0
    NULL,
    NULL,
	EpochString,
	sizeof(EpochString),
	sizeof(EpochString),	
	"Settings",
	REG_BINARY,
#endif
};

#define NAPPREGS    (sizeof(AppRegs) / sizeof(AppRegs[0]))

BOOL
init_main()
{
    satellite_t ** (*readSatDB)(int, char *, char *, char *);
    site_t ** (*readSiteDB)(int, char *, char *, unsigned char *, char *);
    BOOL (*readSatmodeDB)(int, HWND, satellite_t **, char *, char *, char *);
    BOOL (*readRotDB)(int, HWND, rotinfo_t **, char *, char *, char *);
    BOOL (*readRadDB)(int, HWND, radinfo_t **, char *, char *, char *);
    BOOL (*GetRegistryValues)(int, HWND, registry_t *, reginfo_t *, int, int);
    int  len;
    satellite_t **sapp;
    site_t **sipp;
    extern void *LibFunc(const char *), LibClose(void);

	srand(time(0));
	
    InitializeCriticalSection(&display_mutex);
    InitializeCriticalSection(&sat_mutex);

    strcpy(gtrfilename,".\\gtr.out");
    GetCurrentDirectory(sizeof(datadir), datadir);
    lowerCase(datadir);

    selInfo = NULL;
    currentSel = NULL;

    GetRegistryValues = (void (*)) LibFunc("GetRegistryValues");
    if (GetRegistryValues == NULL)
        goto nogo;

#ifdef _DEBUG_
    diag("calling GetRegistryValues\n");
#endif /* _DEBUG_ */

    textbuf[0] = 0;
    len = 64;
    GetUserName(textbuf, &len);
    AppReginfo.ri_username = textbuf;
    
    if (!(*GetRegistryValues)(VSTVERSION, Gwnd, AppRegs, &AppReginfo, NAPPREGS, TRUE))
        goto nogo;

#ifdef _DEBUG_
    diag("Got registry values.\n");
#endif /* _DEBUG_ */
    if ((timeZoneHrs[0] != '-' && timeZoneHrs[0] != '+') &&
        !((timeZoneHrs[0] >= '0') && (timeZoneHrs[0] <= '9')) &&
        timeZoneHrs[0] != '.') {
            usermsg("Invalid installed value for TimeZone. Set to UTC");
        strcpy(timeZoneHrs,"0.0");
        strcpy(timeZoneName,"UTC");
    }
    if ((timeZoneHrs[0] == '-' || timeZoneHrs[0] == '+' ||
        timeZoneHrs[0] == '.') && !(timeZoneHrs[1] >= '0' &&
        timeZoneHrs[1] <= '9')) {
            usermsg("Invalid installed value for TimeZone. Set to UTC");
        strcpy(timeZoneHrs,"0.0");
        strcpy(timeZoneName,"UTC");
    }
    timeZone = atof(timeZoneHrs) / 24.0;
    if (timeZoneName[0] == 0)
        strcpy(timeZoneName,"???");

#ifdef _DEBUG_
    diag("Reading site DB\n");
#endif /* _DEBUG_ */

    readSiteDB = (void(*)) LibFunc("readSiteDB");
    if (readSiteDB == NULL)
        goto nogo;

    if (!(siteInfo = (*readSiteDB)(VSTVERSION, datadir, sitefilename,
#if 0
            EpochString, tmpbuf))) {
#else
			NULL, tmpbuf))) {
#endif
        usermsg(tmpbuf);
    }

   for (NSites=0, sipp = siteInfo; sipp && *sipp; sipp++, NSites++) ;
#ifdef _DEBUG_
    diag("Reading Sat DB\n");
#endif /* _DEBUG_ */

    if (!(readSatDB = (void(*)) LibFunc("readSatDB")))
        goto nogo;

    if (!(satInfo = (*readSatDB)(VSTVERSION, datadir, satfilename, tmpbuf))) {
        usermsg(tmpbuf);
    }

    for (NSats=0, sapp = satInfo; sapp && *sapp; sapp++, NSats++) ;
    
#ifdef _DEBUG_
    diag("Reading Mode DB\n");
#endif /* _DEBUG_ */

    if (!(readSatmodeDB = (void(*)) LibFunc("readSatmodeDB")))
        goto nogo;

    if (!(*readSatmodeDB)(VSTVERSION, Gwnd, satInfo, datadir, modesfilename, tmpbuf))
        usermsg(tmpbuf);

#ifdef _DEBUG_
    diag("Reading Rotator DB\n");
#endif /* _DEBUG_ */

    if (!(readRotDB = (void(*)) LibFunc("readRotDB")))
        goto nogo;

    if (!(*readRotDB)(VSTVERSION, Gwnd, &rotInfo, datadir, rotatorfilename, tmpbuf))
        usermsg(tmpbuf);

#ifdef _DEBUG_
    diag("Reading Radio DB\n");
#endif /* _DEBUG_ */

    if (!(readRadDB = (void(*)) LibFunc("readRadDB")))
        goto nogo;

    if (!(*readRadDB)(VSTVERSION, Gwnd, &radInfo, datadir, radiofilename, tmpbuf))
        usermsg(tmpbuf);

    LibClose();

#ifdef _DEBUG_
    diag("reading active DB\n");
#endif /* _DEBUG_ */

    if (!findSitebyName(SiteName)) {
        sprintf(tmpbuf,"Cannot find \"%s\" in the site database. You may \
run into problems...", SiteName);
        usermsg(tmpbuf);
    }

    readactiveDB();

#ifdef _DEBUG_
    diag("init_main finished sucessfully\n");
#endif /* _DEBUG_ */
    return TRUE;
    
nogo:
    LibClose();
#ifdef _DEBUG_
    diag("init_main: +++ INIT FAILED +++\n");
#endif /* _DEBUG_ */
    usermsg(dllinvalidmsg);
    return FALSE;
}


BOOL
UnInstall(version)
int version;
{
    void (*RegClean)(int, HANDLE, reginfo_t *);
    extern void *LibFunc(const char *), LibClose(void);
    int len;

    RegClean = (void (*)) LibFunc("RegCleanup");
    if (RegClean == NULL) {
        LibClose();
        usermsg(dllinvalidmsg);
        return FALSE;
    }

    textbuf[0] = 0;
    len = 64;
    GetUserName(textbuf, &len);
    AppReginfo.ri_username = textbuf;

    sprintf(tmpbuf, "%s is about to be un-installed for \"%s\". Do you want to proceed ?",
        VersionStr, textbuf);
    
    if (!yesno(tmpbuf)) {
        LibClose();
        return FALSE;
    }
    
    (*RegClean)(version, NULL, &AppReginfo);

    LibClose();
    return TRUE;
}


void
copyrights()
{
    void (*crmsg)(int, HWND);
    extern void *LibFunc(const char *), LibClose(void);

    crmsg = (void (*)) LibFunc("Copyright");
    if (crmsg == NULL) {
        LibClose();
        fatal(dllinvalidmsg);
    }
    (*crmsg)(VSTVERSION, Gwnd);
    LibClose();
}
