/*
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#pragma  check_stack(off)

#include <windows.h>
#include "resource.h"
#include "vstdefs.h"
#include "vsttype.h"
#include "vstextrn.h"


#define NI 16
static UINT bid[NI] = {
    IDC_CC_0,  IDC_CC_1,  IDC_CC_2,  IDC_CC_3,
    IDC_CC_4,  IDC_CC_5,  IDC_CC_6,  IDC_CC_7,
    IDC_CC_8,  IDC_CC_9,  IDC_CC_10, IDC_CC_11,
    IDC_CC_12, IDC_CC_13, IDC_CC_14, IDC_CC_15,
};

#define SET_PEN     0
#define SET_BRUSH   1
#define SET_TEXT    2
#define IDT_FLASH	32000

static int   which, ipen, ibrush, itext;
static UINT  flash = (UINT)-1;
static BOOL	 flash_state = TRUE;

static void
SqrButton(HWND hwnd, UINT id)
{
    if (id != IDC_CC_BRUSH)
        setbutton(hwnd, IDC_CC_BRUSH, FALSE);
    if (id != IDC_CC_TEXT)
        setbutton(hwnd, IDC_CC_TEXT, FALSE);
    if (id != IDC_CC_PEN)
	    setbutton(hwnd, IDC_CC_PEN, FALSE);
	    
    setbutton(hwnd, id, TRUE);
}

static void
DlgButtons(HWND hwnd, int color)
{
    int i;	
    for (i=0; i < 16; i++) {
		if (color == i)
	      	flash = bid[i];
	    SendDlgItemMessage(hwnd, bid[i], BM_SETSTATE,
			(WPARAM) ((color == i) ? TRUE : FALSE), (LPARAM) 0);
    }
}


static int
checkbuttons(hwnd, wParam)
HWND hwnd;
WPARAM wParam;
{
    int i, cmd;

    cmd = LOWORD(wParam);

    switch (cmd) {
    case IDOK:
    case IDCANCEL:
        return cmd;
    
    case IDC_CC_PEN:
        which = SET_PEN;
        SqrButton(hwnd, IDC_CC_PEN);
        DlgButtons(hwnd, ipen);
        return -1;

    case IDC_CC_BRUSH:
        which = SET_BRUSH;
        SqrButton(hwnd, IDC_CC_BRUSH);
        DlgButtons(hwnd, ibrush);
        return -1;

    case IDC_CC_TEXT:
        which = SET_TEXT;
        SqrButton(hwnd, IDC_CC_TEXT);
        DlgButtons(hwnd, itext);
        return -1;

    default:        
        break;
    }
	if (HIWORD(wParam) != BN_CLICKED)
		return cmd;

    for (i=0; i<16; i++) {
        if ((UINT)cmd == (UINT)bid[i]) {
            if (which == SET_PEN)
             	DlgButtons(hwnd, ipen = i);
            else if (which == SET_BRUSH)
             	DlgButtons(hwnd, ibrush = i);
            else
             	DlgButtons(hwnd, itext = i);
        }
    }
    return -1;
}
       
static int
findex(UINT id)
{
    int i;
    for (i=0; i<NI; i++)
    	if (id == bid[i])
    		return i;
	return -1;
}

static void
DrawButton(LPARAM lParam)
{
    int c;
	LPDRAWITEMSTRUCT dip = (LPDRAWITEMSTRUCT) lParam;
	
	if (findex(dip->CtlID) == (c = CBLACK))
		c = CWHITE;

	SelectObject(dip->hDC, hDrawPen[c]);
	FillRect(dip->hDC, &dip->rcItem, hDrawBrush[8]);
    SelectObject(dip->hDC, hDrawBrush[findex(dip->CtlID)]);

	if (!(dip->itemState & ODS_SELECTED))
		Ellipse(dip->hDC, dip->rcItem.left+3, dip->rcItem.top+3,
			dip->rcItem.right-3, dip->rcItem.bottom-3);
	else
		Ellipse(dip->hDC, dip->rcItem.left, dip->rcItem.top,
			dip->rcItem.right, dip->rcItem.bottom);

 	if (dip->itemState & ODS_FOCUS)
		Ellipse(dip->hDC, dip->rcItem.left+5, dip->rcItem.top+5,
			dip->rcItem.right-5, dip->rcItem.bottom-5);
}

static
BOOL CALLBACK ColorsProc(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
	POINT *p;
	int cmd;
	extern POINT *DialogPos(HWND, HWND);
        
	if (message == WM_MOUSEMOVE)
    	return TRUE;
            
    switch(message) {
	case WM_INITDIALOG:
    	p = DialogPos(Gwnd, hwnd);
        SqrButton(hwnd, IDC_CC_PEN);
        which = SET_PEN;
        DlgButtons(hwnd, ipen = PenColor);
        ibrush = BrushColor;
        itext = TextColor;
        SetTimer(hwnd, IDT_FLASH, (DWORD) 261, (TIMERPROC) NULL);
        SetWindowPos(hwnd, 0, (int)p->x, (int)p->y, 0, 0,
        	SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW);
        return TRUE;
                
    case WM_TIMER:
     	if (LOWORD(wParam) == IDT_FLASH && flash != 0xffffffff)
		    SendDlgItemMessage(hwnd, (UINT)flash, BM_SETSTATE,
				(WPARAM) (flash_state = !flash_state), (LPARAM) 0);
		return TRUE;
            
    case WM_DRAWITEM:
		DrawButton(lParam);
		return TRUE;
				
    case WM_COMMAND:
        if ((cmd = checkbuttons(hwnd, wParam)) == -1)
            return TRUE;

        if (cmd == IDOK) {
            KillTimer(hwnd, IDT_FLASH);
            EndDialog(hwnd, IDOK);
            return TRUE;
        }
        if (cmd == IDCANCEL) {
            KillTimer(hwnd, IDT_FLASH);
            EndDialog(hwnd, IDCANCEL);
            return TRUE;
        }
        break;

    case WM_CTLCOLORDLG:
        ColorSet(wParam, CBLACK, 8);
        return (BOOL) hDrawBrush[8];
                
    case WM_CTLCOLORSTATIC:
    case WM_CTLCOLORMSGBOX:
    case WM_CTLCOLORBTN:
	    ColorSet(wParam, CBLACK, 8);
    	return (BOOL) hDrawBrush[8]; 

    default:
        break;
                
    }
    return FALSE;
}

/*
 * On return, PenColor, BrushColor and TextColor will be set
 * according to user's selection, or remain unchanged if user CANCELed.
 */

void
SetColors()
{
    int result;

    if (running) {
        usermsg("Cannot change colors while Real-time Display is running");
        return ;
    }
    result = DialogBox(NULL, MAKEINTRESOURCE(IDD_COLORS), Gwnd, ColorsProc);
    if (result == IDOK) {
        PenColor = ipen;
        BrushColor = ibrush;
        TextColor = itext;
    }
}

