/*
 *  make IO for Yarn -  rg070596
 *
 *  rg130696:
 *  - Umstieg auf vsoup (zuerst fr News-Empfang)
 *  - groe Vernderung:
 *    es knnen Mails/News versendet werden und gleichzeitig Mails und News
 *    getrennt empfangen werden
 *  rg180796:
 *  - import versucht es solange bis soup.zip auch wirklich angenommen wurde
 *    (wird nicht, wenn Yarn aktiv)
 *  - SEND verpackt im erfolglosen Fall die Dateien einfach wieder.
 *    Dann knnen sie in Yarn weiterhin bearbeitet werden.
 *
 *  environment vars:
 *  - home
 *  - tmp
 *  - yarn
 *
 *  directory structure (must be set up manually!):
 *  - %home%\yarn\in       - files for reception
 *  - %home%\yarn\in\mail  - files for received mail
 *  - %home%\yarn\in\news  - files for received news
 *  - %home%\yarn\in\news2 - files for received news from alternative source
 *  - %home%\yarn\out      - souper packets for transmission
 *  - %yarn%\bin           - yarn executables and so on
 *    (the news db is under %yarn%\news)
 *
 *  external utilities:
 *  - %yarn%\bin\vsoup.exe  - soup packet receiver transmitter
 *  - %yarn%\bin\import.exe
 *
 *  options: (actually none, all internally used)
 *  - SEND      - start the send process
 *  - RCVMAIL   - start the receive mail process
 *  - RCVNEWS   - start the receive news process
 *  - RCVNEWS2  - start the alternate receive news process
 *  with no option given, YarnIo starts all the above processes
 *
 *  todo:
 *  - restructure script, so that there are several procedures (& stems)
 *  - handle more than one single news server (in a clean way)
 *  - one semaphor for each process
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

DEBUG = 0

/*
 *  get some global vars
 */
env = 'os2environment'
homeDir = value('home',,env)
tmpDir  = value('tmp',,env)
yarnDir = value('yarn',,env)
parse source . . compCmdName
cmdName = filespec('name',compCmdName)
yarnBinDir = yarnDir || '\bin'

if (homeDir = '')  |  (tmpDir = '')  |  (yarnDir = '') then
    call Help 'Either HOME or TMP or YARN not defined in environment'

/*
 *  define some global vars (commands / directories)
 *  change, if you like to
 */
xmtDir        = homeDir || '\yarn\out'
xmtFileZip    = xmtDir  || '\reply.zip'         /* same as in yarn-config! */
xmtFileMsg    = xmtDir  || '\????.msg'          /* mail/news.msg */
rcvDir        = homeDir || '\yarn\in'
rcvNewsDir    = rcvDir  || '\news'
rcvNews2Dir   = rcvDir  || '\news2'
rcvMailDir    = rcvDir  || '\mail'

clearNntp     = 'set nntpserver='

importProg    = yarnBinDir || '\import.exe'
soupSend      = yarnBinDir || '\vsoup.exe -s'
soupRcvNews   = yarnBinDir || '\vsoup.exe -m -a -t 5 -h' rcvNewsDir
soupRcvNews2  = yarnBinDir || '\vsoup.exe -m -a -i -t 3 -h' rcvNews2Dir 'nntp://second.news.server'
soupRcvMail   = yarnBinDir || '\vsoup.exe -n'
soupRcvFile   = 'soup.zip'
unzipProg     = 'unzip.exe -oq'
zipProg       = 'zip -0mq' soupRcvFile 'areas *.msg'
zipProgSend   = 'zip -mq' xmtFileZip 'replies ????.msg'
rmSoupPacks   = 'rm -f areas *.msg *.idx'

/*
 *  files for internal use
 */
semActive   = tmpdir  || '\yarnio.act'
semImport   = tmpdir  || '\yarnio.imp'
flgRcvNews  = tmpdir  || '\yarnio.frn'
flgRcvNews2 = tmpDir  || '\yarnio.fr2'
flgRcvMail  = tmpDir  || '\yarnio.frm'
flgXmt      = tmpDir  || '\yarnio.fx'

if \DEBUG then do
   startProc = 'start /c /b /min'
end
else do
   startProc = 'start /c /b'
end


if DEBUG then trace('i')

/*
 *  get command line options
 */
parse arg Option ropt
if ropt \= '' then
   call Help 'too many options (options are for internal use anyway...)'

/*
 *  define cleanup routine
 */
/*  if signals are caught, then the handler is called, even if soup is aborted (I dont want this)
signal on failure name CleanUp
signal on halt    name CleanUp
signal on error   name CleanUp
*/

/*
 *  do the thing
 */
if Option = '' then do
   /*
    *  main process:  initiate all other processes and wait for completion
    */
   if stream(semActive,'c','open write') = 'READY:' then do
      say 'starting the transmitting/receiving processes...'
      rc = SysFileDelete( flgRcvNews )
      rc = SysFileDelete( flgRcvNews2 )
      rc = SysFileDelete( flgRcvMail )
      rc = SysFileDelete( flgXmt )
      '@' startProc '"YarnIo SEND"'     CompCmdName 'SEND'
      '@' startProc '"YarnIo RCVMAIL"'  CompCmdName 'RCVMAIL'
      '@' startProc '"YarnIo RCVNEWS"'  CompCmdName 'RCVNEWS'
      '@' startProc '"YarnIo RCVNEWS2"' CompCmdName 'RCVNEWS2'
      say 'waiting...'
      loopCnt = 0
      do forever
         rc = SysSleep( 1 )
         loopCnt = loopCnt + 1
         if loopCnt > 3600 then do
            say 'timeout:  cleaning up and exit...'
            res = 3
            leave
         end
         if FileExists(flgRcvNews) & FileExists(flgRcvMail) & FileExists(flgXmt) & FileExists(flgRcvNews2) then do
            rc = SysSleep( 3 )
            say ''
            say 'results:'
            say '--------'
            say 'SEND:    ' linein( flgXmt )
            say 'RCVMAIL: ' linein( flgRcvMail )
            say 'RCVNEWS: ' linein( flgRcvNews )
            say 'RCVNEWS2:' linein( flgRcvNews2 )
            say ''
            say 'finished...'
            res = 0
            leave
         end
      end
      rc = lineout( flgXmt )
      rc = lineout( flgRcvMail )
      rc = lineout( flgRcvNews )
      rc = lineout( flgRcvNews2 )
      rc = SysFileDelete( flgRcvNews )
      rc = SysFileDelete( flgRcvNews2 )
      rc = SysFileDelete( flgRcvMail )
      rc = SysFileDelete( flgXmt )
      rc = stream(semActive,'c','close')
      rc = SysFileDelete(semActive)
      rc = SysSleep( 30 )
      exit 0
   end
   else do
      say CmdName 'already active'
      say '(if actually not, delete' semActive 'manually)'
      exit 3 
   end
end
else if Option = 'SEND' then do
   /*
    *  transmit messages (news & mail):
    *  First try to transmit old *.msg, after that unpack and transmit reply.zip 
    */
   text = 'nothing done'
   doneAny = 0
   if DEBUG then rc = SysSleep( 10 )
   if UCompare(directory(xmtDir),XmtDir) = 0 then do
      if FileExists(xmtFileZip) then do
         say 'sending' xmtFileMsg '(' || xmtFileZip || ')'
         '@' unzipProg xmtFileZip
         rc = SysFileDelete( xmtFileZip )
         '@' echo soupSend
         '@' soupSend
         if rc = 0 then
            text = 'msg(s) transmitted'
         else
            text = soupSend 'returned with an error'
         if FileExists(xmtFileMsg) then do
            say 'moving' xmtFileMsg 'again into' xmtFileZip
            '@' zipProgSend
         end
         '@' zipProg
         rc = DoImport(xmtDir)
      end
      else
         text = 'nothing done'
   end
   else
      text = 'cannot change to' XmtDir
   if DEBUG then rc = SysSleep( 10 )
   rc = lineout( flgXmt,text )
   rc = lineout( flgXmt )
end
else if Option = 'RCVMAIL' then do
   /*
    *  receive mails
    */
   text = 'ok'
   if DEBUG then rc = SysSleep( 10 )
   if UCompare(directory(rcvMailDir),rcvMailDir) = 0 then do
      '@' rmSoupPacks
      '@' echo soupRcvMail
      '@' soupRcvMail
      if rc \= 0 then
         text = soupRcvMail 'returned with an error'
      '@' zipProg
      rc = DoImport( rcvMailDir )
   end
   else
      text = 'cannot change to' rcvMailDir
   if DEBUG then rc = SysSleep( 10 )
   rc = lineout( flgRcvMail,text )
   rc = lineout( flgRcvMail )
end
else if Option = 'RCVNEWS' then do
   /*
    *  receive news
    */
   text = 'ok'
   if DEBUG then rc = SysSleep( 10 )
   if UCompare(directory(rcvNewsDir),rcvNewsDir) = 0 then do
      '@' rmSoupPacks
      '@' clearNntp
      '@' echo soupRcvNews
      '@' soupRcvNews
      if rc \= 0 then
         text = soupRcvNews 'returned with an error'
      '@' zipProg
      rc = DoImport( rcvNewsDir )
   end
   else
      text = 'cannot change to' rcvNewsDir
   if DEBUG then rc = SysSleep( 10 )
   rc = lineout( flgRcvNews,text )
   rc = lineout( flgRcvNews )
end
else if Option = 'RCVNEWS2' then do
   /*
    *  receive news
    */
   text = 'ok'
   if DEBUG then rc = SysSleep( 10 )
   if UCompare(directory(rcvNews2Dir),rcvNews2Dir) = 0 then do
      '@' rmSoupPacks
      '@' echo soupRcvNews2
      '@' soupRcvNews2
      if rc \= 0 then
         text = soupRcvNews2 'returned with an error'
      '@' zipProg
      rc = DoImport( rcvNews2Dir )
   end
   else
      text = 'cannot change to' rcvNews2Dir
   if DEBUG then rc = SysSleep( 10 )
   rc = lineout( flgRcvNews2,text )
   rc = lineout( flgRcvNews2 )
end
else
   call Help 'ill option:' Option

say Option || ':' text
rc = SysSleep( 30 )   /* do not close window immediately */
exit 0



CleanUp:
file = 'nul'
if Option = 'SEND' then
   file = flgXmt
else if Option = 'RCVMAIL' then
   file = flgRcvMail
else if Option = 'RCVNEWS' then
   file = flgRcvNews
else if Option = 'RCVNEWS2' then
   file = flgRcvNews2
rc = lineout( file,'ABORTED...' )
rc = lineout( file )
say 'aborted...'
rc = SysSleep( 3 )
exit 3



UCompare: procedure
s1 = arg(1)
s2 = arg(2)

parse upper var s1 u1
parse upper var s2 u2
return compare(u1,u2)



DoImport: procedure expose semImport importProg soupRcvFile
dir  = arg(1)

/*
 *  wait until semaphor is free
 */
do forever
   if stream(semImport,'c','open write') = 'READY:' then
      leave
   rc = SysSleep( 2 )
end

/*
 *  repeat import until soupRcvFile has been successfully read...
 */
do forever
   '@' importProg dir || '\' || soupRcvFile
   if \FileExists( dir || '\' || soupRcvFile ) then
      leave
   say 'import failed, retrying in 10s...'
   rc = SysSleep( 10 )
end
rc = stream(semImport,'c','close')
return 1



FileExists: procedure
filemask = arg(1)
rc = SysFileTree( filemask,res,F,, )
return res.0 \= 0



Help: procedure expose CmdName
msg  = arg(1)

say CmdName '0.22 rg180796'
say ''
say 'failed:' msg
say ''
say CmdName 'receives and transmits news/mail to Yarn via VSoup'
exit( 3 )
