//  $Id: smtp.cc 1.10 1996/09/01 12:13:29 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//
//  Send mail reply packet using SMTP directly
//


#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "global.hh"
#include "mts.hh"
#include "smtp.hh"
#include "socket.hh"
#include "util.hh"



void smtpClose(TSocket &socket)
//
//  close SMTP connection
//
{
#ifdef DEBUG
    printfT( "smtpClose(): QUIT\n" );
#endif
    socket.puts("QUIT");
    socket.close();
}   // smtpClose



static int getSmtpReply( TSocket &socket, char *response)
//
//  get a response from the SMTP server and test it
//
{
    char buf[BUFSIZ];

    do {
	buf[3] = '\0';
	socket.gets(buf, BUFSIZ);
    } while (buf[3] == '-');		/* wait until not a continuation */

    if (strncmp(buf, response, 3) != 0) {
	areas.mailPrintf1(1, "Expecting SMTP %s reply, got %s\n", response, buf);
    }
    return (buf[0] == *response);	/* only first digit really matters */
}   // getSmtpReply



int smtpConnect ( TSocket &socket )
//
//  Open socket and intialize connection to SMTP server.
//  return value != 0  -->  ok
//
{
    if (socket.open( smtpInfo.host,"smtp","tcp" ) < 0)
	return 0;

    if (!getSmtpReply(socket, "220")) {
	areas.mailPrintf1( 1,"Disconnecting from %s\n", smtpInfo.host);
	smtpClose(socket);
	return 0;
    }

    socket.printf("HELO %s\n", hostName);
    if (!getSmtpReply(socket, "250")) {
	areas.mailPrintf1( 1,"Disconnecting from %s\n", smtpInfo.host);
	smtpClose(socket);
	return 0;
    }
    return 1;
}   // smtpConnect
    


static void sendSmtpRcpt( TSocket &socket, const char *buf )
//
//  Send RCPT command.
//
{
    areas.mailPrintf1(1,"%s: mailing to %s\n", progname, buf);
    socket.printf( "RCPT TO:<%s>\r\n", buf );
    getSmtpReply(socket, "250");
}   // sendSmtpRcpt



static void putAddresses( TSocket &socket, char *addresses )
//
//  Send an RCPT command for each address in the address list.
//
{
    const char *srcEnd;
    char *startAddr;
    char *endAddr;
    char saveCh;
    const char *addr;
    
    srcEnd = strchr(addresses, '\0');
    startAddr = addresses;

    while (startAddr < srcEnd) {
	endAddr = findAddressSep(startAddr);
	saveCh = *endAddr;
	*endAddr = '\0';
	addr = extractAddress(startAddr);
	if (addr) {
	    sendSmtpRcpt(socket, addr);
	    //// delete addr;
	}
	*endAddr = saveCh;
	startAddr = endAddr + 1;
    }
}   // putAddresses



int smtpMail( TSocket &socket, FILE *fd, size_t bytes)
//
//  Send message to SMTP server. 
//
{
    const char *addr;
    char buf[BUFSIZ], *addrs, ch;
    const char *from;
    char *resentTo;
    char *s;
    char more;
    long offset;
    size_t count;

    /* Look for From header and send MAIL command to SMTP server. */
    from = getHeader(fd, "From");
    if (from == NULL || (addr = extractAddress(from)) == NULL) {
	areas.mailPrintf1( 1,"%s: no address in From header", progname );
	if (from != NULL)
	    delete from;
	return 0;
    }
    areas.mailPrintf1(1,"%s: mailing from %s\n", progname, addr);
    socket.printf("MAIL FROM:<%s>\r\n", addr);
    //// delete from;
    //// delete addr;
    if ( !getSmtpReply(socket, "250")) {
	return 0;
    }

    offset = ftell(fd);
    if ((resentTo = (char *)getHeader(fd, "Resent-To")) != NULL) {
	/* Send to address on Resent-To header. */
	putAddresses(socket, resentTo);
	//// delete resentTo;
    }
    else {
	/* Send to addresses on To, Cc and Bcc headers. */
	more = fgets(buf, sizeof(buf), fd) != 0;
	while (more) {
	    if (buf[0] == '\n')
		break;

	    if (isHeader(buf, "To")  ||  isHeader(buf, "Cc")  ||  isHeader(buf, "Bcc")) {
		addrs = buf;
		while (*addrs != '\0' && !isspace(*addrs)) {
		    ++addrs;
		}
		putAddresses(socket, addrs);
		
		/* Read next line and check if it is a continuation line. */
		while ((more = fgets(buf, sizeof(buf), fd) != 0) != 0) {
		    ch = buf[0];
		    if (ch == '\n' || (ch != ' ' && ch != '\t'))
			break;
		    putAddresses(socket, buf);
		}
		
		continue;
	    }
	
	    more = fgets(buf, sizeof(buf), fd) != 0;
	}
    }

    /* Send the DATA command and the mail message line by line. */
    socket.puts("DATA");
    if ( !getSmtpReply(socket, "354")) {
	return 0;
    }

    fseekT(fd, offset, SEEK_SET);
    count = bytes;
    while (fgetsT(buf, sizeof(buf), fd) && count > 0) {
	count -= strlen(buf);
	if ((s = strchr(buf, '\n')) != NULL)
	    *s = '\0';
	if (buf[0] == '.') {
	    socket.printf(".");               //  write an extra .
	}
	socket.printf("%s\n", buf);
    }
    fseekT(fd, offset+bytes, SEEK_SET);

    socket.puts(".");
    getSmtpReply(socket, "250");

    return 1;
}   // smtpMail
