//  $Id: sema.hh 1.6 1996/07/29 22:20:46 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//


#ifndef __SEMA_HH__
#define __SEMA_HH__


#if defined(OS2)  &&  defined(__MT__)

#define INCL_DOSSEMAPHORES
#include <os2.h>

class TSemaphor {
private:
    HMTX Sema;
public:
    TSemaphor( void )    { DosCreateMutexSem( (PSZ)NULL, &Sema, 0, FALSE ); }
    ~TSemaphor()         { DosCloseMutexSem( Sema ); }
    void Request( void ) { DosRequestMutexSem( Sema,SEM_INDEFINITE_WAIT ); }
    void Release( void ) { DosReleaseMutexSem( Sema ); }
};


class TEvSemaphor {
private:
    HEV Sema;
public:
    TEvSemaphor( void )                            { DosCreateEventSem( (PSZ)NULL, &Sema, 0, FALSE ); }
    ~TEvSemaphor()                                 { DosCloseEventSem( Sema ); }
    void Post( void )                              { DosPostEventSem( Sema ); }
    void Wait( long timeMs = SEM_INDEFINITE_WAIT,
	       int resetSema = 1 )                 { if (DosWaitEventSem(Sema,timeMs) == 0) { if (resetSema) Reset();} }
    void Reset( void )                             { unsigned long ul;  DosResetEventSem( Sema,&ul ); }
};

#else

class TSemaphor {
public:
    TSemaphor( void )    {}
    ~TSemaphor()         {}
    void Request( void ) {}
    void Release( void ) {}
};


class TEvSemaphor {
public:
    TEvSemaphor( void )      {}
    ~TEvSemaphor()           {}
    void Post( void )        {}
    void Wait( long timeMs ) {}
    void Reset( void )       {}
#endif


#endif  // __SEMA_HH__
