//  $Id: mts.hh 1.5 1996/09/02 13:24:07 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//
//  multithreading save library functions
//


#ifndef __MTS_HH__
#define __MTS_HH__

#include <errno.h>
#include <regexp.h>
#include <stdio.h>
#include <stdlib.h>

#if defined(OS2)  &&  defined(__MT__)
///#include <stddef.h>
//
//  dieses Verhalten basiert auf emx09a!
//  (wenn errno == EINVAL, dann wurde _beginthread durch interrupt unterbrochen)
//  BEGINTHREAD sollte eigentlich auch einen Fehlercode zurckliefern...
//
////#define BEGINTHREAD(f,arg)  { while (_beginthread((f),NULL,327680,(arg)) == -1) { \
////                                 if (errno != EINVAL) \
////				     break; }}
#define BEGINTHREAD(f,arg) _beginthread((f),NULL,100000,(arg))
#else
#define BEGINTHREAD(f,arg)  (f)(arg)
#endif

#include "sema.hh"        // all semaphore classes included !


FILE *fopenT( const char *name, const char *mode );
int fcloseT( FILE *io );
int fflushT( FILE *out );
int fprintfT( FILE *out, const char *fmt, ... ) __attribute__ ((format (printf, 2, 3)));
int printfT( const char *fmt, ... ) __attribute__ ((format (printf, 1, 2)));
int sprintfT( char *dst, const char *fmt, ... ) __attribute__ ((format (printf, 2, 3)));
int vfprintfT( FILE *out, const char *fmt, va_list arg_ptr );
int vprintfT( const char *fmt, va_list arg_ptr );
int vsprintfT( char *dst, const char *fmt, va_list arg_ptr );
int sscanfT( const char *src, const char *fmt, ... ) __attribute__ ((format (scanf, 2, 3)));
int fscanfT( FILE *in, const char *fmt, ... ) __attribute__ ((format (scanf, 2, 3)));
int fgetcT( FILE *in );
char *fgetsT( char *buf, int len, FILE *in );
int fputcT( int c, FILE *out );
int fputsT( const char *s, FILE *out );
size_t freadT( void *buf, size_t size, size_t count, FILE *in );
size_t fwriteT( const void *buf, size_t size, size_t count, FILE *out );
int fseekT( FILE *io, long offset, int origin );
long ftellT( FILE *io );
int ftruncateT( FILE *io, long offset );
FILE *popenT( const char *command, const char *mode );
int pcloseT( FILE *io );
int removeT( const char *fname );

regexp *regcompT( const char *exp );
int regexecT( const regexp *cexp, const char *target );

const char *xstrdup( const char *src );
void xstrdup( const char **dst, const char *src );


//
//  multithreading save counter
//
class TProtCounter {
private:
    TProtCounter( const TProtCounter &right );   // not allowed !
    operator = ( const TProtCounter &right );    // not allowed !
public:
    TProtCounter( void ) { Cnt = 0; }
    ~TProtCounter() {}
    operator = ( const long &right ) { Cnt = right;  return *this; }

    TProtCounter & operator += (const long &offs) { sema.Request();  Cnt += offs;  sema.Release();  return *this;  }
    TProtCounter & operator ++(void) { sema.Request();  ++Cnt;  sema.Release();  return *this; }
    operator long() { long res;  sema.Request();  res = Cnt;  sema.Release();  return res; }
private:
    long Cnt;
    TSemaphor sema;
};


extern TSemaphor sysSema;     // requested/released on library calls


#endif   // __MTS_HH__
