//  $Id: mts.cc 1.6 1996/09/02 13:23:12 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//


#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mts.hh"
#include "sema.hh"



TSemaphor sysSema;
static TSemaphor regSema;



FILE *fopenT( const char *name, const char *mode )
{
    FILE *res;

    sysSema.Request();
    res = fopen( name,mode );
    sysSema.Release();
    return res;
}   // fopenT



int fcloseT( FILE *io )
{
    int res;

    sysSema.Request();
    res = fclose( io );
    sysSema.Release();
    return res;
}   // fcloseT



int fflushT( FILE *out )
{
    int res;

    sysSema.Request();
    res = fflush( out );
    sysSema.Release();
    return res;
}   // fflushT



int fprintfT( FILE *out, const char *fmt, ... )
{
    va_list ap;
    char buf[BUFSIZ];
    int  buflen;

    sysSema.Request();

    va_start( ap, fmt );
    buflen = vsprintf( buf, fmt, ap );
    va_end( ap );
    if (buflen > 0)
	fputs( buf, out );
    
    sysSema.Release();
    return buflen;
}   // fprintfT



int printfT( const char *fmt, ... )
{
    va_list ap;
    char buf[BUFSIZ];
    int  buflen;

    sysSema.Request();

    va_start( ap, fmt );
    buflen = vsprintf( buf, fmt, ap );
    va_end( ap );
    if (buflen > 0)
	fputs( buf, stdout );
    
    sysSema.Release();
    return buflen;
}   // printfT



int sprintfT( char *dst, const char *fmt, ... )
{
    va_list ap;
    char buf[BUFSIZ];
    int  buflen;

    sysSema.Request();

    va_start( ap, fmt );
    buflen = vsprintf( buf, fmt, ap );
    va_end( ap );
    if (buflen >= 0)
	memcpy( dst,buf,buflen+1 );
    
    sysSema.Release();
    return buflen;
}   // sprintfT



int vfprintfT( FILE *out, const char *fmt, va_list arg_ptr )
{
    int buflen;

    sysSema.Request();
    buflen = vfprintf( out,fmt,arg_ptr );
    sysSema.Release();
    return buflen;
}   // vfprintfT



int vprintfT( const char *fmt, va_list arg_ptr )
{
    int buflen;

    sysSema.Request();
    buflen = vprintf( fmt,arg_ptr );
    sysSema.Release();
    return buflen;
}   // vprintfT



int vsprintfT( char *dst, const char *fmt, va_list arg_ptr )
{
    int buflen;

    sysSema.Request();
    buflen = vsprintf( dst,fmt,arg_ptr );
    sysSema.Release();
    return buflen;
}   // vsprintfT



int sscanfT( const char *src, const char *fmt, ... )
{
    va_list ap;
    int fields;

    sysSema.Request();
    va_start( ap, fmt );
    fields = vsscanf( src, fmt, ap );
    va_end( ap );
    sysSema.Release();
    return fields;
}   // sscanfT



int fscanfT( FILE *in, const char *fmt, ... )
{
    va_list ap;
    int fields;

    sysSema.Request();
    va_start( ap, fmt );
    fields = vfscanf( in, fmt, ap );
    va_end( ap );
    sysSema.Release();
    return fields;
}   // fscanfT



int fgetcT( FILE *in )
{
    int res;

    sysSema.Request();
    res = fgetc( in );
    sysSema.Release();
    return res;
}   // fgetcT



char *fgetsT( char *buf, int len, FILE *in )
{
    char *res;

    sysSema.Request();
    res = fgets( buf,len,in );
    sysSema.Release();
    return res;
}   // fgetsT



int fputcT( int c, FILE *out )
{
    int res;

    sysSema.Request();
    res = fputc( c,out );
    sysSema.Release();
    return res;
}   // fputcT



int fputsT( const char *s, FILE *out )
{
    int res;

    sysSema.Request();
    res = fputs( s,out );
    sysSema.Release();
    return res;
}   // fputsT



size_t freadT( void *buf, size_t size, size_t count, FILE *in )
{
    size_t res;

    sysSema.Request();
    res = fread( buf,size,count,in );
    sysSema.Release();
    return res;
}   // freadT



size_t fwriteT( const void *buf, size_t size, size_t count, FILE *out )
{
    size_t res;

    sysSema.Request();
    res = fwrite( buf,size,count,out );
    sysSema.Release();
    return res;
}   // fwriteT



int fseekT( FILE *io, long offset, int origin )
{
    int res;

    sysSema.Request();
    res = fseek( io,offset,origin );
    sysSema.Release();
    return res;
}   // fseekT



long ftellT( FILE *io )
{
    long res;

    sysSema.Request();
    res = ftell( io );
    sysSema.Release();
    return res;
}   // ftellT



int ftruncateT( FILE *io, long offset )
{
    int handle;
    int res;

    sysSema.Request();
    handle = fileno(io);
    res = ftruncate( handle,offset );
    fseek( io,offset,SEEK_SET );
    sysSema.Release();
    return res;
}   // ftruncateT



FILE *popenT( const char *command, const char *mode )
{
    FILE *res;

    sysSema.Request();
    res = popen( command,mode );
    sysSema.Release();
    return res;
}   // popenT


int pcloseT( FILE *io )
{
    int res;

    sysSema.Request();
    res = pclose( io );
    sysSema.Release();
    return res;
}   // pcloseT



int removeT( const char *fname )
{
    int res;

    sysSema.Request();
    res = remove( fname );
    sysSema.Release();
    return res;
}   // removeT



regexp *regcompT( const char *exp )
{
    regexp *res;

    regSema.Request();
    res = regcomp( exp );
    regSema.Release();
    return res;
}   // regcompT



int regexecT( const regexp *cexp, const char *target )
{
    int res;

    regSema.Request();
    res = regexec( cexp,target );
    regSema.Release();
    return res;
}   // regexecT



const char *xstrdup( const char *src )
{
    int len;
    char *dst;

    len = strlen(src)+1;
    dst = new char [len];
    if (dst != NULL)
	memcpy( dst,src,len );
    else {
	fprintfT( stderr,"\nxstrdup failed\nprogram aborted\n" );
	exit( 3 );
    }
    return dst;
}   // xstrdup



void xstrdup( const char **dst, const char *src )
{
    if (*dst != NULL)
	delete *dst;

    *dst = xstrdup( src );
}   // xstrdup
