//  $Id: main.cc 1.14 1996/09/02 13:22:50 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//
//  Fetch mail and news using POP3 and NNTP into a SOUP packet.
//

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <getopt.h>

//
//  fr TCPOS2.INI-Leserei
//
#ifdef OS2
#define INCL_WINSHELLDATA
#define INCL_DOSPROCESS    ////
#define INCL_DOSEXCEPTIONS ////
#include <os2.h>
#endif

#define DEFGLOBALS
#include "areas.hh"
#include "global.hh"
#include "mts.hh"
#include "news.hh"
#include "pop3.hh"
#include "reply.hh"


static enum { RECEIVE, SEND, CATCHUP } mode = RECEIVE;
static char doMail = 1;
static char doSummary = 0;
static int  catchupCount;
#ifdef OS2
static char doIni = 1;		// if TRUE, read TCPOS2.INI file
#endif



static void setFiles( void )
{
#ifdef OS2
    sprintfT(newsrcFile, "%s/newsrc", homeDir);
    sprintfT(killFile, "%s/kill", homeDir);
#else
    sprintfT(newsrcFile, "%s/.newsrc", homeDir);
    sprintfT(killFile, "%s/.kill", homeDir);
#endif
}   // setFiles



static void getUrlInfo( const char *url, serverInfo &info )
//
//  get an URL in the form [user[:passwd]@]host
//
{
    char user[512];
    char passwd[512];
    char host[512];

    if (sscanfT(url,"%[^@]@%s",user,host) == 2) {
	if (sscanfT(url,"%[^:]:%[^@]@%s",user,passwd,host) == 3)
	    xstrdup( &info.passwd,passwd );
	else
	    sscanfT(url,"%[^@]@%s",user,host );
	xstrdup( &info.user,user );
	xstrdup( &info.host,host );
    }
    else
	xstrdup( &info.host,url );

#ifdef TRACE_ALL
    printfT( "getUrlInfo(%s): %s:%s@%s\n",url,info.user,info.passwd,info.host );
#endif
}   // getUrlInfo



static void usage( const char *fmt, ... )
{
    va_list ap;

    if (fmt != NULL) {
	char buf[BUFSIZ];
	
	va_start( ap,fmt );
	vsprintf( buf,fmt,ap );
	va_end( ap );
	areas.mailPrintf1( 1,"%s\n",buf );
    }

    fputsT("VSoup v1.1 (rg010996) - transfer POP3 mail and NNTP news to SOUP\n", stderr);
    fprintfT(stderr, "usage: %s [options] [URLs]\n",progname );
    fputsT("  URL:  (nntp|pop3|smtp)://[userid[:password]@]host\n",stderr );
    fputsT("global options:\n",stderr );
    fputsT("  -h dir   Set home directory\n", stderr);
#ifdef OS2
    fputsT("  -i       Do not read 'Internet Connection for OS/2' settings\n", stderr);
#endif
    fputsT("  -m       Do not get mail\n", stderr);
    fputsT("  -M       generate status mail\n", stderr);
    fputsT("  -n       Do not get news\n", stderr);
    fputsT("  -r       Read only mode.  Do not delete mail or update newsrc\n", stderr);
    fputsT("  -s       Send replies\n", stderr);

    fputsT("news reading options:\n", stderr);
    fputsT("  -a       Add new newsgroups to newsrc file\n", stderr);
    fputsT("  -c[n]    Mark every article as read except for the last n [default: 10]\n", stderr);
    fputsT("  -k n     Set maximum news packet size in kBytes\n", stderr);
    fputsT("  -K file  Set kill file\n", stderr);
    fputsT("  -l n     Kill articles longer than n lines\n", stderr);
    fputsT("  -N file  Set newsrc file\n", stderr);
#if defined(OS2)  &&  defined(__MT__)
    fprintfT(stderr,"  -t n     Number of threads [1..%d, standard: %d]\n",
	     MAXNNTPTHREADS,DEFNNTPTHREADS );
#endif
    fputsT("  -u       Create news summary\n", stderr);
    fputsT("  -x       Do not process news Xref headers\n", stderr);
    areas.closeAll( 1 );
    exit( EXIT_FAILURE );
}   // usage



static void parseCmdLine( int argc, char **argv )
{
    int c;
    int i;

    while ((c = getopt(argc, argv, "?ac::h:iK:k:l:MmN:nrst:ux")) != EOF) {
	switch (c) {
	case '?':
	    usage( NULL );
	    break;
	case 'a':
	    doNewGroups = 1;
	    break;
	case 'c':
	    mode = CATCHUP;
	    if (optarg != NULL)
		catchupCount = atoi(optarg);
	    else
		catchupCount = 10;
	    break;
	case 'h':
	    homeDir = optarg;
	    setFiles();
	    break;
#ifdef OS2
	case 'i':
	    doIni = 0;
	    break;
#endif
	case 'K':
	    strcpy(killFile, optarg);
	    killFileOption = 1;
	    break;
	case 'k':
	    maxBytes = atol(optarg) * 1000L;
	    break;
	case 'l':
	    maxLines = atoi(optarg);
	    break;
	case 'M':
	    genStsMail = 1;
	    break;
	case 'm':
	    doMail = 0;
	    break;
	case 'N':
	    strcpy(newsrcFile, optarg);
	    break;
	case 'n':
	    doNews = 0;
	    break;
	case 'r':
	    readOnly = 1;
	    break;
	case 's':
	    mode = SEND;
	    break;
#if defined(OS2)  &&  defined(__MT__)
	case 't':
	    maxNntpThreads = atoi(optarg);
	    if (maxNntpThreads < 1  ||  maxNntpThreads > MAXNNTPTHREADS)
		usage( "ill num of threads %s",optarg );
	    break;
#endif
	case 'u':
	    doNews = 1;
	    doSummary = 1;
	    break;
	case 'x':
	    doXref = 0;
	    break;
	default:
	    usage( NULL );
	}
    }

    //
    //  get the URLs
    //
    for (i = optind;  i < argc;  i++) {
	if (strnicmp("smtp://",argv[i],7) == 0)
	    getUrlInfo( argv[i]+7, smtpInfo );
	else if (strnicmp("pop3://",argv[i],7) == 0)
	    getUrlInfo( argv[i]+7, pop3Info );
	else if (strnicmp("nntp://",argv[i],7) == 0)
	    getUrlInfo( argv[i]+7, nntpInfo );
	else
	    usage( "ill URL %s",argv[i] );
    }
}   // parseCmdLine



#ifdef OS2
static void readTcpIni (void)
{
    HAB hab;
    HINI hini;
    char *etc;
    char buf[BUFSIZ];
    char curConnect[20] = "";
    char host[40]       = "";
    char domain[40]     = "";

    etc = getenv("ETC");
    if (etc == NULL) {
	fputsT("Must set ETC\n", stderr);
	exit(EXIT_FAILURE);
    }
    sprintfT(buf, "%s\\TCPOS2.INI", etc);

    hab = WinInitialize(0);
    hini = PrfOpenProfile(hab, buf);
    if (hini == NULLHANDLE) {
	fprintfT(stderr, "Cannot open profile %s\n", buf);
	exit(EXIT_FAILURE);
    }

    PrfQueryProfileString(hini, "CONNECTION", "CURRENT_CONNECTION", NULL,
                          curConnect, sizeof(curConnect));

    PrfQueryProfileString(hini, curConnect, "HOSTNAME", NULL, host,
			  sizeof(host));
    PrfQueryProfileString(hini, curConnect, "DOMAIN_NAME", NULL, domain,
			  sizeof(domain));
    sprintfT(buf, "%s.%s", host, domain);
    xstrdup( &hostName,buf );

    PrfQueryProfileString(hini, curConnect, "POPSRVR", NULL, buf, sizeof(buf));
    xstrdup( &pop3Info.host,buf );
    PrfQueryProfileString(hini, curConnect, "POP_ID", NULL, buf, sizeof(buf));
    xstrdup( &pop3Info.user,buf );
    xstrdup( &smtpInfo.user,buf );
    xstrdup( &nntpInfo.user,buf );
    PrfQueryProfileString(hini, curConnect, "POP_PWD", NULL, buf, sizeof(buf));
    xstrdup( &pop3Info.passwd,buf );
    xstrdup( &smtpInfo.passwd,buf );
    xstrdup( &nntpInfo.passwd,buf );    

    PrfQueryProfileString(hini, curConnect, "DEFAULT_NEWS", NULL, buf, sizeof(buf));
    xstrdup( &nntpInfo.host,buf );

    PrfQueryProfileString(hini, curConnect, "MAIL_GW", NULL, buf, sizeof(buf));
    xstrdup( &smtpInfo.host,buf );
    
    PrfCloseProfile(hini);
    WinTerminate(hab);

#ifdef DEBUG
    printfT( "TCPOS2.INI information:\n" );
    printfT( "-----------------------\n" );
    printfT( "host/domain:  %s/%s\n", host,domain );
    printfT( "hostName:     %s\n", hostName );
    printfT( "defNews:      %s\n", nntpInfo.host );
    printfT( "popServer:    %s\n", pop3Info.host );
    printfT( "popUser:      %s\n", pop3Info.user );
//    printfT( "popPassword:  %s\n", pop3Info.passwd );
    printfT( "mailGateway:  %s\n", smtpInfo.host );
    printfT( "-----------------------\n" );
#endif
}   // readTcpIni
#endif



static void signalHandler( int sig )
{
    char msg[100];

#ifndef NDEBUG
    printfT( "\nHallo exception\n" );
#endif
    sprintf( msg,"signal %d received",sig );
    
    //// durch's Abbrechen gibt es manchmal einen SIGSEGV !?
    ////  die Kinder mssen zuerst gekillt werden (aber wie??)
    //// Holzhammer:  die Threads brechen bei SIGSEGV ab und der Hauptthread bekommt
    //// maximale Prioritt...
#if defined(OS2)  &&  defined(__MT__)
#if defined(NDEBUG)
    DosSetPriority(PRTYS_PROCESS, PRTYC_IDLETIME,0,0);
    DosSetPriority(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER,31, 1);
#else
    printfT( "priority-idle: %ld\n",DosSetPriority(PRTYS_PROCESS, PRTYC_IDLETIME,0,0) );
    printfT( "priority-forg: %ld\n",DosSetPriority(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER,31, 1) );
#endif
#endif
////    printfT( "pid: %d, res: %d\n",getpid(),kill(-getpid(),SIGPIPE) );
#if 0
    {
	int i;
	for (i = 2;  i < 10;  ++i) {
	    printfT( "DosKillThread(%d)=%ld\n",i,DosKillThread(i) );
	}
    }
#endif
////    printfT( "DosKillProcess(%d)=%ld\n",getpid(),DosKillProcess(1,getpid()) );

    fprintfT( stderr,"\n\n%s\n",msg );
    fflushT( stderr );   // notwendig !?
    sleep( 1 );

    areas.closeAll( 1, msg );            // generate status mail in case of signal reception
    if ( !readOnly)
	newsrc.writeFile();
    fflush(stdout);      // notwendig !?
    exit( EXIT_FAILURE );
}   // signalHandler



int main (int argc, char **argv)
{
    int retcode = EXIT_SUCCESS;
    char *s;
    
#ifdef OS2
    if (_osmode != OS2_MODE) {
	fprintfT( stderr,"sorry, DOS not sufficient...\n" );
	exit( EXIT_FAILURE );
    }
#endif
    
    signal(SIGINT,   signalHandler );     // ^C
    signal(SIGBREAK, signalHandler );     // ^Break
    signal(SIGPIPE,  signalHandler );     // broken pipe
    signal(SIGTERM,  signalHandler );     // kill (lt der sich doch catchen?)
	
    progname = strrchr(argv[0], '\\');
    if (progname == NULL)
	progname = argv[0];
    else
	++progname;

    //
    //  get some environment vars (HOME, NNTPSERVER)
    //
#ifdef OS2
    if (doIni)
	readTcpIni();
#endif
    if ((homeDir = getenv("HOME")) == NULL)
	homeDir = ".";
    if ((s = getenv("NNTPSERVER")) != NULL)
	getUrlInfo( getenv("NNTPSERVER"), nntpInfo );
    setFiles();
    parseCmdLine(argc, argv);

    areas.mailStart();
    areas.mailPrintf( "%s started\n", progname );
    areas.mailStop();

    switch (mode) {
    case RECEIVE:
	if (doMail) {
	    if ( !getMail( pop3Info.host,pop3Info.user,pop3Info.passwd ))
		retcode = EXIT_FAILURE;
	}
	if (doNews) {
	    if (doSummary) {
		if ( !sumNews())
		    retcode = EXIT_FAILURE;
	    }
	    else {
		if ( !getNews())
		    retcode = EXIT_FAILURE;
	    }
	}
	break;

    case SEND:
	if ( !sendReply())
	    retcode = EXIT_FAILURE;
	break;

    case CATCHUP:
	if ( !catchupNews(catchupCount))
	    retcode = EXIT_FAILURE;
	break;
    }

    areas.mailStart();
    areas.mailPrintf( "%s finished, retcode=%d\n", progname,retcode );
    areas.mailStop();

    if (retcode != EXIT_SUCCESS)
	areas.closeAll( 1 );
    else
	areas.closeAll( genStsMail );
    exit( retcode );
}   // main
