//  $Id: areas.hh 1.6 1996/08/01 12:10:13 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//


#ifndef __AREAS_HH__
#define __AREAS_HH__


#include <stdio.h>

#include "sema.hh"


class TAreas {

private:
    TAreas( const TAreas &right );      // copy constructor not allowed !
    operator = (const TAreas &right);   // assignment operator not allowed !
    TAreas( void );                     // not allowed !
public:
    TAreas( const char *areasName, const char *msgNamePattern );
    ~TAreas();

    void msgOpen( const char *id, const char *format );
    void msgClose( void );
    int  msgPuts( const char *s );
    size_t msgWrite( const char *buf, size_t size, size_t count );
    int  msgPrintf( const char *fmt, ... );
    void msgFlush( void );
    void closeAll( void );
    void msgStart( void );    // for multithreading (zwar ein Krppel, aber doch)
                              // msgOpon is not required (also msgClose), see next version...
    void msgStop( void );     // for multithreading

protected:
    const char *msgNamePattern;
    FILE *areasF;

private:
    const char *areasName;          // zwischengespeicherte Parameter
    const char *msgId;
    const char *msgFormat;
    FILE *msgF;
    int  msgCounter;
    const char *msgName;
    int  msgStarted;

    void msgEffOpen( void );
    void areasClose( void );
};
    

class TAreasMail: public TAreas  {
private:
    TAreasMail( void );                         // not allowed !
    TAreasMail( const TAreasMail &right );      // copy constructor not allowed !
    operator = (const TAreasMail &right);       // assignment operator not allowed !
public:
    TAreasMail( const char *areasName, const char *msgNamePattern ); ///: TAreas(areasName,msgNamePattern) {}
    ~TAreasMail();
    void mailStart( int doEcho=0 );
    void mailStop( void );
    int  mailPrintf( const char *fmt, ... );
    int  mailPrintf1( int doEcho, const char *fmt, ... );
    void closeAll( int genStsMail, const char *msg = NULL );
private:
    int mailStarted;
    int mailFirstLine;
    FILE *mailF;
    const char *mailName;
    int conEcho;
    TSemaphor mpSema;

    void mailEffOpen( void );
};


#endif   // __AREAS_HH__
