//  $Id: areas.cc 1.10 1996/09/01 11:29:53 hardy Exp $
//
//  This progam/module was written by Hardy Griech based on ideas and
//  pieces of code from Chin Huang (cthuang@io.org).  Bug reports should
//  be submitted to rgriech@ibm.net.
//
//  This file is part of soup++ for OS/2.  Soup++ including this file
//  is freeware.  There is no warranty of any kind implied.  The terms
//  of the GNU Gernal Public Licence are valid for this piece of software.
//
//  SOUP AREAS file management
//


#include <assert.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "areas.hh"
#include "mts.hh"



////  open/close braucht man eigentlich nicht: es reicht start/stop mit entsprechenden Parametern...



static TSemaphor area;   // requested by msgOpen, released by msgClose...
static TSemaphor msg;    // requested by msgStart, released by msgStop
static TSemaphor mail;   // requested by mailStart, released by mailStop



TAreas::TAreas( const char *areasName, const char *msgNamePattern )
{
#ifdef TRACE_ALL
    printfT( "TAreas::TAreas(%s,%s)\n",areasName,msgNamePattern );
#endif

    areasF = NULL;
    msgF   = NULL;
    
    msgCounter = 1;
    msgStarted = 0;
    msgId      = NULL;
    msgFormat  = NULL;
    
    TAreas::areasName = xstrdup(areasName);
    TAreas::msgNamePattern = xstrdup(msgNamePattern);
    
    if ((areasF = fopenT(areasName, "wb")) == NULL) {
	perror(areasName);
	exit( EXIT_FAILURE );
    }
}   // TAreas::TAreas



TAreas::~TAreas()
{
#ifdef TRACE_ALL
    printfT( "TAreas::~TAreas()\n" );
#endif
    areasClose();
}   // TAreas::~TAreas



void TAreas::closeAll( void )
{
#ifdef TRACE_ALL
    printfT( "TAreas::closeAll()\n" );
#endif
    areasClose();
}   // TAreas::closeAll



void TAreas::areasClose( void )
{
#ifdef TRACE_ALL
    printfT( "TAreas::areasClose()\n" );
#endif

    msgClose();
    if (areasF != NULL) {
	fcloseT( areasF );
	areasF = NULL;
////	delete areasName;
////	delete msgNamePattern;
    }
}   // TAreas::areasClose



void TAreas::msgClose( void )
{
#ifdef TRACE_ALL
    printfT( "TAreas::msgClose()\n" );
#endif
//    assert( !msgStarted );  no assertion here, because of possible abnormal termination
    if (msgF != NULL) {
	assert( areasF != NULL  &&  msgName != NULL );
	fcloseT( msgF );
	msgF = NULL;
////	delete msgName;
	msgName = NULL;
	++msgCounter;
    }
    if (msgId != NULL) {
////	delete msgId;
	msgId = NULL;
    }
    if (msgFormat != NULL) {
////	delete msgFormat;
	msgFormat = NULL;
    }
    area.Release();
}   // TAreas::msgClose



void TAreas::msgOpen( const char *id, const char *format )
{
#ifdef TRACE_ALL
    printfT( "TAreas::msgOpen(%s,%s) before sema\n",id,format );
#endif
    area.Request();
#ifdef TRACE_ALL
    printfT( "TAreas::msgOpen(%s,%s) behind sema\n",id,format );
#endif

    assert( msgF == NULL );
////    assert( !msgStarted );  // thread killerei!
    msgId = xstrdup(id);
    msgFormat = xstrdup(format);
}   // TAreas::msgOpen



void TAreas::msgEffOpen( void )
//
//  Open .Msg-file, if not already open
//  If .Msg-file was not open, then write information to areasF & flush areasF
//
{
    char buf[FILENAME_MAX];

#ifdef TRACE_ALL
////    printfT( "TAreas::msgEffOpen()\n" );
#endif

    if (areasF == NULL)       // signal abort
	return;
    assert( msgStarted );
	
    if (msgF == NULL) {
	sprintfT( buf, msgNamePattern,msgCounter );
	msgName = xstrdup(buf);
	if (strcmp(msgFormat,"ic") == 0)
	    strcat( buf,".idx" );
	else
	    strcat( buf,".msg" );
	if ((msgF = fopenT(buf, "wb")) == NULL) {
	    perror(buf);
	    exit( EXIT_FAILURE );
	}
	fprintfT(areasF, "%s\t%s\t%s\n", msgName, msgId, msgFormat);
	fflushT( areasF );
    }

    assert( msgF != NULL );
}   // TAreas::msgEffOpen



int TAreas::msgPuts( const char *s )
{
    int r1, r2;

    msgEffOpen();

    assert( msgStarted );
    r1 = fputsT( s,msgF );
    r2 = fputcT( '\n',msgF );
    if (r1 == EOF  ||  r2 == EOF)
	return EOF;
    return 1;
}   // TAreas::msgPuts



size_t TAreas::msgWrite( const char *buf, size_t size, size_t count )
{
    msgEffOpen();

    assert( msgStarted );
    return fwriteT( buf,size,count,msgF );
}   // TAreas::msgWrite



int TAreas::msgPrintf( const char *fmt, ... )
{
    va_list ap;
    int res;

    msgEffOpen();

    assert( msgStarted );
    va_start( ap, fmt );
    res = vfprintfT( msgF, fmt, ap );
    va_end( ap );
    return res;
}   // TAreas::msgPrintf



void TAreas::msgFlush( void )
//
//  flush .Msg-file
//
{
    if (msgF != NULL)
	fflushT( msgF );
}   // TAreas::msgFlush



void TAreas::msgStart( void )
{
    msg.Request();
    msgStarted = 1;
}   // TAreas::msgStart



void TAreas::msgStop( void )
{
    msgStarted = 0;
    msg.Release();
}   // TAreas::msgStop



//--------------------------------------------------------------------------------



TAreasMail::TAreasMail( const char *areasName, const char *msgNamePattern ): TAreas( areasName,msgNamePattern )
{
#ifdef TRACE_ALL
    printfT( "TAreasMail::TAreasMail(%s,%s)\n",areasName,msgNamePattern );
#endif
    mailF = NULL;
    mailName = xstrdup("StsMail");
    mailStarted = 0;
    conEcho = 0;
#ifdef TRACE_ALL
    printfT( "TAreasMail::TAreasMail: finished\n" );
#endif
}   // TAreasMail::TAreasMail



TAreasMail::~TAreasMail()
{
#ifdef TRACE_ALL
    printfT( "TAreasMail::~TAreasMail()\n" );
#endif
////    assert( !mailStarted );  thread-killerei
}   // TAreasMail::~TAreasMail



void TAreasMail::mailEffOpen( void )
{
    char fname[FILENAME_MAX];
    time_t now;
    char dateBuf[200];

    assert( mailStarted );
    if (mailF == NULL) {
	sprintfT( fname,"%s.msg",mailName );
	if ((mailF = fopenT(fname, "wb")) == NULL) {
	    perror(fname);
	    exit( EXIT_FAILURE );
	}
	now = time(NULL);
	strftime(dateBuf, sizeof(dateBuf), "From POPmail %a %b %d %H:%M %Z %Y\n",
		 localtime(&now));
	fprintfT( mailF, "%s",dateBuf );
	fprintfT( mailF, "To: SouperUser\n" );
	fprintfT( mailF, "From: Souper\n" );
	fprintfT( mailF, "Subject: soup++ status report\n\n" );	
    }
}   // TAreasMail::mailEffOpen



int TAreasMail::mailPrintf( const char *fmt, ... )
{
    va_list ap;
    int res;

    mpSema.Request();

    assert( mailStarted );
    mailEffOpen();
    assert( mailF != NULL );

    if (mailFirstLine) {
	time_t now = time(NULL);
	fprintfT( mailF,"\n---------- %s", ctime(&now) );
	mailFirstLine = 0;
    }
    va_start( ap, fmt );
    res = vfprintfT( mailF, fmt, ap );
    if (conEcho)
	res = vprintfT( fmt, ap );
    va_end( ap );

    mpSema.Release();
    return res;
}   // TAreasMail::mailPrintf



int TAreasMail::mailPrintf1( int doEcho, const char *fmt, ... )
//
//  prints a single line to the mail file without any header...
//
{
    va_list ap;
    int res;

    mail.Request();

    assert( !mailStarted );
    mailStarted = 1;
    mailEffOpen();
    assert( mailF != NULL );

    va_start( ap, fmt );
    res = vfprintfT( mailF, fmt, ap );
    if (doEcho)
	res = vprintfT( fmt, ap );
    va_end( ap );
    fflushT( mailF );

    mailStarted = 0;
    mail.Release();
    return res;
}   // TAreasMail::mailPrintf1



void TAreasMail::mailStart( int doEcho )
{
#ifdef TRACE_ALL
    printfT( "TAreasMail::mailStart()\n" );
#endif
    mail.Request();
    mailStarted = 1;
    mailFirstLine = 1;
    conEcho = doEcho;
//// new line + datum in Mail ausgeben / mail ffnen...
}   // TAreasMail::mailStart



void TAreasMail::mailStop( void )
{
#ifdef TRACE_ALL
    printfT( "TAreasMail::mailStop()\n" );
#endif
    conEcho = 0;
    mailPrintf( "-----------------------------------\n\n" );
    fflushT( mailF );
    mailStarted = 0;
    mail.Release();
}   // TAreasMail::mailStop



void TAreasMail::closeAll( int genStsMail, const char *msg )
{
#ifdef TRACE_ALL
    printfT( "TAreasMail::closeAll()\n" );
#endif
    if (mailF != NULL) {
	if (msg != NULL)
	    fprintf( mailF,"\n%s\n",msg );      // nicht mailPrintf verwenden (semaphor!)
	fflushT( mailF );                       // sollte eigentlich nicht notwendig sein !?
	fcloseT( mailF );
	if (genStsMail  &&  areasF != NULL) {
	    fprintfT( areasF,"%s\t%s\t%s\n",mailName,"Email","mn" );
	    fflushT( areasF );
	}
	else {
	    char fname[FILENAME_MAX];
	    sprintf( fname,"%s.msg",mailName );
	    removeT( fname );
	}
	mailF = NULL;
////    delete mailName;
    }
    TAreas::closeAll();
}   // TAreasMail::closeAll
