/* Copyright 1993 HockWare Inc. */
Call RxFuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
say ''
say '  VisPro/REXX (tm) by HockWare (tm) Inc.'
say ''
say '  This command file is used to help you remove VisPro/REXX'
say '  from your system.'
say ''
say '  This program does NOT remove any program files or projects'
say '  that you may have created using VisPro/REXX.  This is left'
say '  to the only person who can make that decision, you.  The'
say '  VisPro/REXX samples are not removed, since you may have'
say '  changed them.'
say ''
say "  You don't need to use this command file if you want to"
say '  install over a previous version of VisPro/REXX.  To'
say '  reinstall, you can use the SETUP program.'
say ''
say '  Note: before continuing, make certain that all VisPro/REXX'
say '  windows are closed.  Otherwise, the removal will not work.'
say ''
say '  Are you sure you want to remove VisPro/REXX(Y/N)?'
PARSE UPPER VALUE LINEIN() with RESPONSE
IF RESPONSE<>'Y' THEN EXIT
say ''

/* Get value of OS/2 boot path */
OSPATH=SysSearchPath('PATH','CMD.EXE')
OSDIR=OVERLAY('        ',OSPATH,LENGTH(OSPATH)-LENGTH('CMD.EXE'))
OSDIR=STRIP(OSDIR)

/* Get value of VisPro/REXX installation directory */
CONFIG=LEFT(OSDIR,2)||'\CONFIG.SYS'
call SysFileSearch 'SET VISPRORX=', CONFIG, 'hits.'

/* look at the last line with our configuration statement    */
/* Is it an exact match to what we need?. If so, we are done */
/* Also, if there are no hits, but we are installing to the  */
/* C drive, we are also done                                 */
i=hits.0

if i=0 THEN
   PRODUCTDIR='C:\VISPRORX'
ELSE DO
   PRODUCTDIR=STRIP(DELSTR(hits.i,1,13))
   END

PROJECTDIR=PRODUCTDIR||'\'||'Projects'
SAMPLESDIR=PROJECTDIR||'\'||'SAMPLES'

/* Check if VPForm class is active */
found='FALSE'
call SysQueryClassList "list."
do i = 1 to list.0
   parse upper var list.i class .
   if class='VPFORM' then do
      found='TRUE'
      leave
   end
end

/* If VPForm active, deregister */
if (found='TRUE') THEN DO
   say '  Deregistering VisPro/REXX class...'
   ret = SysDeregisterObjectClass( "VPForm");
   if ret = 0 THEN do
      say '  The VisPro/REXX class could not be deregistered.'
      say '  Close all VisPro/REXX windows and retry this command.'
      exit
      end
   else
      say '  VisPro/REXX class deregistered successfully.'
end

say ''
say '  Removing VisPro/REXX program files...'

res = SysIni('SYSTEM', 'VISPROREXX', 'VERSION', 'DELETE:')
call REMOVEFILE PRODUCTDIR'\visprorx.exe'
call REMOVEFILE PRODUCTDIR'\runit.exe'
call REMOVEFILE PRODUCTDIR'\template.exe'
call REMOVEFILE PRODUCTDIR'\VpDemo.exe'
call REMOVEFILE PRODUCTDIR'\hockware.bmp'
call REMOVEFILE PRODUCTDIR'\read.me'
call REMOVEFILE PRODUCTDIR'\P00.BMP'
call REMOVEFILE PRODUCTDIR'\P01.BMP'
call REMOVEFILE PRODUCTDIR'\P02.BMP'
call REMOVEFILE PRODUCTDIR'\P03.BMP'
call REMOVEFILE PRODUCTDIR'\P04.BMP'
call REMOVEFILE PRODUCTDIR'\P05.BMP'
call REMOVEFILE PRODUCTDIR'\P06.BMP'
call REMOVEFILE PRODUCTDIR'\P07.BMP'
call REMOVEFILE PRODUCTDIR'\P08.BMP'
call REMOVEFILE PRODUCTDIR'\P09.BMP'
call REMOVEFILE PRODUCTDIR'\P10.BMP'
call REMOVEFILE PRODUCTDIR'\P11.BMP'
call REMOVEFILE PRODUCTDIR'\P12.BMP'
call REMOVEFILE PRODUCTDIR'\P13.BMP'
call REMOVEFILE PRODUCTDIR'\P14.BMP'
call REMOVEFILE PRODUCTDIR'\P15.BMP'
call REMOVEFILE PRODUCTDIR'\P16.BMP'
call REMOVEFILE PRODUCTDIR'\P17.BMP'
call REMOVEFILE PRODUCTDIR'\P18.BMP'
call REMOVEFILE PRODUCTDIR'\FORM.OPT'
call REMOVEFILE OSDIR'\HELP\VISPRORX.HLP'

rc = SysFileDelete(OSDIR'\DLL\VPFORM.DLL')
if (rc > 4) then do
   say '  The 'OSDIR'\DLL\VPFORM.DLL file could not be erased.'
   say ''
   say '  Perform an OS/2 Shutdown to release this DLL.'
   say '  After rebooting, you can erase this DLL '
   say '  by reinvoking this command file.'
end
else do
   say '  VisPro/REXX was successfully removed.  To finish'
   say '  the cleanup, you need to go to the end of your'
   say '  CONFIG.SYS and remove the SET VISPRORX statement'
   say '  In addition, remove any shadows and program references'
   say '  left in the PROJECTS folder'
end
EXIT

REMOVEFILE:
Arg Filename

say '  Removing file 'FileName
rc = SysFileDelete(FileName)
if (rc > 4) then do
   say '  Error removing file 'FileName'.'
   say '  Make certain that all VisPro/REXX windows are closed.'
   say '  Then retry this command.'
end
RETURN
