{$A+,B-,D-,F-,G+,I-,K+,L-,N-,P-,Q-,R-,S-,T-,V-,W-,X+,Y-}
{$M 8192,8192}

{
//              VPEDEMO.PAS
//              ===========
//
// Demonstration of VPE
//
// 12/1995 by IDEAL Software, T. Radde
//}
program VPEDEMO;

uses WinTypes,WinProcs,
      {$IFDEF VER80} {Units for Delphi}
       SysUtils,
       Messages,
      {$ELSE}
       Strings,      {Units for BP7}
      {$ENDIF}
      VPEngine;



{----------------------------------------------------------------------------
// Globals:
//----------------------------------------------------------------------------
}

{$R VPEDEMO.RES}
var hMainWindow         : HWND;
var hMainDlg            : HWND;

const Precision         : LongInt = 0;
const PBackGnd  : LongInt = 0;
const Speed             : LongInt = 0;
const Colors            : LongInt = 0;
const Report            : LongInt = 0;


var DemoText : array [0..1024] of char;

procedure SetDemoText;
begin
StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCopy(
DemoText,'The moment of impact bursts through the silence and in a roar of sound, the '),
'final second is prolonged in a world of echoes as if concrete and clay of '),
'Broadway itself was reliving its memories.'+#13+#10),
'The last great march past. Newsman stands limp as a whimper as audience and '),
'eventare locked as one. Bing Crosby coos''You don''t have to feel pain '),
'to sing the blues, you don''t have to holla - you don''t feel a thing in your '),
'dollar collar.'' Martin Luther cries ''Everybody Sing!'' and rings the grand old '),
'liberty bell. Leary, weary of his prison cell, walks on heaven, talks on hell.'+#13+#10),
'Who needs Medicare and the 35c flat rate fare, when Fred Astaire and '),
'Ginger Rogers are dancing through the air? From Broadway Melody stereotypes '),
'the band returns to ''Stars and Stripes'' bringing a tear to the moonshiner, '),
'who''s been pouring out his spirit from the illegal still. The pawn broker '),
'clears the noisy till and clutches his lucky dollar bill.'+#13+#10),
'Then the blackout.'+#13+#10+#13+#10),
'(Genesis, ''The Lamb lies down on Broadway'')'#0);

end;


{//----------------------------------------------------------------------------
//                               Precision
//----------------------------------------------------------------------------
}

const HEADLINE = 1;      { ordinal for storing a setting}


{// Page 1 of Precision demo
// ========================
}
procedure page1(hDoc : LongInt);
var y : Integer;
var WYSIWYG : array[0..512] of char;
begin
   StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(strcopy(WYSIWYG,
   '[Center PenSize 3]This demo shows the capabilities and precision of VPE.'+#13+#10),
   'Print this page and compare not only the '),
   'positions of the frames,'+#13+#10+'but the positions of each letter that can be seen.'+#13+#10),
   '(Switch the grid on.)'+#13+#10),
   'This is true WYSIWYG !!!'+#13+#10+'(''What you see is what you get'')'+#13+#10),
   'Note, that the nearest result can be seen at a scaling of 1:1.'+#13+#10),
   'With every other scaling you get ''best results'' in comparison to execution speed.'#0);
   {y := VpeWriteBox(hdoc, 575, 200, 1625, -1,@WYSIWYG);}
   y := VpeWriteBox(hdoc, 575, 200, 1625, -1,WYSIWYG);


   y := VpeWriteBox(hdoc, 100, y + 75, 2000, -1,
   '[''Arial'' FontSize 14 Left Bold Italic Underline PenSize 0]'+
   'RIGHT ALIGNED, 0.25 cm blue frame, light-blue backgr., red bold text, Arial 9pt');
   VpeStoreSet(hdoc, HEADLINE);

   VpeSelectFont(hdoc, 'Arial', 9);
   VpeSetPen(hdoc, 25, PS_SOLID, COLOR_BLUE);
   VpeSetTextColor(hdoc, COLOR_LTRED);
   VpeSetFontAttr(hdoc, ALIGN_RIGHT, 1, 0, 0);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   { y+30 because frame = 0.25cm --> frame drawn around center of coordinates
   // we also want a little gap between the headline and the frame}
   y := VpeWriteBox(hdoc, 150, y + 30, 1850, -1,Demotext);
   VpeSetTransparentMode(hdoc, 1);

   VpeUseSet(hdoc, HEADLINE);
   y := VpeWrite(hdoc, 250, y + 75, 2000, -1, 'JUSTIFIED, no frame, Times New Roman 11pt');

   VpeSelectFont(hdoc, 'Times New Roman', 11);
   VpeSetFontAttr(hdoc, ALIGN_JUSTIFIED, 0, 0, 0);
   y := VpeWriteBox(hdoc, 250, y + 20, 1550, -1,Demotext);

   VpeUseSet(hdoc, HEADLINE);
   y := VpeWriteBox(hdoc, 250, y + 75, 2000, -1, 'CENTERED, thin yellow frame, Times New Roman 11pt');

   VpeSelectFont(hdoc, 'Times New Roman', 11);
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 0, 0);
   VpeSetPen(hdoc, 5, PS_SOLID, COLOR_LTYELLOW);
   y := VpeWriteBox(hdoc, 150, y + 20, 1850, -1,Demotext);
end;


{// Page 2 of Precision demo
// ========================
}
procedure page2(hDoc : LongInt);

type PtArray = array[0..3 * 1500] of TPoint;

var y : Integer;
var xr,yr,x,xstep : real;
var s : array[0..159] of char;
var index, skip, first, xx, oldy : Integer;
const segments : Integer =0;
var p : LongInt;
var points : ^PtArray;
begin
   VpePageBreak(hdoc);
   VpeUseSet(hdoc, HEADLINE);
   y := VpeWriteBox(hdoc, 200, 200, 2000, -1, 'An example of drawing (better to turn the grid off here):');
   VpeSetPen(hdoc, 8, PS_SOLID, COLOR_BLACK);
   VpeBox(hdoc, 200, 300, 1700, 1800);
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);

   xr := 6; xstep := xr / 750;
   yr := 18;

   {// The following graph is created with VpeAddPolyPoint()}
   x := -xr;
   skip := 0;
   VpeSetPen(hdoc, 2, PS_SOLID, COLOR_BLUE);
   p := VpePolyLine(hdoc, 0, 1500);

   for xx := 200 to 1700-1 do
   begin
      y := Round(1050 - ((x*x*x) - 2*(x*x) - 8*x) / ( yr / 750));

      x := x + xstep;

      if (y < 300) then
      begin
	 y := 300;
	 skip := 1;
	 continue;
      end
      else if (y > 1800) then
      begin
	 y := 1800;
	 skip := 1;
	 continue;
      end;

      if (skip = 1) then
      begin
	 VpeAddPolyPoint(hdoc, p, -1, -1);
	 oldy := y;
	 skip := 2;
      end
      else
      begin
	 if (skip = 2) then
	 begin
	    VpeAddPolyPoint(hdoc, p, xx-1, oldy);
	    skip := 0;
	 end;
	 VpeAddPolyPoint(hdoc, p, xx, y);
	 inc(segments);
      end;
   end;



   {// The following graph is created directly with VpePolyLine()}
   New(Points);
   x := -xr;
   first := 1;
   VpeSetPen(hdoc, 2, PS_SOLID, COLOR_LTRED);
   index := 0;
   for xx := 200 to 1700-1 do
   begin
      y := Round(1050 - (3*(x*x) - 4*x - 8) / ( yr / 750));
      x := x+xstep;

      if (y < 300) then
      begin
	 y := 300;
	 skip := 1;
	 continue;
      end
      else if (y > 1800) then
      begin
	 y := 1800;
	 skip := 1;
	 continue;
      end;

      if (skip = 1) then
      begin
	 if (index > 0) then   {// Array must not begin with -1,-1 pair!}
	 begin
	    points^[index].x := -1;
	    points^[index].y := -1;
	 end;
	 {// don't increment index here, so we don't have multiple
	 // (redundant AND FORBIDDEN) -1, -1 pairs in the array}
	 oldy := y;
	 skip := 2;
      end
      else
      begin
	 if (skip = 2) then
	 begin
	    if (index > 0) then
	       inc(index);
	    points^[index].x := xx - 1;
	    points^[index].y := oldy;
	    inc(index);
	    skip := 0;
	 end;
	 points^[index].x := xx;
	 points^[index].y := y;
	 inc(index);
	 inc(segments);
      end;
   end;

   VpePolyLine(hdoc, LongInt(points), index);
   Dispose(points);



   {// The following graph is created "manually" VpeLine()
   // Never use it for such tasks, it's slow and memory exhausting
   // in comparision to VpePolyLine()}
   x := -xr;
   first := 1;
   VpeSetPen(hdoc, 2, PS_SOLID, COLOR_GREEN);
   for xx := 200 to 1700-1 do
	begin
      y := Round(1050 - (3*x - 4) / ( yr / 750));
      x :=x+ xstep;

      if (y < 300) then
      begin
	 y := 300;
	 first := 1;
	 continue;
      end
      else if (y > 1800) then
      begin
	 y := 1800;
	 first := 1;
	 continue;
      end;

      if first <> 0 then
	 oldy := y
      else
      begin
	 VpeLine(hdoc, xx-1, oldy, xx, y);
	 inc(segments);
	 oldy := y;
      end;
      first := 0;
   end;


   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeLine(hdoc, 200, 1050, 1700, 1050);
   VpeLine(hdoc, 950, 300, 950, 1800);

   VpeSelectFont(hdoc, 'Arial', 10);
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSetPen(hdoc, 1, PS_DOT, COLOR_BLACK);
   for xx := 1 to Round(xr-1) do
   begin
      VpeLine(hdoc,Round( 950 + xx * 750 / 6), 300,Round(950 + xx * 750 / 6), 1800);
      str(xx,s);
      VpePrint(hdoc,Round(960 + xx * 750 / 6), 1050, s);
      VpeLine(hdoc, Round(950 - xx * 750 / 6), 300,Round(950 - xx * 750 / 6), 1800);
      Str(xx,s);
      VpePrint(hdoc, Round(960 - xx * 750 / 6), 1050, s);
   end;
   y := 2;
   while y < yr do
   begin
      VpeLine(hdoc, 200,Round(1050 + y * 750 / yr), 1700, Round(1050 + y * 750 / yr));
      Str(y,s);
      VpePrint(hdoc, 960,Round(1050 - y * 750 / yr), s);
      VpeLine(hdoc, 200, Round(1050 - y * 750 / yr), 1700,Round(1050 - y * 750 / yr));
      Str(y,s);
      VpePrint(hdoc, 960, Round(1050 + y * 750 / yr), s);
      inc(y,2);
   end;

   y := 1850;
   wvsprintf(s, '[S 14]The three graphs together consist of %d (number determined during runtime)'+
					 ' single lines!'+#13+#10+#13+#10+'VPE manages this data bulk for you FAST!', segments);
   VpeWrite(hdoc, 200, y, 2000, -1, s);
end;











{// Page 3 and 4 of Precision demo
// ==============================}
procedure page3_4(hdoc : LongInt);
var y: integer;
begin
   VpePageBreak(hdoc);

   VpeNoPen(hdoc);
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
   VpeSelectFont(hdoc, 'Arial', 18);
   VpeWrite(hdoc, 0, 150, 2100, 300, 'The supported barcode-types:');
   VpeSelectFont(hdoc, 'Arial', 10);
   VpeSetBold(hdoc, 1);

   VpeWrite(hdoc, 200, 300, 550, 400, '2 of 5:');
   VpeBarcode(hdoc, 200, 360, 550, 560, BCT_2OF5, '123789', nil);

   VpeWrite(hdoc, 700, 300, 1200, 400, 'Interleaved 2 of 5:');
   VpeBarcode(hdoc, 700, 360, 1200, 560, BCT_INTERLEAVED2OF5, '123895783482', nil);

   VpeWrite(hdoc, 1350, 300, 1750, 400, 'Code 39 (text on top):');
   VpeSetBarcodeParms(hdoc, 0, 1);
   VpeBarcode(hdoc, 1350, 360, 1750, 560, BCT_CODE39, 'ABC123', nil);

   VpeWrite(hdoc, 200, 700, 550, 800, 'Code 93 (rotated):');
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeSetRotation(hdoc, 900);
   VpeBarcode(hdoc, 275, 760, -300, -200, BCT_CODE93, 'DEF987', nil);

   VpeWrite(hdoc, 700, 700, 1200, 800, '[Rot 0]Codabar (rotated):');
   VpeSetRotation(hdoc, 1800);
   VpeBarcode(hdoc, 700, 760, -500, -200, BCT_CODABAR, '123456', nil);

   VpeWrite(hdoc, 1400, 700, 1700, 800, '[Rot 0]EAN-8 (rotated):');
   VpeSetRotation(hdoc, 2700);
   VpeBarcode(hdoc, 1450, 760, -300, -200, BCT_EAN8, '40167794', nil);

   VpeWrite(hdoc, 200, 1200, 500, 1400, '[Rot 0]EAN-8 + 2:');
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeBarcode(hdoc, 200, 1260, 500, 1460, BCT_EAN8_2, '12345670', '12');

   VpeWrite(hdoc, 700, 1200, 1200, 1400, 'EAN-8 + 5:');
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeBarcode(hdoc, 700, 1260, 1200, 1460, BCT_EAN8_5, '98765430', '12345');

   VpeWrite(hdoc, 1350, 1200, 1750, 1400, 'EAN-13:');
   VpeBarcode(hdoc, 1350, 1260, 1750, 1460, BCT_EAN13, '9781556153952', nil);

   VpeWrite(hdoc, 200, 1600, 600, 1800, 'EAN-13 + 2:');
   VpeBarcode(hdoc, 200, 1660, 600, 1860, BCT_EAN13_2, '4501645096787', '12');

   VpeWrite(hdoc, 700, 1600, 1200, 1800, 'EAN-13 + 5:');
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeBarcode(hdoc, 700, 1660, 1200, 1860, BCT_EAN13_5, '9781556153952', '12345');

   VpeWrite(hdoc, 1350, 1600, 1750, 1800, 'EAN-128 A:');
   VpeSetBarcodeParms(hdoc, 0, 0);
   VpeBarcode(hdoc, 1350, 1660, 1750, 1860, BCT_EAN128A, 'EAN-128 A', nil);

   VpeWrite(hdoc, 200, 2000, 600, 2200, 'EAN-128 B:');
   VpeBarcode(hdoc, 200, 2060, 600, 2260, BCT_EAN128B, 'ean-128 b', nil);

   VpeWrite(hdoc, 700, 2000, 1200, 2200, 'EAN-128 C:');
   VpeBarcode(hdoc, 700, 2060, 1200, 2260, BCT_EAN128C, '128902', nil);

   VpeWrite(hdoc, 1350, 2000, 1850, 2200, 'POSTNET (1.20) 5 or 9 digits:');
   VpeBarcode(hdoc, 1350, 2060, 1628, 2120, BCT_POSTNET, '12345', nil);
   VpeBarcode(hdoc, 1350, 2150, 1850, 2210, BCT_POSTNET, '414649623', nil);

   VpePageBreak(hdoc);

   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
   VpeSelectFont(hdoc, 'Arial', 18);
   VpeWrite(hdoc, 0, 150, 2100, 300, 'The supported barcode-types (continued):');
   VpeSelectFont(hdoc, 'Arial', 10);
   VpeSetBold(hdoc, 1);

   VpeWrite(hdoc, 200, 300, 550, 400, 'UPC-A:');
   VpeBarcode(hdoc, 200, 360, 550, 560, BCT_UPCA, '07447079382', nil);

   VpeWrite(hdoc, 700, 300, 1100, 400, 'UPC-A + 2:');
   VpeBarcode(hdoc, 700, 360, 1100, 560, BCT_UPCA_2, '07447079382', '01');

   VpeWrite(hdoc, 1350, 300, 1800, 400, 'UPC-A + 5:');
   VpeBarcode(hdoc, 1350, 360, 1800, 560, BCT_UPCA_5, '03126764825', '94687');

   VpeWrite(hdoc, 200, 700, 550, 900, 'UPC-E:');
   VpeBarcode(hdoc, 200, 760, 550, 960, BCT_UPCE, '0378492', nil);

   VpeWrite(hdoc, 700, 700, 1100, 900, 'UPC-E + 2:');
   VpeBarcode(hdoc, 700, 760, 1100, 960, BCT_UPCE_2, '0378492', '14');

   VpeWrite(hdoc, 1350, 700, 1800, 900, 'UPC-E + 5:');
   VpeBarcode(hdoc, 1350, 760, 1800, 960, BCT_UPCE_5, '0364825', '79462');

   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   y:= VpeWrite(hdoc, 200, 1100, 1800, VFREE,
	  'VPE supports 21 barcode types. Barcodes can be rotated in 90 degree steps, the '+
	  'text can be drawn on bottom or top of the barcode, and also independently '+
	  'the add-on text. Any of these features can be combined.');

   y := VpePrint(hdoc, 500, y+100, '[S 24 U C LtYellow]Text and images');
   VpePrint(hdoc, VRIGHT, VBOTTOM, '[Rot 900 C Blue] can be freely ');
   VpeWriteBox(hdoc, 500, VBOTTOM, VLEFT, VFREE, '[Rot 1800 C Red CE]rotated in 90');

   { The WIDTH (after rotation it's the height) is the top of the last inserted text
     minus the bottom of the first inserted object.}
   VpeWriteBox(hdoc, 400, y, -(VpeGet(hdoc, VTOP) - y), VFREE, '[Rot 2700 C Green]degree steps');
end;


{ Page 5 of Precision demo
  ======================== }
procedure page5(hdoc : LongInt);
var x, y, y2 : Integer;
    p : LongInt;
begin

   VpePageBreak(hdoc);
   VpeUseSet(hdoc, HEADLINE);
   y := VpeWriteBox(hdoc, 100, 200, 2000, -1,
		   'VPE is also able to manage bitmaps for you!'+#13+#10+
		   'Place your logo wherever you want.');
   y := VpeWriteBox(hdoc, 100, y, 1400, -1,
       '[S 10 L BO IO UO](Note: These are 256-color bitmaps, in 16-color mode it doesn''t look very good)');

   y := VpeWriteBox(hdoc, 100, y + 50, 1400, -1, '[N B U]VPE supports the following graphics file formats:');
       VpeWriteBox(hdoc, 100, y, 1400, -1,
       '-Windows and OS/2 Bitmaps (2 / 16 / 256 / True Color)'+#13+#10+
       '-Windows WMF (Metafile)'+#13+#10+
       '-AutoCAD DXF'+#13+#10+
       '-GIF (2 / 16 / 256 Colors)'+#13+#10+
       '-PCX (2 / 16 / 256 Colors)'+#13+#10+
       '-JPG (256 / True Color)'+#13+#10+
       '-TIFF 5.0 (2 / 16 / 256 / True Color, LZW / PackBits / Fax G3 & G4 / Tiled Images)'+#13+#10+
       '-Microsoft filters (feature, some restrictions and only 16-bit version)');
   VpeSetPen(hdoc, 5, PS_SOLID, COLOR_BLACK);
   VpePicture(hdoc, 1400, 150, -1, -1, 'logo.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
   y := VpeGet(hdoc, VBOTTOM);
   x := VpeGet(hdoc, VRIGHT);
   VpeWriteBox(hdoc, 1400, y, x, -1, '[N S 14 CE C White BC Red TO Italic Bold]IDEAL Software');
   VpeDefaultBitmapDPI(hdoc, 96, 96);
   VpePicture(hdoc, 1400, VpeGet(hdoc, VBOTTOM) + 100, -1, -1, 'fruits.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);

   y := VpeWriteBox(hdoc, 150, y + 400, 1500, -1,
	       '[S 14 CE PS 0]Scale your bitmaps as you like:');
   inc(y,20);
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpePicture(hdoc, 150, y, 200, -1, 'logo.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
   VpePicture(hdoc, VpeGet(hdoc, VRIGHT) + 100, y, VpeGet(hdoc, VRIGHT) + 250, -1, 'logo.bmp',
				  PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
   VpePicture(hdoc, VpeGet(hdoc, VRIGHT) + 100, y, VpeGet(hdoc, VRIGHT) + 750, -1, 'logo.bmp',
				 PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);

   y := VpeGet(hdoc, VBOTTOM) + 300;
   y := VpePrint(hdoc, 150, y, '[N U]Draw! Set the Pen, Background Color and Hatch Style:');
   y := y+50;
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_BLUE);
   VpeBox(hdoc, 150, y, -300, -300);

   VpeSetHatchStyle(hdoc, HS_BDIAGONAL);
   VpeSetHatchColor(hdoc, COLOR_BLUE);
   VpeSetBkgColor(hdoc, COLOR_LTYELLOW);
   VpeNoPen(hdoc);
   p := VpePolygon(hdoc, 0, 4);
   VpeAddPolygonPoint(hdoc, p, 250, y+400);
   VpeAddPolygonPoint(hdoc, p, 500, y+600);
   VpeAddPolygonPoint(hdoc, p, 300, y+700);
   VpeAddPolygonPoint(hdoc, p, 150, y+1000);

   VpeSetPen(hdoc, 6, PS_SOLID, COLOR_BLACK);
   p := VpePolygon(hdoc, 0, 4);
   VpeAddPolygonPoint(hdoc, p, 650, y);
   VpeAddPolygonPoint(hdoc, p, 1000, y+200);
   VpeAddPolygonPoint(hdoc, p, 700, y+300);
   VpeAddPolygonPoint(hdoc, p, 550, y+600);

   VpeNoPen(hdoc);
   VpeSetHatchStyle(hdoc, HS_DIAGCROSS);
   VpeSetHatchColor(hdoc, COLOR_RED);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeEllipse(hdoc, 750, 2150, -500, -300);

   VpeSetHatchStyle(hdoc, HS_FDIAGONAL);
   VpeSetPen(hdoc, 10, PS_SOLID, COLOR_GREEN);
   VpeSetTransparentMode(hdoc, 1);
   y2 := VpeWrite(hdoc, 1200, y + 200, -500, -1, '[S 12 B CE]Write text beyond,');
   VpeEllipse(hdoc, 1200, y, -500, -500);
   VpeWrite(hdoc, 1200, y2, -500, -1, 'or above the hatching.');

   VpeSetTransparentMode(hdoc, 0);
   VpeWriteBox(hdoc, 770, 2280, -460, -1, '[PS 3 PC Black HSN BC Cyan S 10 NB]Or blank the hatching out.');

   VpeSetTransparentMode(hdoc, 1);
end;


{ Page 6 of Precision demo
  ======================== }
procedure page6(hdoc : LongInt);
begin
   VpePageBreak(hdoc);

   VpeNoPen(hdoc);
   VpePicture(hdoc, 0, 0, -1, -1, 'gew.tif', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);

   VpeWrite(hdoc, 250, 130, 1200, -1, '[S 24 C LtRed L PS 0]Stadt Xhausen');
   VpeWrite(hdoc, 250, 500, 1000, -1, '[S 14 C Blue]Mustermann & Co.'+#13+#10+'Feinkost Im- und Export');
   VpeWrite(hdoc, 1200, 460, 1700, -1, '[S 11 B]Dsseldorf');
   VpeWrite(hdoc, 250, 680, 750, -1, 'Schmidt');
   VpeWrite(hdoc, 250, 840, 750, -1, '24.7. 1947');
   VpeWrite(hdoc, 500, 840, 1000, -1, 'Oberammergau');
   VpeWrite(hdoc, 250, 1010, 750, -1, 'Zunderstr. 93');
   VpeWrite(hdoc, 1000, 1010, 1750, -1, '0 27 84 / 16 45 98');
   VpeWrite(hdoc, 250, 1265, 1750, -1, 'Willi-Graf-Str. 17');
   VpeWrite(hdoc, 1000, 1265, 1750, -1, '0 27 84 / 23 54 90');
   VpeWrite(hdoc, 1220, 670, 1750, -1, 'Heinz - Willi');
   VpeWrite(hdoc, 1100, 1400, 1950, -1,
   '[S 10 J I]'+
   'It is very important to mention here, that there is no problem in using '+
   'the special features of VPE, like justified text and all the other attributes. '+
   'Here you can see justified italic text. These features and options make VPE'+
   ' a professional tool, that makes document processing easy for the '+
   'developer, as well as for the end-user.');
end;

{ Precision demo
  ============== }
procedure precisiondemo(mode : Integer);
var hDoc : LongInt;
begin

   if (mode = 0) then
   begin
      hdoc := VpeOpenDoc(hMainWindow, 'Precision + Capabilities', -1, -1, VPE_EMBEDDED or VPE_GRID_POSSIBLE or VPE_ROUTE_HELP);
      Precision := hdoc;
   end
   else
   begin
      hdoc := VpeOpenDoc(hMainWindow, 'Precision + Capabilities',  -1, -1, 0);
      PBackGnd := hdoc;
   end;

   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 1, 1);
   VpeSetPen(hdoc, 0, PS_SOLID, 0);
   VpeDefineHeader(hdoc, 100, 100, 1000, 150, 'Precision + Capabilities   /  IDEAL Software');
   VpeSetUnderlined(hdoc, 0);
   VpeDefineFooter(hdoc, 1900, 2800, 2100, 2900, 'Page @PAGE');

   page1(hdoc);
   page2(hdoc);
   page3_4(hdoc);
   page5(hdoc);
   page6(hdoc);

   VpeRemoveSet(hdoc, HEADLINE);
   VpeGotoPage(hdoc, 1);

   if (mode = 0) then
      VpePreviewDoc(hdoc, nil, VPE_SHOW_NORMAL)
   else
      VpePrintDoc(hdoc, 0);
end;

{ ----------------------------------------------------------------------------
  Report Demo

  This all is done manually, only for your eyes...
  ---------------------------------------------------------------------------- }
procedure reporttest;
var hDoc : LongInt;
var y : Integer;
begin

   hdoc := VpeOpenDoc(hMainWindow, 'Report', -1, -1, 0);
   Report := hdoc;
   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   VpeSetPen(hdoc, 5, PS_SOLID, COLOR_BLACK);
   VpeDefaultBitmapDPI(hdoc, 96, 96);
   VpePicture(hdoc, 1650, 150, -1, -1, 'fruits.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
   VpeWriteBox(hdoc, 1650, VpeGet(hdoc, VBOTTOM), VpeGet(hdoc, VRIGHT), -1,
	   '[N S 9 CE I C Blue BC Gray TO]Fruits of Doom Software');
   y := VpeGet(hdoc, VBOTTOM) + 100;
   VpePrint(hdoc, 150, 200, '[N S 26 U]Year End Results');
   VpePrint(hdoc, 150, 400, '[N S 32]Fruits of Doom Software');

   VpeLine(hdoc, 150, y, 2000, y);
   inc(y,50);

   VpeNoPen(hdoc);
   VpePrintBox(hdoc, 150, y, '[N S 18 C Blue]Product: Apples');
   y := VpeGet(hdoc, VBOTTOM) + 10;
   VpePrint(hdoc, 150, y, '[S 16 C Purple]Country');
   VpePrint(hdoc, 650, y, 'Quantity');
   VpePrint(hdoc, 1150, y, 'Value (in $)');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, '[S 14 C Black]Germany');
   VpeWrite(hdoc, 650, y, 900, y+60, '[R]2.450,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '120.050,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'Great Britain');
   VpeWrite(hdoc, 650, y, 900, y+60, '2.250,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '110.250,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'France');
   VpeWrite(hdoc, 650, y, 900, y+60, '1.700,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '83.300,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'USA');
   VpeWrite(hdoc, 650, y, 900, y+60, '3.200,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '156.800,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'Australia');
   VpeWrite(hdoc, 650, y, 900, y+60, '1.080,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '52.920,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpePrint(hdoc, 150, y, 'Total');
   VpeWrite(hdoc, 650, y, 900, y+60, '10.680,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '523.320,00');




   inc(y,210);
   VpePrintBox(hdoc, 150, y, '[N S 18 C Blue]Product: Oranges');
   y := VpeGet(hdoc, VBOTTOM) + 10;
   VpePrint(hdoc, 150, y, '[S 16 C Purple]Country');
   VpePrint(hdoc, 650, y, 'Quantity');
   VpePrint(hdoc, 1150, y, 'Value (in $)');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, '[S 14 C Black]Germany');
   VpeWrite(hdoc, 650, y, 900, y+60, '[R]2.450,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '120.050,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'Great Britain');
   VpeWrite(hdoc, 650, y, 900, y+60, '2.250,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '110.250,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'France');
   VpeWrite(hdoc, 650, y, 900, y+60, '1.700,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '83.300,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'USA');
   VpeWrite(hdoc, 650, y, 900, y+60, '3.200,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '156.800,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'Australia');
   VpeWrite(hdoc, 650, y, 900, y+60, '1.080,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '52.920,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpePrint(hdoc, 150, y, 'Total');
   VpeWrite(hdoc, 650, y, 900, y+60, '10.680,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '523.320,00');

   inc(y, 210);
   VpePrintBox(hdoc, 150, y, '[N S 18 C Blue]Product: Bananas');
   y := VpeGet(hdoc, VBOTTOM) + 10;
   VpePrint(hdoc, 150, y, '[S 16 C Purple]Country');
   VpePrint(hdoc, 650, y, 'Quantity');
   VpePrint(hdoc, 1150, y, 'Value (in $)');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, '[S 14 C Black]Germany');
   VpeWrite(hdoc, 650, y, 900, y+60, '[R]2.450,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '120.050,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'Great Britain');
   VpeWrite(hdoc, 650, y, 900, y+60, '2.250,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '110.250,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'France');
   VpeWrite(hdoc, 650, y, 900, y+60, '1.700,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '83.300,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'USA');
   VpeWrite(hdoc, 650, y, 900, y+60, '3.200,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '156.800,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_GRAY);
   VpeBox(hdoc, 150, y, 1550, y+60);
   VpeSetTransparentMode(hdoc, 1);
   VpePrint(hdoc, 150, y, 'Australia');
   VpeWrite(hdoc, 650, y, 900, y+60, '1.080,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '52.920,00');

   y := VpeGet(hdoc, VBOTTOM);
   VpePrint(hdoc, 150, y, 'Total');
   VpeWrite(hdoc, 650, y, 900, y+60, '10.680,00');
   VpeWrite(hdoc, 1150, y, 1450, y+60, '523.320,00');

   y := VpeGet(hdoc, VBOTTOM) + 210;
   VpePrint(hdoc, 150, y, '[S 20 U]Yearly Country Sales Total: $1.569.960,00');

  { Draw a pie
    use the VpeGet()-stuff to easily position this anywhere on the paper
    ====================================================================}
  VpePageBreak(hdoc);
  VpeSelectFont(hdoc, 'Times New Roman', 12);
  VpePrint(hdoc, 200, VBOTTOM, '[N S 18 U]Analyze of Paradise:');
  VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
  VpeSetTransparentMode(hdoc, 0);
  VpeSetBkgColor(hdoc, COLOR_RED);

  VpePie(hdoc, 200, VpeGet(hdoc, VBOTTOM) + 100, -600, -600, 0, 300);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 20, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Apples');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_BLUE);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 300, 750);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 70, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Oranges');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_LTYELLOW);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 750, 1500);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 120, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Bananas');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_GREEN);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 1500, 2900);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 170, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Cherries');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 2900, 0);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 220, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Coconuts');

  VpeSetTransparentMode(hdoc, 1);

  VpeGotoPage(hdoc, 1);

  VpePreviewDoc(hdoc, nil, VPE_SHOW_NORMAL);
end;



{ ----------------------------------------------------------------------------
				Colortest
  ---------------------------------------------------------------------------- }
procedure colortest;

const range  = 1400;
const step   = 1;
const color_step = 2;
const min_color = 0;
const max_color = 255;

var  hdoc : LongInt;
var  rc  : TRect;
var  x, y : Integer;
var  r, g, b : Integer;
var  delta_r, delta_g, delta_b : Integer;
var  xx, factor : real;

begin
   hdoc := VpeOpenDoc(hMainWindow, 'Colors', -1, -1, VPE_NO_MOUSE_SCALE or VPE_NO_USER_MOVE
	  or VPE_NO_USER_CLOSE or VPE_NO_STATBAR or VPE_NO_RULER or VPE_NO_HELPBTN or VPE_NO_INFOBTN);
   VpeSetScale(hdoc, 0.25);
   Colors := hdoc;

   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   VpeSetPen(hdoc, 0, PS_SOLID, COLOR_BLACK);
   VpeSelectFont(hdoc, 'Arial', 30);

   xx := -3.1415;
   factor := 2 * abs(xx) / range * step;

   r := 192;
   delta_r := color_step;
   g := min_color+1;
   delta_g := color_step;
   b := min_color+1;
   delta_b := color_step;

   x := 100;
   while x < range+100 do
   begin
     y := Round(sin(xx) * 500.0 + 500);
     VpeSetTextColor(hdoc, RGB( r, g, b));
     VpeWriteBox(hdoc, x, y, x+800, y + 120, 'Color Test');

     if (x mod 10 = 0) then
     begin
	xx :=xx+ factor;
	inc(x,step);
	y  := Round(sin(xx) * 500.0 + 500);
	VpeSetTextColor(hdoc, COLOR_BLACK);
	VpeWriteBox(hdoc, x, y, x+800, y + 120, 'Color Test');
     end;

     xx :=xx+ factor;
     if (r > min_color) and (r < max_color) then
     begin
	inc(r,delta_r);
	if (r < min_color) then
	   r := min_color;
	if (r > max_color) then
	   r := max_color;
     end
     else if (g > min_color) and (g < max_color) then
     begin
	inc(g, delta_g);
	if (g < min_color) then
	   g := min_color;
	if (g > max_color) then
	   g := max_color;
     end
     else if (b > min_color) and (b < max_color) then
     begin
	inc(b,delta_b);
	if (b < min_color) then
	   b := min_color;
	if (b > max_color) then
	   b := max_color;
     end;

     if (r >= max_color) and (b >= max_color) then
     begin
	delta_r := -color_step;
	r := max_color-1;
     end;
     if (r >= min_color) and (g >= max_color) then
     begin
	delta_g := -color_step;
	g := max_color-1;
     end;
     if (g = min_color) and (b >= max_color) then
     begin
	delta_b := -color_step;
	b := max_color-1;
     end;

     if (r=min_color) and (g=min_color) and (b=min_color) then
     begin
	r := min_color+1; g:=min_color+1; b:=min_color+1;
	delta_b := color_step;
	delta_g := color_step;
	delta_r := color_step;
     end;
     inc(x,step);
   end;

   rc.left := 0;
   rc.top  := 0;
   rc.right := 280;
   rc.bottom :=200;
   VpePreviewDoc(hdoc, @rc, VPE_SHOW_NORMAL);
end;

{ ========================================================================
			      SpeedTest
  ======================================================================== }

const RPT_PATH      =  'journal.rpt';


{ ========================================================================
			    Globals
  ======================================================================== }
const sum_amount   : Real = 0;
const sum_prorated : Real = 0;
const   sum_tax          : Real = 0;

{// ========================================================================
//                            striplf
// ========================================================================}
procedure striplf(s :PChar);
var i : Integer;
begin
   i := strlen(s)-1;
   while (i>=0) and ((s[i]=#13) or (s[i]=#10)) do
   begin
      s[i] := #0;
      dec(i);
   end;
end;

{// ========================================================================
//                            stof
// ========================================================================}
function stof(s : PChar) : Real;
var i : Integer;
var p : Pchar;
var R : Real;
begin
   p := s;

   while s^ <> #0 do
   begin
      if s^ = ',' then
	 s^ := '.'
      else if s^ = '.' then
      begin
	 for i := 0 to Ord(s[i])-1 do
	    s[i] := s[i+1];
      end;
      inc(s);
   end;
   val(p,r,i);
   if i = 0 then
	  stof := r else
       stof := 0;
end;







{// ========================================================================
//                            stoDM
// ========================================================================}
procedure stoDM(s : PChar);
var i,tocopy : Integer;
var beg          : boolean;
var P : Pchar;
var tmp : array[0..127] of char;

begin
   strcopy(tmp, s);
   p := tmp;

   while p^ <> #0 do
   begin
      if p^ = '.' then
	 p^ := ',';
      inc(p);
   end;

   i := strlen(tmp) - 3;    {// 2 Nachkommastellen und tausender-punkt}
   p := tmp;
   beg := true;
   s^ := #0;
 
   while (i > 0) do
   begin
      tocopy := i mod 3;
      if (tocopy = 0) then
      begin
	 if not beg then
	    strcat(s, '.');
	 tocopy := 3;
      end;
      s := strlcat(s, p,strlen(s)+ tocopy);
      p :=p+ tocopy;
      dec(i,tocopy);
      beg := false;
   end;

   strcat(s, p);
end;





{// ========================================================================
//                              PrintJournal
//
// Structure of input-file
// =======================
// User-Name
// Year
// Start Month (or blank)
// End Month (or blank)
// <@>Table-Name --> start a new table!!!
// No.
// Date
// Amount
// Prorated Amount
// Tax
// Remark
// Remark
//
// NOTE: In this demo Y2 has a constant value for much faster processing
//
// ========================================================================}

{// ========================================================================
//                              GenerateReport
// ========================================================================}
procedure GenerateReport;
var fh : Text;
var i, stepper, min, z : Integer;
const count : LongInt = 0;
const table : LongInt = 1;
begin
   Randomize;

   SetDlgItemText(hMainDlg, 110, 'Generating pseudo report-file...');

   Assign(fh,RPT_PATH);
   Rewrite(fh);
   WriteLn(fh, 'Test-Document');
   WriteLn(fh, '1996');
   WriteLn(fh);
   z := 0;

   while (count < 20000) do
   begin
      if z < (Random(65000) mod 5) + 10 then
      begin
	 stepper := 4;
	 min := 3;
      end
      else
      begin
	 stepper := 21;
	 min := 20;
	 z := -1;
      end;
	   inc(z);
      WriteLn(fh, '@Table ', table);
      inc(table);
      i := (random(65000) mod stepper) + min;
      while i > 0 do
      begin
	 writeln(fh,count);
	 writeln(fh,random(65000) mod 28 + 1:2,'.',random(65000) mod 12+1:02,'.95');

	 writeln(fh,random(65000),',', random(65000) mod 100:02);
	 writeln(fh,random(65000),',', random(65000) mod 100);
	 writeln(fh,random(65000),',', random(65000) mod 100);
	 writeln(fh);
	 writeln(fh);
	 inc(count,7);
	 dec(i);
      end;
   end;

   close(fh);

   SetDlgItemText(hMainDlg, 110, 'Report generation finished.');
end;







{// ========================================================================
//                              PrintHeader
// ========================================================================}
procedure PrintHeader(hdoc : LongInt ; table : PChar);
begin
   VpeSetAlign(hdoc, ALIGN_CENTER);
   VpeSelectFont(hdoc, 'Arial', 14);
   VpeSetBkgColor(hdoc, COLOR_LTGRAY);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, VRIGHTMARGIN, -60, table);

   VpeSetFontAttr(hdoc, ALIGN_CENTER, 1, 0, 0);
   VpeSelectFont(hdoc, 'Arial', 11);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -200, -50, 'No.');
   VpeWriteBox(hdoc, VRIGHT, VTOP, -200, VBOTTOM, 'Date');
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, 'Amount');
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, 'Prorated Amount');
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, 'Tax');
   VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, 'Remark');
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSetBkgColor(hdoc, RGB(255, 255, 255));
end;




{// ========================================================================
//                              PrintFooter
// ========================================================================}
procedure PrintFooter(hdoc : LongInt);
var s : array[0..19] of char;

begin
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 1, 0, 0);
   VpeSetBkgColor(hdoc, COLOR_LTGRAY);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -400, -50, 'Sum');
   VpeSetFontAttr(hdoc, ALIGN_RIGHT, 1, 0, 0);
   Str(sum_amount:1:2,s);
   stoDM(s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);
   Str(sum_prorated:1:2,s);
   stoDM(s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);
   Str(sum_tax:1:2,s);
   stoDM(s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);
   VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, '');
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSetBkgColor(hdoc, RGB(255, 255, 255));
end;





{// ========================================================================
//                              PrintFoot
// ========================================================================}
procedure PrintPageFooter(hdoc : LongInt; name : PChar; page : Integer );
var buf : array[0..31] of char;

begin

   VpeStorePos(hdoc);
   VpeNoPen(hdoc);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOMMARGIN, VpeGet(hdoc, VRIGHTMARGIN) - 400, -50, name);
   wvsprintf(buf, 'Journal Page %d', page);
   VpeSetAlign(hdoc, ALIGN_RIGHT);
   VpeWriteBox(hdoc, VRIGHT, VBOTTOMMARGIN, VRIGHTMARGIN, -50, buf);
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeRestorePos(hdoc);
end;






{// ========================================================================
//                              PageBreak
// ========================================================================}
procedure PageBreak(hdoc : LongInt; page : Integer);
var z : array[0..79] of char;

begin


   VpePageBreak(hdoc);

   if (page mod 10 = 0) then
   begin
      wvsprintf(z, 'now reading inputfile and generating page %d', page);
      SetDlgItemText(hMainDlg, 110, z);
   end;
end;





{// ========================================================================
//                              PrintJournal
// ========================================================================}
function PrintJournal : Boolean;
var hdoc : LongInt;
var fh  : Text;
var s   : array[0..255] of char;
var buf : array[0..513] of char;
var name : array[0..79] of char;
var year : array[0..7] of char;
var period : array[0..31] of char;
var table  : array[0..128] of char;
const footer_ok : Boolean = FALSE;
const page : Integer = 1;
var   hOldCursor : HCURSOR ;
var i : Integer;
begin

   PrintJournal := false;
   hOldCursor := SetCursor(LoadCursor(0, IDC_WAIT));
   Assign(fh,RPT_PATH);
   Reset(fh);
   if IOResult <> 0 then
   begin
      SetDlgItemText(hMainDlg, 110, 'ERROR: Report-file not found!');
      EXIT;
   end;

   hdoc := VpeOpenDoc(hMainWindow, 'Speed + Tables', -1, -1, VPE_GRID_POSSIBLE);
   Speed := hdoc;
   VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
   VpeSetTransparentMode(hdoc, 0);


   {// Read constant data block:
   // =========================}
   ReadLn(fh,name);
   striplf(name);
   ReadLn(fh,year);
   striplf(year);
   ReadLn(fh,s);
   striplf(s);

   if (strlen(s) > 0) then
   begin
      if (strlcomp(s, 'Month', 5) = 0) then     { // if 'Month' possibly eliminate 2 Blanks}
      begin
	 if (s[7] = ' ') then
	 begin
	    s[6] := s[8];
	    s[7] := #0;
	 end;
      end;
      strcopy(period, ', ');
      strcat(period, s);
   end
   else
      period[0] := #0;

   strcat(strcat(strcopy(s, 'Journal '),year), period);
   VpeSetPen(hdoc, 0, 0, COLOR_BLACK);
   VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
   VpeSelectFont(hdoc, 'Arial', 16);
   VpeWriteBox(hdoc, VLEFTMARGIN, VTOPMARGIN, VRIGHTMARGIN, VFREE, s);

   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
   VpeSelectFont(hdoc, 'Arial', 11);

   {// process variable data:
   // ======================}
   while not EOF(fh) do

   begin
      REadLn(fh,s);
      if IOResult <> 0 then BREAK;
      striplf(s);
      if (s[0] = '@') then
      begin
	 {// Beginning of a new table:
	 // =========================}
	 if (footer_ok) then
	    PrintFooter(hdoc);
	 sum_tax:=0;
	 sum_prorated:=0;
	 sum_amount:=0;

	 {// Is the room to the page-bottom big enough for a new table ?}
	 if (VpeGet(hdoc, VBOTTOMMARGIN) - VpeGet(hdoc, VBOTTOM) < 400) then
	 begin
	    {// No, add a new page:}
	    PrintPageFooter(hdoc, name, page);
	    PageBreak(hdoc, page);
	    inc(page);
	 end
	 else
	 begin
	    {// Beginning of new table is 1cm below previous table:}
	    VpeSet(hdoc, VBOTTOM, VpeGet(hdoc, VBOTTOM) + 100);
	 end;
	 strcopy(table, s+1);
	 PrintHeader(hdoc, table);
	 footer_ok := FALSE;
      end
      else
      begin
	 {// list part:
	 // ==========}
	 footer_ok := TRUE;
	 VpeSetTransparentMode(hdoc, 1);
	 VpeSetAlign(hdoc, ALIGN_RIGHT);
	 VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -200, -50, s);

	 REadLn(fh,s);
	 striplf(s);
	 VpeWriteBox(hdoc, VRIGHT, VTOP, -200, VBOTTOM, s);

	 readLn(fh,s);
	 striplf(s);
	 sum_amount := sum_amount+stof(s);
	 stoDM(s);
	 VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);

	 ReadLn(fh,s);
	 striplf(s);
	 sum_prorated := sum_prorated+stof(s);
	 stoDM(s);
	 VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);

	 ReadLn(fh,s);
	 striplf(s);
	 sum_tax := sum_tax+stof(s);
	 stoDM(s);
	 VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, s);

	 ReadLn(fh,s);
	 striplf(s);
	 strcopy(buf, s);
	 strcat(buf, ' ');
	 ReadLn(fh,s);
	 striplf(s);
	 strcat(buf, s);
	 VpeSetAlign(hdoc, ALIGN_LEFT);
	 VpeSelectFont(hdoc, 'Arial', 6);
	 VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, buf);
	 VpeSelectFont(hdoc, 'Arial', 11);
	 VpeSetTransparentMode(hdoc, 0);

	 if (VpeGet(hdoc, VBOTTOM) + 150 > VpeGet(hdoc, VBOTTOMMARGIN)) then
	 begin
	    {// Bottom of page reached:
	    // =======================}
	    PrintFooter(hdoc);
	    PrintPageFooter(hdoc, name, page);
	    PageBreak(hdoc, page);
	    inc(page);
	    PrintHeader(hdoc, table);
	 end;
      end; {// else}
   end; {// while}

   Close(fh);

   PrintFooter(hdoc);
   PrintPageFooter(hdoc, name, page);

   VpeGotoPage(hdoc, 1);
   i := VpeGetPageCount(hdoc);
   wvsprintf(s, 'Generated %d pages out of textfile!', i);
   VpeWriteBox(hdoc, 100, 100, 1000, 150, s);

   SetCursor(hOldCursor);
   SetDlgItemText(hMainDlg, 110, '');


   VpePreviewDoc(hdoc, nil, VPE_SHOW_MAXIMIZED);

   PrintJournal := true;
end;



const szAppName  = 'VPE';

const ID_PRECISION  = 100;
const ID_CPRECISION = 111;
const ID_PAGE_LEFT  = 888;
const ID_PAGE_RIGHT = 889;
const ID_PBACKGND         = 200;
const ID_GENERATE         = 900;
const ID_REMOVEREP  = 901;
const ID_SPEED            = 101;
const ID_CSPEED   = 112;
const ID_COLORS   = 102;
const ID_CCOLORS          = 113;
const ID_REPORT   = 902;
const ID_CREPORT          = 904;
var   F : TExt;
{// ========================================================================
//                              DlgSelectProc
// ========================================================================}

function DlgSelectProc(hDlg : HWND;message : Word;wParam : Word; lParam : LongInt) : Bool;export;

begin
   DlgSelectProc := False;
   case message of
    WM_INITDIALOG:
     begin
       hMainDlg := hDlg;
       DlgSelectProc := True;
       EXIT;
     end;

   WM_COMMAND:
     begin
       SetDlgItemText(hMainDlg, 110, '');
       case wParam of
	 ID_PRECISION:
	     if (Precision <> 0) then
		SetDlgItemText(hMainDlg, 110, 'Precision test is already running')
	     else
	     begin
		SetDlgItemText(hMainDlg, 110, 'The window titled ''VPE'' is the applications main window.'+
					 ' It''s content is an embedded window from the VPE-DLL!!! You just need about 12 lines of code!');
		precisiondemo(0);
		EnableWindow(GetDlgItem(hMainDlg, ID_CPRECISION), TRUE);
		EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_LEFT), TRUE);
		EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_RIGHT), TRUE);
	     end;


	  ID_CPRECISION:
	     if (VpeCloseDoc(Precision)=0) then
		SetDlgItemText(hMainDlg, 110, 'Can''t close, task ''precision test'' is currently printing');

	  ID_PAGE_LEFT:
	   begin
	     VpeSetUpdate(Precision, 1);
	     VpeGotoPage(Precision, VpeGetCurrentPage(Precision)-1);
	     VpeSetUpdate(Precision, 0);
	   end;

	  ID_PAGE_RIGHT:
	   begin
	     VpeSetUpdate(Precision, 1);
	     VpeGotoPage(Precision, VpeGetCurrentPage(Precision)+1);
	     VpeSetUpdate(Precision, 0);
	   end;

	  ID_PBACKGND:
	    begin
	      SetDlgItemText(hMainDlg, 110, 'Here no preview is shown.'+
				  ' Also no printer-setup is done - setting of the standrd printer or of your last setup in VPE are taken');
	      EnableWindow(GetDlgItem(hMainDlg, ID_PBACKGND), FALSE);
	      precisiondemo(1);
	    end;


	  ID_GENERATE: GenerateReport;

	  ID_REMOVEREP: begin
					     Assign(F,RPT_PATH);
								  Erase(F);
			end;

	  ID_SPEED:
	   begin
	     if Speed <> 0 then
		SetDlgItemText(hMainDlg, 110, 'Speed test is already running')
	     else
	     begin
		if PrintJournal then
		   EnableWindow(GetDlgItem(hMainDlg, ID_CSPEED), TRUE);
	     end;
	   end;

	  ID_CSPEED:
	     if VpeCloseDoc(Speed)=0 then
		SetDlgItemText(hMainDlg, 110, 'Can''t close, task ''speed test'' is currently printing');

	  ID_COLORS:
	     if (Colors <> 0 ) then
		SetDlgItemText(hMainDlg, 110, 'Color test is already running')
	     else
	     begin
		colortest;
		EnableWindow(GetDlgItem(hMainDlg, ID_CCOLORS), TRUE);
	     end;

	  ID_CCOLORS:
	     if (VpeCloseDoc(Colors)=0) then
		SetDlgItemText(hMainDlg, 110, 'Can''t close, task ''color test'' is currently printing');


	  ID_REPORT:
	     if (Report <> 0) then
		SetDlgItemText(hMainDlg, 110, 'Report test is already running')
	     else
	     begin
		reporttest;
		EnableWindow(GetDlgItem(hMainDlg, ID_CREPORT), TRUE);
	     end;

	  ID_CREPORT:
	     if (VpeCloseDoc(Report) = 0) then
		SetDlgItemText(hMainDlg, 110, 'Can''t close, task ''report test'' is currently printing');
	  IDOK,
	  IDCANCEL:
	   begin
	     if (SendMessage(hMainWindow, WM_CLOSE, 0, 0) <> 0) then
	     begin
		EndDialog(hDlg, 0);
	     end;
	     EXIT;
	  end;
       end;
     end;
   end;


end;






{// ========================================================================
//                              WndProc
// ========================================================================}
var  no_close  : Integer;

function WndProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var  lpfnDlgProc : TFARPROC;
begin
   case message of
    WM_CREATE:
       begin
	 no_close := 0;
	 hMainWindow := Window;
	 lpfnDlgProc := MakeProcInstance (@DlgSelectProc, hInstance);
	 CreateDialog(hInstance, 'DLG_TEST', Window, lpfnDlgProc);
	 WndProc := 0;
	 EXIT;
       end;

       VPE_DESTROYWINDOW:
	begin
	 if (Precision = lParam) then
	 begin
	    Precision := 0;
	    EnableWindow(GetDlgItem(hMainDlg, ID_CPRECISION), FALSE);
	    EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_LEFT), FALSE);
	    EnableWindow(GetDlgItem(hMainDlg, ID_PAGE_RIGHT), FALSE);
	 end
	 else if (Speed = lParam) then
	 begin
	    Speed := 0;
	    EnableWindow(GetDlgItem(hMainDlg, ID_CSPEED), FALSE);
	 end
	 else if (Colors = lParam) then
	 begin
	    Colors := 0;
	    EnableWindow(GetDlgItem(hMainDlg, ID_CCOLORS), FALSE);
	 end
	 else if (Report = lParam) then
	 begin
	    Report := 0;
	    EnableWindow(GetDlgItem(hMainDlg, ID_CREPORT), FALSE);
	 end;
       end;


      VPE_PRINT,
      VPE_PRINTCANCEL:
	begin
	 if wParam <> 0 then
	 begin
	    inc(no_close);
	 end
	 else
	 begin
	    dec(no_close);
	    if (lParam = PBackGnd) then
	    begin
	       VpeCloseDoc(PBackGnd);
	       PBackGnd := 0;
	       EnableWindow(GetDlgItem(hMainDlg, ID_PBACKGND), TRUE);
	       if (message = VPE_PRINT) then
		  SetDlgItemText(hMainDlg, 110, 'Message: Background-Processing finished.')
	       else
		  SetDlgItemText(hMainDlg, 110, 'Message: Background-Processing aborted.');
	    end;
	 end;
	 WndProc := 0;
       end;


      VPE_HELP: MessageBox(Window, 'User requested help!', 'Note:', MB_OK);

      WM_SIZE:
       begin
	 if Precision <> 0 then  { // this is an embedded window}
	 begin
	    MoveWindow(VpeWindowHandle(Precision), 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	 end;
	 WndProc := 0;
       end;


      WM_KEYDOWN:
       begin
	 if Precision <> 0 then  {// this is an embedded window}
	 begin
	    SendMessage(VpeWindowHandle(Precision), WM_KEYDOWN, wParam, lParam);
	 end;
	 WndProc := 0;
       end;

      WM_CLOSE:
	begin
	 if (no_close= 0) then    { // can't close, because printing?}
	 begin
	    DestroyWindow(Window);
	    WndProc := 1;
	 end;
	 MessageBox(Window, 'Can''t close, job is printing!', 'WARNING:', MB_OK);
	 WndProc := 0;
       end;


      WM_DESTROY:
       begin
	 PostQuitMessage(0);
	 WndProc :=0;
       end;
     else WndProc := DefWindowProc (Window, message, wParam, lParam) ;
   end;

end;


{// ========================================================================
//                              WinMain
// ========================================================================}



procedure WinMain;

var  msg : TMSG;
var Window : HWnd;
var wndclass : TWndClass;

begin

   if HPrevInst = 0 then
   begin
      wndclass.style         := CS_HREDRAW or CS_VREDRAW ;
      wndclass.lpfnWndProc   := @WndProc ;
      wndclass.cbClsExtra    := 0 ;
      wndclass.cbWndExtra    := 0 ;
      wndclass.hInstance     := hInstance ;
      wndclass.hIcon         := LoadIcon (hInstance, 'APP_ICON');
      wndclass.hCursor       := LoadCursor (0, IDC_ARROW) ;
      wndclass.hbrBackground := GetStockObject (WHITE_BRUSH) ;
      wndclass.lpszMenuName  := szAppName ;
      wndclass.lpszClassName := szAppName ;
      RegisterClass(wndclass) ;
   end;

   Window := CreateWindow(szAppName, szAppName,
		       WS_OVERLAPPEDWINDOW,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       CW_USEDEFAULT, CW_USEDEFAULT,
		       0, 0, hInstance, nil) ;

   ShowWindow (Window, CmdShow) ;
   UpdateWindow (Window) ;

   while GetMessage(Msg, 0, 0, 0) do
   begin
     TranslateMessage(Msg);
     DispatchMessage(Msg);
   end;
   Halt(Msg.wParam);
end;

begin
  SetDemoText;
  WinMain;
end.

