** VPE-Interface for Foxpro and Visual Foxpro
** by Jrg Mckli 5.5.96
**
** For Windows 16 bit RegFn() and CallFn() is used
** For Windows 32 bit DECLARE is used
**
** The functions which receive RECT structures are not supported.
** Use VpeGet() and VpeSet() instead.
**
** Functions which send RECT structures are implemented, but better you use the
** single-parameter "SP"-functions.
**
** You can increase the performance for 32 bit platforms by removing the
** redirecting function calls via callfn() appearing below the PROCEDURE InitVpe.
** This interface is designed to be used from Foxpro and Visual Foxpro together.

PROCEDURE InitVpe
  IF 'DOS' $ OS()	&& 16bit OS

    IF NOT 'FOXTOOLS' $ SET('LIBRARY')
      SET LIBRARY TO (SYS(2004)+'foxtools') ADDITIVE
    ENDIF 

    PUBLIC VpeGetVersion, VpeOpenDoc, VpeOpenDocFile, VpeCloseDoc, VpeWindowHandle   
    PUBLIC VpeSetDefOutRect, VpeSetDefOutRectSP, VpeSetOutRect, VpeGetOutRect, VpeSetPosRect, VpeGetPosRect 
    PUBLIC VpeSet, VpeGet, VpeStorePos, VpeRestorePos, VpeSetScale, VpeSetRulersMeasure
    PUBLIC VpeSetupPrinter, VpeSetPrintOptions, VpePrintDoc, VpeIsPrinting
    PUBLIC VpePreviewDoc, VpePreviewDocSP, VpeCenterPreview
    PUBLIC VpeSetUpdate,VpeRefreshDoc, VpeSetPen, VpeNoPen
    PUBLIC VpeLine, VpePolyLine, VpeAddPolyPoint, VpePolygon, VpeAddPolygonPoint 
    PUBLIC VpeSetBkgColor, VpeSetTransparentMode, VpeSetHatchStyle, VpeSetHatchColor
    PUBLIC VpeBox, VpeEllipse, VpePie
    PUBLIC VpeSetBarcodeParms, VpeBarcode, VpeKeepBitmapAspect, VpeDefaultBitmapDPI, VpeGetPictureTypes
    PUBLIC VpePicture, VpePictureDIB, VpePictureResID, VpePictureResName
    PUBLIC VpeSelectFont, VpeSetFontAttr, VpeSetAlign, VpeSetBold, VpeSetUnderlined, VpeSetItalic, VpeSetTextColor
    PUBLIC VpePrint, VpePrintBox, VpeWrite,VpeWriteBox, VpeDefineHeader, VpeDefineFooter
    PUBLIC VpePageBreak, VpeGetPageCount, VpeGetCurrentPage, VpeGotoPage, VpeStoreSet, VpeUseSet, VpeRemoveSet
    PUBLIC VpeSetAutoBreak, VpeWriteDoc, VpeReadDoc, VpeSetRotation

    VpeGetVersion     = regfn('VpeGetVersion','','I','VPENGINE.DLL')
    VpeOpenDoc        = regfn('VpeOpenDoc','ICIIL','L','VPENGINE.DLL')
    VpeOpenDocFile    = regfn('VpeOpenDocFile','ICCIIL','L','VPENGINE.DLL')
    VpeCloseDoc       = regfn('VpeCloseDoc','L','I','VPENGINE.DLL')
    VpeWindowHandle   = regfn('VpeWindowHandle','L','I','VPENGINE.DLL')
    VpeSetDefOutRect  = regfn('VpeSetDefOutRect','LC','','VPENGINE.DLL')
    VpeSetDefOutRectSP= regfn('VpeSetDefOutRectSP','LIIII','','VPENGINE.DLL')
    VpeSetOutRect     = regfn('VpeSetOutRect','LC','','VPENGINE.DLL')
    VpeGetOutRect     = regfn('VpeGetOutRect','LC','','VPENGINE.DLL')
    VpeSetPosRect     = regfn('VpeSetPosRect','LC','','VPENGINE.DLL')
    VpeGetPosRect     = regfn('VpeGetPosRect','LC','','VPENGINE.DLL')
    VpeSet            = regfn('VpeSet','LII','','VPENGINE.DLL')
    VpeGet    	      = regfn('VpeGet','LI','I','VPENGINE.DLL')
    VpeStorePos       = regfn('VpeStorePos','L','','VPENGINE.DLL')
    VpeRestorePos     = regfn('VpeRestorePos','L','','VPENGINE.DLL')
    VpeSetScale       = regfn('VpeSetScale','LD','','VPENGINE.DLL')
    VpeSetRulersMeasure = regfn('VpeSetRulersMeasure','LI','','VPENGINE.DLL')
    VpeSetupPrinter   = regfn('VpeSetupPrinter','LCI','I','VPENGINE.DLL')
    VpeSetPrintOptions= regfn('VpeSetPrintOptions','LL','','VPENGINE.DLL')
    VpePrintDoc       = regfn('VpePrintDoc','LI','','VPENGINE.DLL')
    VpeIsPrinting     = regfn('VpeIsPrinting','L','I','VPENGINE.DLL')
    VpePreviewDoc     = regfn('VpePreviewDoc','LCI','','VPENGINE.DLL')
    VpePreviewDocSP   = regfn('VpePreviewDocSP','LIIIII','','VPENGINE.DLL')
    VpeCenterPreview  = regfn('VpeCenterPreview','LIII','','VPENGINE.DLL')
    VpeSetUpdate      = regfn('VpeSetUpdate','LI','','VPENGINE.DLL')
    VpeRefreshDoc     = regfn('VpeRefreshDoc','L','','VPENGINE.DLL')
    VpeSetPen 	      = regfn('VpeSetPen','LIIL','','VPENGINE.DLL')
    VpeNoPen 	      = regfn('VpeNoPen','L','','VPENGINE.DLL')
    VpeLine 	      = regfn('VpeLine','LIIII','','VPENGINE.DLL')
    VpePolyLine       = regfn('VpePolyLine','LLI','L','VPENGINE.DLL')  && set POINT = 0
    VpeAddPolyPoint   = regfn('VpeAddPolyPoint','LLII','','VPENGINE.DLL')
    VpePolygon        = regfn('VpePolygon','LLI','L','VPENGINE.DLL')  && set POINT = 0
    VpeAddPolygonPoint = regfn('VpeAddPolygonPoint','LLII','','VPENGINE.DLL')
    VpeSetBkgColor    = regfn('VpeSetBkgColor','LL','','VPENGINE.DLL')
    VpeSetTransparentMode = regfn('VpeSetTransparentMode','LI','','VPENGINE.DLL')
    VpeSetHatchStyle  = regfn('VpeSetHatchStyle','LI','','VPENGINE.DLL')
    VpeSetHatchColor  = regfn('VpeSetHatchColor','LL','','VPENGINE.DLL')
    VpeBox 	      = regfn('VpeBox','LIIII','','VPENGINE.DLL')
    VpeEllipse	      = regfn('VpeEllipse','LIIII','','VPENGINE.DLL')
    VpePie 	      = regfn('VpePie','LIIIIII','','VPENGINE.DLL')
    VpeSetBarcodeParms= regfn('VpeSetBarcodeParms','LII','','VPENGINE.DLL')
    VpeBarcode	      = regfn('VpeBarcode','LIIIIICC','','VPENGINE.DLL')
    VpeKeepBitmapAspect = regfn('VpeKeepBitmapAspect','LI','','VPENGINE.DLL')
    VpeDefaultBitmapDPI = regfn('VpeDefaultBitmapDPI','LII','','VPENGINE.DLL')
    VpeGetPictureTypes  = regfn('VpeGetPictureTypes','ICI','','VPENGINE.DLL')
    VpePicture          = regfn('VpePicture','LIIIICI','','VPENGINE.DLL')
    VpePictureDIB     = regfn('VpePictureDIB','LIIIIII','','VPENGINE.DLL')
    VpePictureResID   = regfn('VpePictureResID','LIIIIII','','VPENGINE.DLL')
    VpePictureResName = regfn('VpePictureResName','LIIIICI','','VPENGINE.DLL')
    VpeSelectFont     = regfn('VpeSelectFont','LCI','','VPENGINE.DLL')
    VpeSetFontAttr    = regfn('VpeSetFontAttr','LIIII','','VPENGINE.DLL')
    VpeSetAlign       = regfn('VpeSetAlign','LI','','VPENGINE.DLL')
    VpeSetBold        = regfn('VpeSetBold','LI','','VPENGINE.DLL')
    VpeSetUnderlined  = regfn('VpeSetUnderlined','LI','','VPENGINE.DLL')
    VpeSetItalic      = regfn('VpeSetItalic','LI','','VPENGINE.DLL')
    VpeSetTextColor   = regfn('VpeSetTextColor','LL','','VPENGINE.DLL')
    VpePrint 	      = regfn('VpePrint','LIIC','I','VPENGINE.DLL')
    VpePrintBox       = regfn('VpePrintBox','LIIC','I','VPENGINE.DLL')
    VpeWrite 	      = regfn('VpeWrite','LIIIIC','I','VPENGINE.DLL')
    VpeWriteBox       = regfn('VpeWriteBox','LIIIIC','I','VPENGINE.DLL')
    VpeDefineHeader   = regfn('VpeDefineHeader','LIIIIC','','VPENGINE.DLL')
    VpeDefineFooter   = regfn('VpeDefineFooter','LIIIIC','','VPENGINE.DLL')
    VpePageBreak      = regfn('VpePageBreak','L','','VPENGINE.DLL')
    VpeGetPageCount   = regfn('VpeGetPageCount','L','I','VPENGINE.DLL')
    VpeGetCurrentPage = regfn('VpeGetCurrentPage','L','I','VPENGINE.DLL')
    VpeGotoPage       = regfn('VpeGotoPage','LI','','VPENGINE.DLL')
    VpeStoreSet       = regfn('VpeStoreSet','LI','','VPENGINE.DLL')
    VpeUseSet         = regfn('VpeUseSet','LI','','VPENGINE.DLL')
    VpeRemoveSet      = regfn('VpeRemoveSet','LI','','VPENGINE.DLL')
    VpeSetAutoBreak   = regfn('VpeSetAutoBreak','LI','','VPENGINE.DLL')
    VpeWriteDoc       = regfn('VpeWriteDoc','LC','','VPENGINE.DLL')
    VpeReadDoc        = regfn('VpeReadDoc','LC','','VPENGINE.DLL')
    VpeSetRotation    = regfn('VpeSetRotation','LI','','VPENGINE.DLL')

  ELSE	&& 32bit OS

    DECLARE INTEGER VpeGetVersion   IN VPE32.DLL
    DECLARE INTEGER VpeOpenDoc      IN VPE32.DLL INTEGER,STRING,INTEGER,INTEGER,INTEGER 
    DECLARE INTEGER VpeOpenDocFile  IN VPE32.DLL INTEGER,STRING,STRING,INTEGER,INTEGER,INTEGER 
    DECLARE INTEGER VpeCloseDoc     IN VPE32.DLL INTEGER
    DECLARE INTEGER VpeWindowHandle IN VPE32.DLL INTEGER 
    DECLARE VpeSetDefOutRect        IN VPE32.DLL INTEGER,STRING
    DECLARE VpeSetDefOutRectSP      IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpeSetOutRect           IN VPE32.DLL INTEGER,STRING
    DECLARE VpeGetOutRect           IN VPE32.DLL INTEGER,STRING
    DECLARE VpeSetPosRect           IN VPE32.DLL INTEGER,STRING
    DECLARE VpeGetPosRect           IN VPE32.DLL INTEGER,STRING
    DECLARE VpeSet                  IN VPE32.DLL INTEGER INTEGER,INTEGER 
    DECLARE INTEGER VpeGet    	    IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeStorePos             IN VPE32.DLL INTEGER
    DECLARE VpeRestorePos           IN VPE32.DLL INTEGER
    DECLARE VpeSetScale             IN VPE32.DLL INTEGER,DOUBLE 
    DECLARE VpeSetRulersMeasure     IN VPE32.DLL INTEGER,INTEGER 
    DECLARE INTEGER VpeSetupPrinter IN VPE32.DLL INTEGER,STRING,INTEGER 
    DECLARE VpeSetPrintOptions      IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpePrintDoc             IN VPE32.DLL INTEGER,INTEGER 
    DECLARE INTEGER VpeIsPrinting   IN VPE32.DLL INTEGER 
    DECLARE VpePreviewDoc           IN VPE32.DLL INTEGER,STRING,INTEGER 
    DECLARE VpePreviewDocSP         IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER 
    DECLARE VpeCenterPreview        IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER 
    DECLARE VpeSetUpdate            IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeRefreshDoc           IN VPE32.DLL INTEGER, INTEGER 
    DECLARE VpeSetPen 	            IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpeNoPen                IN VPE32.DLL INTEGER
    DECLARE VpeLine 	            IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE INTEGER VpePolyLine     IN VPE32.DLL INTEGER,INTEGER,INTEGER  && set POINT = 0
    DECLARE VpeAddPolyPoint         IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE INTEGER VpePolygon      IN VPE32.DLL INTEGER,INTEGER,INTEGER  && set POINT = 0
    DECLARE VpeAddPolygonPoint      IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpeSetBkgColor          IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetTransparentMode   IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetHatchStyle        IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetHatchColor        IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeBox 	            IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpeEllipse              IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpePie	            IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpeSetBarcodeParms      IN VPE32.DLL INTEGER,INTEGER,INTEGER
    DECLARE VpeBarcode	            IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER, STRING, STRING
    DECLARE VpeKeepBitmapAspect     IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeDefaultBitmapDPI     IN VPE32.DLL INTEGER,INTEGER,INTEGER
    DECLARE VpeGetPictureTypes      IN VPE32.DLL INTEGER,STRING,INTEGER
    DECLARE VpePicture              IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,STRING,INTEGER
    DECLARE VpePictureDIB           IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpePictureResID         IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpePictureResName       IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,STRING,INTEGER
    DECLARE VpeSelectFont           IN VPE32.DLL INTEGER,STRING,INTEGER
    DECLARE VpeSetFontAttr          IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER
    DECLARE VpeSetAlign             IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetBold              IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetUnderlined        IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetItalic            IN VPE32.DLL INTEGER,INTEGER
    DECLARE VpeSetTextColor         IN VPE32.DLL INTEGER,INTEGER
    DECLARE INTEGER VpePrint 	    IN VPE32.DLL INTEGER,INTEGER,INTEGER,STRING
    DECLARE INTEGER VpePrintBox     IN VPE32.DLL INTEGER,INTEGER,INTEGER,STRING
    DECLARE INTEGER VpeWrite 	    IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,STRING
    DECLARE INTEGER VpeWriteBox     IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,STRING
    DECLARE VpeDefineHeader         IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,STRING
    DECLARE VpeDefineFooter         IN VPE32.DLL INTEGER,INTEGER,INTEGER,INTEGER,INTEGER,STRING
    DECLARE VpePageBreak            IN VPE32.DLL INTEGER 
    DECLARE INTEGER VpeGetPageCount IN VPE32.DLL INTEGER 
    DECLARE INTEGER VpeGetCurrentPage IN VPE32.DLL INTEGER 
    DECLARE VpeGotoPage             IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeStoreSet             IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeUseSet               IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeRemoveSet            IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeSetAutoBreak         IN VPE32.DLL INTEGER,INTEGER 
    DECLARE VpeWriteDoc             IN VPE32.DLL INTEGER,STRING 
    DECLARE VpeReadDoc              IN VPE32.DLL INTEGER,STRING 
    DECLARE VpeSetRotation          IN VPE32.DLL INTEGER,INTEGER 
  ENDIF
RETURN  && InitVpe

FUNCTION VpeGetVersion
RETURN CallFn(VpeGetVersion)

FUNCTION VpeOpenDoc
  LPARAMETERS m.parentwindow,m.title,m.pagewidth,m.pageheight,m.flags
RETURN callfn(VpeOpenDoc, m.parentwindow, m.title, m.pagewidth,m.pageheight, m.flags)

FUNCTION VpeOpenDocFile
  LPARAMETERS m.parentwindow, m.filename, m.title,m.pagewidth,m.pageheight,m.flags
RETURN callfn(VpeOpenDocFile, m.parentwindow,m.filename,m.title,m.pagewidth,m.pageheight, m.flags)

FUNCTION VpeCloseDoc
  LPARAMETERS m.doc
RETURN callfn(VpeCloseDoc, m.doc)

FUNCTION VpeWindowHandle
  LPARAMETERS m.doc
RETURN callfn(VpeWindowHandle, m.doc)

FUNCTION VpeSetDefOutRect
  LPARAMETERS m.doc, m.rect
RETURN callfn(VpeSetDefaultOutputRect, m.doc, m.rect)

FUNCTION VpeSetDefOutRectSP
  LPARAMETERS m.doc, m.x, m.y, m.x2, m.y2
RETURN callfn(VpeSetDefaultOutputRect, m.doc, m.x, m.y, m.x2, m.y2)

FUNCTION VpeSetOutRect 
  LPARAMETERS m.doc, m.rect
RETURN callfn(VpeSetOutputRect, m.doc, m.rect)

FUNCTION VpeGetOutRect 
  LPARAMETERS m.doc RETURN callfn(VpeGetOutputRect,LC,')
  ** DOESN'T WORK
RETURN

FUNCTION VpeSetPosRect    
  LPARAMETERS m.doc, m.rect
RETURN callfn(VpeSetPosRect,m.doc, m.rect)

FUNCTION VpeGetPosRect
 LPARAMETERS m.doc
  ** DOESN'T WORK
RETURN callfn(VpeGetPosRect,LC,')

FUNCTION VpeSet 
  LPARAMETERS m.doc, m.what, m.value
RETURN callfn(VpeSet,m.doc, m.what, m.value)

FUNCTION VpeGet
  LPARAMETERS m.doc, m.what
RETURN callfn(VpeGet,m.doc, m.what)

FUNCTION VpeStorePos
  LPARAMETERS m.doc 
RETURN callfn(VpeStorePos,m.doc)

FUNCTION VpeRestorePos
  LPARAMETERS m.doc
RETURN callfn(VpeRestorePos,m.doc)

FUNCTION VpeSetScale
  LPARAMETERS m.doc, m.scale
RETURN callfn(VpeSetScale,m.doc, m.scale)

FUNCTION VpeSetRulersMeasure
  LPARAMETERS m.doc, m.measure
RETURN callfn(VpeSetRulersMeasure,m.doc, m.measure)

FUNCTION VpeSetupPrinter
  LPARAMETERS m.doc,m.fname,m.control
RETURN callfn(VpeSetupPrinter, m.doc,m.fname,m.control)

FUNCTION VpeSetPrintOptions
  LPARAMETERS m.doc,m.flags
RETURN callfn(VpeSetPrint, m.doc, m.flags)

FUNCTION VpePrintDoc
  LPARAMETERS m.doc, m.setup
RETURN callfn(VpePrintDoc,m.doc, m.setup)

FUNCTION VpeIsPrinting
  LPARAMETERS m.doc 
RETURN callfn(VpeIsPrinting,m.doc)

FUNCTION VpePreviewDoc
  LPARAMETERS m.doc, rect, m.show_hide 
RETURN callfn(VpePreviewDoc, m.doc, rect, m.show_hide)

FUNCTION VpePreviewDocSP
  LPARAMETERS m.doc, m.x, m.y, m.x2, m.y2, m.show_hide
RETURN callfn(VpePreviewDoc, m.doc, m.x, m.y, m.x2, m.y2, m.show_hide)

FUNCTION VpeCenterPreview
  LPARAMETERS m.doc, m.w, m.h, m.whandle
RETURN callfn(VpeCenterPreview, m.doc, m.w, m.h, m.whandle)

FUNCTION VpeSetUpdate
  LPARAMETERS m.doc, m.update
RETURN callfn(VpeSetUpdate,m.doc, m.update)

FUNCTION VpeRefreshDoc
  LPARAMETERS m.doc 
RETURN callfn(VpeRefreshDoc,m.doc)

FUNCTION VpeSetPen
  LPARAMETERS m.doc,m.pensize, m.penstyle, m.color
RETURN callfn(VpeSetPen,m.doc,m.pensize, m.penstyle, m.color)

FUNCTION VpeNoPen
  LPARAMETERS m.doc
RETURN callfn(VpeNoPen,m.doc)

FUNCTION VpeLine
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2
RETURN callfn(VpeLine,m.doc, m.x,m.y,m.x2,m.y2)

FUNCTION VpePolyLine
  LPARAMETERS m.doc,m.points, m.size
  ** set POINT = 0
RETURN callfn(VpePolyLine,m.doc,m.points, m.size)

FUNCTION VpeAddPolyPoint
  LPARAMETERS m.doc, m.point, m.x, m.y
RETURN callfn(VpeAddPolyPoint, m.doc, m.point, m.x, m.y)

FUNCTION VpePolygon
  LPARAMETERS m.doc,m.points, m.size
  ** set POINT = 0
RETURN callfn(VpePolygon,m.doc,m.points, m.size)

FUNCTION VpeAddPolygonPoint
  LPARAMETERS m.doc, m.point, m.x, m.y
RETURN callfn(VpeAddPolygonPoint, m.doc, m.point, m.x, m.y)

FUNCTION VpeSetBkgColor   
  LPARAMETERS m.doc, m.color 
RETURN callfn(VpeSetBkgColor,m.doc, m.color)

FUNCTION VpeSetTransparentMode
  LPARAMETERS m.doc, m.onoff 
RETURN callfn(VpeSetTransparentMode, m.doc, m.onoff)

FUNCTION VpeSetHatchStyle
  LPARAMETERS m.doc, m.style 
RETURN callfn(VpeSetHatchStyle,m.doc, m.style)

FUNCTION VpeSetHatchColor
  LPARAMETERS m.doc, m.Color 
RETURN callfn(VpeSetHatchColor,m.doc, m.color)

FUNCTION VpeBox 			
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2
RETURN callfn(VpeBox,m.doc, m.x,m.y,m.x2,m.y2)

FUNCTION VpeEllipse 			
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2
RETURN callfn(VpeEllipseBox,m.doc, m.x,m.y,m.x2,m.y2)

FUNCTION VpePie		
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2,m.begin,m.end
RETURN callfn(VpePie,m.doc, m.x,m.y,m.x2,m.y2,m.begin,m.end)

FUNCTION VpeSetBarcodeParms  
  LPARAMETERS m.doc, m.topbott, m.addtopbott
RETURN callfn(VpeSetBarcodeParms, m.doc, m.topbott, m.addtopbott)
  
FUNCTION VpeBarcode
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2,m.type, m.code, m.addcode
RETURN callfn(VpeBarcode,m.doc, m.x,m.y,m.x2,m.y2,m.type, m.code, m.addcode)

FUNCTION VpeKeepBitmapAspect 
  LPARAMETERS m.doc, m.onoff 
RETURN callfn(VpeKeepBitmapAspect,m.doc, m.onoff)

FUNCTION VpeDefaultBitmapDPI
  LPARAMETERS m.doc, m.x, m.y
RETURN callfn(VpeDefaultBitmapDPI, m.doc, m.x, m.y)

FUNCTION VpeGetPictureTypes  
  LPARAMETERS m.with_filters, m.str, m.size
RETURN callfn(VpeGetPictureTypes, m.with_filters, m.str, m.size)

FUNCTION VpePicture
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2,m.fname,m.flags
RETURN callfn(VpePicture,m.doc, m.x,m.y,m.x2,m.y2,m.fname,m.flags)

FUNCTION VpePictureDIB
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2,m.hdib,m.flags
RETURN callfn(VpePictureDIB,m.doc, m.x,m.y,m.x2,m.y2,m.hdib,m.flags)

FUNCTION VpePictureResID
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2,m.resid,m.flags
RETURN callfn(VpePictureResID,m.doc, m.x,m.y,m.x2,m.y2,m.resid,m.flags)

FUNCTION VpePictureResName
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2,m.fname,m.flags
RETURN callfn(VpePictureResName,m.doc, m.x,m.y,m.x2,m.y2,m.fname,m.flags)

FUNCTION VpeSelectFont 	 
  LPARAMETERS m.doc, m.fontname, m.size
RETURN callfn(VpeSelectFont,m.doc, m.fontname, m.size)

FUNCTION VpeSetFontAttr
  LPARAMETERS m.doc, m.alignment,mbold,m.underlined,m.italic
RETURN callfn(VpeSetFontAttr,m.doc, m.alignment,mbold,m.underlined,m.italic)

FUNCTION VpeSetAlign
  LPARAMETERS m.doc, m.alignment
RETURN callfn(VpeSetAlign,m.doc, m.alignment)

FUNCTION VpeSetBold       
  LPARAMETERS m.doc, m.bold 
RETURN callfn(VpeSetBold,m.doc, m.bold)

FUNCTION VpeSetUnderlined
  LPARAMETERS m.doc, m.underlined
RETURN callfn(VpeSetUnderlined,m.doc, m.underlined)

FUNCTION VpeSetItalic    
  LPARAMETERS m.doc, m.italic 
RETURN callfn(VpeSetItalic, m.doc, m.italic)

FUNCTION VpeSetTextColor  
  LPARAMETERS m.doc,m.color
RETURN callfn(VpeSetTextColor, m.doc,m.color)

FUNCTION VpePrint 	 	   
  LPARAMETERS m.doc, m.x,m.y, m.string
RETURN callfn(VpePrint,m.doc, m.x,m.y, m.string)

FUNCTION VpePrintBox	 	   
  LPARAMETERS m.doc, m.x,m.y, m.string
RETURN callfn(VpePrintBox,m.doc, m.x,m.y, m.string)

FUNCTION VpeWrite 
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2, m.string
RETURN callfn(VpeWrite,m.doc, m.x,m.y,m.x2,m.y2, m.string)

FUNCTION VpeWriteBox 	 
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2, m.string
RETURN callfn(VpeWriteBox,m.doc, m.x,m.y,m.x2,m.y2, m.string)

FUNCTION VpeDefineHeader  
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2, m.string
RETURN callfn(VpeDefineHeader,m.doc, m.x,m.y,m.x2,m.y2, m.string)

FUNCTION VpeDefineFooter 
  LPARAMETERS m.doc, m.x,m.y,m.x2,m.y2, m.string
RETURN callfn(VpeDefineFooter,m.doc, m.x,m.y,m.x2,m.y2, m.string)

FUNCTION VpePageBreak
  LPARAMETERS m.doc
RETURN callfn(VpePageBreak, m.doc)

FUNCTION VpeGetPageCount 
  LPARAMETERS m.doc
RETURN callfn(VpeGetPageCount, m.coc)

FUNCTION VpeGetCurrentPage
  LPARAMETERS m.doc 
RETURN callfn(VpeGetCurrentPage,m.doc)

FUNCTION VpeGotoPage
  LPARAMETERS m.doc, m.page
RETURN callfn(VpeGotoPage,m.doc,m.page)

FUNCTION VpeStoreSet
  LPARAMETERS m.doc, m.id
RETURN callfn(VpeStoreSet,m.doc, m.id)

FUNCTION VpeUseSet 
  LPARAMETERS m.doc, m.id
RETURN callfn(VpeUseSet,m.doc, m.id)

FUNCTION VpeRemoveSet 
  LPARAMETERS m.doc, m.id 
RETURN callfn(VpeRemoveSet,m.doc, m.id)

FUNCTION VpeSetAutoBreak 
  LPARAMETERS m.doc, m.flag
RETURN callfn(VpeSetAutoBreak ,m.doc, m.flag)

FUNCTION VpeWriteDoc
  LPARAMETERS m.doc, m.fname
RETURN callfn(VpeWriteDoc,m.doc, m.fname)

FUNCTION VpeReadDoc
  LPARAMETERS m.doc, m.fname
RETURN callfn(VpeReadDoc,m.doc, m.fname)

FUNCTION VpeSetRotation
  LPARAMETERS m.doc, m.angle
RETURN callfn(VpeSetRotation,m.doc, m.angle)

******************************************************************
FUNCTION Rect
  LPARAMETERS x,y,w,h
  IF 'DOS' $ OS()	&& 16bit OS
    RETURN CHR(m.x%256)+CHR(INT(m.x/256))+;
           CHR(m.y%256)+CHR(INT(m.y/256))+;
           CHR(m.w%256)+CHR(INT(m.w/256))+;
           CHR(m.h%256)+CHR(INT(m.h/256))
  ELSE			&& 32bit OS
    RETURN CHR(m.x%256)+CHR(INT(m.x/256))+CHR(0)+CHR(0)+;
           CHR(m.y%256)+CHR(INT(m.y/256))+CHR(0)+CHR(0)+;
           CHR(m.w%256)+CHR(INT(m.w/256))+CHR(0)+CHR(0)+;
           CHR(m.h%256)+CHR(INT(m.h/256))+CHR(0)+CHR(0)
  ENDIF
******************************************************************


