/*
 * runvprp.c -- CALLS the named VPT report from memory.
 */

#define  INCL_REXXSAA
//#define  INCL_RXSHV
#include <os2.h>
#include <rexxsaa.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <time.h>
#include "runvprp.h"

/*****************************************************************************
*  BOOL RunInline (PSZ progbuf, ULONG proglen)
*
*  Info: Run a rexx programm string in rexx macro space
*
*****************************************************************************/
BOOL RunInline (PSZ progbuf, ULONG proglen)
{
   char buf[256];
   RXSTRING Result, InMemRexx[2];
   APIRET rc;
   SHORT retcode;
   PSZ filename;

         /* Set storage for the Result... */

   Result.strptr = buf;
   Result.strlength = sizeof (buf);

         /*
          * Set the filename... this is informational mostly, so that a PARSE
          * SOURCE in the inline program will return something.
          */

   filename = "INLINE";

         /*
          * You pass in an array of two RXSTRINGs.  The first RXSTRING is the
          * inline program in native rexx.  RexxStart will the tokenized version of the inline program
          into the second RXSTRING. You can save
          * this tokenized version for later use - just pass the tokenized one instead of passing the native
          * inline program. The tokenized starts executing a little bit faster because it needn't be reparsed by the interpreter.
          */

   InMemRexx[0].strptr = progbuf;
   InMemRexx[0].strlength = proglen;

   InMemRexx[1].strptr = NULL;
   InMemRexx[1].strlength = 0;

   rc = RexxStart (0, NULL, filename, InMemRexx, "CMD", RXCOMMAND,
                   NULL, &retcode, &Result);

         /*
          * If you don't use the tokenized version of the program, you should
          * be sure to free it...
          */

   if (InMemRexx[1].strptr) {
      DosFreeMem (InMemRexx[1].strptr);
   }
   if (Result.strptr != buf) {
      DosFreeMem (Result.strptr);
   }
   return (rc == 0);
}

/*****************************************************************************
*  LONG SetRexxVariable (PSZ name, PSZ value)
*
*  Info: Set the value of a REXX variable
*
*****************************************************************************/
LONG SetRexxVariable (PSZ name, PSZ value)
{
   SHVBLOCK shv;                 /* variable pool control shv */

   shv.shvcode = RXSHV_SYSET;             /* do a symbolic set operation */
   shv.shvret = (UCHAR) 0;                /* clear return code field    */
   shv.shvnext = (PSHVBLOCK) 0;           /* no next shv              */
         /* set variable name string   */
   MAKERXSTRING (shv.shvname, name, strlen (name));
         /* set value string           */
   MAKERXSTRING (shv.shvvalue, value, strlen (value));
   shv.shvvaluelen = strlen (value);      /* set value length           */
   RexxVariablePool (&shv);
   return (shv.shvret);
}

/*****************************************************************************
*  LONG SetRexxStem (PSZ StemName, PSZ NameTail, PSZ Contents)
*
*  Info: Set the value of a REXX Stemvariable
*
*****************************************************************************/
LONG SetRexxStem (PSZ StemName, PSZ NameTail, PSZ Contents)
{
   CHAR VarName[256];
   int count;

   strcpy (VarName, StemName);
   if (VarName[(count = strlen (VarName)) - 1] != '.')
      VarName[count++] = '.';
   strcpy (&VarName[count], NameTail);
   strupr (VarName);                      /* uppercase the name         */
   return SetRexxVariable (VarName, Contents);
}

/*****************************************************************************
*  LONG DropRexxVariable (PSZ name)
*
*  Info: Drop a REXX variable, just as REXX drop
*
*****************************************************************************/
LONG DropRexxVariable (PSZ name)
{
   SHVBLOCK shv;
   ULONG len;
   PSZ varname;

   len = strlen (name);
   varname = alloca (len + 1);
   if (varname != NULL) {

      strcpy (varname, name);
      strupr (varname);

      shv.shvnext = NULL;
      shv.shvcode = RXSHV_DROPV;
      shv.shvname.strptr = varname;
      shv.shvname.strlength = len;
      shv.shvvalue.strptr = NULL;
      shv.shvvalue.strlength = 0;
      shv.shvvaluelen = 0;

      RexxVariablePool (&shv);
      return (shv.shvret);
   }
   return FALSE;
}

RexxFunctionHandler GetVPTData;
/*****************************************************************************
*  ULONG GetVPTData (PUCHAR funcname, ULONG numargs, PRXSTRING args, PSZ queuename, PRXSTRING result)
*
*  Info: function callable from rexx, to access native C-function
*
*****************************************************************************/
ULONG GetVPTData (PUCHAR funcname, ULONG numargs, PRXSTRING args, PSZ queuename, PRXSTRING result)
{
   BOOL ret;

         /* Get rid of compiler warnings... */

   funcname = funcname;
   queuename = queuename;

         /* Need exactly one argument... */

   if (numargs != 1)
      return (40);

   ret = GetData (args[0].strptr);

   result->strptr[0] = (ret ? '1' : '0');
   result->strlength = 1;

   return (0);
}


/*****************************************************************************
*  char *LineIn (char *psz, int len, FILE *file)
*
*  Info: Get next line from file, strip trailing newline
*
*****************************************************************************/
char *LineIn (char *psz, int len, FILE * file)
{
   if (fgets (psz, len, file) == NULL)
      *psz = '\0';
   else {
      len = strlen (psz) - 1;
      if (*(psz + len) == '\n')
         *(psz + len) = '\0';
   }
}

/*****************************************************************************
*  BOOL GetData (PSZ StemName)
*
*  Info: Dataserver function driven by StemName
*
*****************************************************************************/
BOOL GetData (PSZ StemName)
{
   char tStemName[64];
   int count;

         /*
          * create a dotted copy of StemName
          */
   strcpy (tStemName, StemName);
   if (tStemName[(count = strlen (tStemName)) - 1] != '.')
      tStemName[count++] = '.';
   tStemName[count] = '\0';
         /*
          * check for the correct StemName to get the wright data
          */
   if (!stricmp (tStemName, "SALARY.")) {
      PSZ filename = "SAMPLE.DAT";
      FILE *file;

      file = fopen (filename, "r");
      if (file != NULL) {
         CHAR aTextValue[255];
         int i;
         char VarName[64];

               /*
                * clear the rexx variable (not really needed, because the
                * varable reside only during runtime of the rexx macro )
                */
         DropRexxVariable (tStemName);
               /*
                * fill the stem with data
                */

         {                                /* get current date */
            time_t temp;
            struct tm *timeptr;

            temp = time (NULL);
            timeptr = localtime (&temp);
            strftime (aTextValue, sizeof (aTextValue) - 1, "%d. %b %Y", timeptr);
            count = aTextValue[0] == '\0' ? 1 : 0;
            SetRexxStem (tStemName, "DATE", aTextValue + count);
         }
         fgets (aTextValue, sizeof (aTextValue), file);
         count = atoi (aTextValue);
         SetRexxStem (tStemName, "0", aTextValue);
         filename = "SAMPLE.DAT";
         for (i = 0; i++ < count;) {
            sprintf (VarName, "%s%d", tStemName, i);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 1. */
            SetRexxStem (VarName, "ID", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 2. */
            SetRexxStem (VarName, "NAME", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 3. */
            SetRexxStem (VarName, "DEPT", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 4. */
            SetRexxStem (VarName, "JOB", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 5. */
            SetRexxStem (VarName, "YEARS", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 6. */
            SetRexxStem (VarName, "SALARY", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 7. */
            SetRexxStem (VarName, "COMM", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 8. */
            SetRexxStem (VarName, "DEPTNAME", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* ignore. */
            LineIn (aTextValue, sizeof (aTextValue), file); /* 9. */
            SetRexxStem (VarName, "DIVISION", aTextValue);
            LineIn (aTextValue, sizeof (aTextValue), file); /* 10. */
            SetRexxStem (VarName, "LOCATION", aTextValue);
         }                                /* end for */
         fclose (file);
         return TRUE;
      }
   } else {
      DropRexxVariable (tStemName);
            /* get data for other Reports */
   }
   return FALSE;
}

/*****************************************************************************
*  BOOL RunVPReprot (ULONG hwnd, PSZ VPTName, PSZ StemName, PSZ Option)
*
*  Info: call the VpPrintReport
*        This is done by creating a few rexx statements in memmory:
*        register the VPreport calls, call the data server, call VpPrintReport
*
*****************************************************************************/
BOOL RunVPReprot (ULONG hwnd, PSZ VPTName, PSZ StemName, PSZ Option)
{
   static char RexxCommandBuf[1024];
   char tStemName[64];
   int count;
   BOOL rc;

         /*
          * create a dotted copy of StemName
          */
   strcpy (tStemName, StemName);
   if (tStemName[(count = strlen (tStemName)) - 1] != '.')
      tStemName[count++] = '.';
   tStemName[count] = '\0';

         /*
          * create rexx statements
          */
   sprintf (RexxCommandBuf, "call RxFuncAdd 'VpReportLoadFuncs', 'VPRPTDLL', 'VpReportLoadFuncs';\r\n\
                             call VpReportLoadFuncs;\r\n\
                             call GetVPTData '%s'\r\n\
                             call VpPrintReport %lu, '%s', '%s', '%s';\r\n",
            tStemName, hwnd, VPTName, tStemName, Option);

         /*
          * register the data server
          */
   RexxRegisterFunctionExe ("GETVPTDATA", (PFN) GetVPTData);
         /*
          * run the rexx programm in memmory
          */
   rc = RunInline (RexxCommandBuf, strlen (RexxCommandBuf));
         /*
          * deregister the data server
          */
   RexxDeregisterFunction ("GETVPTDATA");
   return rc;
}
