//Action CPP (C) Freeware 1994 by Marty A. Lineberry
//

#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#include <graphics.h>
#include <string.h>
#include <dos.h>
#include <stdio.h>
#include <bios.h>
#include <ctype.h>
#include <time.h>
#include <math.h>
#include <io.h>

#define REBOOTINIT 0x19

#define	KEYBOARD_INTERRUPT 0x16

#define LEFT 19200
#define SPACEBAR 14624
#define ESC 283
#define UP 18432
#define DOWN 20480
#define LEFT 19200
#define RIGHT 19712
#define TAB 3849
#define ENTER 7181
#define F1 15104
#define F2 15360
#define F3 15616
#define F4 15872
#define F5 16128
#define F6 16384
#define F7 16640
#define F8 16896
#define F9 17152
#define F10 17408
#define PAGE_UP 18688
#define PAGE_DOWN 20736
#define HOME 18176
#define END 20224
#define DELETE 21248
#define INSERT 20992
#define RIGHT_SHIFT  0x01
#define LEFT_SHIFT   0x02
#define CTRL   0x04
#define ALT    0x08

#define TRUE 1
#define FALSE 0

#define OR ||
#define AND &&

#define END_IF

#define	RESETMOUSE 0x0000
#define MOUSE_INTERRUPT 0x33
#define SHOWMOUSE 0x01
#define HIDEMOUSE 0x02
#define MOUSEPOSITION 0x03
#define MOVEMOUSE 0x04
#define BUTTON_XY 0x05
#define BUTTONRELEASE 0x06
#define MOUSELIMITX 0x07
#define MOUSELIMITY 0x08
#define CURSORSHAPE 0x09
#define HIDEMOUSEXY 0x10
#define MOUSEMOTION 0x0B
#define SETMOUSESENSITIVITY 0x1A
#define GETMOUSESENSITIVITY 0x1B


#define JOYSTICK_RESET 0x8400
#define JOYSTICK_INTERRUPT 0x15
#define JOYSTICKBUTTONS 0
#define BOOL(x) (!(!(x)))
#define JOYSTICK_XY 1

//********************************************************************
//****************** Function prototypes. ****************************
//********************************************************************

//Keyboard Functions
void flush_buffer();  //Flushes Keyboard of any a-waiting characters
int key();           //Returns CTRL ALT SHIFT Keypress's
int C_Break(void);   //Goes here if Ctrl+Break pressed
int Key_Press(char *); //Returns Keypress's and character

//Pause till any keypress
//if t_f is TRUE prints       Pause Press a key
//if t_f is FALSE just waits till keypress
void Pause(int t_f);


//Misc Functions
void Basic_Sound(int freq,int pause); //Sounds a frequency for delay(pause)
void Reboot(void);  //Reboots computer
void Type_Writer(char string[]); //use Type_Writer("Hello");See function.
char ascii(int num);//changes Ascii number to character
void Slow_Down(int pause);
int printXY(int column,int row,char string[],int Variable);//to moniter variables while a program is running

//Graphics Functions
void InitGraphics(int VIDEOMODE);//Initialize graphics to graphics mode. See function
void DrawBox(int X,int Y,int width,int height,int color,int fillsw);//see function

//Mouse Functions
int Detect_Mouse(void); //Checks to see if mouse is present and sets MousePresent to TRUE or FALSE
int Number_Of_Buttons(void); //Returns number of mouse buttons available.
void Move_Mouse(int Mouse_X,int Mouse_Y);//Moves mouse to new X,Y position.
void Display_Mouse(void);//Shows Mouse cursor
void Hide_Mouse(void);//Hides Mouse cursor
void Mouse_Position(int *Mouse_X,int *Mouse_Y);//Returns current mouse X,Y position
int Mouse_Held(void);//Checks to see if any mouse buttons held down
void Vert_Mouse_Limit(int Mouse_Y_Min,int Mouse_Y_Max); //Sets Mouse Y limits of movement
void Horiz_Mouse_Limit(int Mouse_X_Min,int Mouse_X_Max);//Sets Mouse X limits of movement
int Button_XY(int *Mouse_X,int *Mouse_Y,int Button_Check);
void Hide_Mouse_XY(int left_X,int right_X,int top_Y,int bottom_Y);//See function.
void Mouse_Sens(int Speed_X,int Speed_Y,int threshold);
void Mouse_Motion(int *Mickeys_X,int *Mickeys_Y);
void near Cursor_Shape(int X_Hot_Spot,int Y_Hot_Spot,int cursor_select);//See function.

//Joystick Functions
//returns buttons pressed and variables the X,Y
int JoyStick_Switches(int *switch_0,int *switch_1,int *switch_2,int *switch_3);
int JoyStick_XY(int *A_X,int *A_Y,int *B_X,int *B_Y);



//*********************************************************
//************ Global Variables ***************************
//*********************************************************
REGS InRegister;
REGS OutRegister;
struct SREGS segregs;

int MousePresent = FALSE;
int JoyStickPresent = FALSE;
int Max_X; //Holds Maximum Screen Size for graphics mode chosen
int Max_Y; //with initgraph()

unsigned short near *cursor[32];    /*  Array to Contain Cursor    */


unsigned short Hand_Cursor[32] =
{

	    0xE1FF, 0xE1FF, 0xE1FF, 0xE1FF,
	    0xE1FF, 0xE000, 0xE000, 0xE000,
	    0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000,

	   /*  Define cursor mask  */

	    0x1E00, 0x1200, 0x1200, 0x1200,
	    0x1200, 0x13FF, 0x1249, 0x1249,
	    0xF249, 0x9001, 0x9001, 0x9001,
	    0x8001, 0x8001, 0x8001, 0xFFFF
};






///////////////////////////////////////////////////////////////////////////
//************************************************************************* 
//*************************************************************************  
//********************** Misc Routines ************************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////

//*********************************************************
//* Used to Moniter a variable while a program is running *
//* for test purposes only                                *
//*********************************************************
int printXY(int column,int row,char string[],int Variable)
{
int x,y;
int temp2=0;
x = wherex();
y = wherey();
_setcursortype(_NOCURSOR);
gotoxy(column,row);
cout << "                                               ";
gotoxy(column,row);
while(string[temp2] != NULL)  //Process string passed till reaches end
	{
	cout << string[temp2];
	temp2++;
	}
cout << Variable;
gotoxy(x,y);
_setcursortype(_NORMALCURSOR);
return 0;
}


//*********************************************************
//*********** Prints out 1 character at a time ************
//*********************************************************
void Type_Writer(char string[])
{
//temp counters
int temp = 0;
int temp2 = 0;

_setcursortype(_SOLIDCURSOR); //Turns on Block cursor
Hide_Mouse(); //Hide's Mouse
while(string[temp] != NULL)  //Process string passed till reaches end
	{
	Slow_Down(190);
	//Makes sound for everything except spaces
	if(string[temp] != ' ')
		{
		sound(150);
		Slow_Down(10);
		nosound();
		}
	//Prints out character
	cout << string[temp];
	//Goes to next char in string by adding 1
	temp++;
	//Just incase string is over screen width it prints new line
	//and sounds carriage return
	if(temp == 79)
		{
		for(temp2=0;temp2<20;temp2++)
			{
			Basic_Sound(temp2*10,12);
			}
		 cout << "\n";
		Basic_Sound(700,70);
		}

	}
	//Sound for carriage return
	for(temp2=0;temp2<20;temp2++)
		{
		Basic_Sound(temp2*10,12);
		}
	cout << "\n";
	Basic_Sound(700,70);
//Turns cursor off
_setcursortype(_NOCURSOR);
//Re-displays Mouse
Display_Mouse();
return;
}

//**********************************************************
//**************** Sound Function **************************
//**********************************************************
void Basic_Sound(int freq,int pause)
{
nosound();
sound(freq);
Slow_Down(pause);
nosound();
}

//*********************************************************
//************* Reboots Computer **************************
//*********************************************************
void Reboot(void)
{
if(getvect(REBOOTINIT))  //Checks for error
	{
	int86(REBOOTINIT,0,0);
	}
return;
}



///////////////////////////////////////////////////////////////////////////
//*************************************************************************
//*************************************************************************
//********************** Joystick Routines ********************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////

//******************************************************
//********* JoyStick Function XY ***********************
//******************************************************
int JoyStick_XY(int *A_X,int *A_Y,int *B_X,int *B_Y)
{
InRegister.x.ax = JOYSTICK_RESET;
InRegister.x.dx = JOYSTICK_XY;
int86(JOYSTICK_INTERRUPT, &InRegister, &OutRegister);
if (OutRegister.x.cflag)
	{
	return FALSE;
	}
*A_X = OutRegister.x.ax;
*A_Y = OutRegister.x.bx;
*B_X = OutRegister.x.cx;
*B_Y = OutRegister.x.dx;
return TRUE;
}

//******************************************************
//********* JoyStick Function Buttons ******************
//******************************************************
int JoyStick_Switches(int *switch_0,int *switch_1,int *switch_2,int *switch_3)
{
InRegister.x.ax = JOYSTICK_RESET;
InRegister.x.dx = JOYSTICKBUTTONS;
int86(JOYSTICK_INTERRUPT, &InRegister, &OutRegister);
if (OutRegister.x.cflag)
	{
	 return FALSE;
	}
*switch_0 = BOOL(OutRegister.h.al & 0x10);
*switch_1 = BOOL(OutRegister.h.al & 0x20);
*switch_2 = BOOL(OutRegister.h.al & 0x40);
*switch_3 = BOOL(OutRegister.h.al & 0x80);
return TRUE;
}




///////////////////////////////////////////////////////////////////////////
//*************************************************************************
//*************************************************************************
//********************** Keyboard Routines ********************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////


//********************************************************************
//*********************** Test for Keyboard Events *******************
//********************************************************************
int Key_Press(char *char_ch)
{
int Key_Pressed = bioskey(1);

if(Key_Pressed) Key_Pressed = bioskey(0);
   *char_ch = ascii(Key_Pressed);    //char_1;
   return Key_Pressed;
}





//*******************************************************************
//*********** Converts an ascii number to character *****************
//*******************************************************************
char ascii(int num)
{
char asc_char;
asc_char = (char)num;
return (asc_char);
}

//*****************************************************************
//Routine to pause until a key is pressed and then to clear buffer
//******************************************************************
void Pause(int t_f)
{
int temp;
if(t_f == TRUE)
	{
	cout << "\nPause Press a Key\n";
	}
while(!kbhit()); //Waits for Key Press
flush_buffer(); //Clears buffer of any Key Pressed including arrow keys
return;
}


//******************************************
//** Processes Control Break ***************
//******************************************
int C_Break(void)
{
cout << "Ctrl Break Pressed.....Program aborted";
return FALSE; //FALSE ENDS The Program
}


//********************************************
//**** Gets Ctrl,Alt,& Shift Key Status ******
//********************************************
int key()
{
InRegister.x.ax =  0x0200;   //Reads Flags
if(getvect(KEYBOARD_INTERRUPT)) //Checks for error
 {
	int86(KEYBOARD_INTERRUPT,&InRegister,&OutRegister);
	if (OutRegister.x.ax & RIGHT_SHIFT) return  RIGHT_SHIFT;
	if (OutRegister.x.ax & LEFT_SHIFT)  return  LEFT_SHIFT;
	if (OutRegister.x.ax & CTRL)  return  CTRL;
	if (OutRegister.x.ax & ALT)   return  ALT;

	return OutRegister.x.ax;
 }
return FALSE;
}



//**********************************************************
//********** Flushes Keyboard buffer ***********************
//**********************************************************
void flush_buffer(void)
{
while(kbhit())
	{
	getch();
	}
return;
}


//**********************************************************
//**************** Slow Down Function **********************
//**********************************************************
void Slow_Down(int pause)
{
//if(pause <= 0) pause = 1;
delay(pause);
return;
}







///////////////////////////////////////////////////////////////////////////
//*************************************************************************
//*************************************************************************
//********************** Graphics Routines ********************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////



//******************************************************************
//********* Sets up Graphics mode for Mode you choose **************
//******************************************************************
void InitGraphics(int VIDEOMODE)
{
int gdriver,gmode,errorcode;

switch(VIDEOMODE)
	{
     case 1:  gdriver = CGA, gmode = CGAHI; break;
     case 2:  gdriver = EGA, gmode = EGAHI; break;
     case 3:  gdriver = EGA, gmode = EGALO; break;
     case 4:  gdriver = EGA64, gmode = EGALO;break;
     case 5:  gdriver = EGA64, gmode = EGAHI;break;
     case 6:  gdriver = VGA, gmode = VGALO; break;
     case 7:  gdriver = VGA, gmode = VGAMED; break;
     case 8:  gdriver = IBM8514, gmode = IBM8514LO; break;
     case 9:  gdriver = VGA, gmode = VGAHI; break;
     default:
	 detectgraph(&gdriver, &gmode);
	 break;
	}

   initgraph(&gdriver, &gmode, "");
   if ( (errorcode = graphresult()) != grOk)
   {
      cout << "Graphics error: " << errorcode << '\n';
      Pause(TRUE);
      abort();
   }
cleardevice();
Max_X = getmaxx();
Max_Y = getmaxy();
return;
}



//******************************************************************
//********************** Draws a Box *******************************
//******************************************************************
// X     -> upper left horiz corner of box
// Y     -> upper left vert  corner of box
//width  -> width of box starting from X to the right
//height -> height of box starting from Y down
//color well is color ...it restores color before leaving
//fillsw ->  1 Draws a filled box using indiviual pixels
//           0 Draws a empty box
//           3 Draws a filled box using floodfill()
//NOTE...-> There are other ways to draw a filled box, but
//this is easier to understand. Basically less different
//graphics calls.
void DrawBox(int X,int Y,int width,int height,int color,int fillsw)
{
int Local_X;
int Local_Y;
int Local_Width = X + width;
int Local_Height = Y + height;
int oldcolor = getcolor();
Hide_Mouse();
   if(fillsw == TRUE)
    {
	for(Local_Y = Y;Local_Y < Local_Height; Local_Y++)
	  {
	       for(Local_X = X;Local_X < Local_Width;Local_X++)
		{
		putpixel(Local_X,Local_Y,color);
		}
	   }
     }
    else if(fillsw == FALSE)
     {
	setcolor(color);
	line(X,Y,X+width,Y);
	line(X+width,Y,X+width,Y+height);
	line(X+width,Y+height,X,Y+height);
	line(X,Y+height,X,Y);
	setcolor(oldcolor);
     }
    else if(fillsw == 3)
     {
	setcolor(color);
	line(X,Y,X+width,Y);
	line(X+width,Y,X+width,Y+height);
	line(X+width,Y+height,X,Y+height);
	line(X,Y+height,X,Y);
	setfillstyle(SOLID_FILL,color);
	floodfill(X+(width/2),Y+(height/2),color);
	setcolor(oldcolor);
     }

Display_Mouse();
return;
}



///////////////////////////////////////////////////////////////////////////
//*************************************************************************
//*************************************************************************
//********************** Mouse Routines ***********************************
//*************************************************************************
//*************************************************************************
///////////////////////////////////////////////////////////////////////////


//***********************************************************
//********** Determine's rather a mouse is present **********
//***********************************************************
int Detect_Mouse(void)
{
//Check to see if an interrupt is ready
if(getvect(MOUSE_INTERRUPT))
	{
	InRegister.x.ax = RESETMOUSE;  //assigns 0x0000 to variable
				       //in ax register
	//Turns on mouse and gets info
	//sends reset into Register ax
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);


	if(OutRegister.x.ax != FALSE)            //Mouse     present = -1
		{                                 //Mouse not present = 0
		MousePresent = TRUE;
		return TRUE;
		}
	else
		{
		cout << "MOUSE NOT INSTALLED";
		Pause(TRUE);
		return FALSE;
		}

	}
else
	{
	cout << "No Mouse Present";
	Pause(TRUE);
	}
return FALSE;
}


//***********************************************************
//*********** Cursor Shape Change ***************************
//***********************************************************
void near Cursor_Shape(int X_Hot_Spot,int Y_Hot_Spot,int cursor_select)
{
//unsigned short cursor [32];    /*  Array to Contain Cursor    */
if(MousePresent == TRUE)
{


 switch(cursor_select)
 {
	 //define screen mask
	case 1: //Hand
	    memcpy(*cursor,Hand_Cursor,32);
	case 2: //Hourglass
	    //define screen mask
	    *cursor [0]  =0xC007;
	    *cursor [1]  =0xC007;
	    *cursor [2]  =0xC007;
	    *cursor [3]  =0xE00F;
	    *cursor [4]  =0xE00F;
	    *cursor [5]  =0xF01F;
	    *cursor [6]  =0xF83F;
	    *cursor [7]  =0xFC7F;
	    *cursor [8]  =0xFC7F;
	    *cursor [9]  =0xF83F;
	    *cursor [10] =0xF01F;
	    *cursor [11] =0xE00F;
	    *cursor [12] =0xE00F;
	    *cursor [13] =0xC007;
	    *cursor [14] =0xC007;
	    *cursor [15] =0xC007;

	    /*  Define *cursor mask  */

	    *cursor [16] = 0x0000;
	    *cursor [17] = 0x1FF0;
	    *cursor [18] = 0x0000;
	    *cursor [19] = 0x0FF0;
	    *cursor [20] = 0x09A0;
	    *cursor [21] = 0x0440;
	    *cursor [22] = 0x0280;
	    *cursor [23] = 0x0100;
	    *cursor [24] = 0x0100;
	    *cursor [25] = 0x0280;
	    *cursor [26] = 0x07C0;
	    *cursor [27] = 0x0C60;
	    *cursor [28] = 0x0820;
	    *cursor [29] = 0x0000;
	    *cursor [30] = 0x1FF0;
	    *cursor [31] = 0x0000;
	    break;




	case 3: //Hollow Arrow
	    //define screen mask
	    *cursor [0]  =0xE7FF;
	    *cursor [1]  =0xE3FF;
	    *cursor [2]  =0xE1FF;
	    *cursor [3]  =0xE0FF;
	    *cursor [4]  =0xE07F;
	    *cursor [5]  =0xE03F;
	    *cursor [6]  =0xE01F;
	    *cursor [7]  =0xE00F;
	    *cursor [8]  =0xE007;
	    *cursor [9]  =0xE003;
	    *cursor [10] =0xE001;
	    *cursor [11] =0xE01F;
	    *cursor [12] =0xE21F;
	    *cursor [13] =0xFF0F;
	    *cursor [14] =0xFF0F;
	    *cursor [15] =0xFF8F;

	    /*  Define *cursor mask  */

	    *cursor [16] = 0x1800;
	    *cursor [17] = 0x1400;
	    *cursor [18] = 0x1200;
	    *cursor [19] = 0x1100;
	    *cursor [20] = 0x1080;
	    *cursor [21] = 0x1040;
	    *cursor [22] = 0x1020;
	    *cursor [23] = 0x1020;
	    *cursor [24] = 0x1008;
	    *cursor [25] = 0x1004;
	    *cursor [26] = 0x103E;
	    *cursor [27] = 0x1320;
	    *cursor [28] = 0x1D20;
	    *cursor [29] = 0x0090;
	    *cursor [30] = 0x0090;
	    *cursor [31] = 0x0070;
	    break;




	case 4:  //Space Ship
	    //define screen mask
	    *cursor [0]  =0xFE7F;
	    *cursor [1]  =0xFE7F;
	    *cursor [2]  =0xFCEF;
	    *cursor [3]  =0xFC3F;
	    *cursor [4]  =0xF81F;
	    *cursor [5]  =0xF81F;
	    *cursor [6]  =0xF00F;
	    *cursor [7]  =0xF00F;
	    *cursor [8]  =0xE007;
	    *cursor [9]  =0xE007;
	    *cursor [10] =0xC003;
	    *cursor [11] =0xC003;
	    *cursor [12] =0x8001;
	    *cursor [13] =0x8001;
	    *cursor [14] =0x0E70;
	    *cursor [15] =0x8C31;

	    /*  Define *cursor mask  */
	    *cursor [16] = 0x0180;
	    *cursor [17] = 0x0180;
	    *cursor [18] = 0x03C0;
	    *cursor [19] = 0x03C0;
	    *cursor [20] = 0x07E0;
	    *cursor [21] = 0x07E0;
	    *cursor [22] = 0x0FF0;
	    *cursor [23] = 0x0FF0;
	    *cursor [24] = 0x1FF8;
	    *cursor [25] = 0x1FF8;
	    *cursor [26] = 0x3FFC;
	    *cursor [27] = 0x3FFC;
	    *cursor [28] = 0x7FFE;
	    *cursor [29] = 0x7FFE;
	    *cursor [30] = 0xF18F;
	    *cursor [31] = 0x73CE;
	    break;



       default:return;


  }
    /*   Function 9:  Set Graphics Cursor Block  */
    InRegister.x.ax = CURSORSHAPE;
    InRegister.x.bx = X_Hot_Spot;
    InRegister.x.cx = Y_Hot_Spot;
    InRegister.x.dx = (unsigned short)*cursor;
    segread(&segregs);
    segregs.es = segregs.ds;
    int86x (MOUSE_INTERRUPT, &InRegister, &OutRegister, &segregs);
    segread(&segregs);
}
return;
}


//****************************************************
//******** Set's Mouse's Sensitivity *****************
//****************************************************
void Mouse_Sens(int Speed_X,int Speed_Y,int threshold)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = SETMOUSESENSITIVITY;
InRegister.x.bx = Speed_X;
InRegister.x.cx = Speed_Y;
InRegister.x.dx = threshold;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	}
return;
}



//****************************************************
//******** Get's Mouse's Sensitivity *****************
//****************************************************
void Mouse_Sens(int *Speed_X,int *Speed_Y,int *threshold)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = GETMOUSESENSITIVITY;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	*Speed_X = OutRegister.x.bx;
	*Speed_Y = OutRegister.x.cx;
	*threshold = OutRegister.x.dx;
	}
return;
}


//****************************************************
//******** Mouse Movement since last Call ************
//****************************************************
void Mouse_Motion(int *Mickeys_X,int *Mickeys_Y)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = MOUSEMOTION;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	*Mickeys_X = OutRegister.x.cx;
	*Mickeys_Y = OutRegister.x.dx;
	}
return;
}

//**********************************************************
//**** Hide's mouse in a particular section of screen      *
//**** This will turn off Mouse Display                    *
//**** & won't turn it back on so use Display_Mouse        *
//**** It's better to just test the mouse X,Y so that      *
//**** when it's in a region you can just use Hide_Mouse() *
//**********************************************************
void Hide_Mouse_XY(int left_X,int right_X,int top_Y,int bottom_Y)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = HIDEMOUSEXY;
InRegister.x.cx = left_X;
InRegister.x.si = right_X;
InRegister.x.dx = top_Y;
InRegister.x.di = bottom_Y;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	}
return;
}


//******************************************************
//******* Moves Mouse to New Position ******************
//******************************************************
void Move_Mouse(int Mouse_X,int Mouse_Y)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = MOVEMOUSE;
InRegister.x.cx = Mouse_X;
InRegister.x.dx = Mouse_Y;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	}
return;
}


//****************************************************
//***** Sets Mouse Horiz min and max movement ********
//****************************************************

void Horiz_Mouse_Limit(int Mouse_X_Min,int Mouse_X_Max)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = MOUSELIMITX;
InRegister.x.cx = Mouse_X_Min;
InRegister.x.dx = Mouse_X_Max;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	}
return;
}


//****************************************************
//***** Returns Mouse X & Y at Button Press   ********
//****************************************************

int Button_XY(int *Mouse_X,int *Mouse_Y,int Button_Check)
{
if(MousePresent == FALSE)return 0;
InRegister.x.ax = BUTTON_XY;
InRegister.x.bx = Button_Check;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	*Mouse_X = OutRegister.x.cx;
	*Mouse_Y = OutRegister.x.dx;
	}
return OutRegister.x.ax;
;
}





//****************************************************
//***** Sets Mouse Vert min and max movement ********
//****************************************************

void Vert_Mouse_Limit(int Mouse_Y_Min,int Mouse_Y_Max)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = MOUSELIMITY;
InRegister.x.cx = Mouse_Y_Min;
InRegister.x.dx = Mouse_Y_Max;

if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	}
return;
}


//****************************************************
//***** Returns the mouse X and Y position   *********
//****************************************************
void Mouse_Position(int *Mouse_X,int *Mouse_Y)
{
if(MousePresent == FALSE)return;
InRegister.x.ax = MOUSEPOSITION;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	*Mouse_X = OutRegister.x.cx;
	*Mouse_Y = OutRegister.x.dx;
	}

return;
}



//****************************************************
//***** Returns the mouse button held down ************
//****************************************************
int Mouse_Held(void)
{
if(MousePresent == FALSE)return FALSE;
InRegister.x.ax = MOUSEPOSITION;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	return OutRegister.x.bx;
	}

return FALSE;
}







//***********************************************************
//********** Determine's rather a mouse is present **********
//********** & the number of buttons on mouse      **********
//***********************************************************
int Number_Of_Buttons(void)
{
if(MousePresent == FALSE)return FALSE;
//Check to see if an interrupt is ready
if(getvect(MOUSE_INTERRUPT))
	{
	InRegister.x.ax = RESETMOUSE;  //assigns 0x0000 to variable
				       //in ax register
	//Turns on mouse and gets info
	//sends reset into Register ax
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	return OutRegister.x.bx;
	}
return FALSE;
}


//*********************************************************
//********** Displays Mouse cursor arrow on screen ********
//*********************************************************
void Display_Mouse()
{
if(MousePresent == FALSE)return;
InRegister.x.ax = SHOWMOUSE;
if(getvect(MOUSE_INTERRUPT))
		{
		int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
		}
return;
}


//*************************************************************
//************* Hides mouse cursor ****************************
//*************************************************************
void Hide_Mouse()
{
if(MousePresent == FALSE)return;
InRegister.x.ax = HIDEMOUSE;
if(getvect(MOUSE_INTERRUPT))
	{
	int86(MOUSE_INTERRUPT,&InRegister,&OutRegister);
	}
return;
}



