**********************************************************************
* Getexpir.prg                               FoxPro for Windows 2.6
* Demonstrate functions to allow next century input
**********************************************************************
* Default Expiration Date
ld_expirdt = {1/1/2010}
lc_expirdt = l_date2str4( ld_expirdt )  && lc_expirdt is "01012010"

* The picture and valid for the character get variable
@ 20,10 GET lc_expirdt PICTURE '@R 99/99/9999' VALID v_str4date( lc_expirdt )
READ

* Convert the string date back into a real date
ld_expirdt = l_str2date4(lc_expirdt)

lc_temp = DTOS(ld_expirdt)
lc_date = SUBSTR(lc_temp,5,2) + '/' + SUBSTR(lc_temp,7,2) + '/' + LEFT(lc_temp,4)
WAIT WINDOW "You entered " + lc_date NOWAIT  

RETURN

**********************************************************************
* FUNCTION l_date2str4
* Converts a date into an 8 character date string with no "//"
**********************************************************************
FUNCTION l_date2str4
PARAMETERS pd_date
PRIVATE lc_return, lc_temp
lc_temp = DTOS(pd_date)
lc_return = SUBSTR(lc_temp,5,2) + SUBSTR(lc_temp,7,2) + LEFT(lc_temp,4)
RETURN lc_return


*  **********************************************************************
*  * FUNCTION l_date2str4
*  * Converts a date into an 8 character date string with no "//"
*  **********************************************************************
*  FUNCTION l_date2str4
*  PARAMETERS pd_date
*  PRIVATE lc_return, lc_century
*  * Save current Century setting.  Later, we can turn CENTURY ON
*  * permanently.
*  lc_century = SYS(2001,"CENTURY")
*  SET CENTURY ON
*  * Note: strtran pulls out the "/" characters. ie {3/4/96}=>"03041996"
*  lc_return = STRTRAN( DTOC(pd_date),"/","" )
*  SET CENTURY &lc_century.
*  RETURN lc_return


**********************************************************************
* FUNCTION v_str4date
* Validates date input into a strdate character variable.
**********************************************************************
FUNCTION v_str4date
PARAMETER pc_datestr
PRIVATE ll_return
* Check to make sure there are 8 characters to work with and
* the 8 characters represent a real date.
ll_return = LEN(ALLTRIM(pc_datestr))=8 .and. ;
  MONTH( CTOD( LEFT(pc_datestr,2) + "/" +;
  SUBSTR(pc_datestr,3,2) + "/" + ;
  RIGHT(pc_datestr,4) ) ) <> 0
RETURN (ll_return)

**********************************************************************
* FUNCTION l_str2date4
* Converts the 8 character date string back into a real date.
**********************************************************************
FUNCTION l_str2date4
PARAMETERS pc_datestr
PRIVATE ld_return
ld_return = CTOD( LEFT(pc_datestr,2) + "/" + ;
  SUBSTR(pc_datestr,3,2) + "/" + ;
  RIGHT(pc_datestr,4)) 
RETURN ld_return
