#include "stdafx.h"
#include "GameFrame.h"

#include "Game.h"
#include "Error.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(CGameFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CGameFrame)
	ON_WM_SYSCOMMAND()
	ON_WM_ACTIVATEAPP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//-----------------------------------------------------------------------------
// default constructor
//-----------------------------------------------------------------------------
CGameFrame::CGameFrame()
{
  // Initialize variables
  m_bUseEmulation = FALSE;

  m_pDD = NULL;
  m_pFrontBuffer = NULL;
  m_pBackBuffer = NULL;
  m_pGamePalette = NULL;

  CString className = AfxRegisterWndClass(
                        CS_NOCLOSE, // Windows class styles
                        NULL,       // No cursor
                        HBRUSH(::GetStockObject(BLACK_BRUSH)),  // Black background
                        AfxGetApp()->LoadIcon(IDR_MAINFRAME));  

  // create actual window
  #ifdef _DEBUG
    // create actual window
    CreateEx( 
      0,
      className, 
      GetWindowTitle(), 
      WS_OVERLAPPEDWINDOW,
      0,0, 
      100,100,
      NULL,
      NULL );
  #else
    // create actual window
    CreateEx( 
      WS_EX_TOPMOST,
      className, 
      GetWindowTitle(), 
      WS_POPUP | WS_SYSMENU,
      0,0, 
      GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
      NULL,
      NULL );
  #endif
}

//-----------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------
CGameFrame::~CGameFrame()
{
}

//-----------------------------------------------------------------------------
// GetWindowTitle
//-----------------------------------------------------------------------------
CString CGameFrame::GetWindowTitle()
{
  return "Game";
}

//-----------------------------------------------------------------------------
// InitGraphics
//-----------------------------------------------------------------------------
BOOL CGameFrame::InitGraphics()
{
  HRESULT ddrval;

  if( m_bUseEmulation )
    ddrval = DirectDrawCreate((GUID*)DDCREATE_EMULATIONONLY, &m_pDD, NULL);
  else
    ddrval = DirectDrawCreate(NULL, &m_pDD, NULL);
  if (ddrval != DD_OK)
  {
    DDrawError("DirectDrawCreate failed:", ddrval);
    return FALSE;
  }

  ddrval = m_pDD->SetCooperativeLevel(m_hWnd, DDSCL_ALLOWREBOOT |
                                              DDSCL_EXCLUSIVE | 
                                              DDSCL_FULLSCREEN );
  if (ddrval != DD_OK)
  {
    DDrawError("SetCooperativeLevel failed:", ddrval);
    return FALSE;
  }

  ddrval = m_pDD->SetDisplayMode(((CGameApp*)AfxGetApp())->m_displayWidth, 
                                 ((CGameApp*)AfxGetApp())->m_displayHeight, 
                                 8);
  if (ddrval != DD_OK)
  {
    DDrawError("SetDisplayMode failed:", ddrval);
    return FALSE;
  }

  // Create flipping surface
  DDSURFACEDESC ddsd;
  ddsd.dwSize = sizeof(DDSURFACEDESC);
  ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
  ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                        DDSCAPS_FLIP |
                        DDSCAPS_COMPLEX;
  ddsd.dwBackBufferCount = 1;
  ddrval = m_pDD->CreateSurface(&ddsd, &m_pFrontBuffer, NULL);
  if (ddrval != DD_OK)
  {
    DDrawError("CreateSurface failed:", ddrval);
    return FALSE;
  }

  // get a pointer to the back buffer
  DDSCAPS ddscaps;
  ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
  ddrval = m_pFrontBuffer->GetAttachedSurface(&ddscaps, &m_pBackBuffer);
  if (ddrval != DD_OK)
  {
    DDrawError("GetAttachedSurface failed:", ddrval);
    return FALSE;
  }

  InitPalette();

  return TRUE;
}

//-----------------------------------------------------------------------------
// InitPalette
//-----------------------------------------------------------------------------
BOOL CGameFrame::InitPalette()
{
  return TRUE;
}

//-----------------------------------------------------------------------------
// KillGraphics
//-----------------------------------------------------------------------------
void CGameFrame::KillGraphics()
{
  // Get rid of DirectDraw objects
  if (m_pFrontBuffer != NULL)
    m_pFrontBuffer->Release();

  if (m_pGamePalette != NULL)
    m_pGamePalette->Release();

  if (m_pDD != NULL)
    m_pDD->Release();
}

//-----------------------------------------------------------------------------
// RestoreSurfaces
//-----------------------------------------------------------------------------
BOOL CGameFrame::RestoreSurfaces()
{
  HRESULT ddrval;

  if (m_pFrontBuffer != NULL && m_pFrontBuffer->IsLost() != DD_OK)
  {
    ddrval = m_pFrontBuffer->Restore();
    if (ddrval != DD_OK)
    {
      DDrawError("m_pFrontBuffer Restore failed:", ddrval);
      return FALSE;
    }

    if (m_pGamePalette != NULL)
      m_pFrontBuffer->SetPalette(m_pGamePalette);
  }

  return TRUE;
}

//-----------------------------------------------------------------------------
// UpdateGame
//-----------------------------------------------------------------------------
BOOL CGameFrame::UpdateGame()
{
  return TRUE;
}

//*****************************************************************************
// Message Handlers
//*****************************************************************************

//-----------------------------------------------------------------------------
// OnSysCommand
//-----------------------------------------------------------------------------
void CGameFrame::OnSysCommand(UINT nID, LPARAM lParam) 
{
  if (nID != SC_KEYMENU)
  {
  	CFrameWnd::OnSysCommand(nID, lParam);
  }
}

//-----------------------------------------------------------------------------
// OnActivateApp
//-----------------------------------------------------------------------------
void CGameFrame::OnActivateApp(BOOL bActive, HTASK hTask) 
{
	CFrameWnd::OnActivateApp(bActive, hTask);

	if (bActive)
    ((CGameApp*)AfxGetApp())->StartPlay();
  else
    ((CGameApp*)AfxGetApp())->StopPlay();
}

//*****************************************************************************
// Diagnostics
//*****************************************************************************

#ifdef _DEBUG
void CGameFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CGameFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG
