'*********************************************************************
' Public Sub SpinNumeric(ctl As Control, intIncrement As Integer, _
'    intMin As Integer, intMax As Integer)
'
' ctl - The control to spin
' intIncrement - The increment to use
' intMin - The minimum value to allow
' intMax - The maximum value to allow
'*********************************************************************'
Public Sub SpinNumeric(ctl As Control, intIncrement As Integer, _
  intMin As Integer, intMax As Integer)
On Error GoTo Err_SpinNumeric

   If (ctl + intIncrement) >= intMin Then    ' Check Min
     If (ctl + intIncrement) <= intMax Then  ' Check Max
       ctl = ctl + intIncrement              ' Spin it
       DoEvents
       Exit Sub
     End If
   End If

   DoCmd.Beep  ' Out of range
   Exit Sub

Exit_SpinNumeric:
   Exit Sub

Err_SpinNumeric:
   MsgBox Err.Description
   Resume Exit_SpinNumeric

End Sub

'*********************************************************************
' Public Sub SpinDate(ctl As Control, strInterval As String, _
'   intIncrement As Integer)
'
' ctl - The control to spin
' strInterval - The DateAdd interval to use
' intIncrement - The number of intervals to increment by
'*********************************************************************'
Public Sub SpinDate(ctl As Control, strInterval As String, _
  intIncrement As Integer)
On Error GoTo Err_SpinDate

   ctl = CVDate(ctl)       ' Make sure it's a date
   ctl = DateAdd(strInterval, intIncrement, ctl) ' Spin it
   DoEvents

Exit_SpinDate:
   Exit Sub

Err_SpinDate:
   MsgBox Err.Description
   Resume Exit_SpinDate

End Sub
