/*-----------------------------------------------
   NTGDI.C -- NT GDI Demonstration Shell Program
              (c) Charles Petzold, 1993
  -----------------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ntgdi.h"

extern  void     PaintRoutine (HWND, HDC, int, int) ;
LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;

HANDLE hInst ;

extern char szClass [] ;
extern char szTitle [] ;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR szCmdLine,     int nCmdShow)
     {
     char     szResource [] = "NTGdi" ;
     HWND     hwnd ;
     MSG      msg ;
     WNDCLASS wndclass ;

     hInst = hInstance ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = szResource ;
     wndclass.lpszClassName = szClass ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szClass, szTitle,
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

BOOL PrintRoutine (HWND hwnd)
     {
     static char szMessage [80] ;
     static char szPrinter [80] ;
     BOOL        bReturn = TRUE ;
     char        *szDevice, *szDriver, *szOutput ;
     DOCINFO     di ;
     HDC         hdcPrn ;
     int         cxPage, cyPage ;

     GetProfileString ("windows", "device", ",,,", szPrinter, 80) ;

     if ((szDevice = strtok (szPrinter, "," )) &&
         (szDriver = strtok (NULL,      ", ")) &&
         (szOutput = strtok (NULL,      ", ")))

               hdcPrn = CreateDC (szDriver, szDevice, szOutput, NULL) ;

     else
          return FALSE ;

     if (hdcPrn == NULL)
          return FALSE ;

     cxPage = GetDeviceCaps (hdcPrn, HORZRES) ;
     cyPage = GetDeviceCaps (hdcPrn, VERTRES) ;

     strcpy (szMessage, szClass) ;
     strcat (szMessage, ": Printing") ;

     di.cbSize      = sizeof (DOCINFO) ;
     di.lpszDocName = szMessage ;
     di.lpszOutput  = NULL ;

     if (StartDoc (hdcPrn, &di) > 0)
          {
          if (StartPage (hdcPrn) > 0)
               {
               PaintRoutine (hwnd, hdcPrn, cxPage, cyPage) ;

               if (EndPage (hdcPrn) <= 0)
                    bReturn = FALSE ;
               }
          else
               bReturn = FALSE ;

          if (EndDoc (hdcPrn) <= 0)
               bReturn = FALSE ;
          }
     else
          bReturn = FALSE ;

     DeleteDC (hdcPrn) ;

     return bReturn ;
     }

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
     {
     BOOL         bReturn ;
     static int   cxClient, cyClient ;
     HDC          hdc ;
     PAINTSTRUCT  ps ;

     switch (message)
          {
          case WM_COMMAND:
               switch (wParam)
                    {
                    case IDM_PRINT:
                         SetCursor (LoadCursor (NULL, IDC_WAIT)) ;
                         ShowCursor (TRUE) ;

                         bReturn = PrintRoutine (hwnd) ;

                         ShowCursor (FALSE) ;
                         SetCursor (LoadCursor (NULL, IDC_ARROW)) ;

                         if (!bReturn)
                              MessageBox (hwnd,
                                          "Error encountered during printing",
                                          szClass, MB_ICONASTERISK | MB_OK) ;
                         return 0 ;

                    case IDM_EXIT:
                         SendMessage (hwnd, WM_CLOSE, 0, 0L) ;
                         return 0 ;

                    case IDM_ABOUT:
                         MessageBox (hwnd, "NT GDI Demonstration Program\n"
                                     "Copyright (c) Charles Petzold, 1993",
                                     szClass, MB_ICONINFORMATION | MB_OK) ;
                         return 0 ;
                    }
               break ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               PaintRoutine (hwnd, hdc, cxClient, cyClient) ;

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY :
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
