/*************************************************************************
 *              (C) Copyright 1989-1994 Visual Solutions, Inc.           *
 *                      All Rights Reserved                              *
 * This software may not be used, copied or made available to anyone,    *
 * except in accordance with the license under which it is furnished.    *
 *************************************************************************/

#if  !defined(_INC_WINDOWS) & !defined(_WINNT_)
typedef unsigned HWND;
typedef unsigned WPARAM;
typedef long LPARAM;
typedef char FAR* LPSTR;
#endif

#define EXPORT _export
#ifndef FAR
#define FAR far
#endif
#ifndef PASCAL
# ifdef _WINNT_
#   define PASCAL
# else
#   define PASCAL pascal
#endif
#endif
#define TRUE 1
#define FALSE 0

#ifndef NO_PROTOS
# define	P(s) s
#else
# define P(s) ()
#endif

typedef void FAR *VOID_PTR;
typedef int FAR PASCAL USER_BLOCK();
typedef void FAR PASCAL USER_BLOCK_V();
typedef long FAR PASCAL USER_BLOCK_L();
typedef char FAR* FAR PASCAL USER_BLOCK_STR();
typedef USER_BLOCK *USER_BLOCK_FUNC;
typedef double FAR DOUBLE;
typedef LPSTR PASCAL USER_EVENT_FUNC( HWND, int, WPARAM, LPARAM);

/* Return sim time thru arg pointer since not all langs agree
 * on how to return a double val */
void PASCAL FAR EXPORT getSimTime( DOUBLE *pTime);
void PASCAL FAR EXPORTgetSimTimeStep( DOUBLE *pTimeStep);
void PASCAL EXPORT stopSimulation( int stopVal); /* 1:stop this run,2:stop multirun */
void PASCAL setBlockErr();		 /* Flag Block in Red */
int EXPORT debMsg P((char FAR *fmt , ...));
void FAR *PASCAL EXPORT galloc (unsigned long size );
void PASCAL EXPORT gfree (void FAR *freeP );
void FAR *PASCAL EXPORT grealloc (void FAR *inP , unsigned long size );

typedef struct {
  char FAR* menuName;
  char FAR* funcName;
  int inputCount;
  int outputCount;
  int paramCount;
  char FAR* helpText;
} USER_MENU_ITEM;

void setUserBlockMenu P((USER_MENU_ITEM FAR * ));

typedef enum {
  VR_NULL, VR_GET_CONSTRAINTS,
  VR_GET_UNKNOWNS, VR_SET_UNKNOWNS,
  VR_GET_SOLVER_INFO, VR_EXECUTE, VR_GET_UNKNOWNS_INPUT
  , VR_SET_BLOCK_MENU
} VR_CMD;

int FAR PASCAL userSolver();
int FAR PASCAL vsmRequest( long FAR*, double FAR*);

#define WM_VSM_GET_PARAM_DESC WM_USER+2000
