#include <windows.h>	// standard windows include file
#include <windowsx.h>	// windows macros for portability
#include <vsuser.h>	// vissim function prototypes
#include <custdlg.h>	// custdlg type definitions and literals

/* globals */

HINSTANCE DLLInst;


/* simulation start function */

void FAR PASCAL custdlgSS(params, runCount)
double FAR params[];
long FAR *runCount;
{


} /* custdlgSS */


/* simulation step function */

void FAR PASCAL custdlg(params, insig, outsig)
double FAR params[];
double FAR insig[];
double FAR outsig[];
{


} /* custdlg */


/* simulation end function */

void FAR PASCAL custdlgSE(params)
double FAR params[];
{


} /* custdlgSE */


/* parameter allocation function */

long FAR PASCAL custdlgPA(pCount)
short FAR *pCount;
{
	*pCount = 0;
	return (sizeof(TEMP_STRUCT));

} /* custdlgPA */


/* parameter initialization function */

void FAR PASCAL custdlgPI(values)
TEMP_STRUCT FAR *values;
{

	values->iInfMethod = INF_MAX_MIN;
	values->iDefuzMethod = DEFUZ_YAGERS;

} /* custdlgPI */


/* parameter change function */

char FAR * PASCAL custdlgPC(values)
TEMP_STRUCT FAR *values;
{
	FARPROC lpfnProc;

	lpfnProc = MakeProcInstance(CustomDlgProc, DLLInst);
	DialogBoxParam(DLLInst, "CUSTDLG", NULL, lpfnProc, (LPARAM) values);
	FreeProcInstance(lpfnProc);

	return NULL;

} /* custdlgPC */


/* parameter change dialog procedure */

BOOL FAR PASCAL CustomDlgProc(hDlg, msg, wParam, lParam)
HWND hDlg;
UINT msg;
WPARAM wParam;
LPARAM lParam;
{

	static TEMP_STRUCT FAR *data;
	int iInference, iDefuz;

	switch (msg) {

	case WM_INITDIALOG:
	
		/* initialize the dialog box fields */
		
		data = (TEMP_STRUCT FAR *) lParam;
		iInference = IDD_FIRST_INFERENCE + data->iInfMethod;
		iDefuz = IDD_FIRST_DEFUZ + data->iDefuzMethod;
		CheckRadioButton(hDlg, IDD_MINMAX, IDD_BOUNDSUMPROD, iInference);
		CheckRadioButton(hDlg, IDD_YAGER, IDD_MAXHEIGHT, iDefuz);
		break;

	case WM_COMMAND:

		switch (GET_WM_COMMAND_ID(wParam, lParam)) {

		case IDCANCEL:
			EndDialog(hDlg, FALSE);
			break;

		case IDOK:

			/* read the new values */

			if (Button_GetCheck(GetDlgItem(hDlg, IDD_MINMAX)))
				data->iInfMethod = INF_MAX_MIN;
			else if (Button_GetCheck(GetDlgItem(hDlg, IDD_SUMPROD)))
				data->iInfMethod = INF_SUM_PRODUCT;
			else
				data->iInfMethod = INF_BOUNDED_SUM;

			if (Button_GetCheck(GetDlgItem(hDlg, IDD_YAGER)))
				data->iDefuzMethod = DEFUZ_YAGERS;
			else if (Button_GetCheck(GetDlgItem(hDlg, IDD_CENTER)))
				data->iDefuzMethod = DEFUZ_CENTER_GRAVITY;
			else
				data->iDefuzMethod = DEFUZ_MAX_HEIGHT;

			EndDialog(hDlg, TRUE);
			break;
		}
		return TRUE;
	}
	return FALSE;

} /* CustomDlgProc */


/* DLL entry point */

int FAR PASCAL LibMain(hInstance, wDataSeg, cbHeapSize, lpszCmdLine)
HINSTANCE hInstance;
WORD wDataSeg;
WORD cbHeapSize;
LPSTR lpszCmdLine;
{

#ifdef UNIX
	LibFunc("custdlg", custdlg);
	LibFunc("custdlgPA", custdlgPA);
	LibFunc("custdlgPI", custdlgPI);
	LibFunc("custdlgPC", custdlgPC);
	LibFunc("custdlgSE", custdlgSE);
	LibFunc("custdlgSS", custdlgSS);
#endif

	DLLInst = hInstance;
	return TRUE;

} /* LibMain */


/* DLL exit procedure */

int FAR PASCAL WEP(nParameter)
int nParameter;
{

	return 1;

} /* WEP */
