/*
 * This file is part of the VgaText C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#ifndef INCLUDED_VGATEXT_H
#define INCLUDED_VGATEXT_H

/*
 * v g a   t e x t   m o d e   e f f e c t s   c l a s s
 * 
 * special vga text mode color effects (direct video bios manipulation class)
*/
#include "typedef.h"

class zVgaText
{
public:
	zVgaText();
	~zVgaText();

	static Boolean Detect();  // try to detect a VGA card
	static Boolean restoreBlink; // True if we need to restore the blinking

	static void resume();  // installs the custom timer handler/palettes
	static void suspend(); // suspends the operation of the effects
	static void enable();  // enables the timer intercept handler
	static void disable(char nPalette = 0); // disables the timer handler

	static void PulseColor(char attr, char aDelta); // create pulse def
	static void PulseColor(char attr, char delta, char nStart, char nEnd);
	static void SetColor(char attr, char rgb[3]); // set a color definition
	static void SetColor(char attr, char rgb[3], char nStart, char nEnd);
	static void GradeColor(char attr, char rgb[3]); // grade a color
	static void GradeColor(char attr, char rgb[3], char nStart, char nEnd);
	static void BlinkSim(char attr); // simulated software blinking
	static void FadeOut(char aDelay = 12);  // fades out the whole palette
	static void FadeIn(char aDelay = 12); // fades in the whole palette

	static void ResetPalettes();  // reset user DAC palettes to original
	static void LoadPalettes();   // load the user DAC palettes into the VGA
	static void EnableBlink(Boolean enable);  // enable/disable blinking
	static void SetDelay(ushort nTicks);  // sets tick delay for handler
	static void SetDelta(char nDelta); // set the delta skip step

protected:
	static uchar *GetDacPtr(char attrib, char palette);  // attrib pos in DAC
	static void   CalcScale(char rgbStart[3], char rgbEnd[3], char nRange);
	static uchar  dac[768]; // user-modifiable rgb values
	static uchar  pal[17];  // user-modifiable vga palette
	static ushort delayTicks; // delay ticks for the timer intercept
	static ushort countdown;  // current tick countdown used by the handler
	static char   delta;      // number of palettes to skip over
	static char   nCurPalette;  // the current palette (0..15)

private:
	static uchar origDac[768]; // original DAC rgb values
	static uchar origPal[17];  // original VGA color registers
	static uchar origPageMode;  // original VGA paging mode
	static uchar origDispPage;  // original active display page

	static void interrupt (*timerVector)(...);  // save vector for INT9
	static void interrupt timerHandler(...);    // our very own handler

	static Boolean vgaCard;     // True if VGA is detected, False otherwise
	static Boolean initVga;     // True if initialized, False otherwise
	static Boolean timerSet;    // True if the timer INT is intercepted
};

#endif /* INCLUDED_VGATEXT_H */
