/*
 * This file is part of the VgaText C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#include "vgatext.h"
#include <conio.h>

void ShowText(const char *aText);
void ShowNoPrompt(const char *aText);

void main()
{
	zVgaText vga;
	int i;

	if( !vga.Detect() ){
		cprintf("VGA is *required* for this to work...");
		return;
	}
	// fade in the whole screen (set the original palette to 0)
	for( i = 0; i < 16; ++i ) vga.SetColor(i, "\x00\x00\x00");
	vga.LoadPalettes();
	ShowNoPrompt("This text was invisible and then came up");
	vga.ResetPalettes();
	vga.FadeIn();
	cprintf("press a key...");
	getch(); clrscr();

	//pulse reds and greens (normal and bright)
	vga.ResetPalettes();
	vga.PulseColor(2, 2);
	vga.PulseColor(10, 2);
	vga.PulseColor(4, 2);
	vga.PulseColor(12, 2);
	vga.LoadPalettes();  // required to transfer the palettes to the DAC
	vga.enable(); // enable the interrupt intercept
	// now anything green or red should be pulsing
	ShowText("Green and red should be pulsing");

	vga.disable(0); // disable the interrupt
	vga.ResetPalettes();
	vga.GradeColor(2, "\x3F\x00\x00");
	vga.LoadPalettes();
	vga.enable();
	ShowText("This grades green from normal to high red");

	vga.disable();
	vga.ResetPalettes();
	for( i = 0; i < 16; ++i ) vga.PulseColor(i, 2);
	vga.LoadPalettes();
	vga.enable();
	ShowText("All 16 attributes should be pulsing now");

	vga.disable();
	vga.ResetPalettes();
	vga.SetColor(2, "\x3F\x00\x00", 8, 15);
	vga.LoadPalettes();
	vga.enable();
	ShowText("This changes green to red instantly");

	vga.disable();
	vga.ResetPalettes();
	vga.GradeColor(3, "\x00\x00\x00");
	vga.LoadPalettes();
	vga.enable();
	ShowText("This fades low cyan to black");

	vga.disable();
	vga.ResetPalettes();
	vga.SetColor(14, "\x00\x00\x00", 0, 14);
	vga.SetColor(14, "\x3F\x3F\x00", 15, 15); // max yellow
	vga.SetColor(1,  "\x00\x00\x3F", 15, 15); // max blue
	vga.SetDelta(1);
	vga.LoadPalettes();
	vga.enable();
	ShowText("Look at the yellow strobe and the blue beacon");

	vga.disable();
	vga.ResetPalettes();
	vga.GradeColor(3, "\x00\x00\x00", 0, 7);
	vga.BlinkSim(3);
	vga.LoadPalettes();
	vga.enable();
	ShowText("This is 'softened' blink for cyan");

	vga.disable();
	vga.ResetPalettes();
	ShowText("This will fade out the moment you press a key.");
	vga.FadeOut();
	clrscr();
}


void
ShowText(const char *aText)
{
	ShowNoPrompt(aText);
	textattr(15);
	cprintf("\n\r\n\rpress a key...");
	getch();
}

void ShowNoPrompt(const char *aText)
{
	int i;

	clrscr();
	cprintf("%s\n\r\n\r", aText);
	for( i = 0; i < 16; ++i ){
		textattr(i);
		cprintf("    sample for color 0x%02X\n\r", i);
	}
}
