
/**************************************************************************
                610to612.C

 Note : This file is for the voice file conversion between the ZyXEL
        firmware V6.10 to V6.12 ADPCM leakage parameters conversion.

 Usage : 610to612  sfile dfile
                     ^     ^
                     |     +--- Destination file path and name
                     |
                     +--- Source file path and name

 Created by Lin Chinru, Apr. 10, 1994.
 Copyright 1994, ZyXEL Communications Corporation
 **************************************************************************/
#include <stdio.h>

void ToPCM(int) ;
void ToAdpcm(int) ;
void Quit(int,char *) ;
void Adaptive1(char) ;
void Adaptive2(char) ;


char    Rcnt, CompBit ;
FILE    *SourFh, *DestFh ;

int     Rdata, EstMax1, Delta1, EstMax2, Delta2, Data, Pack ;
int     MaxTbl[] = { 0x399A, 0x3A9F, 0x4D14, 0x6607 } ;

/* ------------------------------------------------- */
/* Reserved buffers for the ZyXEL ADPCM file header  */
/* ------------------------------------------------- */
char    ZheadBuf0[16] ;
char    ZheadBuf1[16] = { 'Z','y','X','E','L',2,0,0,0,0,0,0,0,0,0,0 } ;

void main(int argc, char *argv[])
{
        /* ---------- Open file and check for legality -------------- */
        if ( argc!=3 )
                Quit(0,"") ;
        if ( (SourFh=fopen(argv[1],"rb")) == NULL )
                Quit(1,argv[1]) ;
        if ( (DestFh=fopen(argv[2],"wb")) == NULL )
                Quit(1,argv[2]) ;

        /* ------------------ */
        /* Initial parameters */
        /* ------------------ */
        Rcnt    = 8 ;
        Rdata   = 0 ;
        Delta1  = 5 ;
        EstMax1 = 0 ;
        Delta2  = 5 ;
        EstMax2 = 0 ;

        /* -------------------------------- */
        /*  ZyXEL ADPCM -> .VOC conversion  */
        /* -------------------------------- */
        fread( ZheadBuf0, sizeof(char), 16, SourFh) ;
        if ( strcmp( ZheadBuf0, ZheadBuf1, 6) || ZheadBuf0[20]==0 )
                Quit(2,argv[1]) ;
        fwrite( ZheadBuf0, sizeof(char), 16, DestFh) ;
        CompBit = ZheadBuf0[10] ;
        if ( CompBit == 1 ) {
                MaxTbl[0] = 0x3800 ;
                MaxTbl[1] = 0x5600 ;
        }
        while ( (Data=getc(SourFh)) != EOF )    {
                if ( CompBit == 1 )     {
                        ToPCM((Data&0xc0)>>6) ; /* XX-- ---- */
                        ToPCM((Data&0x30)>>4) ; /* --XX ---- */
                        ToPCM((Data&0x0c)>>2) ; /* ---- XX-- */
                        ToPCM(Data&0x03) ;      /* ---- --XX */
                }
                else    {
                        ToPCM((Data&0xe0)>>5) ; /* XXX- ---- */
                        ToPCM((Data&0x1c)>>2) ; /* ---X XX-- */
                        Pack = (Data&0x03)<<1 ;
                        Data = getc(SourFh) ;
                        ToPCM(Pack|((Data&0x80)>>7)) ;
                        ToPCM((Data&0x70)>>4) ; /* -XXX ---- */
                        ToPCM((Data&0x0e)>>1) ; /* ---- XXX- */
                        Pack = (Data&0x01)<<2 ;
                        Data = getc(SourFh) ;
                        ToPCM(Pack|((Data&0xc0)>>6)) ;
                        ToPCM((Data&0x38)>>3) ; /* --XX X--- */
                        ToPCM(Data&0x07) ;      /* ---- -XXX */
                }
        }
        fclose(SourFh) ;
        fclose(DestFh) ;
}


/**************************************************************************
        ToPCM()



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void ToPCM(int Vdata)
{
int     Wdata ;

        Adaptive1((char)Vdata) ;
        if ( EstMax1 > 8191 )
                Wdata = 8191 ;
        else if ( EstMax1 < -8192 )
                Wdata = -8192 ;
        else
                Wdata = EstMax1 ;
        ToAdpcm(((Wdata>>6)+128)&0xff) ;
}

/**************************************************************************
        Adaptive1(DataBit)



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Adaptive1(char DataBit)
{
int     TmpMax ;
char    TmpData, SignBit ;
long    TmpDelta ;
long    t0 ;

        /*****************/
        t0 = (long)EstMax1;
        t0 *= 3973 ;
        t0 += 2048 ;
        t0 /= 4096 ;
        EstMax1 = (int)t0 ;
        /*****************/

        SignBit = DataBit & (2*CompBit) ;
        DataBit &= ~(2*CompBit) ;
        if ( (Delta1&1) && !SignBit )
                ++EstMax1 ;

        /* ------------------- */
        /* Calculate the Delta */
        /* ------------------- */
        TmpDelta = Delta1 ;
        TmpDelta *= MaxTbl[DataBit] ;
        TmpDelta += 8192 ;
        TmpDelta >>= 14 ;

        /* -------------------- */
        /* Calculate the EstMax */
        /* -------------------- */
        TmpMax  = (Delta1>>1) ;
        while ( DataBit-- )
                TmpMax += Delta1 ;
        if ( SignBit )
                EstMax1 -= TmpMax ;
        else
                EstMax1 += TmpMax ;

        Delta1 = (int)TmpDelta ;
}


/**************************************************************************
        ToAdpcm()



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void ToAdpcm(int Edata)
{
char    TmpCompBit, DataBit ;


        DataBit = 0 ;
        Rdata   &= 0xff00 ;

        Edata -= 128 ;
        Edata <<= 6 ;
        Edata += 32 ;
        /* Check for the waveform data and quantize this data */
        if ( Edata -= EstMax2 )  {
                TmpCompBit = 2*CompBit ;
                /* ----------------------------------------------------- */
                /* If the data is negative, set flag and change the sign */
                /* ----------------------------------------------------- */
                if ( Edata < 0 ) {
                        Edata = -Edata ;
                        DataBit = TmpCompBit ;
                }
                /* --------------------------------------------------- */
                /* Quantize the waveform data, delta value is adaptive */
                /* --------------------------------------------------- */
                while ( ((Edata-=Delta2)>0) && --TmpCompBit )
                        DataBit += 1 ;
                /* ---------------------------- */
                /* Rdata is the compressed data */
                /* ---------------------------- */
                Rdata  |= ( DataBit << (7-CompBit) ) ;
        }
        /* ------------------------------------------------------ */
        /* check if the compressed data can be pack into one byte */
        /* ------------------------------------------------------ */
        TmpCompBit = CompBit+1 ;
        while ( TmpCompBit-- )     {
                Rdata  <<= 1 ;
                if ( !(--Rcnt) )    {
                        putc(Rdata>>8,DestFh) ;
                        Rcnt = 8 ;
                }
        }
        /* -------------------------------------- */
        /* Adaptive the Delta and Estimat Maximum */
        /* -------------------------------------- */
        Adaptive2(DataBit) ;
}

/**************************************************************************
        Adaptive2(DataBit)



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Adaptive2(char DataBit)
{
int     TmpMax ;
char    TmpData, SignBit ;
long    TmpDelta ;
long    t0 ;

        /*****************/
        t0 = (long)EstMax2;
        t0 *= 4093 ;
        t0 += 2048 ;
        t0 /= 4096 ;
        EstMax2 = (int)t0 ;
        /*****************/

        SignBit = DataBit & (2*CompBit) ;
        DataBit &= ~(2*CompBit) ;
        if ( (Delta2&1) && !SignBit )
                ++EstMax2 ;

        /* ------------------- */
        /* Calculate the Delta */
        /* ------------------- */
        TmpDelta = Delta2 ;
        TmpDelta *= MaxTbl[DataBit] ;
        TmpDelta += 8192 ;
        TmpDelta >>= 14 ;

        /* -------------------- */
        /* Calculate the EstMax */
        /* -------------------- */
        TmpMax  = (Delta2>>1) ;
        while ( DataBit-- )
                TmpMax += Delta2 ;
        if ( SignBit )
                EstMax2 -= TmpMax ;
        else
                EstMax2 += TmpMax ;

        Delta2 = (int)TmpDelta ;
}


/**************************************************************************
        Quit()



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Quit(int Num, char *MsgStr)
{
        if ( Num == 0 ) {
                printf("Usage : 610to612 sfile dfile.\n");
                printf("                   ^     ^\n") ;
                printf("                         Destination file\n");
                printf("                    Source file\n") ;
        }
        else if ( Num == 1 )
                printf("Can't open %s\n", MsgStr) ;
        else if ( Num == 2 )
                printf("File format error on %s\n", MsgStr) ;
        exit(1) ;
}




