// animation.h : header file for CAnimation class
//
#ifndef __ANIMATION_H
#define __ANIMATION_H

#include "ddraw.h"

class CAnim
{
  protected:
    static int DisplayWidth;
  public:
    static void SetDisplayWidth(int nDisplayWidth);

  public:
    CAnim(LPDIRECTDRAW pDirectDraw,
          char* pFileRoot,
          char* pDirectoryName,
          int nNumFrames,
          BOOL bStoreInVideo = TRUE);
    // Default constructor, does not actually allocate memory or load images,
    // just sets up internal data

    virtual ~CAnim();

    BOOL Load();
    // actually allocates storage memory and reads image files

    void Release();
    // releases the direct draw surface, call this is your CGameFrame 
    // descendents KillGraphics function

    BOOL Restore();
    // calls ddraw restore function on surface, and reloads images from disk

    HRESULT Render(int nX, 
                   int nY,
                   int nFrameNum,
                   LPDIRECTDRAWSURFACE pDestSurface,
                   BOOL bTransparent = TRUE);
    // calls ddraw BltFast function

    int GetNumFrames() {return m_nNumFrames;};
    int GetWidth() {return m_nWidth;};
    int GetHeight() {return m_nHeight;};
    
  protected:
    BOOL InternalLoad(BOOL bRestore);

    LPDIRECTDRAW m_pDirectDraw;

    LPDIRECTDRAWSURFACE m_pSurface;

    char* m_pFileRoot;
    int m_nNumFrames;
    BOOL m_bInVideo;

    int m_nWidth;   // Width of one frame
    int m_nHeight;  // Height of one frame

    int m_nNumRows;
    int m_nNumCols;

    int* m_pnRows;
    int* m_pnCols;
};

#endif // __ANIMATION_H