unit About;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, SysUtils;

type
  TAboutBox = class(TForm)
    Panel1: TPanel;
    OKButton: TBitBtn;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    lblMemory: TLabel;
    lblGDIResources: TLabel;
    Label3: TLabel;
    lblUserResources: TLabel;
    Label4: TLabel;
    procedure FormShow(Sender: TObject);
  private
    { Variables to hold resource information generated by About Box }
    lMemoryFree: Longint;
    lGDIResources: Longint;
    lUserResources: Longint;
    procedure GetSystemInfo;
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

{$R *.DFM}

procedure TAboutBox.GetSystemInfo;
begin
  {Code to Calculate and Display Memory and System Resources}
  lMemoryFree := GetFreeSpace(0) div 1024;
  lGDIResources := Longint(GetFreeSystemResources(GFSR_GDIRESOURCES));
  lUserResources := Longint(GetFreeSystemResources(GFSR_USERRESOURCES));
end;

procedure TAboutBox.FormShow(Sender: TObject);
begin
  GetSystemInfo;
  lblMemory.Caption := FormatFloat(',#', lMemoryFree) + ' KB Free';
  lblGDIResources.Caption := InttoStr(lGDIResources) + '% Free';
  lblUserResources.Caption := InttoStr(lUserResources) + '% Free';
end;

end.

