****************************************************************************
* FUNCTION Incr( cIdNo )
* Increment numeric character strings such as id numbers stored in a
* character field.  Pads id with leading zeros..."00001"..."00928"..."01015".
* Syntax:  cNewId = Incr( idno )
* Note: Field/Var should be large enough as to avoid numeric overflow
****************************************************************************
FUNCTION Incr
PARAMETER cIdNo
nFldlen = LEN(cIdNo)
nIncrval = VAL(cIdNo) + 1
cRtnval = PADL(ALLTRIM(STR(nIncrval,nFldlen,0)),nFldlen,"0")
RETURN cRtnval

****************************************************************************
* FUNCTION NextID( cTable )
* Returns the next incremental ID number for the specified table.  Value
* returned is a character string left padded with zeroes.  Assumes that
* ID numbers are stored in an ID table with structure NAME c(10), ID c(6),
* and that the ID table was opened at startup time.  The passed parameter
* doesn't have to be a real table name. It can be any lookup value that
* corresponds to an entry in the Id table.
****************************************************************************
FUNCTION NextID
PARAMETER cTable
cId = ""                          && Initialize the return value
nOldArea = SELECT()               && Save the current work area
cOldRepr = SET('REPROCESS')       && Save the current reprocess setting
cOldExac = SET('EXACT')           && Save the current exact setting
SET EXACT ON                      && Don't allow partial matches
SET REPROCESS TO AUTOMATIC        && Keep trying to lock until success or Esc
SELECT Id                         && Select the Id table
SET ORDER TO Name                 && Select Index
IF SEEK( UPPER(cTable) )          && Look for match on table name
  IF RLOCK()                      && Try to lock the record
    REPLACE Id.Id WITH Incr( Id.Id )  && Generate the new ID number
    cId = Id.Id                   && and store it for return to caller
    UNLOCK                        && Unlock the record
  ENDIF
ENDIF
SELECT (nOldArea)                 && Restore the old work area
SET EXACT &cOldExac               && Restore the exact setting
SET REPROCESS TO cOldRepr         && Restore the reprocess setting
RETURN cId                        && Return the Id
