.286
INCLUDE ShowCMOS.Hd
;͸
;                     Display CMOS Contents To Screen			    
;;
COMSEG SEGMENT BYTE PUBLIC
	ASSUME	CS:COMSEG, DS:COMSEG, ES:COMSEG, SS:COMSEG
	ORG	100H
;
ComStart:	jmp	RealStart
;͸
;                                Variables				    
;;
LastCMOSByte	db	128
;͸
;                              Start Of Code				    
;;
RealStart:	Call	BlastUserMessage	; Print info screen
		Call	ReadCMOS		; Read the CMOS data into
						; a buffer
		Call	DisplayCMOSData		; Display the CMOS data box
						; onto the screen
;
		mov	ah, EXE_TERMINATE	; Terminate and return to
		int	DOS_FUNCTION		; DOS
;͸
;                               SUBROUTINES				    
;;
;Ŀ
;                                Read CMOS				    
;  This routine will determine how many bytes of data the cmos holds.	      
;  It will also read in all the CMOS data bytes into the buffer.	    
;  Call With    :       Nothing					    
;  Alters       :       AX, BX						    
;  Returns      :       Nothing					    
;  Calls        :       ReadCMOSByte					    
;                       ScanForDups					    
;                       CheckForWriteAbility				    
;
ReadCMOS:	xor	bx, bx			; Clear out a count and
						; offset register
GetNextCMOSByte:
		mov	al, bl			; Get current CMOS location
		Call	ReadCMOSByte		; Read in value
		mov	[OFFSET CMOSDataBuffer + bx], al ; Save the value
						; in a buffer for later
		inc	bl			; Increment counter
		cmp	bl, 128			; See if we've finished
		jne	GetNextCMOSByte		; If not, get the next value
;--------------------------------------------------------------------------
		Call	ScanForDups		; Make the two checks for
		Call	CheckForWriteAbility	; extended CMOS bytes
		ret
;Ŀ
;                           Scan For Duplicates			    
;  This routine will scan the first 64 bytes of CMOS against the	     
;  second 64 bytes of CMOS and make sure they are not exactly the same.      
;  If they are, this routine will set a flag to designate printing of	     
;  only the first 64 bytes.						    
;  Call With    :       Nothing					    
;  Returns      :       Nothing					    
;  Alters       :       DI, SI, CX					    
;  Calls        :       Nothing					    
;
ScanForDups:	mov	di, OFFSET CMOSDataBuffer ; Point to buffer, starting
		mov	si, di			; at floppy disk info.  This
		add	di, 10h			; is done because this info
		add	si, 50h			; won't always be changing.
		mov	cx, 30h			; If they are the same, we
		repe cmpsb			; probably only have 64 bytes
		jne	NotTheSameInfo		; of CMOS data
		mov	LastCMOSByte, 64
NotTheSameInfo:	ret
;Ŀ
;                    Check For Memory Writing Ability			    
;  This routine will check to make sure that there are valid memory	     
;  cells after the first 64 bytes of memory.  If there are not, this	     
;  routine will set a flag to designate printing of only the first 64	     
;  bytes of CMOS.							    
;  Call With    :       Nothing					    
;  Returns      :       Nothing					    
;  Alters       :       AX, BX						    
;  Calls        :       ReadCMOSByte					    
;                       WriteCMOSByte					    
;
CheckForWriteAbility:
		mov	al, 127	      		; Get the last possible
		Call	ReadCMOSByte		; byte location and read
		mov	bl, al			; in the value
		mov	ah, al
		xor	ah, 10101010b		; Alter the value we read to
		mov	al, 127			; anything else and write it
		push	ax			; back out to CMOS.
		Call	WriteCMOSByte
		pop	ax
		Call	ReadCMOSByte		; Read it back in and make
		cmp	ah, al			; sure it's what we wrote.
		je	WriteWorked		; If it isn't, we don't have
		mov	LastCMOSByte, 64	; 128 bytes of CMOS memory
WriteWorked:	mov	ah, bl			; Now get the original value
		mov	al, 127			; and write it back out to
		Call	WriteCMOSByte		; the memory location
		ret
;Ŀ
;                            Display CMOS Data				    
;  This routine will convert the CMOS data to text and display it onto	     
;  the screen.								    
;  Call With    :       Nothing					    
;  Alters       :       All Registers may be altered			    
;  Returns      :       Nothing					    
;  Calls        :       ConvertByteToText				    
;                       DisplayByteOnScreen				    
;
DisplayCMOSData:
		xor	bx, bx			; Clear our counter
		mov	si, OFFSET CMOSDataBuffer ; Point to the buffer and
		mov	di, OFFSET ByteLocations ; table locations
GetNextByte:	mov	al, [si + bx]		; Get a byte out of the 
						; data buffer
;
		Call	ConvertByteToText	; Convert the byte to text
						; and plug it into the table
;
		add	di, 2			; Point to next table location
		inc	bx			; and to next byte
		cmp	bl, LastCMOSByte	; If we are done, leave
		jne	GetNextByte		; Otherwise do the next byte
;
		Call	PrintOutBox		; Print out the table
		ret
;Ŀ
;                          Convert Byte To Text			    
;  This routine will convert a byte into it's hex digits and get it	     
;  ready for display.							    
;  Call With    :       AL = Byte to convert				    
;  Returns      :       Nothing					    
;  Alters       :       AX						    
;  Calls        :       Nothing					    
;
ConvertByteToText:
		push	bx			; Save calling registers
		push	si
		push	di
;
		xor	bx, bx			; Clear working reg
		mov	di, [di]		; DI current points to list
						; of offsets.  Get correct
						; offset for this byte.
		mov	si, OFFSET DigitsText	; Point SI to HEX digits
DoNextDigit:	xor	ah, ah			; Clear upper byte of AX
		shl	ax, 04			; Shift first nibble into AH
		mov	bl, ah			; Store in BX
		mov	ah, [si + bx]		; Get HEX representation for
						; this nibble
		mov	[di], ah		; And store it into our 
						; output info
		inc	di			; Point DI to second digits
						; location in output table
		or	al, al			; See if we are finished
						; with byte
		jnz	DoNextDigit
;
		pop	di			; Restore calling registers
		pop	si
		pop	bx
		ret
;Ŀ
;                              Print Out Box				    
;  This routine will print out the table, taking care to only print out     
;  the correct number of bytes available.				    
;  Call With    :       Nothing					    
;  Returns      :       Nothing					    
;  Alters       :       AX, DX						    
;  Calls        :       ClearScreen					    
;
PrintOutBox:	Call	ClearScreen
;--------------------------------------------------------------------------
		mov	dx, OFFSET StartCMOSData ; Print out the top of the
		mov	ah, DOS_PRINTSTRING	; box and the first 64 bytes
		int	DOS_FUNCTION		; of data.
;--------------------------------------------------------------------------
		cmp	LastCMOSByte, 128	; Check to see if we have
		jne	FinishBox		; another 64 bytes
		mov	dx, OFFSET Second64Bytes ; Print out the next 64 
		mov	ah, DOS_PRINTSTRING	; bytes if we have them
		int	DOS_FUNCTION
;--------------------------------------------------------------------------
FinishBox:	mov	dx, OFFSET EndCMOSData	; Print out the bottom of  
		mov	ah, DOS_PRINTSTRING	; the box.
		int	DOS_FUNCTION
;--------------------------------------------------------------------------
		ret
;Ŀ
;                          Blast User Message				    
;  This routine will write the user message onto the screen and wait	     
;  for a keystroke.							    
;  Call With    :       Nothing					    
;  Alters       :       AX, DX						    
;  Returns      :       Nothing					    
;  Calls        :       ClearScreen					    
;
BlastUserMessage:
		Call	ClearScreen		; Clear screen and move
						; cursor to top of screen
;--------------------------------------------------------------------------
		mov	dx, OFFSET CMOSMessage	; Use DOS to write the
		mov	ah, DOS_PRINTSTRING	; message onto screen
		int	DOS_FUNCTION
		Call	WaitForKeystroke
		ret
;Ŀ
;                              Clear Screen				    
;  This routine will clear the screen by writing spaces to every	     
;  location.								    
;  Call With    :       Nothing					    
;  Alters       :       AX, BX, CX, DX					    
;  Returns      :       Nothing					    
;  Calls        :       SetCursorLoc					    
;
ClearScreen:	xor	dx, dx				; Move cursor to the
		Call	SetCursorLoc			; top of the screen
;--------------------------------------------------------------------------
		mov	al, SPACE_CHARACTER		; Fill the screen
		xor	bh, bh				; with bright white
		mov	bl, BR_WHT_ON_BLK		; on black spaces
		mov	cx, ONE_SCREEN_OF_CHARS
		mov	ah, WRITE_CHAR_AND_ATTRIB
		int	VIDEO_IO		
		ret					
;Ŀ
;                           Wait For Keystroke				    
;  This routine will wait until a key is in the buffer.		    
;  Call With    :       Nothing					    
;  Alters       :       AX						    
;  Returns      :       Nothing					    
;  Calls        :       Nothing					    
;
WaitForKeystroke:
		mov	ah, WAIT_FOR_KEYSTROKE
		int	KEYBOARD_IO
		ret 
;Ŀ
;                           Set Cursor Location			    
;  This routine will set the cursor position to the value in DX	    
;  Call With    :       DX = New Cursor Position			    
;  Returns      :       Nothing					    
;  Alters       :       AX, BX, DX					    
;  Calls        :       Nothing					    
;
SetCursorLoc:	mov	ah, SET_CURSOR_POSITION	; Set cursor position on
		xor	bh, bh			; display page 0
		int	VIDEO_IO
		ret

;͸
;                                INCLUDES				    
;;
INCLUDE Pcmag.Asm

;Ŀ
;                        BUFFERS, STRINGS, SCREENS			    
;
CMOSDataBuffer:
db	128 dup (0)

StartCMOSData:
db"͵ CMOS Data ͻ",CR,LF
First64Bytes:
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF,"$"
Second64Bytes:
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF
db"00 00 00 00 00 00 00 00",CR,LF,"$"
EndCMOSData:
db"ͼ",CR,LF,"$"
DigitsText:
db"0123456789ABCDEF"

BL1		equ	OFFSET First64Bytes
BL2		equ	OFFSET Second64Bytes
;--------------------------------------------------------------------------
ByteLocations:
dw BL1+001, BL1+004, BL1+007, BL1+010, BL1+013, BL1+016, BL1+019, BL1+022
dw BL1+028, BL1+031, BL1+034, BL1+037, BL1+040, BL1+043, BL1+046, BL1+049
dw BL1+055, BL1+058, BL1+061, BL1+064, BL1+067, BL1+070, BL1+073, BL1+076
dw BL1+082, BL1+085, BL1+088, BL1+091, BL1+094, BL1+097, BL1+100, BL1+103
dw BL1+109, BL1+112, BL1+115, BL1+118, BL1+121, BL1+124, BL1+127, BL1+130
dw BL1+136, BL1+139, BL1+142, BL1+145, BL1+148, BL1+151, BL1+154, BL1+157
dw BL1+163, BL1+166, BL1+169, BL1+172, BL1+175, BL1+178, BL1+181, BL1+184
dw BL1+190, BL1+193, BL1+196, BL1+199, BL1+202, BL1+205, BL1+208, BL1+211

dw BL2+001, BL2+004, BL2+007, BL2+010, BL2+013, BL2+016, BL2+019, BL2+022
dw BL2+028, BL2+031, BL2+034, BL2+037, BL2+040, BL2+043, BL2+046, BL2+049
dw BL2+055, BL2+058, BL2+061, BL2+064, BL2+067, BL2+070, BL2+073, BL2+076
dw BL2+082, BL2+085, BL2+088, BL2+091, BL2+094, BL2+097, BL2+100, BL2+103
dw BL2+109, BL2+112, BL2+115, BL2+118, BL2+121, BL2+124, BL2+127, BL2+130
dw BL2+136, BL2+139, BL2+142, BL2+145, BL2+148, BL2+151, BL2+154, BL2+157
dw BL2+163, BL2+166, BL2+169, BL2+172, BL2+175, BL2+178, BL2+181, BL2+184
dw BL2+190, BL2+193, BL2+196, BL2+199, BL2+202, BL2+205, BL2+208, BL2+211
;--------------------------------------------------------------------------
CMOSMessage:
db""
db"                                                                              "
db"                                                                              "
db"                               Show CMOS Values                               "
db"                                                                              "
db"                                                                              "
db"                                                                              "
db"                                                                              "
db"   This program will read the CMOS, determine how many CMOS data bytes are    "
db"   available, and display the available data in hex format.  The first 16     "
db"   bytes of data belong to the system clock and other volatile information.   "
db"   These values will probably change each time you run this program.          "
db"                                                                              "
db"   This program demonstrates how to read data from the CMOS RAM.  No care     "
db"   is taken during the reading of the CMOS Real Time Clock.  For better       "
db"   examples of how to read this information, please see either of the two     "
db"   clock programs.                                                            "
db"                                                                              "
db"                                                                              "
db"                                                                              "
db"                                                                              "
db""
db"                                                                                "
db"                           Press Any Key To Continue                            ","$"



;
COMSEG	ENDS
	END	ComStart
