{$A+,B-,D-,F-,G-,I-,K-,L-,N-,P-,Q-,R-,S-,T-,V+,W+,X+,Y-}
PROGRAM ShutDn;
Uses WinTypes, WinProcs, WinDOS, Strings,
{$IFDEF Ver70} OWindows; {$ELSE} WObjects; {$ENDIF}
{$R ShutDn}
{$D ShutDown - Copyright (c) 1993 by Neil J. Rubenking}

CONST AppName : PChar = 'ShutDown';
TYPE
  TMyApplication = OBJECT(TApplication)
    PROCEDURE InitMainWindow; virtual;
  END;

  PTestWindow = ^TTestWindow;
  TTestWindow = OBJECT(TWindow)
    DidShutDown : Boolean;
    FUNCTION GetClassName : PChar; Virtual;
    PROCEDURE GetWindowClass(var AWndClass: TWndClass); Virtual;
    PROCEDURE wmQueryOpen(VAR Msg : TMessage); Virtual
      wm_First + wm_QueryOpen;
    FUNCTION CanClose : Boolean; Virtual;
    PROCEDURE wmQueryEndSession(VAR Msg : TMessage);
      Virtual wm_First + wm_QueryEndSession;
  END;

  FUNCTION TTestWindow.GetClassName;
  BEGIN GetClassName := AppName; END;

  PROCEDURE TTestWindow.GetWindowClass(VAR AWndClass : TWndClass);
  BEGIN
    TWindow.GetWindowClass(AWndClass);
    AWndClass.hIcon := LoadIcon(HInstance, AppName);
    DidShutDown := FALSE;
  END;

  PROCEDURE TTestWindow.wmQueryOpen(VAR Msg : TMessage);
  BEGIN Msg.Result := 0; END;

  FUNCTION TTestWindow.CanClose : Boolean;
  BEGIN
    CanClose := MessageBox(hWindow, 'ShutDown should remain active '+
      'until Windows shuts down.  Terminate it anyway?',
      'ShutDown Message', mb_YesNo + mb_IconQuestion) = idYes;
  END;

  PROCEDURE TTestWindow.wmQueryEndSession(VAR Msg : TMessage);
  VAR
    CommandLine : ARRAY[0..144] OF Char;
    InstanceID  : THandle;
  BEGIN
    IF NOT DidShutDown THEN
      BEGIN
        MessageBox(hWindow, 'Running SHUTDOWN.BAT.  When it '+
          'finishes, exit Windows again', 'ShutDown Message',
          mb_Ok + mb_IconInformation);
        Msg.Result := 0;
        StrCopy(CommandLine, GetEnvVar('COMSPEC'));
        StrCat(CommandLine, ' /C SHUTDOWN.BAT');
        WinExec(CommandLine, sw_ShowNormal);
        DidShutDown := TRUE;
      END
    ELSE DefWndProc(Msg);
  END;

  PROCEDURE TMyApplication.InitMainWindow;
  BEGIN
    MainWindow := New(PTestWindow, Init(Nil, AppName));
  END;

VAR MyApp: TMyApplication;
BEGIN
  cmdShow := SW_ShowMinimized;
  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
END.
