/*--------------------------------------------
   ENDJOIN.C -- Geometric Line Ends and Joins
                (c) Charles Petzold, 1993
  --------------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>

void DrawFigure (HPS hps, int i, SHORT cxClient, SHORT cyClient)
     {
     POINTL ptl ;

     ptl.x = (1 + 10 * i) * cxClient / 30 ;
     ptl.y = 3 * cyClient / 4 ;
     GpiMove (hps, &ptl) ;

     ptl.x = (5 + 10 * i) * cxClient / 30 ;
     ptl.y = cyClient / 4 ;
     GpiLine (hps, &ptl) ;

     ptl.x = (9 + 10 * i) * cxClient / 30 ;
     ptl.y = 3 * cyClient / 4 ;
     GpiLine (hps, &ptl) ;
     }

void PaintClient (HPS hps, SHORT cxClient, SHORT cyClient)
     {
     static LONG alJoin [] = { LINEJOIN_BEVEL, LINEJOIN_ROUND, LINEJOIN_MITRE },
                 alEnd  [] = { LINEEND_FLAT, LINEEND_SQUARE, LINEEND_ROUND } ;
     int         i ;

     for (i = 0 ; i < 3 ; i++)
          {
                    // Draw the geometric line

          GpiSetLineJoin (hps, alJoin [i]) ;
          GpiSetLineEnd  (hps, alEnd  [i]) ;
          GpiSetLineWidthGeom (hps, cxClient / 20) ;
          GpiSetPattern (hps, PATSYM_HALFTONE) ;

          GpiBeginPath (hps, 1) ;
          DrawFigure (hps, i, cxClient, cyClient) ;
          GpiEndPath (hps) ;

          GpiStrokePath (hps, 1, 0) ;

                    // Draw the cosmetic line

          GpiSetLineWidth (hps, LINEWIDTH_THICK) ;

          DrawFigure (hps, i, cxClient, cyClient) ;
          }
     }
