/*
 * This file is part of Utiliteez v1.00.R1
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but without any warranty; without even the implied warranty of
 * merchantability or fitness for a particular purpose. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#pragma warn -ofp
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <dir.h>
#include <time.h>
#include <ctype.h>

#define MAXLINE   513
#define _VERSION  "v1.0"
#define isspec(c) strchr( "+*;.?", (c) )


int
main( argc, argv )
	 int  argc;
	char *argv[];
{
	FILE *fin, *fout;
	char buf[MAXLINE], path[MAXPATH], s[MAXLINE], tmstr[15],
		 fname[MAXFILE+MAXEXT], *p;
	struct stat info;

	strlwr( *argv );

	fprintf( stderr, "std2ext %s Copyright (c) 1995-1997 Branislav L. Slantchev [%s]\n\n",
				_VERSION, __DATE__ );

	/* check for enough command line arguments */
	if( 3 != --argc )
	{
		fprintf(stderr, "usage: std2ext <files.bbs> <filepath> <output>\n");
		exit( EXIT_FAILURE );
	}

	strlwr( *(argv+2) );

	/* open listing file */
	if( !(fin = fopen( *(argv+1), "r" )) )
	{
		fprintf( stderr, "%s: couldn't open '%s'", *argv, *(argv+1) );
		exit( EXIT_FAILURE );
	}

	/* create the output file */
	if( !(fout = fopen( *(argv+3), "w")) )
	{
		fprintf( stderr, "%s: couldn't create '%s'", *argv, *(argv+3) );
		fclose( fin );
		exit( EXIT_FAILURE );
	}

	/* read line by line and process */
	fprintf( stderr, "Massaging '%s'...", argv[1] );
	for( ;; )
	{
		if( !fgets( buf, MAXLINE, fin ) ) break;

		/* just a description, copy it verbatim */
		if( isspace(buf[0]) || isspec(buf[0]) )
		{
			fputs( buf, fout );
			continue;
		}

		/* check for file name */
		sscanf( buf, "%12s", fname );
		sprintf( path, "%s/%s", *(argv+2),  strlwr(fname) );
		if( -1 == stat(path, &info) )
		{
			fprintf( stderr, "%s: warning: '%s' not found, skipped.\n",
				*argv, path );
			fputs( buf, fout );
			continue;
		}

		/* we have the statistics, create the output string */
		strftime( tmstr, 9, "%m/%d/%y", localtime( &info.st_ctime ) );
		p = strchr( buf, ' ' );	*p = '\0';
		for( ++p; isspace(*p); ++p ) ;
		sprintf( s, "%-12s %8ld %s %s", buf, info.st_size, tmstr, p );
		fputs( s, fout );
	}

	/* cleanup */
	fclose( fin );
	fclose( fout );

	fprintf( stderr, "Done!\n" );
	return 0;
}
