/*
 * This file is part of Utiliteez v1.00.R1
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but without any warranty; without even the implied warranty of
 * merchantability or fitness for a particular purpose. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#include "pb_sdk.h"

#ifndef EOS
	#define EOS '\0'
#endif

/*
 * searches for s2 in s1, not case sensitive
*/
char*
stristr( const char *s1, const char *s2 )
{
	char first = toupper(*s2);
	size_t len = strlen(s2);

	for( ; toupper(*s1) != first || strnicmp(s1,s2,len); ++s1 )
		if( EOS == *s1 ) return NULL;
	return (char *)s1;
}

void
main(int argc, char *argv[])
{
	char command[512];

	/* just some safety checking here */
	if( 1 == argc ){
		Log(LOG_FRIEND, "runexe: no parameters specified!");
		return;
	}

	/* you can run batch files too... these a a bit
	 * different in terms that you have to load a
	 * copy of COMMAND.COM to execute them. We will
	 * simply scan the command line for a .BAT or .CMD (for OS/2)
	 * extension and make sure we use the *Z parameter in
	 * the command line (which will ensure a command.com copy)
	*/
	if( stristr(argv[1], ".bat") || stristr(argv[1], ".cmd") )
		strcpy(command, "*Z");
	else command[0] = EOS;

	/* since separate arguments are passed separately, we
	* will collect them all here in our command line:
	*/
	for( int i = 1; i < argc; ++i ){
		/* this is needed to ensure at least one whitespace */
		sprintf(&command[strlen(command)], " %s", argv[i]);
	}

	Log(LOG_FRIEND, "runexe: exec '%s'", command);
	MenuFunction(MENU_SHELL, command);
}
