/*
 * This file is part of Utiliteez v1.00.R1
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but without any warranty; without even the implied warranty of
 * merchantability or fitness for a particular purpose. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#define CRC32POLY 0xedb88320L
#include <stdio.h>

const char header[] ="\
/*\n\
 ANSI X3.66 32-bit CRC checksum calculation\n\
 Copyright (C) 1995 by Branislav L. Slantchev\n\
\n\
 This file was generated by the CRCTAB program\n\
 Copyright (C) 1995-1997 by Branislav L. Slantchev\n\
\n\
 CRC32 is free software; you can redistribute it and/or modify\n\
 it under the terms of the GNU General Public License as published by\n\
 the Free Software Foundation; version 2.\n\
\n\
 CRC32 is distributed in the hope that it will be useful,\n\
 but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
 GNU General Public License for more details.\n\
\n\
 You should have received a copy of the GNU General Public License\n\
 along with CRC32; see the file COPYING.  If not, write to the\n\
 Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.\n\
*/\n\n/*\n\
 * This is an implementation of the ANSI X3.66 32-bit CRC checksum\n\
 * The polynomial is 0x14C11DB7 (the same used in PKZip and Ethernet)\n\
 * and the reversed value used here 0xEDB88320. Note that when using\n\
 * the updateCRC32 macro, you will need to initialize the crc to -1L\n\
 * (0xFFFFFFFF) and, when done invert the result: ~crc. This is the CRC.\n\
 * You can, of course, XOR the crc with the start mask, 0xFFFFFFFF, but\n\
 * this will give you the same result (of course).\n\
*/\n\n";

#define _VERSION "v1.0"

int
main(void)
{
	int i, j;
	unsigned long crc;
	char *name = "CRC32TAB.CPP";
	FILE *fp;

	fprintf(stderr, "crctab %s Copyright (c) 1995-1997 Branislav L. Slantchev [%s]\n\n",
		_VERSION, __DATE__);

	fp = fopen( name, "w" );
	if( !fp ) return 1;

	fprintf( fp, header );
	fprintf( fp, "/*\n * 32-bit CRC table based on the polynomial 0x%lX\n*/\n", CRC32POLY );
	fprintf( fp, "static unsigned long tblCRC32[256] = {" );

	for( i = 0; i < 256; i++ ){
		crc = (unsigned long)i;
		for( j = 0; j < 8; j++ ){
			if( crc & 1 )
				crc = (crc >> 1) ^ CRC32POLY;
			else
				crc >>= 1;
		}
		if( !(i % 6) ) fprintf( fp, "\n" );
		fprintf( fp, "0x%08lxL%c ", crc, (i < 255) ? ',' : ' ' );
	}

	fprintf( fp, "\n};\n" );
	fprintf( fp, "\n/*\n * Updates the CRC with a single byte\n*/" );
	fprintf( fp, "\n#define updateCRC32(b,crc) \\\n"
	"\t\t( tblCRC32[(int)((crc)^(b)) & 0xFF]^(((crc) >> 8) & 0x00FFFFFFL) )\n\n" );
	fclose( fp );

	fprintf(stderr, "Saved as '%s'\n", name);
	return 0;
}
