unit Qr20ssbc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, QRPrntr, Quickrpt, QR2Const, ssBC;

type
  TQR20ssBarcode = class(TQRPrintable)
  private
    FBarcode : TssBarcode;

  protected
    procedure Notification( AComponent: TComponent; Operation: TOperation); override;
    procedure SetBarcode(Value : TssBarcode);
    constructor Create(AOwner : TComponent); override;
  public
    procedure Print(PX,PY : integer); override;
    procedure Paint; override;
  published
    property Barcode : TssBarcode read FBarcode write SetBarcode;
  end;

procedure Register;

implementation

constructor TQR20ssBarcode.Create(AOwner : TComponent);

begin
  inherited Create(AOwner);
  Width:=200;
  Height:=200;
end;

procedure TQR20ssBarcode.SetBarcode(Value : TssBarcode);

begin
  FBarcode := Value;
  Invalidate;
end;

procedure TQR20ssBarcode.Paint;

begin
  if Assigned(FBarcode) then
  begin
    Width := FBarCode.Width;
    Height := FBarcode.Height;
    try
      FBarcode.DataBits := FBarcode.CreateDatabits(Screen.PixelsPerInch);
      FBarcode.AODataBits := FBarcode.CreateAODatabits(Screen.PixelsPerInch);
    finally
      FBarcode.DrawBarcode(Self.Canvas,0,0, Screen.PixelsPerInch);
    end;
  end
  else
  begin
    if (csDesigning in ComponentState) then
    with Canvas do
    begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
      Pen.Style := psDash;
      Brush.Style := bsClear;
      Rectangle(0, 0, Width, Height);
      Pen.Style := psSolid;
    end;
  end;
end;


procedure TQR20ssBarcode.Print(PX,PY : integer);
var
  InchX, InchY : single;
  PrnX, PrnY : integer;
  POffset : TPoint;

begin
  InchX := GetDeviceCaps(QRPrinter.Canvas.Handle, LOGPIXELSX);
  if Assigned(FBarcode) then
  begin
    try
      FBarcode.CodeHeight := 0;
      FBarcode.DataBits := FBarcode.CreateDatabits(InchX);
      FBarcode.AODataBits := FBarcode.CreateAODatabits(InchX);
    finally
      FBarcode.DrawBarcode(QRPrinter.Canvas,QRPrinter.XPos(PX+Size.Left), QRPrinter.YPos(PY+Size.Top), InchX);
    end;
  end;
end;

procedure TQR20ssBarcode.Notification(AComponent: TComponent; Operation: TOperation);

begin
  inherited Notification(AComponent, Operation);
  if (Operation=opRemove) and (AComponent=FBarcode) then
    SetBarcode(nil);
end;

procedure Register;
begin
  RegisterComponents('Soft Sector', [TQR20ssBarcode]);
end;

end.
