; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;  Example configurationfile for User Registration Door 1.02b
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : REGISTRATIONKEY
; Purpose : Enter here the registrationkey you received with registering
;           the program.

RegistrationKey = 0


; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : ANSWERFILE
; Purpose : Defines the name of Answer File where the answers of the users
;           have to be written. You must specifify the full path and file-
;           name. If none is supplied, URD will use/create NEWUSER.ASW in
;           the RA system directory.

AnswerFile = C:\RA\NEWUSER.ASW


; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : ANSWERED
; Purpose : This keyword defines the start of the section that describes
;           how URD has to update the user when he/she has fineshed the
;           questionnaire correctly.
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : AFLAGS, BFLAGS, CFLAGS, DFLAGS
; Purpose : Sets or resets the flags. The flags are numbered from 1 to 8.
;           You can use the following characters :
;
;             -  Flag is not affected
;             1  Flag is set
;             0  Flag is reset
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : UPDATELEVEL
; Purpose : Updates the securitylevel of the user. The format of this line
;           is :
;
;             UpdateLevel <old level>,<new level>,<timeleft>
;
;           <old level>  : The level of the user before he started the
;                          registration.
;           <new level>  : The level he will get AFTER completing the
;                          registration.
;           <timeleft>   : If the users level was updated due to this
;                          statement, his timelimit will be set to this
;                          value.
;
;           You can use this line as often as you want. It's only limited by
;           the amount of memory you have available. The level of the user
;           is only updated when an exact match can be made. If you don't
;           want to use the level update or timeleft update, make them zero.
;           For example : UpdateLevel 10,20,0  or  UpdateLevel 10,0,30
;           If <old level> is zero, the statement will be ignored.
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : LOCKOUT
; Purpose : Locks out the user when he/she doesn't want to anser you
;           questionnaire. The securitylevel of the user will be lowered to
;           zero (0) and the call will be terminated. A LOCKOUT will
;           override a DELETE if they are used both. This keyword can only
;           be used in the NOTANSWERED section.
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : DELETE
; Purpose : Deletes the user from the userbase if he/she doesn't want to
;           answer your questionnaire. After deleting the user the call
;           be terminated. This keyword can only be used in the NOTANSWERED
;           section.
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : HANGUP
; Purpose : Terminates the call if the user don't want to answer your
;           questionnaire. This keyword can be only be used in the
;           NOTANSWERED section.
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : END
; Purpose : The section must be ended with an END keyword
;

Answered
  AFlags = 1-------
  BFlags = --------
  CFlags = --------
  DFlags = --------
  UpdateLevel = 10,15,30
End


; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Keyword : NOTANSWERED
; Purpose : This keyword defines the start of the section that describes
;           how URD has to update the user when it doesn't wanted to
;           answer the question. You can use the same keywords as with
;           ANSWERED.

NotAnswered
  AFlags = 0-------
  BFlags = --------
  CFlags = --------
  DFlags = --------
  UpdateLevel = 10,5,15
  Lockout
End


; NOTE: A keyword like "DFLAGS = --------" may also be left out. URD won't
;       change the flags by default.
; <EOF>