#include <sys\stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "ubbsstr.h"
#include <x32.h>

struct   filerecord  frec[100];
struct   confrecord  crec;

typedef struct
{
   char  *file;
   char  *descrip;
   char  *uploadedby;
   long  dateoful;
   long  filesize;
   short timesdled;
}  rec_struc;

struct
{
   rec_struc   *files;
   unsigned long  total_size;
   unsigned long  file_count;
}  *confs;

struct
{
   char  id[5];
   char  *descrip;
}  id_descrip[300];

struct
{
   unsigned long  size;
   unsigned long  count;
}  *confnew;

char  *p1, *p2, buffer[256], filebase[80], confdata[80], bbsname[80];
char  file_size[80];

char  listname[80], dirname[80], newname[80];

int   i, handle, x, max_names, sec, j;
char  uploader, dirlist;
long  newfiles;
long  tot_length, cur_pos, startmem, totnewcount;
double   tot_size, mod, mod2, totnewsize;
FILE  *fo1, *fo2, *fo3;
struct tm   *t;

int   sort_func(const void *a, const void *b)
{
   static   int   x = 0;
   static   int   count = 0;

   if (++count == 100)
   {
      switch(++x)
      {
         case  1:
            printf("\b/");
            break;
         case  2:
            printf("\b-");
            break;
         case  3:
            printf("\b\\");
            break;
         case  4:
            printf("\b|");
            x = 0;
            break;
      }
      count = 0;
   }
   return(strcmp(*(char **)a, *(char **)b));
}

void  printtotal(FILE *fo, double size, long count)
{
   fprintf(fo, "\n");

   file_size[0] = 0;
   do
   {
      mod = fmod(size, 1000.0);
      tot_length = mod;
      sprintf(buffer, "%03d", tot_length);
      size -= mod;
      size /= 1000.0;
      strrev(buffer);
      strcat(file_size, buffer);
   }
   while(size > 0);

   strrev(file_size);
   while(file_size[0] == '0')
      strcpy(file_size, file_size+1);
   p1 = file_size+strlen(file_size);
   while(p1 > file_size)
   {
      p1 -= 3;
      if (p1 > file_size)
      {
         memmove(p1+1, p1, strlen(p1)+1);
         *p1 = ',';
      }
   }
   fprintf(fo, " Totals: All Directories                           %8lu  %15.15s\n", count, file_size);
   fprintf(fo, "\n");
   fprintf(fo, "               Generated by UltraLst v1.1  Copyright 1994  B-Ware\n");
}

void  printtail(FILE *fo)
{
   fprintf(fo, "Summary of Directories:\n");
   fprintf(fo, "\n");
   fprintf(fo, "  #  Directory Name                                 Files        Bytes\n");
   fprintf(fo, "\n");
}

void  printheader(FILE *fo, int i)
{
   fprintf(fo, "\n");
   fprintf(fo, "File Directory # %d", x+1);
   if (id_descrip[i].descrip)
      fprintf(fo, ": %s\n", id_descrip[i].descrip);
   else
      fprintf(fo, "\n");
   fprintf(fo, "\n");
}

void  printfile(FILE *fo, int x, int i)
{
   t = localtime(&confs[x].files[i].dateoful);
   sprintf(file_size, "%lu", confs[x].files[i].filesize);
   p1 = file_size+strlen(file_size);
   while(p1 > file_size)
   {
      p1 -= 3;
      if (p1 > file_size)
      {
         memmove(p1+1, p1, strlen(p1)+1);
         *p1 = ',';
      }
   }
   if (strlen(confs[x].files[i].descrip) > 45)
   {
      strncpy(buffer, confs[x].files[i].descrip, 45);
      buffer[45] = NULL;
      p1 = &buffer[strlen(buffer)];
      while(*(--p1) == ' ')
      ;
      *(++p1) = NULL;
      p1 = confs[x].files[i].descrip+45;
      fprintf(fo, "%-12.12s %10.10s %02d/%02d/%02d %s\n", confs[x].files[i].file, file_size, t->tm_mon+1, t->tm_mday, t->tm_year, buffer);
      while(strlen(p1) > 45)
      {
         strncpy(buffer, p1, 45);
         buffer[45] = NULL;
         p2 = &buffer[strlen(buffer)];
         while(*(--p2) == ' ')
         ;
         *(++p2) = NULL;
         fprintf(fo, "%-32.32c %s\n", ' ', buffer);
         p1+=45;
      }
      fprintf(fo, "%-32.32c %s\n", ' ', p1);
      if (uploader)
         fprintf(fo, "%-32.32c -Uploaded By: %s (%d)\n", ' ', strlen(confs[x].files[i].uploadedby) ? confs[x].files[i].uploadedby : "UNKNOWN", confs[x].files[i].timesdled);
   }
   else
      if (strlen(confs[x].files[i].descrip))
      {
         fprintf(fo, "%-12.12s %10.10s %02d/%02d/%02d %s\n", confs[x].files[i].file, file_size, t->tm_mon+1, t->tm_mday, t->tm_year, confs[x].files[i].descrip);
         if (uploader)
            fprintf(fo, "%-32.32c -Uploaded By: %s (%d)\n", ' ', strlen(confs[x].files[i].uploadedby) ? confs[x].files[i].uploadedby : "UNKNOWN", confs[x].files[i].timesdled);
      }
      else
      {
         if (uploader)
            fprintf(fo, "%-12.12s %10.10s %02d/%02d/%02d -Uploaded By: %s (%d)\n", confs[x].files[i].file, file_size, t->tm_mon+1, t->tm_mday, t->tm_year, strlen(confs[x].files[i].uploadedby) ? confs[x].files[i].uploadedby : "UNKNOWN", confs[x].files[i].timesdled);
         else
            fprintf(fo, "%-12.12s %10.10s %02d/%02d/%02d\n", confs[x].files[i].file, file_size, t->tm_mon+1, t->tm_mday, t->tm_year);
      }
}

main(int argc, char *argv[])
{
   if (argc < 4)
   {
      printf("Command Line:\nULTRALST <ultralst config file> <ubbs.dat path\\filename> <conf #> <sec>");
      exit(1);
   }
   startmem = _x32_coreleft();
   if ((fo1 = fdopen(sopen(argv[2], O_RDWR, SH_DENYNO, S_IREAD|S_IWRITE), "rt")) == NULL)
   {
      printf("Error opening %s", argv[1]);
      exit(1);
   }
   sec = atoi(argv[4]);
   for (i = 0; i < 65; i++)
   {
      fgets(buffer, 256, fo1);
      if (i == 0)
      {
         if (strncmp(buffer, "UBBS", 4) != NULL)
         {
            printf("This program only works with UltraBBS 3.0x and up!");
            exit(1);
         }
      }
      if (i == 40)
      {
         buffer[strlen(buffer)-1] = NULL;
         sprintf(filebase, "%s.DAT", buffer);
      }
      if (i == 42)
      {
         buffer[strlen(buffer)-1] = NULL;
         strcpy(confdata, buffer);
      }
      if (i == 60)
      {
         buffer[strlen(buffer)-1] = NULL;
         strcpy(bbsname, buffer);
      }
   }
   fclose(fo1);
   if ((fo1 = fdopen(sopen(argv[1], O_RDWR, SH_DENYNO, S_IREAD|S_IWRITE), "rt")) == NULL)
      printf("Error opening %s\n", argv[1]);
   else
   {
      i = 0;
      while(fgets(buffer, 256, fo1))
      {
         if (buffer[0] == ';')
            continue;
         strupr(buffer);
         p1 = buffer+strlen(buffer)-1;
         while(*--p1 == ' ')
         ;
         *++p1 = 0;
         while(*buffer == ' ')
            strcpy(buffer, buffer+1);
         if (strncmp(buffer, "LISTNAME:", 9) == NULL)
         {
            p1 = buffer+8;
            while(*++p1 == ' ')
            ;
            strcpy(listname, p1);
            p1 = strchr(listname, ' ');
            if (p1)
               *p1 = 0;
            continue;
         }
         if (strncmp(buffer, "DIRLISTS:", 9) == NULL)
         {
            p1 = buffer+8;
            while(*++p1 == ' ')
            ;
            dirlist = (*p1 == 'Y');
            continue;
         }
         if (strncmp(buffer, "DIRNAME:", 8) == NULL)
         {
            p1 = buffer+7;
            while(*++p1 == ' ')
            ;
            strcpy(dirname, p1);
            p1 = strchr(dirname, ' ');
            if (p1)
               *p1 = 0;
            continue;
         }
         if (strncmp(buffer, "NEWFILES:", 9) == NULL)
         {
            p1 = buffer+8;
            while(*++p1 == ' ')
            ;
            newfiles = atol(p1);
            if (newfiles)
            {
               newfiles = time(NULL) - (newfiles*86400l);
               t = localtime(&newfiles);
               t->tm_hour = t->tm_min = t->tm_sec = 0;
               newfiles = mktime(t);
            }
            continue;
         }
         if (strncmp(buffer, "NEWNAME:", 8) == NULL)
         {
            p1 = buffer+7;
            while(*++p1 == ' ')
            ;
            strcpy(newname, p1);
            p1 = strchr(newname, ' ');
            if (p1)
               *p1 = 0;
            continue;
         }
         if (strncmp(buffer, "UPLDBY:", 7) == NULL)
         {
            p1 = buffer+6;
            while(*++p1 == ' ')
            ;
            uploader = (*p1 == 'Y');
            continue;
         }
         if (strlen(buffer) && buffer[4] == ' ')
         {
            strncpy(id_descrip[i].id, buffer, 4);
            p1 = id_descrip[i].id+4;
            while(*--p1 == ' ')
            ;
            *++p1 = 0;
            strupr(id_descrip[i].id);
            id_descrip[i++].descrip = strdup(buffer+5);
         }
      }
      fclose(fo1);
   }
   if ((handle = sopen(confdata, O_RDWR, SH_DENYNO, S_IREAD|S_IWRITE)) == -1)
   {
      printf("Error opening %s", confdata);
      exit(1);
   }
   lseek(handle, atoi(argv[3])*sizeof(crec), SEEK_SET);
   read(handle, &crec, sizeof(crec));
   close(handle);
   if ((handle = sopen(filebase, O_RDWR, SH_DENYNO, S_IREAD|S_IWRITE)) == -1)
   {
      printf("Error opening %s", filebase);
      exit(1);
   }
   tot_length = filelength(handle);
   if ((confs = calloc(1, sizeof(*confs) * crec.maxdir)) == NULL)
   {
      printf("Error allocating memory for file records");
      exit(1);
   }
   for (x = 0; x < crec.maxdir; x++)
   {
      if ((confs[x].files = calloc(1, sizeof(rec_struc))) == NULL)
      {
         printf("Error allocating memory for file records");
         exit(1);
      }
   }
   if (newfiles)
   {
      if ((confnew = calloc(1, sizeof(*confnew) * crec.maxdir)) == NULL)
      {
         printf("Error allocating memory for new file records");
         exit(1);
      }
   }
   while(1)
   {
      if (cur_pos + sizeof(frec) < tot_length)
      {
         read(handle, &frec, sizeof(frec));
         for (i = 0; i < 100; i++)
         {
				if (!frec[i].f.deleteflag)
            {
	            for (x = 0; x < crec.maxdir; x++)
   	         {
      	         if((crec.dir[x].dirsec <= sec) &&
         	         (strcmp((char *)frec[i].id, crec.dir[x].dirid) == NULL))
            	   {
               	   p1 = (char *)&frec[i].descrip[strlen((char *)frec[i].descrip)];
                  	if (p1 - (char *)frec[i].descrip > 449)
                     	p1 = (char *)frec[i].descrip+449;
	                  while(*(--p1) == ' ')
   	               ;
      	            *(++p1) = NULL;
         	         confs[x].files[confs[x].file_count].file = strdup((char *)frec[i].file);
            	      confs[x].files[confs[x].file_count].descrip = strdup((char *)frec[i].descrip);
               	   confs[x].files[confs[x].file_count].uploadedby = strdup((char *)frec[i].uploadedby);
	                  confs[x].files[confs[x].file_count].dateoful = frec[i].dateoful;
   	               confs[x].files[confs[x].file_count].filesize = frec[i].filesize;
      	            confs[x].files[confs[x].file_count++].timesdled = frec[i].timesdled;
         	         confs[x].total_size += frec[i].filesize;
            	      if ((confs[x].files = realloc(confs[x].files, sizeof(*(confs[x].files)) * (confs[x].file_count+1))) == NULL)
               	   {
	                     printf("Error allocating memory for file records");
   	                  exit(1);
      	            }
         	         max_names++;
            	      break;
               	}
	            }
				}
         }
         cur_pos = lseek(handle, 0, SEEK_CUR);
         printf("Reading: %d %d %d\r", cur_pos / sizeof(*frec), max_names, startmem - _x32_coreleft());
      }
      else
      {
         read(handle, &frec, (unsigned)(sizeof(*frec) * ((tot_length - cur_pos) / sizeof(*frec))));
         for (i = 0; i < (tot_length - cur_pos) / sizeof(*frec); i++)
         {
				if (!frec[i].f.deleteflag)
            {
	            for (x = 0; x < crec.maxdir; x++)
   	         {
      	         if((crec.dir[x].dirsec <= sec) &&
         	         (strcmp((char *)frec[i].id, crec.dir[x].dirid) == NULL))
            	   {
               	   p1 = (char *)&frec[i].descrip[strlen((char *)frec[i].descrip)];
                  	if (p1 - (char *)frec[i].descrip > 449)
                     	p1 = (char *)frec[i].descrip+449;
	                  while(*(--p1) == ' ')
   	               ;
      	            *(++p1) = NULL;
         	         confs[x].files[confs[x].file_count].file = strdup((char *)frec[i].file);
            	      confs[x].files[confs[x].file_count].descrip = strdup((char *)frec[i].descrip);
               	   confs[x].files[confs[x].file_count].uploadedby = strdup((char *)frec[i].uploadedby);
                  	confs[x].files[confs[x].file_count].dateoful = frec[i].dateoful;
	                  confs[x].files[confs[x].file_count].filesize = frec[i].filesize;
   	               confs[x].files[confs[x].file_count++].timesdled = frec[i].timesdled;
      	            confs[x].total_size += frec[i].filesize;
         	         if ((confs[x].files = realloc(confs[x].files, sizeof(*(confs[x].files)) * (confs[x].file_count+1))) == NULL)
            	      {
               	      printf("Error allocating memory for file records");
                  	   exit(1);
	                  }
   	               max_names++;
      	            break;
         	      }
	            }
				}
         }
         cur_pos = lseek(handle, 0, SEEK_CUR);
         printf("Reading: %d %d %d\n", cur_pos / sizeof(*frec), max_names, startmem - _x32_coreleft());
         break;
      }
   }
   close(handle);
   printf("Sorting: |");
   for (x = 0; x < crec.maxdir; x++)
      if (crec.dir[x].dirsec <= sec)
         qsort(confs[x].files, confs[x].file_count, sizeof(rec_struc), sort_func);
   printf("\n");
   if ((fo1 = fopen(listname, "wt")) == NULL)
   {
      printf("Error opening %s", listname);
      exit(1);
   }
   fprintf(fo1, "               Generated by UltraLst v1.1  Copyright 1994  B-Ware\n");
   sprintf(buffer, "%s Master File List (%s Conference)", bbsname, crec.confname);
	if (strlen(buffer)<79)
		fprintf(fo1, "%*c%s\n\n", (80-strlen(buffer))/2, ' ', buffer);
   else
   	fprintf(fo1, "%s\n\n", buffer);
   if (newfiles)
   {
      if ((fo2 = fopen(newname, "wt")) == NULL)
      {
         printf("Error opening %s", newname);
         exit(1);
      }
      fprintf(fo2, "               Generated by UltraLst v1.1  Copyright 1994  B-Ware\n");
      sprintf(buffer, "%s New File List (%s Conference)", bbsname, crec.confname);
		if (strlen(buffer)<79)
	      fprintf(fo2, "%*c%s\n", (80-strlen(buffer))/2, ' ', buffer);
      else
      	fprintf(fo2, "%s\n", buffer);
		tot_length = time(NULL);
		t = localtime(&tot_length);
		sprintf(file_size, "%02d/%02d/%02d", t->tm_mon+1, t->tm_mday, t->tm_year);
      t = localtime(&newfiles);
		sprintf(buffer, "From %02d/%02d/%02d to %s", t->tm_mon+1, t->tm_mday, t->tm_year, file_size);
		if (strlen(buffer)<79)
      	fprintf(fo2, "%*c%s\n\n", (80-strlen(buffer))/2, ' ', buffer);
      else
      	fprintf(fo2, "%s\n\n", buffer);
   }
   fo3 = NULL;
   for (x = 0; x < crec.maxdir; x++)
   {
      if (crec.dir[x].dirsec <= sec)
      {
         if (dirlist)
         {
            if (fo3 != NULL)
            {
               fclose(fo3);
               fo3 = NULL;
            }
            sprintf(buffer, "%03d", x+1);
            strcpy(file_size, dirname);
            p1 = p2 = file_size;
            while(p1)
            {
               if (*(p1+1) == '#' && *(p1+2) == '#')
               {
                  p2 = buffer;
                  *p1++ = *p2++;
                  *p1++ = *p2++;
                  *p1++ = *p2++;
                  break;
               }
               p1 = strchr(p2, '#');
               p2 = p1+1;
            }
            if (!p1)
            {
               printf("Invalid file directory listing filename!\n");
               dirlist = 0;
            }
            else
            {
               if ((fo3 = fopen(file_size, "wt")) == NULL)
               {
                  printf("Error opening %s", file_size);
                  exit(1);
               }
               fprintf(fo3, "               Generated by UltraLst v1.1  Copyright 1994  B-Ware\n");
               sprintf(buffer, "%s File Directory List (%s Conference)", bbsname, crec.confname);
					if (strlen(buffer)<79)
						fprintf(fo3, "%*c%s\n\n", (80-strlen(buffer))/2, ' ', buffer);
               else
               	fprintf(fo3, "%s\n\n", buffer);
            }
         }
         printf("Dir: %-4.4s\r", crec.dir[x].dirid);
         j = 0;
         while(id_descrip[j].descrip)
         {
            if (strcmp(crec.dir[x].dirid, id_descrip[j].id) == NULL)
               break;
            j++;
         }
         printheader(fo1, j);
         if (dirlist)
            printheader(fo3, j);
         for (i = 0; i < confs[x].file_count; i++)
         {
            printfile(fo1, x, i);
            if (newfiles && newfiles <= confs[x].files[i].dateoful)
            {
               totnewcount++;
               totnewsize += confs[x].files[i].filesize;
               if (!confnew[x].count)
                  printheader(fo2, j);
               confnew[x].count++;
               confnew[x].size += confs[x].files[i].filesize;
               printfile(fo2, x, i);
            }
            if (dirlist)
               printfile(fo3, x, i);
         }
         if (confs[x].file_count)
         {
            fprintf(fo1, "File Stats:\n");
            fprintf(fo1, "%d Files, Totaling ", confs[x].file_count);
            sprintf(file_size, "%d", confs[x].total_size);
            p1 = file_size+strlen(file_size);
            while(p1 > file_size)
            {
               p1 -= 3;
               if (p1 > file_size)
               {
                  memmove(p1+1, p1, strlen(p1)+1);
                  *p1 = ',';
               }
            }
            fprintf(fo1, "%s bytes\n\n", file_size);
            if (dirlist)
            {
               fprintf(fo3, "File Stats:\n");
               fprintf(fo3, "%d Files, Totaling ", confs[x].file_count);
               sprintf(file_size, "%d", confs[x].total_size);
               p1 = file_size+strlen(file_size);
               while(p1 > file_size)
               {
                  p1 -= 3;
                  if (p1 > file_size)
                  {
                     memmove(p1+1, p1, strlen(p1)+1);
                     *p1 = ',';
                  }
               }
               fprintf(fo3, "%s bytes\n\n", file_size);
            }
         }
         if (newfiles && confnew[x].count)
         {
            fprintf(fo2, "File Stats:\n");
            fprintf(fo2, "%d Files, Totaling ", confnew[x].count);
            sprintf(file_size, "%d", confnew[x].size);
            p1 = file_size+strlen(file_size);
            while(p1 > file_size)
            {
               p1 -= 3;
               if (p1 > file_size)
               {
                  memmove(p1+1, p1, strlen(p1)+1);
                  *p1 = ',';
               }
            }
            fprintf(fo2, "%s bytes\n\n", file_size);
         }
      }
   }
   printtail(fo1);
   if (newfiles)
      printtail(fo2);
   tot_size = cur_pos = 0;
   for (x = 0; x < crec.maxdir; x++)
   {
      if (crec.dir[x].dirsec <= sec)
      {
         i = 0;
         while(id_descrip[i].descrip)
         {
            if (strcmp(crec.dir[x].dirid, id_descrip[i].id) == NULL)
               break;
            i++;
         }
         sprintf(file_size, "%lu", confs[x].total_size);
         p1 = file_size+strlen(file_size);
         while(p1 > file_size)
         {
            p1 -= 3;
            if (p1 > file_size)
            {
               memmove(p1+1, p1, strlen(p1)+1);
               *p1 = ',';
            }
         }
         fprintf(fo1, "%3d  %-45.45s%8lu  %15.15s\n", x+1, (id_descrip[i].descrip) ? id_descrip[i].descrip:"", confs[x].file_count, file_size);
         tot_size += confs[x].total_size;
         cur_pos += confs[x].file_count;
         if (newfiles)
         {
            sprintf(file_size, "%lu", confnew[x].size);
            p1 = file_size+strlen(file_size);
            while(p1 > file_size)
            {
               p1 -= 3;
               if (p1 > file_size)
               {
                  memmove(p1+1, p1, strlen(p1)+1);
                  *p1 = ',';
               }
            }
            fprintf(fo2, "%3d  %-45.45s%8lu  %15.15s\n", x+1, (id_descrip[i].descrip) ? id_descrip[i].descrip:"", confnew[x].count, file_size);
         }
      }
   }
   printtotal(fo1, tot_size, cur_pos);
   fclose(fo1);
   if (newfiles)
   {
      printtotal(fo2, totnewsize, totnewcount);
      fclose(fo2);
   }
   if (dirlist && fo3)
      fclose(fo3);
   close(handle);
   tot_length = clock()/CLK_TCK;
   printf("\nRun Time: %02d:%02d:%02d\n", tot_length/3600, (tot_length%3600)/60, (tot_length%3600)%60);
   return(0);
}
