Program IsOut;

{ 1996 by Bo Bendtsen, free to use or modify }

Uses Dos;

Const
  MSGPRIVATE    = $0001; (* For addressee *ONLY*   :* 0000 0000 0000 0001 *)
  MSGCRASH	= $0002; (* High priority          :* 0000 0000 0000 0010 *)
  MSGREAD	= $0004; (* Was read by addressee  :* 0000 0000 0000 0100 *)
  MSGSENT	= $0008; (* Was sent by FidoMail   :: 0000 0000 0000 1000 *)
  MSGFILE	= $0010; (* SUBJ=file(s) to send   :* 0000 0000 0001 0000 *)
  MSGFWD	= $0020; (* Msg from & to elsewhere:: 0000 0000 0010 0000 *)
  MSGORPHAN	= $0040; (* Msg destination unknown:: 0000 0000 0100 0000 *)
  MSGKILL	= $0080; (* Delete after sending   :* 0000 0000 1000 0000 *)
  MSGLOCAL	= $0100; (* Msg is Local, not Net  :: 0000 0001 0000 0000 *)
  MSGHOLD	= $0200; (* Hold msg for pickup    :* 0000 0010 0000 0000 *)
  MSGXX2	= $0400; (* <reserved>             X? 0000 0100 0000 0000 *)
  MSGFRQ	= $0800; (* SUBJ=file(s) to get    :* 0000 1000 0000 0000 *)
  MSGRRQ	= $1000; (* Msg Receipt requested  X* 0001 0000 0000 0000 *)
  MSGCPT	= $2000; (* Msg is a Msg Receipt   X* 0010 0000 0000 0000 *)
  MSGARQ	= $4000; (* Audit Trail requested  X* 0100 0000 0000 0000 *)
  MSGURQ	= $8000; (* SUBJ=files(s) to UPD   X* 1000 0000 0000 0000 *)

Type

  Msgtype   =    Record
                   From_user   :  array[0..35] of char;
                   To_user     :  array[0..35] of char;
                   Subject     :  array[0..71] of char;
                   Date_time   :  array[0..19] of char;
                   Times_read  :  word;
                   Destnode    :  word;
                   Orignode    :  word;
                   Cost        :  word;
                   Orignet     :  word;
                   Destnet     :  word;
                   Fill        :  array[0..7] of char;
                   replyto     :  word;
                   Mess_attr   :  word;
                   Next_reply  :  word;
                  end;


  Charset    = Set of char;
  AddrRecord = Record
                 Zone,Net,Node,Point : Word;
               End;
Var
  Txtsize: Word;
  Txt : Array[1..32000] of Char;
  T           : Text;
  Tmp,Tmp2    : String;
  OurZone     : Word;
  Whoto,
  Node        : String[30];
  Outbound    : String[79];
  FDNetmail   : String[79];
  EraseAfter  : Boolean;
  Crash       : Boolean;
  Remove      : Boolean;
  I           : SearchRec;
  Found       : Boolean;
  Path        : String[79];
  Filetosend  : String[79];
  FromName    : String[35];
  ToName      : String[35];

{----------------------------------------------------------------------------}

  Procedure CopyS(Var ToS:String; FromS : String; ToLength:Byte);
  Begin
    ToS:=Copy(FromS,1,ToLength);
  End;

  Function IntToStr(i: LongInt): String;
  Var
    S    : String[11];
  Begin
    Str(i, S); IntToStr := S;
  End;

  Function BlankAfter(S : String; Len : Byte): String;
  var
    o : string;
    SLen : Byte absolute S;
  Begin
    {   Txt:=Copy(Txt,1,Lgd); }    { ndret 17/9 }
    { While Length(Txt)<Lgd Do Txt:=Txt+' '; }
    { ndret 14/4-93 fra FX.PAS }
    if Length(S) >= Len then
      BlankAfter := S
    else begin
      o[0] := Chr(Len);
      Move(S[1], o[1], SLen);
      if SLen < 255 then
        FillChar(o[Succ(SLen)], Len-SLen, ' ');
      BlankAfter := o;
    end;
  End;

  function JustPathname(PathName : string) : string;
  const
    DosDelimSet : set of Char = ['\', ':', #0];
  var
    I : Word;
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);
    if I = 0 then
      JustPathname[0] := #0
    else if I = 1 then
      JustPathname := PathName[1]
    else if (PathName[I] = '\') then begin
      if PathName[Pred(I)] = ':' then
        JustPathname := Copy(PathName, 1, I)
      else
        JustPathname := Copy(PathName, 1, Pred(I));
    end else
      JustPathname := Copy(PathName, 1, I);
  end;

  Function StrToInt(S: String) : LongInt;
  Var
    Kode : Integer;
    i    : LongInt;
    R    : Real;
  Begin
    If s='' Then
    Begin
      StrToInt:=0;
      Exit;
    End;
    i:=1; While s[i] in ['-','0'..'9'] Do Inc(i);
    Delete(s,i,255);
    If Length(S) = 0 Then StrToInt := 0 Else Begin
      Val(S,i,Kode);
      If Kode = 0 Then StrToInt := i Else
      Begin
        Val(S,R,Kode);
        If (Kode = 0) And (R<MaxLongint) Then StrToInt := Trunc(R) Else StrToInt:=0;
      End;
    End;
  End;

  Function StripChars(Strip : String; ch : CharSet): String;
  Var
    b: byte;
  Begin
    b:=Length(Strip);
    While b>0 Do
    Begin
      If Strip[b] in ch Then Delete(Strip,b,1);
      Dec(b);
    End;
    StripChars:=Strip;
  End;

  Function ReplaceChars(S : String; Old:CharSet; New : Char): String;
  Var
    b : Byte;
  Begin
    For b:=1 to Length(S) Do If s[b] in Old Then s[b]:=New;
    ReplaceChars:=s;
  End;

  Procedure StringToNode(s:String; Var A:AddrRecord);
  Type
    Charset = Set of Char;
  Const
    Allchars    : Charset = [#0..#255];
  Var
    n:Byte;
  Begin
    If Pos('@',s)<>0 Then Delete(s,Pos('@',s),255);
    If s='' Then s:='0:0/0' Else s:=StripChars(s,Allchars-['0'..'9',':','/','.']);
    Fillchar(A,sizeof(A),0);
    n:=Pos(':',s);
    If n<>0 Then Begin A.Zone:=StrToInt(Copy(s,1,n-1)); Delete(s,1,n); End
    Else A.Zone:=Ourzone;
    If A.Zone>4096 Then A.Zone:=4096;
    n:=Pos('/',s);
    If n<>0 Then Begin A.Net:=StrToInt(Copy(s,1,n-1)); Delete(s,1,n); End
    Else Begin
    {  A.Net:=C.Users[1].Addr.Net; }
    End;
    n:=Pos('.',s);
    If n=0 Then A.Node:=StrToInt(s)
    Else Begin
      A.Node:=StrToInt(Copy(s,1,n-1));
      Delete(s,1,n);
      A.Point:=StrToInt(s);
    End;
  End;

  function JustFilename(PathName : string) : string;
  const
    DosDelimSet : set of Char = ['\', ':', #0];
  var
    I : Word;
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);
    JustFilename := Copy(PathName, Succ(I), 64);
  end;

  Function UpChar(Ch : Char) : Char;
  Begin
    If Ord(Ch) In [97..122] Then Ch := Chr(Ord(Ch) - 32)
    Else If Ord(Ch) > 90 Then
      If Ch='' Then Ch:=''
      Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
      Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
      Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
      Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:='';
    UpChar:=Ch;
  End;

  Function StUpCase(S : String) : String;
  Var
    SLen : Byte Absolute S;
    x    : Integer;
  Begin
    For x := 1 To SLen Do S[x]:=UpChar(S[x]);
    StUpCase := S;
  End;

  Function InWildCard(Input,Wild:String) : Boolean;
  Var
    p:byte;
    Procedure Convert(Var s:String);
    Var F:String[8]; E:String[3];
    Begin
      E:='   ';
      p:=Pos('.',s);
      If p<>0 Then CopyS(E,BlankAfter(Copy(s,p+1,255),3),3)
      Else p:=Length(s)+1;
      If Pos('*',E)<>0 Then CopyS(E,Copy(E,1,Pos('*',E))+ReplaceChars(Copy(E,Pos('*',E)+1,255),[#0..#255],'*'),3);
      CopyS(F,BlankAfter(Copy(s,1,p-1),8),8);
      If Pos('*',F)<>0 Then CopyS(F,Copy(F,1,Pos('*',F))+ReplaceChars(Copy(F,Pos('*',F)+1,255),[#0..#255],'*'),8);
      s:=F+E;
    End;
  Begin
    InWildCard:=False;
    If Stupcase(Input)=Stupcase(Wild) Then
    Begin
      InWildCard:=True;
      Exit;
    End;
    If (Input='') Or (Wild='') Or (Wild='.') Or (Length(Input)>12) Or (Length(Wild)>12) Or
       ( (Pos('*',Wild)=0) And (Pos('?',Wild)=0) And (Input<>Wild)) Then Exit;
    If Wild[1]='.' Then Insert('*',Wild,1);
    If (Wild='*.*') Or (Wild='*') Then
    Begin
      InWildCard:=True;
      Exit;
    End;
    Input:=StUpcase(Input); Wild:=StUpcase(Wild);
    If (Wild[1]='*') And (Wild[2]<>'.') Then
    Begin
      If Pos(Copy(Wild,2,255),Input)<>0 Then InWildCard:=True;
      Exit;
    End;
    Convert(Input);
    Convert(Wild);
    p:=1;
    While ((Input[p]=Wild[p]) or (Wild[p]='*') or ((Wild[p]='?') And
          (Input[p]<>' '))) And (p<12) Do Inc(p);
    If p=12 Then InWildCard:=True;
  End;

  Function  NodeToString(Addr : AddrRecord): String;
  Var s:String[6];
  Begin
    If Addr.Point=0 Then s:='' Else s:='.'+IntToStr(Addr.Point);
    NodeToString:=IntToStr(Addr.Zone)+':'+IntToStr(Addr.Net)+'/'+IntToStr(Addr.Node)+s;
  End;

  Function NextKludge(Var K:String;Var Mp:Longint):Boolean;
  Begin
    NextKludge:=False;
    K:='';
    While (Txt[Mp]<>#1) And (Mp<TxtSize) Do Inc(Mp);
    If ((Txt[Mp]=#1) And (Mp<=1)) Or ((Txt[Mp]=#1) And (Mp>1) And (Txt[Mp-1] in [#13,#10])) Then
    Begin
      Inc(Mp);
      While Not (Txt[Mp] in [#13,#10]) And (Length(K)<250) Do
      Begin
        NextKludge:=True;
        K:=K+Txt[Mp];
        Inc(Mp);
      End;
    End;
  End;

  Function IntToNulStr(i: LongInt;b:Byte): String;
  { Heltal->streng 40,3 = '040'  9,4 = '0009' etc.  }
  Var
    S    : String[11];
  Begin
    Str(i, S);
    While Length(S)<b Do S:='0'+S;
    If Length(S)>b Then S:='?'+Copy(S,Length(S)-b+2,10);
    IntToNulStr:=S;
  End;

  Function GetDateTimeFormat:String;
  Const
    Month : Array[0..12] Of String[3] =
    ('   ','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
  Var
    MsgDate:Datetime;
    x:word;
  Begin
    GetDate(MsgDate.Year,MsgDate.month,MsgDate.day,x);
    GetTime(MsgDate.Hour,MsgDate.Min,MsgDate.Sec,x);
    GetDate(MsgDate.Year,MsgDate.month,MsgDate.day,x);
    GetDateTimeFormat:=
      IntToNulStr(MsgDate.Day,2)+' '+
      Month[MsgDate.Month]+' '+
      Copy(IntToNulStr(MsgDate.Year,4),3,2)+'  '+
      IntToNulStr(MsgDate.Hour,2)+':'+
      IntToNulStr(MsgDate.Min,2)+':'+
      IntToNulStr(MsgDate.Sec,2);
  End;

  Function StripBackSlash(S : String) : String;
  Begin
    If (S<>'') And (S[Length(s)]='\') And
       Not ((Length(s)=3) And (S[2]=':') And (s[3]='\')) Then
         S[0]:=Chr(Ord(S[0])-1);
    StripBackSlash:=S;
  End;

  Function GrabWord(S: String; B: Byte) : String;
  Var st,e:Byte;
      return : String[80];
  Begin
    Return:='';
    st:=1;e:=1;
    While B>0 Do
    Begin
      While (S[st]=' ') or (S[st]=#9) Do Inc(st);  { #9 er TAB }
      e:=st;
      While (S[e]<>' ') And (e<=Length(s)) And (e<255) Do Inc(e);
      Return:=Copy(S,st,e-st);
      st:=e;
      Dec(B);
    End;
    GrabWord:=Return;
  End;

  Function NodeToFileName(s:String):String;
  Var
    n:Byte;
    Zone,Net,Node,Point : Word;
    AlleTegn:Set of Char;

    Function StripChars(Strip : String; ch : CharSet): String;
    Var
      b: byte;
    Begin
      b:=Length(Strip);
      While b>0 Do
      Begin
        If Strip[b] in ch Then Delete(Strip,b,1);
        Dec(b);
      End;
      StripChars:=Strip;
    End;

    Function Hex(b : Byte): Char;   { bruges ved hex omregning }
    Begin
      If b < 10 Then Hex:=Chr(b+48)
      Else Hex:=Chr(b+55);
    End;

    Function WToHex(i: Word) : String;
    Var
      b      : Array[1..2] Of Byte Absolute i;
    Begin
      WToHex:=Hex(b[2] Shr 4)+Hex(b[2] And 15)+Hex(b[1] Shr 4)+Hex(b[1] And 15);
    End;

  Begin
    AlleTegn:=[#0..#255];
    NodeToFileName:='';
    If Pos('@',s)<>0 Then Delete(s,Pos('@',s),255);
    If s='' Then Exit
    Else s:=StripChars(s,Alletegn-['0'..'9',':','/','.']);

    Zone:=0;
    Net:=0;
    Node:=0;
    Point:=0;

    n:=Pos(':',s);
    If n<>0 Then
    Begin
      Zone:=StrToInt(Copy(s,1,n-1));
      Delete(s,1,n);
    End
    Else
      Zone:=OurZone;

    If Zone>4096 Then Zone:=4096;

    n:=Pos('/',s);
    If n<>0 Then
    Begin
      Net:=StrToInt(Copy(s,1,n-1));
      Delete(s,1,n);
    End;
    n:=Pos('.',s);
    If n=0 Then Node:=StrToInt(s)
    Else Begin
      Node:=StrToInt(Copy(s,1,n-1));
      Delete(s,1,n);
      Point:=StrToInt(s);
    End;

    If Zone=OurZone Then S:=Outbound
    Else S:=Outbound+'.'+Copy(WToHex(Zone),2,3);

    S:=S+'\'+WtoHex(Net)+Wtohex(Node);
    If Point<>0 Then S:=S+'.PNT\0000'+Wtohex(Point);

    NodeToFileName:=S;

  End;

  Function AddBackSlash(S : String) : String;
  Begin
    S:=StripChars(S,[' ']);
    If (S[Length(S)]<>'\') And (S[Length(S)]<>':') And (S<>'') Then S:=S+'\';
    AddBackSlash := S;
  End;

  Function MakeFullDir(Dir: PathStr) : Boolean;
  Var
    x : Byte;
    IO:Word;
  Begin
    Dir:=AddBackSlash(Dir);
    For x:=2 To Length(Dir) Do
      If Dir[x]='\' Then
      Begin
        {$I-} MkDir(Copy(Dir,1,x-1)); {$I+}
        IO:=IOResult;
      End;
    MakeFullDir:=IO=0;
  End;



{----------------------------------------------------------------------------}

  Procedure HandleOutbound;
  Var
    x:word;
    N:Text;
  Begin

    If Remove Then
    Begin
      Path:=Nodetofilename(Whoto);
      FindFirst(Path+'.?LO',Archive,I);
      Found:=False;
      While (DosError=0) Do
      Begin
        Assign(T,Copy(Path,1,Length(Path)-8)+I.Name);
        Assign(N,Path+'.BAK');
        {$I-} Reset(T); {$I+}
        If IOResult=0 Then
        Begin
          {$I-} Rewrite(N); {$I+}
          While Not Eof(T) Do
          Begin
            Readln(T,Tmp);
            Tmp2:=Tmp;
            If (Tmp2<>'') And (Tmp2[1] In ['#','^']) Then
              Delete(Tmp2,1,1);
            If Inwildcard(Justfilename(tmp2),Justfilename(Filetosend)) and
               (
                Copy(Tmp2,1,Length(Tmp2)-Length(Justfilename(Tmp2)))=
                Copy(Filetosend,1,Length(Filetosend)-Length(Justfilename(Filetosend)))
               )
                then
            Begin
              Found:=True;
              Writeln('Removing: '+Tmp2);
            End
            Else
              Writeln(N,Tmp);
          End;
          Close(N);
          Close(T);
          Erase(T);
          Rename(N,Copy(Path,1,Length(Path)-8)+I.Name);
        End;
        FindNext(I);
      End;
      If not found then Writeln('File was not waiting to be send');
      Exit;
    End;

    x:=0;
    Path:=Nodetofilename(Whoto);
    Writeln(' Checking '+Whoto+' ('+Path+'.?LO)');
    FindFirst(Path+'.?LO',Archive,I);
    Found:=False;
    While (DosError=0) and not found Do
    Begin
      Inc(x);
      Assign(T,Copy(Path,1,Length(Path)-8)+I.Name);
      {$I-} Reset(T); {$I+}
      If IOresult=0 Then
      Begin
        While not eof(T) do
        begin
          readln(t,tmp);
          writeln(tmp);
          Tmp2:=Stupcase(Tmp);
          if (tmp2<>'') and (tmp2[1] in ['#','^']) Then Delete(tmp2,1,1);
          If Inwildcard(Justfilename(tmp2),Justfilename(Filetosend)) and
             (
              Copy(Tmp2,1,Length(Tmp2)-Length(Justfilename(Tmp2)))=
              Copy(Filetosend,1,Length(Filetosend)-Length(Justfilename(Filetosend)))
             )
              then Found:=True;
        end;
        Close(T);
      End;
      Findnext(I);
    End;

    Writeln;

    If Found Then
      Writeln(' File already waiting to be sent, will not send again...')
    Else Begin
      Writeln(' File not already waiting to be send, sending...');

      If (x<>0) and not Crash Then {$I-} Append(T) {$I+}
      Else Begin
        FindFirst(Path+'.*',Archive,I);
        If Doserror=3 Then
          MakefullDir(Copy(Path,1,Length(Path)-8));

        If (x=0) And not Crash Then Assign(T,Path+'.HLO')
        Else Assign(T,Path+'.CLO');
        {$I-} Append(T); {$I+}
        If IOResult<>0 Then
          {$I-} Rewrite(T); {$I+}
      End;

      If IOresult=0 Then
      Begin
        FindFirst(Filetosend,Archive,I);
        If Doserror<>0 Then
          Writeln('Could not find file')
        Else Begin
          While Doserror=0 Do
          Begin
            Writeln('Appending: '+Justpathname(Filetosend)+'\'+I.Name);
            If EraseAfter Then Write(T,'^');
            Writeln(T,Justpathname(Filetosend)+I.Name);
            FindNext(I);
          End;
        End;
        Close(T);
      End;
    End;

  End;

{----------------------------------------------------------------------------}

  Procedure HandleNetmail;

  Var
    x      : Longint;
    Msg    : MsgType;
    F      : File;
    High   : Longint;
    Addr   : AddrRecord;
    MyAddr : AddrRecord;
    MsgAddr: AddrRecord;
    DelMsg : Boolean;
    InSub  : Boolean;

  Begin
    StringToNode(Whoto,Addr);
    StringToNode(Node,MyAddr);
    High:=0;
    WriteLn(' Checking '+Whoto+' ('+FDNetmail+'*.MSG)');
    FindFirst(FDNetmail+'*.MSG',Archive,I);
    Found:=False;
    While Doserror=0 Do
    Begin
      DelMsg:=False;
      x:=Strtoint(Copy(I.Name,1,Pos('.',I.Name)-1));
      If x>High Then High:=x;
      Assign(F,FDNetmail+I.Name);
      {$I-} Reset(F,1); {$I+}
      If IOResult=0 Then
      Begin
        {$I-} BlockRead(F,Msg,Sizeof(Msg)); {$I+}
        If (IOResult=0) and
           (msg.mess_attr and msgfile<>0) and
           (msg.mess_attr and msglocal<>0) Then
        Begin
          { File is attach and local }
          Tmp:=msg.subject;
          Delete(Tmp,Pos(#0,Tmp),255);
          Tmp:=Stupcase(Tmp);

          InSub:=False;

          x:=1;
          While Grabword(Tmp,x)<>'' Do
          Begin
            Tmp2:=Grabword(Tmp,x);
            If Inwildcard(Justfilename(tmp2),Justfilename(Filetosend)) and
              (
               Copy(Tmp2,1,Length(Tmp2)-Length(Justfilename(Tmp2)))=
               Copy(Filetosend,1,Length(Filetosend)-Length(Justfilename(Filetosend)))
              )
               then InSub:=True;
            Inc(x);
          End;

          If InSub Then
          Begin
            { File is at least in subject }
            If (Addr.Net=Msg.destnet) And (Addr.Node=Msg.destnode) Then
            Begin
              { Net and node matches, check zone and point number }
              Fillchar(MsgAddr,sizeof(msgaddr),0);

              {$I-} BlockRead(F,Txt,32000,TxtSize); {$I+}
              x:=0;

              Msgaddr.Zone:=0;
              While NextKludge(Tmp,x) Do
              Begin
                If (Msgaddr.Zone=0) And (Pos('MSGID',Stupcase(TMP))=1) Then
                Begin
                  Delete(Tmp,1,7);
                  Msgaddr.Zone:=Strtoint(Copy(Tmp,1,Pos(':',Tmp)-1));
                End;

                If Pos('INTL',Stupcase(TMp))=1 Then
                Begin
                  Delete(Tmp,1,5);
                  Msgaddr.zone:=Strtoint(Copy(Tmp,1,pos(':',Tmp)-1));
                End;

                If Pos('TOPT',Stupcase(tmp))=1 Then
                Begin
                  Msgaddr.Point:=Strtoint(Grabword(Tmp,2));
                End;

              End;

              { Already in outbound ? }
              If (Msgaddr.zone=Addr.Zone) And (msgaddr.point=addr.point) Then
              Begin
                Found:=True;
                If Remove Then DelMsg:=True;
              End;

            End;
          End;
        End;
        Close(F);
        If DelMsg Then
        Begin
          Writeln('Erasing: '+I.Name);
          {$I-} Erase(F); {$I+}
          If IOResult=0 Then  ;
        End;
      End;
      Findnext(I);
    End;

    If Remove Then
    Else If Found Then
      Writeln(' File already waiting to be sent, will not send again... ('+I.name+')')
    Else Begin

      FindFirst(Filetosend,Archive,I);
      If Doserror<>0 Then
      Begin
        Writeln('File not found');
        Exit;
      End;

      While DosError=0 Do
      Begin

        Writeln(' Sending: '+I.Name+' ('+Inttostr(high+1)+'.MSG)');

        Fillchar(Msg,Sizeof(Msg),0);

        Tmp:=FromName+#0;
        Move(Mem[Seg(Tmp):Ofs(Tmp)+1],Msg.From_user,Length(Tmp));

        Tmp:=ToName+#0;
        Move(Mem[Seg(Tmp):Ofs(Tmp)+1],Msg.To_user,Length(Tmp));

        Tmp:=Justpathname(Filetosend)+I.Name+#0;
        Move(Mem[Seg(Tmp):Ofs(Tmp)+1],Msg.subject,Length(Tmp));

        Tmp:=GetDateTimeFormat;
        Fillchar(Msg.date_time,sizeof(Msg.date_time),0);
        Move(Tmp[1],Msg.date_time,Length(Tmp));

        Msg.Destnode:=Addr.Node;
        Msg.Destnet:=Addr.net;
        Msg.Orignode:=MyAddr.Node;
        Msg.Orignet:=Myaddr.net;

        Msg.mess_attr:=MSGPRIVATE+MSGFILE+MSGLOCAL+MSGKILL;

        Assign(F,FDNetmail+Inttostr(High+1)+'.MSG');
        Rewrite(F,1);
        BlockWrite(F,msg,sizeof(msg));

        If addr.zone<>myaddr.zone Then
        Begin
          Tmp:=#1'INTL ';
          x:=Addr.Point;
          Addr.Point:=0;
          Tmp:=Tmp+Nodetostring(Addr)+' ';
          Addr.Point:=x;
          x:=MyAddr.Point;
          Addr.Point:=0;
          Tmp:=Tmp+Nodetostring(MyAddr)+#13;
          Addr.Point:=x;
          BlockWrite(F,Tmp[1],Length(Tmp));
        End;

        If Myaddr.point<>0 Then
        Begin
          Tmp:=#1'FMPT '+Inttostr(Myaddr.point)+#13;
          BlockWrite(F,Tmp[1],Length(Tmp));
        End;

        If addr.point<>0 Then
        Begin
          Tmp:=#1'TOPT '+Inttostr(addr.point)+#13;
          BlockWrite(F,Tmp[1],Length(Tmp));
        End;

        Tmp2:='0123456789abcdef';
        Randomize;
        Tmp:='';
        For x:=1 To 8 Do
          Tmp:=Tmp+Tmp2[Random(16)+1];
        Tmp:=#1'MSGID: '+Nodetostring(Myaddr)+' '+Tmp+#13;
        BlockWrite(F,Tmp[1],Length(Tmp));

        Tmp:=#1'PID IsOut 1 *FREEWARE*'+#13;
        BlockWrite(F,Tmp[1],Length(Tmp));

        If EraseAfter Then
        Begin
          Tmp:=#1'FLAGS KFS'+#13;
          BlockWrite(F,Tmp[1],Length(Tmp));
        End;

        Tmp:=#0;
        BlockWrite(F,Tmp[1],Length(Tmp));

        Close(F);

        Findnext(I);
        Inc(High);

      End;

    End;

  End;

{----------------------------------------------------------------------------}

Begin

  WriteLn(#13#10' Is file outgoing ? (A Bo Bendtsen production)');
  WriteLn(      '');

  If Paramcount<2 Then
  Begin
    WriteLn(#10'Syntax : ISOUT node-address file-address [/KFS (Kill file sent)] [/C Crash]');
    Writeln;
    WriteLn(   'To send: ISOUT 2:254/261 C:\FOR-BO.ZIP');
    WriteLn(   '         ISOUT 2:254/261 C:\FOR-BO.ZIP /KFS');
    WriteLn(   '         ISOUT 1:109/921 C:\FOR-ANDY.ZIP /KFS /C');
    WriteLn(   '         ISOUT 1:109/921 C:\FOR-????.* /KFS /C');
    WriteLn;
    WriteLn(   'Remove : ISOUT 1:109/921 C:\FOR-ANDY.ZIP /REMOVE');
    WriteLn(   '         ISOUT 1:109/921 C:\FOR-ANDY.*   /REMOVE');
    Halt;
  End;

  Whoto:=Paramstr(1);
  Filetosend:=Stupcase(Paramstr(2));

  EraseAfter:=False;
  Crash:=False;
  Remove:=False;

  For Ourzone:=3 To 6 Do
  Begin
    Tmp:=Stupcase(Paramstr(Ourzone));
    If Tmp='/KFS' Then EraseAfter:=True
    Else If Tmp='/C' Then Crash:=True
    Else If Tmp='/REMOVE' Then Remove:=True;
  End;

  Assign(T,'ISOUT.CFG');
  {$I-} Reset(T); {$I+}
  If IOResult<>0 Then
  Begin
    WriteLn('Error reading ONHOLD.CFG');
    Exit;
  End;

  Node:='';
  FromName:='Me';
  ToName:='You';

  While Not Eof(T) Do
  Begin
    ReadLn(T,Tmp);
    If (Tmp<>'') And (Tmp[1]<>';') Then
    Begin
      Tmp2:=StUpcase(Grabword(Tmp,1));
      If Tmp2='OUTBOUND' Then Outbound:=Stupcase(StripBackslash(Grabword(Tmp,2)))
      Else If Tmp2='NETMAIL' Then FDNetmail:=Stupcase(StripBackslash(Grabword(Tmp,2)))+'\'
      Else If Tmp2='ADDRESS' Then Node:=grabword(Tmp,2)
      Else If Tmp2='FROM' Then FromName:=grabword(Tmp,2)
      Else If Tmp2='TO' Then ToName:=grabword(Tmp,2)
    End;
  End;
  Close(T);

  If ((Outbound='') and (FDNetmail='')) Or
     ((Outbound<>'') and (FDNetmail<>'')) Then
  Begin
    Writeln('An outbound OR netmail directory has to be specified');
    Halt;
  End;

  If Node='' Then
  Begin
    Writeln('A node address was not specified');
    Halt;
  End;

  OurZone:=Strtoint(Copy(Node,1,Pos(':',Node)-1));

  If Outbound<>'' Then HandleOutbound;
  If FDNetmail<>'' Then HandleNetmail;

End.

{----------------------------------------------------------------------------}
